/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.dbline;

import java.io.IOException;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bsf.dbline.BreakPoint;
import org.apache.bsf.dbline.Buffer;
import org.apache.bsf.dbline.Callbacks;
import org.apache.bsf.dbline.Context;
import org.apache.bsf.dbline.JsObjectProxy;
import org.apache.bsf.debug.BSFConnect;
import org.apache.bsf.debug.BSFDebugManager;
import org.apache.bsf.debug.jsdi.JsContext;
import org.apache.bsf.debug.jsdi.JsEngine;
import org.apache.bsf.debug.jsdi.JsObject;

public class JsDb
implements Runnable {
    private JsObject global;
    private Callbacks callbacks;
    private Thread m_cmdThread;
    private Object m_lock;
    private static boolean m_inCallback;
    private static int exitStatus;
    private static boolean running;
    Vector m_buffers;
    int m_currentDepth;
    int m_stackDepth;
    Context[] m_stack;
    JsObject undefined;
    JsEngine m_jse;
    Hashtable m_proxies;
    Hashtable m_rot;
    static JsDb self;
    static BSFDebugManager gBsfManager;
    static final int JSDB_CMD_LEN = 256;
    static final String[] usage;

    public JsDb(String[] stringArray) throws RemoteException {
        self = this;
        this.m_buffers = new Vector();
        this.m_proxies = new Hashtable();
        this.m_rot = new Hashtable();
        this.m_lock = new Object();
        m_inCallback = false;
        this.callbacks = new Callbacks(this);
        gBsfManager.registerDebugger("javascript", this.callbacks);
        this.m_cmdThread = new Thread((Runnable)this, "User Input Thread");
        this.m_cmdThread.start();
    }

    JsObjectProxy proxyObject(JsObject jsObject) {
        if (jsObject == null) {
            return null;
        }
        JsObjectProxy jsObjectProxy = (JsObjectProxy)this.m_proxies.get(jsObject);
        if (jsObjectProxy == null) {
            jsObjectProxy = new JsObjectProxy(jsObject);
            this.m_proxies.put(jsObject, jsObjectProxy);
            Integer n = new Integer(jsObjectProxy.getOid());
            this.m_rot.put(n, jsObjectProxy);
        }
        return jsObjectProxy;
    }

    private void displayProperties(JsObjectProxy jsObjectProxy, boolean bl) throws RemoteException {
        JsObject jsObject = jsObjectProxy.getObject();
        JsObject jsObject2 = jsObject.getScope();
        JsObject jsObject3 = jsObject.getPrototype();
        System.out.println("Object <" + jsObjectProxy.getOid() + ">");
        if (jsObject2 != null) {
            JsObjectProxy jsObjectProxy2 = this.proxyObject(jsObject2);
            System.out.println("    Scope <" + jsObjectProxy2.getOid() + ">");
        } else {
            System.out.println("    No scope.");
        }
        if (jsObject3 != null) {
            JsObjectProxy jsObjectProxy3 = this.proxyObject(jsObject3);
            System.out.println("    Prototype <" + jsObjectProxy3.getOid() + ">");
        } else {
            System.out.println("    No prototype.");
        }
        Object[] objectArray = jsObject.getIds(bl);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                Object object;
                Object object2 = objectArray[n];
                if (object2 instanceof String) {
                    String string = (String)object2;
                    object = jsObject.get(string);
                    this.displayProperty(string, object);
                } else {
                    int n2 = (Integer)object2;
                    object = jsObject.get(n2);
                    this.displayProperty(String.valueOf(n2), object);
                }
                ++n;
            }
        } else {
            System.out.println("    No properties.");
        }
    }

    private void displayScope(JsObjectProxy jsObjectProxy, boolean bl) throws RemoteException {
        JsObject jsObject = jsObjectProxy.getObject();
        JsObject jsObject2 = jsObject.getScope();
        if (jsObject2 == null) {
            System.out.println("No scope");
            return;
        }
        System.out.println("Scope chain for Object <" + jsObjectProxy.getOid() + ">");
        while (jsObject2 != null) {
            JsObjectProxy jsObjectProxy2 = this.proxyObject(jsObject2);
            System.out.println("** Scope <" + jsObjectProxy2.getOid() + ">");
            Object[] objectArray = jsObject2.getIds(bl);
            int n = 0;
            while (n < objectArray.length) {
                Object object;
                Object object2 = objectArray[n];
                if (object2 instanceof String) {
                    String string = (String)object2;
                    object = jsObject.get(string);
                    this.displayProperty(string, object);
                } else {
                    int n2 = (Integer)object2;
                    object = jsObject.get(n2);
                    this.displayProperty(String.valueOf(n2), object);
                }
                ++n;
            }
            jsObject2 = jsObject2.getScope();
        }
    }

    private void displayPrototype(JsObjectProxy jsObjectProxy, boolean bl) throws RemoteException {
        JsObject jsObject = jsObjectProxy.getObject();
        JsObject jsObject2 = jsObject.getPrototype();
        if (jsObject2 == null) {
            System.out.println("Empty prototype chain.");
            return;
        }
        System.out.println("Prototype Chain for Object <" + jsObjectProxy.getOid() + ">");
        while (jsObject2 != null) {
            JsObjectProxy jsObjectProxy2 = this.proxyObject(jsObject2);
            System.out.println("** Prototype <" + jsObjectProxy2.getOid() + ">");
            Object[] objectArray = jsObject2.getIds(bl);
            int n = 0;
            while (n < objectArray.length) {
                Object object;
                Object object2 = objectArray[n];
                if (object2 instanceof String) {
                    String string = (String)object2;
                    object = jsObject.get(string);
                    this.displayProperty(string, object);
                } else {
                    int n2 = (Integer)object2;
                    object = jsObject.get(n2);
                    this.displayProperty(String.valueOf(n2), object);
                }
                ++n;
            }
            jsObject2 = jsObject2.getPrototype();
        }
    }

    private void displayProperty(String string, Object object) {
        System.out.print("  ");
        if (object instanceof Number) {
            System.out.println(string + "=" + ((Number)object).floatValue());
        } else if (object instanceof String) {
            System.out.println(string + "=" + object);
        } else if (object instanceof Boolean) {
            System.out.println(string + "=" + (Boolean)object);
        } else if (object instanceof JsObject) {
            if (object == this.undefined) {
                System.out.println(string + "= undefined");
            } else {
                JsObjectProxy jsObjectProxy = this.proxyObject((JsObject)object);
                int n = jsObjectProxy.getOid();
                System.out.println(string + "= Object <" + n + ">");
            }
        } else {
            System.out.println(string + object);
        }
    }

    private Buffer findBufferWithShortName(String string) {
        Enumeration enumeration = this.m_buffers.elements();
        while (enumeration.hasMoreElements()) {
            Buffer buffer = (Buffer)enumeration.nextElement();
            String string2 = buffer.getName();
            if (!string2.startsWith(string)) continue;
            return buffer;
        }
        return null;
    }

    private Buffer findBufferWithURI(String string) {
        Enumeration enumeration = this.m_buffers.elements();
        while (enumeration.hasMoreElements()) {
            Buffer buffer = (Buffer)enumeration.nextElement();
            if (!string.equals(buffer.getURI())) continue;
            return buffer;
        }
        return null;
    }

    public void run() {
        boolean bl = false;
        running = true;
        while (running) {
            String string = this.readCmd();
            try {
                if (string != null) {
                    bl = this.parseCmd(string);
                }
                if (!bl) continue;
                JsDb.inCallback(false);
            }
            catch (Throwable throwable) {
                System.err.println("\nError while parsing/executing command.");
                throwable.printStackTrace();
            }
        }
        System.exit(exitStatus);
    }

    private static void inCallback(boolean bl) {
        m_inCallback = bl;
        if (m_inCallback) {
            System.out.print("> ");
        }
    }

    public String readCmd() {
        int n = 0;
        char[] cArray = new char[256];
        if (m_inCallback) {
            System.out.print("> ");
        } else {
            System.out.print("< ");
        }
        while (n < 256) {
            try {
                char c = (char)System.in.read();
                cArray[n++] = c;
                if (c != '\n') continue;
                break;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (n == 256) {
            System.out.println("\nLine too long.\n");
            return null;
        }
        return new String(cArray, 0, n);
    }

    public boolean parseCmd(String string) throws RemoteException {
        boolean bl = this.cmdParser(string);
        if (m_inCallback) {
            try {
                this.m_jse.poll();
            }
            catch (RemoteException remoteException) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean parseLoad(StringTokenizer stringTokenizer) throws RemoteException {
        String string = stringTokenizer.nextToken();
        string = string.trim();
        String string2 = stringTokenizer.nextToken();
        string2 = string2.trim();
        this.addBuffer(string, string2);
        return false;
    }

    private void showUsage() {
        int n = 0;
        while (n < usage.length) {
            System.out.println(usage[n]);
            ++n;
        }
    }

    private boolean parseStep(StringTokenizer stringTokenizer) throws RemoteException {
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if ((string = string.trim()).equals("in")) {
                this.m_jse.stepIn();
                return true;
            }
            if (string.equals("out")) {
                if (!m_inCallback) {
                    System.out.println("Not in a callback...");
                    return false;
                }
                this.m_jse.stepOut();
                return true;
            }
            if (string.equals("over")) {
                if (!m_inCallback) {
                    System.out.println("Not in a callback...");
                    return false;
                }
                this.m_jse.stepOver();
                return true;
            }
        } else {
            System.out.println("Incorrect syntax...");
        }
        return false;
    }

    private boolean parseSetEntryExit(StringTokenizer stringTokenizer) throws RemoteException {
        if (stringTokenizer.countTokens() == 2) {
            String string = stringTokenizer.nextToken();
            boolean bl = Boolean.valueOf(stringTokenizer.nextToken().trim());
            Buffer buffer = this.findBufferWithShortName(string);
            if (buffer != null) {
                gBsfManager.setEntryExit(buffer.getURI(), bl);
                System.out.println("Setting entry/exit status for " + buffer.getURI() + " to " + bl);
            }
        } else {
            System.out.println("Incorrect syntax...");
        }
        return false;
    }

    private boolean parseRemoveBreakpoint(StringTokenizer stringTokenizer) throws RemoteException {
        String string = stringTokenizer.nextToken();
        int n = Integer.valueOf(string.trim());
        Enumeration enumeration = this.m_buffers.elements();
        while (enumeration.hasMoreElements()) {
            Buffer buffer = (Buffer)enumeration.nextElement();
            BreakPoint breakPoint = buffer.removeBreakpoint(n);
            if (breakPoint == null) continue;
            String string2 = buffer.getURI();
            gBsfManager.removeBreakpoint(string2, n);
            System.out.println("Removed breakpoint " + n + " in " + string2);
            break;
        }
        return false;
    }

    private boolean parseBreakpoint(StringTokenizer stringTokenizer) throws RemoteException {
        String string = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, ":,", false);
        String string2 = stringTokenizer2.nextToken();
        string2 = string2.trim();
        String string3 = stringTokenizer2.nextToken();
        Integer n = Integer.valueOf(string3.trim());
        this.addBreakpoint(string2, n - 1);
        return false;
    }

    private boolean parseExec(StringTokenizer stringTokenizer) throws RemoteException {
        String string = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, ":,", false);
        String string2 = stringTokenizer2.nextToken();
        string2 = string2.trim();
        String string3 = stringTokenizer2.nextToken();
        Integer n = Integer.valueOf(string3.trim());
        n = new Integer(n - 1);
        string3 = stringTokenizer2.nextToken();
        Integer n2 = Integer.valueOf(string3.trim());
        n2 = new Integer(n2 - 1);
        Buffer buffer = this.findBufferWithShortName(string2);
        StringBuffer stringBuffer = buffer.buildFnOrScript(n, n2);
        String string4 = stringBuffer.toString();
        System.out.println("\nExecuting...");
        try {
            this.m_jse.eval(buffer.getName(), string4, n);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        System.out.println("\nExecution done.");
        return false;
    }

    private boolean parseShow(StringTokenizer stringTokenizer) throws RemoteException {
        String string = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, " :,", false);
        String string2 = stringTokenizer2.nextToken();
        if ((string2 = string2.trim()).equals("frame")) {
            this.showCurrentFrame();
        } else if (string2.equals("scope")) {
            Boolean bl = new Boolean(false);
            String string3 = stringTokenizer2.nextToken();
            Integer n = Integer.valueOf(string3.trim());
            if (stringTokenizer2.hasMoreTokens()) {
                string3 = stringTokenizer2.nextToken();
                if ((string3 = string3.trim()).equals("all")) {
                    bl = new Boolean(true);
                }
            } else {
                bl = new Boolean(false);
            }
            this.showScope(n, bl);
        } else if (string2.equals("prototype")) {
            Boolean bl = new Boolean(false);
            String string4 = stringTokenizer2.nextToken();
            Integer n = Integer.valueOf(string4.trim());
            if (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken();
                if ((string4 = string4.trim()).equals("all")) {
                    bl = new Boolean(true);
                }
            } else {
                bl = new Boolean(false);
            }
            this.showPrototype(n, bl);
        } else if (string2.equals("object")) {
            Boolean bl = new Boolean(false);
            String string5 = stringTokenizer2.nextToken();
            Integer n = Integer.valueOf(string5.trim());
            if (stringTokenizer2.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken();
                if ((string5 = string5.trim()).equals("all")) {
                    bl = new Boolean(true);
                }
            } else {
                bl = new Boolean(false);
            }
            this.showObject(n, bl);
        }
        return false;
    }

    private boolean parsePut(String string) throws RemoteException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":=", false);
        String string2 = stringTokenizer.nextToken();
        string2 = string2.trim();
        Integer n = Integer.valueOf(string2 = string2.substring(1, string2.length() - 1));
        JsObjectProxy jsObjectProxy = (JsObjectProxy)this.m_rot.get(n);
        if (jsObjectProxy == null) {
            return false;
        }
        JsObject jsObject = jsObjectProxy.getObject();
        string2 = stringTokenizer.nextToken();
        String string3 = string2.trim();
        string2 = stringTokenizer.nextToken();
        string2 = string2.trim();
        try {
            Float f = Float.valueOf(string2);
            jsObject.put(string3, (Object)f);
        }
        catch (NumberFormatException numberFormatException) {
            if (string2.equals("false")) {
                Boolean bl = new Boolean(false);
                jsObject.put(string3, (Object)bl);
            }
            if (string2.equals("true")) {
                Boolean bl = new Boolean(true);
                jsObject.put(string3, (Object)bl);
            }
            if (string2.startsWith("<")) {
                n = Integer.valueOf(string2 = string2.substring(1, string2.length() - 1));
                jsObjectProxy = (JsObjectProxy)this.m_rot.get(n);
                if (jsObjectProxy == null) {
                    return false;
                }
                JsObject jsObject2 = jsObjectProxy.getObject();
                jsObject.put(string3, (Object)jsObject2);
            }
            jsObject.put(string3, (Object)string2);
        }
        return false;
    }

    private boolean parseList(StringTokenizer stringTokenizer) throws RemoteException {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listBuffer();
            return false;
        }
        String string = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, " :", false);
        String string2 = stringTokenizer2.nextToken();
        if ((string2 = string2.trim()).equals("buffers")) {
            this.listBuffers();
        } else if (string2.equals("breakpoints")) {
            this.listBreakpoints();
        } else if (string2.equals("frames")) {
            this.listFrames();
        } else {
            Integer n = new Integer(-1);
            if (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                n = Integer.valueOf(string3.trim());
                n = new Integer(n - 1);
            }
            this.listBuffer(string2, n);
        }
        return false;
    }

    public boolean cmdParser(String string) throws RemoteException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            if ((string2 = string2.toLowerCase()).equals("load")) {
                return this.parseLoad(stringTokenizer);
            }
            if (string2.equals("put")) {
                if (m_inCallback) {
                    String string3 = string.substring(string.indexOf(" "));
                    this.parsePut(string3);
                } else {
                    System.out.println("Not in a callback...");
                }
            } else if (string2.equals("usage") || string2.equals("help")) {
                this.showUsage();
            } else if (string2.equals("step")) {
                if (m_inCallback) {
                    return this.parseStep(stringTokenizer);
                }
                System.out.println("Not in a callback...");
            } else {
                if (string2.equals("br")) {
                    return this.parseBreakpoint(stringTokenizer);
                }
                if (string2.equals("rm")) {
                    return this.parseRemoveBreakpoint(stringTokenizer);
                }
                if (string2.equals("set_entry_exit")) {
                    return this.parseSetEntryExit(stringTokenizer);
                }
                if (string2.equals("exec")) {
                    if (m_inCallback) {
                        return this.parseExec(stringTokenizer);
                    }
                    System.out.println("Not in a callback...");
                } else if (string2.equals("up")) {
                    if (m_inCallback) {
                        this.up();
                    } else {
                        System.out.println("Not in a callback...");
                    }
                } else if (string2.equals("down")) {
                    if (m_inCallback) {
                        this.down();
                    } else {
                        System.out.println("Not in a callback...");
                    }
                } else if (string2.equals("run")) {
                    if (m_inCallback) {
                        this.m_jse.run();
                        return true;
                    }
                    System.out.println("Not in a callback...");
                } else {
                    if (string2.equals("show")) {
                        return this.parseShow(stringTokenizer);
                    }
                    if (string2.equals("list")) {
                        return this.parseList(stringTokenizer);
                    }
                    if (string2.equals("thrinfo")) {
                        if (m_inCallback) {
                            this.showThrInfo();
                        } else {
                            System.out.println("Not in a callback...");
                        }
                    } else if (string2.equals("quit")) {
                        JsDb.exitDebugger(0);
                    } else if (!string2.equals("")) {
                        System.out.println("Unrecognized command: " + string2 + "\nTo see valid commands, type usage");
                    }
                }
            }
        }
        return false;
    }

    public void addBreakpoint(String string, int n) throws RemoteException {
        Buffer buffer = this.findBufferWithShortName(string);
        if (buffer != null) {
            BreakPoint breakPoint = new BreakPoint();
            breakPoint.m_lineno = n;
            breakPoint.m_buffer = buffer;
            buffer.addBreakpoint(breakPoint);
            gBsfManager.placeBreakpointAtLine(breakPoint.m_id, buffer.getURI(), n);
            System.out.println("Breakpoint " + breakPoint.m_id + " at " + (breakPoint.m_lineno + 1));
        }
    }

    public Buffer addBuffer(String string, String string2) {
        Buffer buffer = this.findBufferWithURI(string2);
        if (buffer == null) {
            buffer = Buffer.factory(string, string2);
        }
        if (buffer != null) {
            this.m_buffers.addElement(buffer);
            System.out.println("Loaded buffer: " + string2);
        }
        return buffer;
    }

    public void createdEngine(JsEngine jsEngine) throws RemoteException {
        this.m_jse = jsEngine;
        this.m_jse.setDebugger(this.callbacks);
        this.undefined = this.m_jse.getUndefinedValue();
    }

    public void deletedEngine(JsEngine jsEngine) {
        if (this.m_jse == jsEngine || this.m_jse.equals(jsEngine)) {
            this.m_jse = null;
        }
    }

    public void down() {
        --this.m_currentDepth;
        if (this.m_currentDepth < 0) {
            this.m_currentDepth = 0;
        }
    }

    public void showThrInfo() {
        try {
            System.out.println("Thread: " + this.m_jse.getThread());
            System.out.println("ThreadGroup: " + this.m_jse.getThreadGroup());
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return;
        }
    }

    public static void exitDebugger(int n) {
        JsDb.inCallback(false);
        BSFConnect.disconnect();
        exitStatus = n;
        running = false;
    }

    public void handleBreakpointHit(JsContext jsContext) throws RemoteException {
        String string;
        JsEngine jsEngine = jsContext.getEngine();
        if (this.m_jse != jsEngine) {
            throw new Error();
        }
        this.m_stackDepth = this.m_jse.getContextCount();
        System.out.println("\n    stack depth=" + this.m_stackDepth);
        if (this.m_stackDepth <= 0) {
            throw new RemoteException("Error: Stack cannot be empty.");
        }
        this.m_stack = new Context[this.m_stackDepth];
        int n = 0;
        while (n < this.m_stackDepth) {
            JsContext jsContext2 = this.m_jse.getContext(n);
            string = jsContext2.getSourceName();
            Buffer buffer = this.findBufferWithURI(string);
            this.m_stack[n] = new Context(jsContext2, buffer);
            ++n;
        }
        this.m_currentDepth = 0;
        int n2 = this.m_stack[0].getCurrentLine();
        string = this.m_stack[0].getBufferName();
        System.out.println("    in JSP " + string + " at line " + (n2 + 1));
        JsDb.inCallback(true);
    }

    public void handleEngineStopped(JsContext jsContext) {
    }

    public void handleExceptionThrown(JsContext jsContext, Object object) throws RemoteException {
        String string;
        JsEngine jsEngine = jsContext.getEngine();
        if (this.m_jse != jsEngine) {
            throw new Error();
        }
        this.m_stackDepth = this.m_jse.getContextCount();
        this.m_stack = new Context[this.m_stackDepth];
        int n = 0;
        while (n < this.m_stackDepth) {
            JsContext jsContext2 = this.m_jse.getContext(n);
            string = jsContext2.getSourceName();
            Buffer buffer = this.findBufferWithURI(string);
            this.m_stack[n] = new Context(jsContext2, buffer);
            ++n;
        }
        this.m_currentDepth = 0;
        int n2 = this.m_stack[0].getCurrentLine();
        string = this.m_stack[0].getBufferName();
        System.out.println("Exception thrown at line " + string + ":" + (n2 + 1) + " reached.");
        JsDb.inCallback(true);
    }

    public void handleSteppingDone(JsContext jsContext) throws RemoteException {
        String string;
        JsEngine jsEngine = jsContext.getEngine();
        if (this.m_jse != jsEngine) {
            throw new Error();
        }
        this.m_stackDepth = this.m_jse.getContextCount();
        System.out.println("\n    stack depth=" + this.m_stackDepth);
        if (this.m_stackDepth <= 0) {
            throw new RemoteException("Error: Stack cannot be empty.");
        }
        this.m_stack = new Context[this.m_stackDepth];
        int n = 0;
        while (n < this.m_stackDepth) {
            JsContext jsContext2 = this.m_jse.getContext(n);
            string = jsContext2.getSourceName();
            Buffer buffer = this.findBufferWithURI(string);
            this.m_stack[n] = new Context(jsContext2, buffer);
            ++n;
        }
        this.m_currentDepth = 0;
        int n2 = this.m_stack[0].getCurrentLine();
        string = this.m_stack[0].getBufferName();
        System.out.println("Stepped to line " + string + ":" + (n2 + 1) + " reached.");
        JsDb.inCallback(true);
    }

    public void listBreakpoints() {
        Enumeration enumeration = this.m_buffers.elements();
        while (enumeration.hasMoreElements()) {
            Buffer buffer = (Buffer)enumeration.nextElement();
            System.out.println("Buffer " + buffer.getName());
            Enumeration enumeration2 = buffer.getBreakpoints();
            while (enumeration2.hasMoreElements()) {
                BreakPoint breakPoint = (BreakPoint)enumeration2.nextElement();
                System.out.println("Breakpoint " + breakPoint.m_id + " at " + (breakPoint.m_lineno + 1));
            }
        }
    }

    public void listBuffer() {
        if (this.m_stack == null) {
            return;
        }
        Context context = this.m_stack[this.m_currentDepth];
        String string = context.getBufferName();
        Buffer buffer = context.getBuffer();
        int n = context.getCurrentLine();
        this.listBufferLines(buffer, n - 5, 10, context);
    }

    public void listBuffer(String string, int n) {
        Buffer buffer = this.findBufferWithShortName(string);
        Context context = null;
        if (buffer == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.m_stackDepth) {
            context = this.m_stack[n2];
            if (buffer == context.getBuffer()) break;
            context = null;
            ++n2;
        }
        this.listBufferLines(buffer, n, 10, context);
    }

    public void listBufferLines(Buffer buffer, int n, int n2, Context context) {
        if (n < 0) {
            n = buffer.getCurrentLine();
        }
        int n3 = n;
        while (n3 < n + n2) {
            String string = buffer.getLine(n3);
            if (string == null) break;
            if (context != null && n3 == context.getCurrentLine()) {
                System.out.print("-> " + (n3 + 1) + ":");
            } else {
                System.out.print("   " + (n3 + 1) + ":");
            }
            System.out.println(string);
            ++n3;
        }
        buffer.setCurrentLine(n3);
    }

    public void listBuffers() {
        Enumeration enumeration = this.m_buffers.elements();
        while (enumeration.hasMoreElements()) {
            Buffer buffer = (Buffer)enumeration.nextElement();
            System.out.println(buffer.getName());
        }
    }

    public void listFrames() {
        int n = this.m_currentDepth;
        while (n < this.m_stackDepth) {
            Context context = this.m_stack[n];
            System.out.print(context.getBufferName());
            System.out.println(":" + (context.getCurrentLine() + 1));
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object = new Object();
            String string = System.getProperty("org.apache.bsf.dbline.hostName");
            while (gBsfManager == null && exitStatus == 0) {
                try {
                    gBsfManager = BSFConnect.connect(string, -1);
                }
                catch (ProtocolException protocolException) {
                    System.out.println(protocolException.getMessage());
                    exitStatus = 1;
                    continue;
                }
                catch (ConnectException connectException) {
                    System.out.println(connectException.getMessage());
                    exitStatus = 2;
                    continue;
                }
                catch (Throwable throwable) {
                    gBsfManager = null;
                }
                if (gBsfManager != null) {
                    new JsDb(stringArray);
                    continue;
                }
                System.out.println("Manager not there yet, sleeping.");
                Object object2 = object;
                synchronized (object2) {
                    try {
                        object.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (exitStatus > 0) {
            System.exit(exitStatus);
        }
    }

    public void showCurrentFrame() throws RemoteException {
        Context context = this.m_stack[this.m_currentDepth];
        JsContext jsContext = context.getJsContext();
        JsObject jsObject = jsContext.getScope();
        boolean bl = false;
        System.out.print("\nCurrent frame: " + context.getBufferName());
        System.out.println(":" + context.getCurrentLine());
        System.out.println("\nProperties in scope: ");
        while (jsObject != null) {
            JsObjectProxy jsObjectProxy = this.proxyObject(jsObject);
            this.displayProperties(jsObjectProxy, false);
            jsObject = jsObject.getScope();
        }
    }

    public void showObject(Integer n, boolean bl) throws RemoteException {
        JsObjectProxy jsObjectProxy = (JsObjectProxy)this.m_rot.get(n);
        if (jsObjectProxy == null) {
            System.out.println("Unknown object <" + n + "> !");
        } else {
            this.displayProperties(jsObjectProxy, bl);
        }
    }

    public void showScope(Integer n, boolean bl) throws RemoteException {
        JsObjectProxy jsObjectProxy = (JsObjectProxy)this.m_rot.get(n);
        if (jsObjectProxy == null) {
            System.out.println("Unknown object <" + n + "> !");
        } else {
            this.displayScope(jsObjectProxy, bl);
        }
    }

    public void showPrototype(Integer n, boolean bl) throws RemoteException {
        JsObjectProxy jsObjectProxy = (JsObjectProxy)this.m_rot.get(n);
        if (jsObjectProxy == null) {
            System.out.println("Unknown object <" + n + "> !");
        } else {
            this.displayPrototype(jsObjectProxy, bl);
        }
    }

    public void up() {
        ++this.m_currentDepth;
        if (this.m_currentDepth >= this.m_stackDepth) {
            this.m_currentDepth = this.m_stackDepth - 1;
        }
    }

    static {
        exitStatus = 0;
        running = false;
        usage = new String[]{"Supported commands:", "load <FILENAME> <URI>", "br shortname:16", "rm <breakpoint id>", "set_entry_exit shortname [true, false]", "exec shortname:12,28 (start line, end line to be interpreted)", "step [in, over, out]", "run", "thrinfo", "list frames (display the stack of contexts)", "list (display source around current position)", "list shortname[:lineno] (display source starting at the given line)", "up / down (move up or down the current context on the stack)", "show frame (display the current context on the stack)", "show object:id[,all]  (display an object with the given id, ", "                       the option 'all' precise to enum properties", "                       with a DONTENUM attribute.)", "show scope:id[,all]  (display the scope chain of the object with ", "                      the given id,the option all precise to enum ", "                      properties with a DONTENUM attribute.)", "show prototype:id[,all]  (display the prototype chain of the object ", "                          with the given id, the option all precise ", "                          to enum properties with a DONTENUM attribute.)", "put <id>:propname=value (where the value is either a string,", "                         a float, a boolean, or an object)", "               Examples: ", " \t\tput <2>:foo=That's it folks", "\t\tput <4>:bar=4.0", " \t\tput <45>:trueOrFalse=false", "\t\tput <31>:foo=<4>", "That's it...", "Notations:", "   URI: full URI, sans hostname and protocol specification", "   shortname: last component of the URI"};
    }
}

