/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.TranslateAction;

public final class TranslateActionFactory
extends AbstractComposerActionFactory {
    private static final ActionMouseCursor TRANSLATE_MOUSE_CURSOR = new ActionMouseCursor(13, 1);
    private static int[] DIFF_LEFT = new int[]{-1, 0};
    private static int[] DIFF_RIGHT = new int[]{1, 0};
    private static int[] DIFF_DOWN = new int[]{0, 1};
    private static int[] DIFF_UP = new int[]{0, -1};

    public TranslateActionFactory(SceneManager sceneMgr) {
        super(sceneMgr);
    }

    @Override
    public synchronized ComposerAction startAction(AWTEvent e, boolean isOutsideEvent) {
        if (!isOutsideEvent && !this.m_sceneMgr.isReadOnly()) {
            SVGObject selObj;
            if (e.getID() == 501) {
                MouseEvent me = (MouseEvent)e;
                SVGObject selObj2 = this.getSelectedObjectAt(me);
                if (selObj2 != null) {
                    return new TranslateAction((ComposerActionFactory)this, selObj2, me);
                }
            } else if (TranslateActionFactory.getCoordDiff(e) != null && (selObj = this.getSelectedObject()) != null) {
                return new TranslateAction((ComposerActionFactory)this, selObj, (KeyEvent)e);
            }
        }
        return null;
    }

    @Override
    public ActionMouseCursor getMouseCursor(MouseEvent evt, boolean isOutsideEvent) {
        if (!isOutsideEvent && this.getSelectedObjectAt(evt) != null) {
            return TRANSLATE_MOUSE_CURSOR;
        }
        return null;
    }

    private SVGObject getSelectedObjectAt(MouseEvent me) {
        SVGObject selObj;
        SVGObject[] selectedObjects = this.m_sceneMgr.getSelected();
        if (selectedObjects != null && selectedObjects.length > 0 && (selObj = selectedObjects[0]).getScreenBBox().contains(me.getPoint())) {
            return selObj;
        }
        return null;
    }

    private SVGObject getSelectedObject() {
        SVGObject[] selectedObjects = this.m_sceneMgr.getSelected();
        if (selectedObjects != null && selectedObjects.length > 0) {
            return selectedObjects[0];
        }
        return null;
    }

    static int[] getCoordDiff(AWTEvent e) {
        KeyEvent ke;
        if (e.getID() == 401 && (ke = (KeyEvent)e).getModifiers() == 0) {
            switch (ke.getKeyCode()) {
                case 40: {
                    return DIFF_DOWN;
                }
                case 37: {
                    return DIFF_LEFT;
                }
                case 39: {
                    return DIFF_RIGHT;
                }
                case 38: {
                    return DIFF_UP;
                }
            }
        }
        return null;
    }
}

