/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.ui;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlgCancellablePane;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlgPane;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public class ModalMessageDlg
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(ModalMessageDlg.class.getName(), 4);

    public static void runLongTask(Dialog parent, Runnable workTask, Runnable postEDTTask, Cancellable canceller, String title, String message) {
        ModalMessageDlg.runLongTaskImpl(parent, workTask, postEDTTask, title, message, canceller);
    }

    public static void runLongTask(Frame parent, Runnable workTask, Runnable postEDTTask, Cancellable canceller, String title, String message) {
        ModalMessageDlg.runLongTaskImpl(parent, workTask, postEDTTask, title, message, canceller);
    }

    public static void runLongTask(Window parent, String title, String message, final LongWorker workTask, final Cancellable canceller) {
        JPanel panel;
        final JDialog dialog = ModalMessageDlg.createDialog(parent, title);
        final Runnable finalizer = new Runnable(){

            @Override
            public void run() {
                dialog.setVisible(false);
                dialog.dispose();
                workTask.doPostRunInEDT();
            }
        };
        if (canceller == null) {
            panel = new ModalMessageDlgPane(message);
        } else {
            Cancellable wrapper = new Cancellable(){

                public boolean cancel() {
                    return canceller.cancel();
                }
            };
            panel = new ModalMessageDlgCancellablePane(message, wrapper);
        }
        ModalMessageDlg.addPanel(parent, dialog, panel);
        RP.post((Runnable)new NamedRunnable(title){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runImpl() {
                try {
                    workTask.doWork();
                }
                finally {
                    SwingUtilities.invokeLater(finalizer);
                }
            }
        });
        if (!CndUtils.isStandalone()) {
            dialog.setVisible(true);
        }
    }

    private static boolean runLongTaskImpl(Window parent, Runnable workTask, final Runnable postEDTTask, String title, String message, final Cancellable canceller) {
        JPanel panel;
        final JDialog dialog = ModalMessageDlg.createDialog(parent, title);
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        final Runnable finalizer = new Runnable(){

            @Override
            public void run() {
                dialog.setVisible(false);
                dialog.dispose();
                if (postEDTTask != null && !cancelled.get()) {
                    postEDTTask.run();
                }
            }
        };
        if (canceller == null) {
            panel = new ModalMessageDlgPane(message);
        } else {
            Cancellable wrapper = new Cancellable(){

                public boolean cancel() {
                    if (canceller.cancel()) {
                        cancelled.set(true);
                        SwingUtilities.invokeLater(finalizer);
                        return true;
                    }
                    return false;
                }
            };
            panel = new ModalMessageDlgCancellablePane(message, wrapper);
        }
        ModalMessageDlg.addPanel(parent, dialog, panel);
        WindowAdapterImpl windowAdapterImpl = new WindowAdapterImpl(dialog, title, workTask, finalizer);
        if (CndUtils.isStandalone()) {
            RequestProcessor.Task task = windowAdapterImpl.submitJob();
            task.waitFinished();
        } else {
            dialog.addWindowListener(windowAdapterImpl);
            dialog.setVisible(true);
        }
        return !cancelled.get();
    }

    private static JDialog createDialog(Window parent, String title) {
        JDialog dialog;
        if (parent == null) {
            dialog = new JDialog();
        } else if (parent instanceof Frame) {
            dialog = new JDialog((Frame)parent);
        } else {
            assert (parent instanceof Dialog);
            dialog = new JDialog((Dialog)parent);
        }
        dialog.setTitle(title);
        dialog.setModal(true);
        return dialog;
    }

    private static void addPanel(Window parent, JDialog dialog, JPanel panel) {
        dialog.getContentPane().add(panel);
        dialog.setDefaultCloseOperation(0);
        dialog.pack();
        Rectangle bounds = parent == null ? new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()) : parent.getBounds();
        int middleX = bounds.x + bounds.width / 2;
        int middleY = bounds.y + bounds.height / 2;
        Dimension size = dialog.getPreferredSize();
        dialog.setBounds(middleX - size.width / 2, middleY - size.height / 2, size.width, size.height);
    }

    private static class WindowAdapterImpl
    extends WindowAdapter {
        private final String title;
        private final Runnable workTask;
        private final Runnable finalizer;
        private final JDialog dialog;

        public WindowAdapterImpl(JDialog dialog, String title, Runnable workTask, Runnable finalizer) {
            this.title = title;
            this.workTask = workTask;
            this.finalizer = finalizer;
            this.dialog = dialog;
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.dialog.removeWindowListener(this);
            this.submitJob();
        }

        private RequestProcessor.Task submitJob() {
            RequestProcessor.Task task = RP.post((Runnable)new NamedRunnable(this.title){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runImpl() {
                    try {
                        WindowAdapterImpl.this.workTask.run();
                    }
                    finally {
                        SwingUtilities.invokeLater(WindowAdapterImpl.this.finalizer);
                    }
                }
            });
            return task;
        }
    }

    public static interface LongWorker {
        public void doWork();

        public void doPostRunInEDT();
    }
}

