/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.library;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;

public class PersistenceLibrarySupport {
    public static final String VOLUME_TYPE_CLASSPATH = "classpath";
    public static final String VOLUME_TYPE_SRC = "src";
    public static final String VOLUME_TYPE_JAVADOC = "javadoc";
    public static final String LIBRARY_TYPE = "j2se";
    public static final String[] VOLUME_TYPES = new String[]{"classpath", "src", "javadoc"};
    private static final String LIBRARIES_REPOSITORY = "org-netbeans-api-project-libraries/Libraries";
    private static int MAX_DEPTH = 3;
    private FileObject storage = null;
    private static PersistenceLibrarySupport instance;

    private PersistenceLibrarySupport() {
    }

    public static PersistenceLibrarySupport getDefault() {
        if (instance == null) {
            instance = new PersistenceLibrarySupport();
        }
        return instance;
    }

    public void addLibrary(LibraryImplementation libraryImplementation) {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        try {
            this.writeLibrary(this.storage, libraryImplementation);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static final FileObject createStorage() {
        try {
            return FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)LIBRARIES_REPOSITORY);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private synchronized void initStorage() {
        if (this.storage == null) {
            this.storage = PersistenceLibrarySupport.createStorage();
            if (this.storage == null) {
                return;
            }
        }
    }

    private void writeLibrary(final FileObject fileObject, final LibraryImplementation libraryImplementation) throws IOException {
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fileObject2 = fileObject.createData(libraryImplementation.getName(), "xml");
                PersistenceLibrarySupport.writeLibraryDefinition(fileObject2, libraryImplementation);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLibraryDefinition(FileObject fileObject, LibraryImplementation libraryImplementation) throws IOException {
        FileLock fileLock = null;
        PrintWriter printWriter = null;
        try {
            String string;
            fileLock = fileObject.lock();
            printWriter = new PrintWriter(new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8"));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<!DOCTYPE library PUBLIC \"-//NetBeans//DTD Library Declaration 1.0//EN\" \"http://www.netbeans.org/dtds/library-declaration-1_0.dtd\">");
            printWriter.println("<library version=\"1.0\">");
            printWriter.println("\t<name>" + libraryImplementation.getName() + "</name>");
            printWriter.println("\t<type>" + libraryImplementation.getType() + "</type>");
            String string2 = libraryImplementation.getDescription();
            if (string2 != null && string2.length() > 0) {
                printWriter.println("\t<description>" + string2 + "</description>");
            }
            if ((string = libraryImplementation.getLocalizingBundle()) != null && string.length() > 0) {
                printWriter.println("\t<localizing-bundle>" + XMLUtil.toElementContent((String)string) + "</localizing-bundle>");
            }
            String[] stringArray = VOLUME_TYPES;
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.println("\t<volume>");
                printWriter.println("\t\t<type>" + stringArray[i] + "</type>");
                List list = libraryImplementation.getContent(stringArray[i]);
                if (list != null) {
                    for (URL uRL : list) {
                        printWriter.println("\t\t<resource>" + XMLUtil.toElementContent((String)uRL.toExternalForm()) + "</resource>");
                    }
                }
                printWriter.println("\t</volume>");
            }
            printWriter.println("</library>");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public static boolean isValidLibraryJavadocRoot(URL uRL) {
        assert (uRL != null && uRL.toExternalForm().endsWith("/"));
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject == null) {
            return false;
        }
        return PersistenceLibrarySupport.findIndexFolder(fileObject, 1) != null;
    }

    private static FileObject findIndexFolder(FileObject fileObject, int n) {
        if (n > MAX_DEPTH) {
            return null;
        }
        if (fileObject.getFileObject("index-files", null) != null || fileObject.getFileObject("index-all.html", null) != null) {
            return fileObject;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2;
            if (!fileObjectArray[i].isFolder() || (fileObject2 = PersistenceLibrarySupport.findIndexFolder(fileObjectArray[i], n + 1)) == null) continue;
            return fileObject2;
        }
        return null;
    }

    private static boolean containsClass(ClassPath classPath, String string) {
        String string2 = string.replace('.', '/') + ".class";
        return classPath.findResource(string2) != null;
    }

    public static boolean containsService(Library library, String string) {
        String string2 = "META-INF/services/" + string;
        return PersistenceLibrarySupport.containsPath(library.getContent(VOLUME_TYPE_CLASSPATH), string2);
    }

    public static boolean containsClass(LibraryImplementation libraryImplementation, String string) {
        String string2 = string.replace('.', '/') + ".class";
        return PersistenceLibrarySupport.containsPath(libraryImplementation.getContent(VOLUME_TYPE_CLASSPATH), string2);
    }

    public static boolean containsService(LibraryImplementation libraryImplementation, String string) {
        String string2 = "META-INF/services/" + string;
        return PersistenceLibrarySupport.containsPath(libraryImplementation.getContent(VOLUME_TYPE_CLASSPATH), string2);
    }

    private static boolean containsPath(List<URL> list, String string) {
        ClassPath classPath = ClassPathSupport.createClassPath((URL[])list.toArray(new URL[list.size()]));
        return classPath.findResource(string) != null;
    }

    private static ClassPath getLibraryClassPath(Library library) {
        List list = library.getContent(VOLUME_TYPE_CLASSPATH);
        URL[] uRLArray = list.toArray(new URL[list.size()]);
        for (int i = 0; i < uRLArray.length; ++i) {
            if (!FileUtil.isArchiveFile((URL)uRLArray[i])) continue;
            uRLArray[i] = FileUtil.getArchiveRoot((URL)uRLArray[i]);
        }
        return ClassPathSupport.createClassPath((URL[])uRLArray);
    }

    public static Library getLibrary(PersistenceUnit persistenceUnit) {
        return PersistenceLibrarySupport.getLibrary(ProviderUtil.getProvider(persistenceUnit));
    }

    public static Library getLibrary(Provider provider) {
        List<ProviderLibrary> list = PersistenceLibrarySupport.createLibraries();
        for (ProviderLibrary providerLibrary : list) {
            if (!provider.equals(providerLibrary.getProvider())) continue;
            return providerLibrary.getLibrary();
        }
        return null;
    }

    public static void addDriver(Project project, JDBCDriver jDBCDriver) {
    }

    private static List<ProviderLibrary> createLibraries() {
        ArrayList<ProviderLibrary> arrayList = new ArrayList<ProviderLibrary>();
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            ClassPath classPath = PersistenceLibrarySupport.getLibraryClassPath(library);
            Provider provider = PersistenceLibrarySupport.extractProvider(classPath);
            if (provider == null || !PersistenceLibrarySupport.containsClass(classPath, "javax.persistence.EntityManager") || !provider.isOnClassPath(classPath)) continue;
            arrayList.add(new ProviderLibrary(library, classPath, provider));
        }
        Collections.sort(arrayList, new Comparator<ProviderLibrary>(){

            @Override
            public int compare(ProviderLibrary providerLibrary, ProviderLibrary providerLibrary2) {
                String string = providerLibrary.getLibrary().getDisplayName();
                String string2 = providerLibrary2.getLibrary().getDisplayName();
                return string.compareToIgnoreCase(string2);
            }
        });
        return arrayList;
    }

    public static List<Provider> getProvidersFromLibraries() {
        ArrayList<Provider> arrayList = new ArrayList<Provider>();
        for (ProviderLibrary providerLibrary : PersistenceLibrarySupport.createLibraries()) {
            arrayList.add(providerLibrary.getProvider());
        }
        Collections.sort(arrayList, new Comparator<Provider>(){

            @Override
            public int compare(Provider provider, Provider provider2) {
                String string = provider.getDisplayName();
                String string2 = provider2.getDisplayName();
                return string.compareToIgnoreCase(string2);
            }
        });
        return arrayList;
    }

    public static Library getFirstProviderLibrary() {
        List<ProviderLibrary> list = PersistenceLibrarySupport.createLibraries();
        if (!list.isEmpty()) {
            return list.get(0).getLibrary();
        }
        return null;
    }

    private static Provider extractProvider(ClassPath classPath) {
        for (Provider provider : ProviderUtil.getAllProviders()) {
            if (!provider.isOnClassPath(classPath)) continue;
            return provider;
        }
        return null;
    }

    private static class ProviderLibrary {
        private final Library library;
        private final ClassPath classPath;
        private final Provider provider;

        public ProviderLibrary(Library library, ClassPath classPath, Provider provider) {
            assert (library != null);
            assert (classPath != null);
            assert (provider != null);
            this.library = library;
            this.classPath = classPath;
            this.provider = provider;
        }

        public ClassPath getClassPath() {
            return this.classPath;
        }

        public Library getLibrary() {
            return this.library;
        }

        public Provider getProvider() {
            return this.provider;
        }
    }
}

