/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.jsf.editor.JsfSupport;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class InjectCompositeComponent {
    private static final int HINT_PRIORITY = 60;
    private static final String TEMPLATES_FOLDER = "JSF";
    private static final String TEMPLATE_NAME = "out.xhtml";
    private static final Rule injectCCRule = new InjectCCSelectionRule();

    public static void inject(Document document, int n, int n2) {
        try {
            FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            InjectCompositeComponent.instantiateTemplate(project, fileObject, document, n, n2);
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public static Hint getHint(final RuleContext ruleContext, final int n, final int n2) {
        return new Hint(injectCCRule, NbBundle.getMessage(InjectCompositeComponent.class, (String)"MSG_InjectCompositeComponentSelectionHintDescription"), ruleContext.parserResult.getSnapshot().getSource().getFileObject(), new OffsetRange(n, n2), Collections.singletonList(new HintFix(){

            public String getDescription() {
                return NbBundle.getMessage(InjectCompositeComponent.class, (String)"MSG_InjectCompositeComponentSelectionHintDescription");
            }

            public void implement() throws Exception {
                InjectCompositeComponent.inject((Document)ruleContext.doc, n, n2);
            }

            public boolean isSafe() {
                return true;
            }

            public boolean isInteractive() {
                return true;
            }
        }), 60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void instantiateTemplate(Project project, FileObject fileObject, final Document document, final int n, final int n2) throws BadLocationException, DataObjectNotFoundException, IOException, ParseException {
        String string = n == n2 ? null : document.getText(n, n2 - n);
        TemplateWizard templateWizard = new TemplateWizard();
        templateWizard.putProperty("project", (Object)project);
        templateWizard.putProperty("selectedText", (Object)string);
        templateWizard.setTitle(NbBundle.getMessage(InjectCompositeComponent.class, (String)"MSG_InsertCompositeComponent"));
        templateWizard.putProperty("fromEditor", (Object)true);
        DataFolder dataFolder = templateWizard.getTemplatesFolder();
        FileObject fileObject2 = dataFolder.getPrimaryFile().getFileObject("JSF/out.xhtml");
        FileObject fileObject3 = project.getProjectDirectory();
        DataFolder dataFolder2 = DataFolder.findFolder((FileObject)fileObject3);
        final Logger logger = Logger.getLogger(InjectCompositeComponent.class.getSimpleName());
        final JsfSupport jsfSupport = JsfSupport.findFor(fileObject);
        if (jsfSupport == null) {
            logger.warning("Cannot find JsfSupport instance for file " + fileObject.getPath());
            return;
        }
        final SnippetContext snippetContext = InjectCompositeComponent.getSnippetContext(document, n, n2, jsfSupport);
        if (!snippetContext.isValid()) {
            templateWizard.putProperty("incorrectActionContext", (Object)true);
        }
        Source source = Source.create((Document)document);
        final AtomicReference atomicReference = new AtomicReference();
        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                HtmlParserResult htmlParserResult;
                ResultIterator resultIterator2 = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                if (resultIterator2 != null && (htmlParserResult = (HtmlParserResult)resultIterator2.getParserResult()) != null) {
                    atomicReference.set(htmlParserResult.getNamespaces());
                }
            }
        });
        templateWizard.putProperty("declaredPrefixes", atomicReference.get());
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        Set set = templateWizard.instantiate(dataObject, dataFolder2);
        final String string2 = (String)templateWizard.getProperty("selectedPrefix");
        if (set != null && set.size() > 0) {
            final String string3 = ((DataObject)set.iterator().next()).getName();
            FileObject fileObject4 = Templates.getTargetFolder((WizardDescriptor)templateWizard);
            final BaseDocument baseDocument = (BaseDocument)document;
            final Indent indent = Indent.get((Document)baseDocument);
            indent.lock();
            try {
                baseDocument.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            baseDocument.remove(n, n2 - n);
                            String string = "<" + string2 + ":" + string3 + "/>";
                            baseDocument.insertString(n, string, null);
                            indent.reindent(n, n + string.length());
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                });
            }
            finally {
                indent.unlock();
            }
            String string4 = fileObject4.getPath();
            string4 = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject4);
            if (string4.endsWith(File.separator)) {
                string4 = string4.substring(0, string4.lastIndexOf(File.separator));
            }
            string4 = string4.substring(string4.lastIndexOf(File.separator) + 1);
            final String string5 = JsfUtils.getCompositeLibraryURL(string4);
            Source source2 = Source.create((Document)document);
            ParserManager.parseWhenScanFinished(Collections.singletonList(source2), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    FaceletsLibrary faceletsLibrary = jsfSupport.getFaceletsLibraries().get(string5);
                    if (faceletsLibrary != null) {
                        if (!JsfUtils.importLibrary(document, faceletsLibrary, string2)) {
                            logger.warning("Cannot import composite components library " + string5);
                        }
                    } else {
                        logger.warning("Composite components library for uri " + string5 + " seems not to be created.");
                    }
                }
            });
            DataObject dataObject2 = (DataObject)set.iterator().next();
            EditorCookie editorCookie = (EditorCookie)dataObject2.getCookie(EditorCookie.class);
            final StyledDocument styledDocument = editorCookie.openDocument();
            ParserManager.parseWhenScanFinished(Collections.singletonList(source2), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    final LinkedHashMap<FaceletsLibrary, String> linkedHashMap = new LinkedHashMap<FaceletsLibrary, String>();
                    for (String string : snippetContext.getDeclarations().keySet()) {
                        String string2 = snippetContext.getDeclarations().get(string);
                        FaceletsLibrary faceletsLibrary = jsfSupport.getFaceletsLibraries().get(string);
                        if (faceletsLibrary == null) continue;
                        linkedHashMap.put(faceletsLibrary, string2);
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            ((BaseDocument)styledDocument).runAtomic(new Runnable(){

                                @Override
                                public void run() {
                                    JsfUtils.importLibrary(styledDocument, linkedHashMap);
                                }
                            });
                        }
                    });
                }
            });
            editorCookie.saveDocument();
        }
    }

    private static SnippetContext getSnippetContext(Document document, final int n, final int n2, final JsfSupport jsfSupport) {
        final SnippetContext snippetContext = new SnippetContext();
        snippetContext.setValid(true);
        Source source = Source.create((Document)document);
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    final HtmlParserResult htmlParserResult = (HtmlParserResult)JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                    if (htmlParserResult == null) {
                        return;
                    }
                    final int n3 = htmlParserResult.getSnapshot().getEmbeddedOffset(n);
                    final int n22 = htmlParserResult.getSnapshot().getEmbeddedOffset(n2);
                    try {
                        for (final String string : htmlParserResult.getNamespaces().keySet()) {
                            if (!jsfSupport.getFaceletsLibraries().containsKey(string)) continue;
                            AstNode astNode = htmlParserResult.root(string);
                            AstNodeUtils.visitChildren((AstNode)astNode, (AstNodeVisitor)new AstNodeVisitor(){

                                public void visit(AstNode astNode) {
                                    AstNode astNode2;
                                    int n = astNode.logicalStartOffset();
                                    int n2 = astNode.logicalEndOffset();
                                    if (n >= n3 && n <= n22 || n2 >= n3 && n2 <= n22) {
                                        snippetContext.addDeclaration(string, (String)htmlParserResult.getNamespaces().get(string));
                                    }
                                    if (n3 > n && n3 < n2 && (n22 <= n || n22 >= n2) || n22 > n && n22 < n2 && (n3 <= n || n3 >= n2)) {
                                        this.fail();
                                    }
                                    if ((astNode2 = astNode.getMatchingTag()) == null && !astNode.isEmpty()) {
                                        this.fail();
                                    }
                                    if (this.isInTagItself(astNode, n3) || this.isInTagItself(astNode, n22) || this.isInTagItself(astNode2, n3) || this.isInTagItself(astNode2, n22)) {
                                        this.fail();
                                    }
                                }

                                private boolean isInTagItself(AstNode astNode, int n) {
                                    return astNode != null && astNode.startOffset() < n && astNode.endOffset() > n;
                                }

                                private void fail() {
                                    snippetContext.setValid(false);
                                    throw new AstTreeVisitingBreakException();
                                }
                            }, (AstNode.NodeType)AstNode.NodeType.OPEN_TAG);
                        }
                    }
                    catch (AstTreeVisitingBreakException astTreeVisitingBreakException) {
                        snippetContext.setValid(false);
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return snippetContext;
    }

    public static class InjectCCCodeGen
    implements CodeGenerator {
        public String getDisplayName() {
            return NbBundle.getMessage(InjectCompositeComponent.class, (String)"MSG_InjectCompositeComponentHint");
        }

        public void invoke() {
            JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
            Document document = jTextComponent.getDocument();
            int n = jTextComponent.getSelectionStart();
            int n2 = jTextComponent.getSelectionEnd();
            InjectCompositeComponent.inject(document, n, n2);
        }
    }

    private static class InjectCCSelectionRule
    implements Rule.SelectionRule {
        private InjectCCSelectionRule() {
        }

        public boolean appliesTo(RuleContext ruleContext) {
            return true;
        }

        public String getDisplayName() {
            return null;
        }

        public boolean showInTasklist() {
            return false;
        }

        public HintSeverity getDefaultSeverity() {
            return HintSeverity.CURRENT_LINE_WARNING;
        }
    }

    private static class SnippetContext {
        private boolean valid;
        private Map<String, String> relatedDeclarations = new HashMap<String, String>();

        private SnippetContext() {
        }

        public void setValid(boolean bl) {
            this.valid = bl;
        }

        public void addDeclaration(String string, String string2) {
            this.relatedDeclarations.put(string, string2);
        }

        public Map<String, String> getDeclarations() {
            return this.relatedDeclarations;
        }

        public boolean isValid() {
            return this.valid;
        }
    }

    private static class AstTreeVisitingBreakException
    extends RuntimeException {
        private AstTreeVisitingBreakException() {
        }
    }
}

