/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.lang.ref.WeakReference;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.cpu.InstrTimingData;

public class TimingAdjusterOld {
    private static TimingAdjusterOld instance;
    private static WeakReference lastStatusRef;
    private InstrTimingData timingData;

    private TimingAdjusterOld(InstrTimingData timing) {
        this.timingData = timing;
    }

    public static synchronized TimingAdjusterOld getDefault() {
        if (instance == null) {
            instance = new TimingAdjusterOld(InstrTimingData.DEFAULT);
        }
        return instance;
    }

    public static synchronized TimingAdjusterOld getInstance(ProfilingSessionStatus status) {
        if (instance != null) {
            ProfilingSessionStatus lastStatus;
            ProfilingSessionStatus profilingSessionStatus = lastStatus = lastStatusRef != null ? (ProfilingSessionStatus)lastStatusRef.get() : null;
            if (lastStatus != null && !lastStatus.equals(status) || lastStatus == null) {
                lastStatusRef = new WeakReference<ProfilingSessionStatus>(status);
                switch (status.currentInstrType) {
                    case 2: {
                        instance = new TimingAdjusterOld(TimingAdjusterOld.getFullInstrTimingData(status));
                        break;
                    }
                    case 3: {
                        instance = new TimingAdjusterOld(TimingAdjusterOld.getSampledInstrTimingData(status));
                    }
                }
            }
        } else {
            lastStatusRef = new WeakReference<ProfilingSessionStatus>(status);
            switch (status.currentInstrType) {
                case 2: {
                    instance = new TimingAdjusterOld(TimingAdjusterOld.getFullInstrTimingData(status));
                    break;
                }
                case 3: {
                    instance = new TimingAdjusterOld(TimingAdjusterOld.getSampledInstrTimingData(status));
                }
            }
        }
        return instance;
    }

    public final double adjustTime(long time, int incommingInv, int outgoingInv, boolean secondTimestamp) {
        if (this.timingData == null) {
            return time;
        }
        if (this.timingData.methodEntryExitCallTime0 == 0.0) {
            if (secondTimestamp) {
                return (double)time / (double)this.timingData.timerCountsInSecond1;
            }
            return (double)time / (double)this.timingData.timerCountsInSecond0;
        }
        if (secondTimestamp) {
            return ((double)time - (double)incommingInv * this.timingData.methodEntryExitInnerTime1 - (double)outgoingInv * this.timingData.methodEntryExitOuterTime1) * 1000000.0 / (double)this.timingData.timerCountsInSecond1;
        }
        return ((double)time - (double)incommingInv * this.timingData.methodEntryExitInnerTime0 - (double)outgoingInv * this.timingData.methodEntryExitOuterTime0) * 1000000.0 / (double)this.timingData.timerCountsInSecond0;
    }

    public final double delta(int incommingInv, int outgoingInv, boolean secondTimestamp) {
        if (this.timingData == null || this.timingData.methodEntryExitCallTime0 == 0.0) {
            return 0.0;
        }
        double adjusted = 0.0;
        adjusted = secondTimestamp ? ((double)incommingInv * this.timingData.methodEntryExitInnerTime1 + (double)outgoingInv * this.timingData.methodEntryExitOuterTime1) * 1000000.0 / (double)this.timingData.timerCountsInSecond1 : ((double)incommingInv * this.timingData.methodEntryExitInnerTime0 + (double)outgoingInv * this.timingData.methodEntryExitOuterTime0) * 1000000.0 / (double)this.timingData.timerCountsInSecond0;
        if (adjusted < 0.0) {
            adjusted = 0.0;
        }
        return adjusted;
    }

    public InstrTimingData getInstrTimingData() {
        InstrTimingData data = TimingAdjusterOld.getFullInstrTimingData(lastStatusRef != null ? (ProfilingSessionStatus)lastStatusRef.get() : null);
        return data != null ? (InstrTimingData)data.clone() : (InstrTimingData)InstrTimingData.DEFAULT.clone();
    }

    private static InstrTimingData getFullInstrTimingData(ProfilingSessionStatus status) {
        if (status == null) {
            return null;
        }
        InstrTimingData timingData = new InstrTimingData();
        double safetyMargin0 = 0.88;
        double safetyMargin1 = 0.88;
        double safetyMargin2 = 0.88;
        if (status.collectingTwoTimeStamps()) {
            timingData.methodEntryExitCallTime0 = status.methodEntryExitCallTime[2] * safetyMargin2;
            timingData.methodEntryExitCallTime1 = status.methodEntryExitCallTime[3] * (double)status.timerCountsInSecond[1] / (double)status.timerCountsInSecond[0] * safetyMargin2;
            timingData.methodEntryExitInnerTime0 = status.methodEntryExitInnerTime[2] * safetyMargin2;
            timingData.methodEntryExitOuterTime0 = status.methodEntryExitOuterTime[2] * safetyMargin2;
            timingData.methodEntryExitInnerTime1 = status.methodEntryExitInnerTime[3] * (double)status.timerCountsInSecond[1] / (double)status.timerCountsInSecond[0] * safetyMargin2;
            timingData.methodEntryExitOuterTime1 = status.methodEntryExitOuterTime[3] * (double)status.timerCountsInSecond[1] / (double)status.timerCountsInSecond[0] * safetyMargin2;
            timingData.timerCountsInSecond0 = status.timerCountsInSecond[0];
            timingData.timerCountsInSecond1 = status.timerCountsInSecond[1];
        } else if (status.absoluteTimerOn) {
            timingData.methodEntryExitCallTime0 = status.methodEntryExitCallTime[0] * safetyMargin0;
            timingData.methodEntryExitInnerTime0 = status.methodEntryExitInnerTime[0] * safetyMargin0;
            timingData.methodEntryExitOuterTime0 = status.methodEntryExitOuterTime[0] * safetyMargin0;
            timingData.timerCountsInSecond0 = status.timerCountsInSecond[0];
        } else {
            String targetMachineOSName = status.targetMachineOSName;
            if (Platform.isWindows(targetMachineOSName) || Platform.isLinux(targetMachineOSName)) {
                safetyMargin1 = 0.0;
            }
            timingData.methodEntryExitCallTime0 = status.methodEntryExitCallTime[1] * (double)status.timerCountsInSecond[1] / (double)status.timerCountsInSecond[0] * safetyMargin1;
            timingData.methodEntryExitInnerTime0 = status.methodEntryExitInnerTime[1] * (double)status.timerCountsInSecond[1] / (double)status.timerCountsInSecond[0] * safetyMargin1;
            timingData.methodEntryExitOuterTime0 = status.methodEntryExitOuterTime[1] * (double)status.timerCountsInSecond[1] / (double)status.timerCountsInSecond[0] * safetyMargin1;
            timingData.timerCountsInSecond0 = status.timerCountsInSecond[1];
        }
        return timingData;
    }

    private static InstrTimingData getSampledInstrTimingData(ProfilingSessionStatus status) {
        if (status == null) {
            return null;
        }
        InstrTimingData timingData = new InstrTimingData();
        double entryExitTimeInAbsCounts = status.methodEntryExitCallTime[4];
        double entryExitTimeInThreadCPUCounts = entryExitTimeInAbsCounts / (double)status.timerCountsInSecond[0] * (double)status.timerCountsInSecond[1];
        if (status.collectingTwoTimeStamps()) {
            timingData.methodEntryExitCallTime0 = entryExitTimeInAbsCounts;
            timingData.methodEntryExitCallTime1 = entryExitTimeInThreadCPUCounts;
            timingData.methodEntryExitInnerTime0 = entryExitTimeInAbsCounts;
            timingData.methodEntryExitOuterTime0 = 0.0;
            timingData.methodEntryExitInnerTime1 = entryExitTimeInThreadCPUCounts;
            timingData.methodEntryExitOuterTime1 = 0.0;
            timingData.timerCountsInSecond0 = status.timerCountsInSecond[0];
            timingData.timerCountsInSecond1 = status.timerCountsInSecond[1];
        } else if (status.absoluteTimerOn) {
            timingData.methodEntryExitCallTime0 = entryExitTimeInAbsCounts;
            timingData.methodEntryExitInnerTime0 = entryExitTimeInAbsCounts;
            timingData.methodEntryExitOuterTime0 = 0.0;
            timingData.timerCountsInSecond0 = status.timerCountsInSecond[0];
        } else {
            timingData.methodEntryExitCallTime0 = entryExitTimeInThreadCPUCounts;
            timingData.methodEntryExitInnerTime0 = entryExitTimeInThreadCPUCounts;
            timingData.methodEntryExitOuterTime0 = 0.0;
            timingData.timerCountsInSecond0 = status.timerCountsInSecond[1];
        }
        return timingData;
    }
}

