/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.launchers;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.PropertyResourceBundle;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.helper.JavaCompatibleProperties;
import org.netbeans.installer.utils.system.launchers.LauncherResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LauncherProperties
implements Cloneable {
    protected File stubFile;
    protected List<LauncherResource> jars;
    protected List<LauncherResource> jvms;
    protected List<LauncherResource> otherResources;
    protected HashMap<String, PropertyResourceBundle> i18nMap;
    protected LauncherResource testJVMFile;
    protected File outputFile;
    protected boolean addExtenstion;
    protected List<String> jvmArguments;
    protected List<String> appArguments;
    protected String mainClass;
    protected String testJVMClass;
    protected List<JavaCompatibleProperties> compatibleJava;
    protected String i18nPrefix;
    protected String i18nBundleBaseName;
    private static final String ERROR_CANNOT_LOAD_BUNDLE_KEY = "LP.error.cannot.load.bundle";
    private static final String ERROR_NO_FILES_KEY = "LP.error.no.files";
    private static final String ERROR_NOT_DIRECTORY_KEY = "LP.error.not.directory";
    private static final String ERROR_DIRECTORY_DONT_EXIST_KEY = "LP.error.directory.do.not.exist";

    public LauncherResource getTestJVMFile() {
        return this.testJVMFile;
    }

    public LauncherProperties(LauncherProperties nl) {
        this.appArguments = nl.appArguments;
        this.jvmArguments = nl.jvmArguments;
        this.i18nMap = nl.i18nMap;
        this.i18nPrefix = nl.i18nPrefix;
        this.i18nBundleBaseName = nl.i18nBundleBaseName;
        this.jars = nl.jars;
        this.jvms = nl.jvms;
        this.outputFile = nl.outputFile;
        this.addExtenstion = nl.addExtenstion;
        this.compatibleJava = nl.compatibleJava;
        this.mainClass = nl.mainClass;
        this.testJVMClass = nl.testJVMClass;
        this.stubFile = nl.stubFile;
        this.testJVMFile = nl.testJVMFile;
        this.otherResources = nl.otherResources;
    }

    public LauncherProperties() {
        this.compatibleJava = new ArrayList<JavaCompatibleProperties>();
        this.jvmArguments = new ArrayList<String>();
        this.appArguments = new ArrayList<String>();
        this.i18nMap = new HashMap();
        this.i18nPrefix = null;
        this.i18nBundleBaseName = null;
        this.jars = new ArrayList<LauncherResource>();
        this.jvms = new ArrayList<LauncherResource>();
        this.otherResources = new ArrayList<LauncherResource>();
    }

    public void setLauncherStub(File launcherStub) {
        this.stubFile = launcherStub;
    }

    public void addJar(LauncherResource file) {
        this.jars.add(file);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getTestJVMClass() {
        return this.testJVMClass;
    }

    public void setJvmArguments(String[] jvmArguments) {
        this.jvmArguments = new ArrayList<String>();
        for (String s : jvmArguments) {
            this.jvmArguments.add(s);
        }
    }

    public void setJvmArguments(List<String> jvmArguments) {
        this.jvmArguments = jvmArguments;
    }

    public void setI18n(File i18nDir) throws IOException {
        this.loadPropertiesMap(this.getPropertiesFiles(i18nDir));
    }

    public void setI18n(File[] files) throws IOException {
        this.loadPropertiesMap(files);
    }

    public void setI18n(String[] resources) throws IOException {
        this.loadPropertiesMap(resources);
    }

    public void setI18n(List<String> resources) throws IOException {
        this.loadPropertiesMap(resources);
    }

    public void setI18nPrefix(String i18nPrefix) throws IOException {
        this.i18nPrefix = i18nPrefix;
    }

    public void setI18nBundleBaseName(String i18nBundleBaseName) throws IOException {
        this.i18nBundleBaseName = i18nBundleBaseName;
    }

    public String getI18NResourcePrefix() {
        return this.i18nPrefix;
    }

    public String getI18NBundleBaseName() {
        return this.i18nBundleBaseName;
    }

    public void setOutput(File output) {
        this.setOutput(output, false);
    }

    public void setOutput(File output, boolean addExt) {
        this.outputFile = output;
        this.addExtenstion = addExt;
    }

    public void setTestJVM(LauncherResource testJVM) {
        this.testJVMFile = testJVM;
    }

    public void addCompatibleJava(JavaCompatibleProperties javaProp) {
        this.compatibleJava.add(javaProp);
    }

    public void setAppArguments(String[] appArguments) {
        this.appArguments = new ArrayList<String>();
        for (String s : appArguments) {
            this.appArguments.add(s);
        }
    }

    public void setAppArguments(List<String> appArguments) {
        this.appArguments = appArguments;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public List<LauncherResource> getJars() {
        return this.jars;
    }

    public List<String> getAppArguments() {
        return this.appArguments;
    }

    public List<String> getJvmArguments() {
        return this.jvmArguments;
    }

    public List<JavaCompatibleProperties> getJavaCompatibleProperties() {
        return this.compatibleJava;
    }

    public File getStubFile() {
        return this.stubFile;
    }

    public void addJVM(LauncherResource location) {
        this.jvms.add(location);
    }

    public List<LauncherResource> getJVMs() {
        return this.jvms;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setTestJVMClass(String testClass) {
        this.testJVMClass = testClass;
    }

    HashMap<String, PropertyResourceBundle> getI18nMap() {
        return this.i18nMap;
    }

    public void addOtherResource(LauncherResource resource) {
        this.otherResources.add(resource);
    }

    public List<LauncherResource> getOtherResources() {
        return this.otherResources;
    }

    private String getLocaleName(String name) {
        String loc = "";
        int idx = name.indexOf("_");
        int end = name.indexOf(".properties");
        if (idx != -1) {
            loc = name.substring(idx + 1, end);
        }
        return loc;
    }

    private PropertyResourceBundle getBundle(File file) throws IOException {
        return this.getBundle(file.getPath(), new FileInputStream(file));
    }

    private PropertyResourceBundle getBundle(String dest, InputStream is) throws IOException {
        if (is == null) {
            throw new IOException(ResourceUtils.getString(LauncherProperties.class, ERROR_CANNOT_LOAD_BUNDLE_KEY, dest));
        }
        try {
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(is);
            return propertyResourceBundle;
        }
        catch (IOException ex) {
            throw new IOException(ResourceUtils.getString(LauncherProperties.class, ERROR_CANNOT_LOAD_BUNDLE_KEY, dest));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex2) {
                Object ex2 = null;
            }
        }
    }

    private void loadPropertiesMap(String[] resources) throws IOException {
        this.i18nMap.clear();
        for (String resource : resources) {
            String loc = this.getLocaleName(ResourceUtils.getResourceFileName(resource));
            this.i18nMap.put(loc, this.getBundle(resource, ResourceUtils.getResource(resource)));
        }
    }

    private void loadPropertiesMap(List<String> resources) throws IOException {
        String[] array = new String[resources.size()];
        for (int i = 0; i < resources.size(); ++i) {
            array[i] = resources.get(i);
        }
        this.loadPropertiesMap(array);
    }

    private File[] getPropertiesFiles(File dir) throws IOException {
        if (!dir.exists()) {
            throw new IOException(ResourceUtils.getString(LauncherProperties.class, ERROR_DIRECTORY_DONT_EXIST_KEY, dir));
        }
        if (!dir.isDirectory()) {
            throw new IOException(ResourceUtils.getString(LauncherProperties.class, ERROR_NOT_DIRECTORY_KEY, dir));
        }
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File filename) {
                return filename.getName().endsWith(".properties");
            }
        });
        if (files == null || files.length == 0) {
            throw new IOException(ResourceUtils.getString(LauncherProperties.class, ERROR_NO_FILES_KEY, dir));
        }
        return files;
    }

    private void loadPropertiesMap(File[] files) throws IOException {
        this.i18nMap.clear();
        for (File f : files) {
            String loc = this.getLocaleName(f.getName());
            LogManager.log("Adding bundle with locale [" + loc + "] using file " + f);
            this.i18nMap.put(loc, this.getBundle(f));
        }
    }
}

