/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.netbeans.modules.ruby.railsprojects.server.RailsServerUiUtils;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.RailsInstallationValidator;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RailsInstallationPanel
extends JPanel {
    private static final String JRUBY_OPENSSL = "jruby-openssl";
    private static final String WARBLE_CMD = "warble";
    private static final String WARBLER = "warbler";
    private static final String GLASSFISH = "glassfish";
    private Panel firer;
    private WizardDescriptor wizardDescriptor;
    private JLabel descLabel;
    private JLabel gfGemLabel;
    private JButton installGfGemButton;
    private JButton installWarblerButton;
    private JSeparator jSeparator1;
    private JLabel jrubyLabel;
    private JLabel jrubySslLabel;
    private JButton proxyButton;
    private JButton railsButton;
    private JButton railsDetailButton;
    private JComboBox railsVersionComboBox;
    private JLabel railsVersionLabel;
    private JButton sslButton;
    private JLabel warblerLabel;
    private JCheckBox withDispatchersCheckBox;

    RailsInstallationPanel(Panel panel) {
        this.initComponents();
        this.firer = panel;
        this.initComponents();
        this.setName(NbBundle.getMessage(RailsInstallationPanel.class, (String)"LAB_InstallRails"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(RailsInstallationPanel.class, (String)"TXT_NewRoRApp"));
        this.initWithDispatchersCheckBox();
    }

    private void initWithDispatchersCheckBox() {
        boolean enable = false;
        String selected = (String)this.railsVersionComboBox.getSelectedItem();
        if (selected != null) {
            RailsProjectUtil.RailsVersion version23 = new RailsProjectUtil.RailsVersion(2, 3);
            enable = RailsProjectUtil.versionFor(selected).compareTo(version23) >= 0;
        }
        this.withDispatchersCheckBox.setSelected(this.withDispatchersCheckBox.isSelected() && enable);
        this.withDispatchersCheckBox.setEnabled(enable);
    }

    private void initRailsVersionComboBox() {
        List gemInfos = this.platform().getGemManager().getVersions("rails");
        int size = gemInfos.size();
        this.railsVersionComboBox.setEnabled(size > 0);
        this.railsVersionLabel.setEnabled(size > 0);
        String[] versions = new String[size];
        for (int i = 0; i < size; ++i) {
            versions[i] = ((GemInfo)gemInfos.get(i)).getVersion();
        }
        this.railsVersionComboBox.setModel(new DefaultComboBoxModel<String>(versions));
    }

    private RubyPlatform platform() {
        return (RubyPlatform)this.wizardDescriptor.getProperty("platform");
    }

    private GemManager gemManager() {
        return this.platform().getGemManager();
    }

    private void updateGemProblem() {
        String gemProblem = this.platform().getRubyGemsProblems();
        if (gemProblem != null) {
            String msg = NbBundle.getMessage(RailsInstallationPanel.class, (String)"GemProblem");
            this.descLabel.setText(msg);
            this.railsButton.setEnabled(false);
            this.sslButton.setEnabled(false);
        } else {
            this.railsDetailButton.setVisible(false);
        }
    }

    private void updateLabel() {
        String version;
        RailsInstallationValidator.RailsInstallationInfo railsInfo = RailsInstallationValidator.getRailsInstallation(this.platform());
        if (railsInfo.isValid()) {
            this.descLabel.setText(railsInfo.getMessage());
            Mnemonics.setLocalizedText((AbstractButton)this.railsButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"UpdateRails"));
        } else {
            this.descLabel.setText(railsInfo.getMessage());
            Mnemonics.setLocalizedText((AbstractButton)this.railsButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"InstallRails"));
        }
        if (!this.isWarblerInstalled()) {
            this.warblerLabel.setText(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.warblerLabel.text"));
            Mnemonics.setLocalizedText((AbstractButton)this.installWarblerButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.installWarblerButton.text"));
        } else {
            version = this.gemManager().getLatestVersion(WARBLER);
            this.warblerLabel.setText(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.warblerLabel.text.installed", (Object)version));
            Mnemonics.setLocalizedText((AbstractButton)this.installWarblerButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.updateWarblerButton.text"));
        }
        if (!this.isGlassFishGemInstalled()) {
            this.gfGemLabel.setText(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.gfGemLabel.text"));
            Mnemonics.setLocalizedText((AbstractButton)this.installGfGemButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.installGfGemButton.text"));
        } else {
            version = this.gemManager().getLatestVersion(GLASSFISH);
            this.gfGemLabel.setText(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.gfGemLabel.text.installed", (Object)version));
            Mnemonics.setLocalizedText((AbstractButton)this.installGfGemButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.updateGfGemButton.text"));
        }
        if (!this.isJRubyOpenSSLInstalled()) {
            this.jrubySslLabel.setText(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.jrubySslLabel.text"));
            Mnemonics.setLocalizedText((AbstractButton)this.sslButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.sslButton.text"));
        } else {
            version = this.gemManager().getLatestVersion(JRUBY_OPENSSL);
            this.jrubySslLabel.setText(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.jrubySslLabel.installed.text", (Object)version));
            Mnemonics.setLocalizedText((AbstractButton)this.sslButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.update.sslButton.text"));
        }
    }

    void read(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        this.updateLabel();
        this.updateGemProblem();
        this.updateGemProblem();
        this.initRailsVersionComboBox();
        this.initWithDispatchersCheckBox();
    }

    void store(WizardDescriptor settings) {
        String version = (String)this.railsVersionComboBox.getSelectedItem();
        GemManager gemManager = this.gemManager();
        if (gemManager != null) {
            String latest = gemManager.getLatestVersion("rails");
            if (version != null && !version.equals(latest)) {
                settings.putProperty("rails.version", this.railsVersionComboBox.getSelectedItem());
            }
        }
        if (this.withDispatchersCheckBox.isSelected()) {
            settings.putProperty("rails.options", (Object)"--with-dispatchers");
        }
    }

    boolean valid(WizardDescriptor settings) {
        if (!this.platform().isValid(false)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RailsInstallationPanel.class, (String)"NoRuby"));
            return false;
        }
        RailsInstallationValidator.RailsInstallationInfo railsInfo = RailsInstallationValidator.getRailsInstallation(this.platform());
        if (!railsInfo.isValid()) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)railsInfo.getMessage());
            return false;
        }
        if (((Boolean)this.wizardDescriptor.getProperty("warSupport")).booleanValue() && !this.isWarblerInstalled()) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RailsInstallationPanel.class, (String)"MSG_NoWarbler"));
            return false;
        }
        RubyInstance server = (RubyInstance)this.wizardDescriptor.getProperty("serverInstance");
        if (!RailsServerUiUtils.isValidServer(server)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RailsInstallationPanel.class, (String)"MSG_NoGfGem"));
            return false;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    private boolean isGlassFishGemInstalled() {
        return this.gemManager().isGemInstalled(GLASSFISH);
    }

    private boolean isWarblerInstalled() {
        return this.gemManager().isGemInstalled(WARBLER) && this.platform().findExecutable(WARBLE_CMD) != null;
    }

    private boolean isJRubyOpenSSLInstalled() {
        return this.gemManager().isGemInstalled(JRUBY_OPENSSL);
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    private void initComponents() {
        this.railsButton = new JButton();
        this.sslButton = new JButton();
        this.descLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jrubyLabel = new JLabel();
        this.jrubySslLabel = new JLabel();
        this.proxyButton = new JButton();
        this.railsDetailButton = new JButton();
        this.railsVersionLabel = new JLabel();
        this.railsVersionComboBox = new JComboBox();
        this.warblerLabel = new JLabel();
        this.installWarblerButton = new JButton();
        this.gfGemLabel = new JLabel();
        this.installGfGemButton = new JButton();
        this.withDispatchersCheckBox = new JCheckBox();
        FormListener formListener = new FormListener();
        Mnemonics.setLocalizedText((AbstractButton)this.railsButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"InstallRails"));
        this.railsButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.sslButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.sslButton.text"));
        this.sslButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.descLabel, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"NoRails"));
        Mnemonics.setLocalizedText((JLabel)this.jrubyLabel, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.jrubyLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jrubySslLabel, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.jrubySslLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.proxyButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.proxyButton.text"));
        this.proxyButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.railsDetailButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.railsDetailButton.text"));
        this.railsDetailButton.addActionListener(formListener);
        this.railsVersionLabel.setLabelFor(this.railsVersionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.railsVersionLabel, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.railsVersionLabel.text"));
        this.railsVersionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.railsVersionComboBox.addItemListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.warblerLabel, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.warblerLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.installWarblerButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.installWarblerButton.text"));
        this.installWarblerButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.gfGemLabel, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.gfGemLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.installGfGemButton, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.installGfGemButton.text"));
        this.installGfGemButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.withDispatchersCheckBox, (String)NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.withDispatchersCheckBox.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.withDispatchersCheckBox).add((Component)this.proxyButton).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.railsVersionLabel).addPreferredGap(0).add((Component)this.railsVersionComboBox, -2, 87, -2)).add((Component)this.descLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.railsDetailButton).add((Component)this.railsButton)).add(162, 162, 162)).add((Component)this.jSeparator1, -2, 469, -2).add((Component)this.jrubySslLabel).add((Component)this.sslButton).add((Component)this.warblerLabel).add((Component)this.installWarblerButton).add((Component)this.gfGemLabel).add((Component)this.installGfGemButton).add((Component)this.jrubyLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.descLabel).add((Component)this.railsDetailButton)).add(13, 13, 13).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.railsVersionLabel).add((Component)this.railsVersionComboBox, -2, -1, -2).add((Component)this.railsButton)).addPreferredGap(0).add((Component)this.withDispatchersCheckBox).addPreferredGap(0).add((Component)this.jSeparator1, -2, 5, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jrubyLabel).addPreferredGap(1).add((Component)this.jrubySslLabel).addPreferredGap(0).add((Component)this.sslButton).addPreferredGap(0).add((Component)this.warblerLabel).addPreferredGap(0).add((Component)this.installWarblerButton).addPreferredGap(0).add((Component)this.gfGemLabel).addPreferredGap(0).add((Component)this.installGfGemButton).add(18, 18, 18).add((Component)this.proxyButton).addContainerGap()));
        this.railsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.railsButton.AccessibleContext.accessibleDescription"));
        this.sslButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.sslButton.AccessibleContext.accessibleDescription"));
        this.proxyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.proxyButton.AccessibleContext.accessibleDescription"));
        this.railsDetailButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsInstallationPanel.class, (String)"RailsInstallationPanel.railsDetailButton.AccessibleContext.accessibleDescription"));
    }

    private void railsDetailButtonActionPerformed(ActionEvent evt) {
        this.platform().reportRubyGemsProblem();
    }

    private void proxyButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void sslButtonActionPerformed(ActionEvent evt) {
        InstallationComplete asyncCompletionTask = new InstallationComplete();
        Gem gem = new Gem(JRUBY_OPENSSL, null, null);
        if (this.gemManager().isGemInstalled(JRUBY_OPENSSL)) {
            this.gemManager().update(new Gem[]{gem}, (Component)this, false, false, true, true, (Runnable)asyncCompletionTask);
        } else {
            this.gemManager().install(new Gem[]{gem}, (Component)this, false, false, null, true, true, (Runnable)asyncCompletionTask);
        }
    }

    private void railsButtonActionPerformed(ActionEvent evt) {
        Gem[] gemArray;
        InstallationComplete asyncCompletionTask = new InstallationComplete();
        Gem rails = new Gem("rails", null, null);
        Gem jdbc = new Gem("activerecord-jdbc-adapter", null, null);
        if (this.platform().isJRuby()) {
            Gem[] gemArray2 = new Gem[2];
            gemArray2[0] = rails;
            gemArray = gemArray2;
            gemArray2[1] = jdbc;
        } else {
            Gem[] gemArray3 = new Gem[1];
            gemArray = gemArray3;
            gemArray3[0] = rails;
        }
        Gem[] gems = gemArray;
        RailsInstallationValidator.RailsInstallationInfo railsInfo = RailsInstallationValidator.getRailsInstallation(this.platform());
        if (railsInfo.getVersion() == null) {
            this.gemManager().install(gems, (Component)this, false, false, null, true, true, (Runnable)asyncCompletionTask);
        } else {
            this.gemManager().update(gems, (Component)this, false, false, true, true, (Runnable)asyncCompletionTask);
        }
    }

    private void installWarblerButtonActionPerformed(ActionEvent evt) {
        this.updateOrInstallGem(WARBLER);
    }

    private void updateOrInstallGem(String gemName) {
        InstallationComplete asyncCompletionTask = new InstallationComplete();
        Gem gem = new Gem(gemName, null, null);
        Gem[] gems = new Gem[]{gem};
        GemManager gemManager = this.platform().getGemManager();
        if (gemManager.isGemInstalled(gemName)) {
            this.gemManager().update(gems, (Component)this, false, false, true, true, (Runnable)asyncCompletionTask);
        } else {
            this.gemManager().install(gems, (Component)this, false, false, null, true, true, (Runnable)asyncCompletionTask);
        }
    }

    private void installGfGemButtonActionPerformed(ActionEvent evt) {
        this.updateOrInstallGem(GLASSFISH);
    }

    private void railsVersionComboBoxItemStateChanged(ItemEvent evt) {
        this.initWithDispatchersCheckBox();
    }

    static class Panel
    implements WizardDescriptor.ValidatingPanel {
        private ArrayList<ChangeListener> listeners;
        private RailsInstallationPanel component;
        private WizardDescriptor settings;

        Panel() {
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
        }

        public void addChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        public void readSettings(Object settings) {
            this.settings = (WizardDescriptor)settings;
            this.component.read(this.settings);
            Object substitute = this.component.getClientProperty("NewProjectWizard_Title");
            if (substitute != null) {
                this.settings.putProperty("NewProjectWizard_Title", substitute);
            }
        }

        public void storeSettings(Object settings) {
            this.component.store((WizardDescriptor)settings);
        }

        public void validate() throws WizardValidationException {
            this.component.validate(this.settings);
        }

        public boolean isValid() {
            return this.component.valid(this.settings);
        }

        public synchronized Component getComponent() {
            if (this.component == null) {
                this.component = new RailsInstallationPanel(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(RailsInstallationPanel.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChangeEvent() {
            Iterator it = null;
            Panel panel = this;
            synchronized (panel) {
                if (this.listeners == null) {
                    return;
                }
                it = ((ArrayList)this.listeners.clone()).iterator();
            }
            ChangeEvent event = new ChangeEvent(this);
            while (it.hasNext()) {
                ((ChangeListener)it.next()).stateChanged(event);
            }
        }
    }

    private class InstallationComplete
    implements Runnable {
        private InstallationComplete() {
        }

        @Override
        public void run() {
            RailsInstallationPanel.this.platform().recomputeRoots();
            RailsServerUiUtils.replaceFakeGlassFish(RailsInstallationPanel.this.wizardDescriptor);
            RailsInstallationPanel.this.updateLabel();
            RailsInstallationPanel.this.firer.fireChangeEvent();
            RailsInstallationPanel.this.platform().recomputeRoots();
            RailsInstallationPanel.this.initRailsVersionComboBox();
            RailsInstallationPanel.this.initWithDispatchersCheckBox();
        }
    }

    private class FormListener
    implements ActionListener,
    ItemListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == RailsInstallationPanel.this.railsButton) {
                RailsInstallationPanel.this.railsButtonActionPerformed(evt);
            } else if (evt.getSource() == RailsInstallationPanel.this.sslButton) {
                RailsInstallationPanel.this.sslButtonActionPerformed(evt);
            } else if (evt.getSource() == RailsInstallationPanel.this.proxyButton) {
                RailsInstallationPanel.this.proxyButtonActionPerformed(evt);
            } else if (evt.getSource() == RailsInstallationPanel.this.railsDetailButton) {
                RailsInstallationPanel.this.railsDetailButtonActionPerformed(evt);
            } else if (evt.getSource() == RailsInstallationPanel.this.installWarblerButton) {
                RailsInstallationPanel.this.installWarblerButtonActionPerformed(evt);
            } else if (evt.getSource() == RailsInstallationPanel.this.installGfGemButton) {
                RailsInstallationPanel.this.installGfGemButtonActionPerformed(evt);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getSource() == RailsInstallationPanel.this.railsVersionComboBox) {
                RailsInstallationPanel.this.railsVersionComboBoxItemStateChanged(evt);
            }
        }
    }
}

