/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.xref.CsmLabelResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.openide.util.CharSequences;

public final class LabelResolverImpl
extends CsmLabelResolver {
    public Collection<CsmReference> getLabels(CsmFunctionDefinition csmFunctionDefinition, CharSequence charSequence, Set<CsmLabelResolver.LabelKind> set) {
        Context context = new Context(csmFunctionDefinition, charSequence, set);
        if (csmFunctionDefinition != null) {
            this.processInnerStatements((CsmStatement)csmFunctionDefinition.getBody(), context);
        }
        return context.collection;
    }

    private void processInnerStatements(CsmStatement csmStatement, Context context) {
        if (csmStatement != null) {
            switch (csmStatement.getKind()) {
                case LABEL: {
                    context.addLabelDefinition((CsmLabel)csmStatement);
                    break;
                }
                case GOTO: {
                    context.addLabelReference((CsmGotoStatement)csmStatement);
                    break;
                }
                case COMPOUND: {
                    for (CsmStatement csmStatement2 : ((CsmCompoundStatement)csmStatement).getStatements()) {
                        this.processInnerStatements(csmStatement2, context);
                    }
                    break;
                }
                case WHILE: 
                case DO_WHILE: 
                case FOR: {
                    this.processInnerStatements(((CsmLoopStatement)csmStatement).getBody(), context);
                    break;
                }
                case IF: {
                    this.processInnerStatements(((CsmIfStatement)csmStatement).getThen(), context);
                    this.processInnerStatements(((CsmIfStatement)csmStatement).getElse(), context);
                    break;
                }
                case SWITCH: {
                    this.processInnerStatements(((CsmSwitchStatement)csmStatement).getBody(), context);
                    break;
                }
            }
        }
    }

    private static final class Context {
        private final Collection<CsmReference> collection = new ArrayList<CsmReference>();
        private final CharSequence label;
        private final Set<CsmLabelResolver.LabelKind> kinds;

        private Context(CsmFunctionDefinition csmFunctionDefinition, CharSequence charSequence, Set<CsmLabelResolver.LabelKind> set) {
            this.label = charSequence;
            this.kinds = set;
        }

        private void addLabelDefinition(CsmLabel csmLabel) {
            if (this.kinds.contains(CsmLabelResolver.LabelKind.Definiton) && (this.label == null || CharSequences.comparator().compare(this.label, csmLabel.getLabel()) == 0)) {
                this.collection.add(CsmReferenceSupport.createObjectReference((CsmOffsetable)csmLabel));
            }
        }

        private void addLabelReference(CsmGotoStatement csmGotoStatement) {
            if (this.kinds.contains(CsmLabelResolver.LabelKind.Reference) && (this.label == null || CharSequences.comparator().compare(this.label, csmGotoStatement.getLabel()) == 0)) {
                this.collection.add(CsmReferenceSupport.createObjectReference((CsmOffsetable)csmGotoStatement));
            }
        }
    }
}

