/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathFactory;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.PathResourceImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.modules.gsfret.source.GlobalSourcePath;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.WeakListeners;

public class CacheClassPath
implements ClassPathImplementation,
PropertyChangeListener {
    private final ClassPath cp;
    private final boolean translate;
    private final boolean isBoot;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private List<PathResourceImplementation> cache;

    private CacheClassPath(ClassPath cp, boolean translate, boolean isBoot) {
        this.cp = cp;
        this.translate = translate;
        this.isBoot = isBoot;
        this.cp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)cp));
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("entries".equals(event.getPropertyName())) {
            CacheClassPath cacheClassPath = this;
            synchronized (cacheClassPath) {
                this.cache = null;
            }
            this.listeners.firePropertyChange("resources", null, null);
        }
    }

    public synchronized List<? extends PathResourceImplementation> getResources() {
        block8: {
            if (this.cache != null) break block8;
            List entries = this.cp.entries();
            this.cache = new LinkedList<PathResourceImplementation>();
            if (this.isBoot && entries.size() == 0) {
                for (URL url : ClassIndexManager.getAllBootRoots()) {
                    this.cache.add(ClassPathSupport.createResource((URL)url));
                }
            } else {
                GlobalSourcePath gsp = GlobalSourcePath.getDefault();
                for (ClassPath.Entry entry : entries) {
                    URL foo;
                    FileObject fo;
                    URL url = entry.getURL();
                    URL[] sourceUrls = this.translate ? gsp.getSourceRootForBinaryRoot(url, this.cp, true) : new URL[]{url};
                    if (sourceUrls != null) continue;
                    if ("jar".equals(url.getProtocol())) {
                        FileObject fo2;
                        URL foo2 = FileUtil.getArchiveFile((URL)url);
                        if (!"file".equals(foo2.getProtocol()) && (fo2 = URLMapper.findFileObject((URL)foo2)) != null && "file".equals((foo2 = URLMapper.findURL((FileObject)fo2, (int)1)).getProtocol())) {
                            url = FileUtil.getArchiveRoot((URL)foo2);
                        }
                    } else if (!"file".equals(url.getProtocol()) && (fo = URLMapper.findFileObject((URL)url)) != null && "file".equals((foo = URLMapper.findURL((FileObject)fo, (int)1)).getProtocol())) {
                        url = foo;
                    }
                    this.cache.add(ClassPathSupport.createResource((URL)url));
                }
            }
        }
        return this.cache;
    }

    public static ClassPath forClassPath(ClassPath cp) {
        assert (cp != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(cp, true, false));
    }

    public static ClassPath forBootPath(ClassPath cp) {
        assert (cp != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(cp, true, true));
    }

    public static ClassPath forSourcePath(ClassPath sourcePath) {
        assert (sourcePath != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(sourcePath, false, false));
    }
}

