/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.assistance;

import java.io.IOException;
import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmDataObject;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.cnd.asm.core.ui.top.NavigatorUI;
import org.netbeans.modules.cnd.asm.model.AsmModelAccessor;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class FunctionNavigator
implements NavigatorPanel {
    private NavigatorUI panelUI;
    private Lookup.Result<AsmDataObject> result;
    private Lookup.Template<AsmDataObject> asmTemplate = new Lookup.Template(AsmDataObject.class);
    private AsmDataObject curDataObject;
    private StateListener stateListener;
    private LookupListener lookupListener;

    public String getDisplayName() {
        return "";
    }

    public String getDisplayHint() {
        return "";
    }

    public NavigatorUI getComponent() {
        if (this.panelUI == null) {
            this.panelUI = new NavigatorUI();
        }
        return this.panelUI;
    }

    public void panelActivated(Lookup context) {
        this.result = context.lookup(this.asmTemplate);
        this.result.addLookupListener(this.getLookupListener());
        this.setContent(this.result);
    }

    public void panelDeactivated() {
        this.result.removeLookupListener(this.getLookupListener());
        this.runInEDT(new Runnable(){

            @Override
            public void run() {
                FunctionNavigator.this.unsubscribe();
            }
        });
    }

    public Lookup getLookup() {
        return null;
    }

    private synchronized LookupListener getLookupListener() {
        if (this.lookupListener == null) {
            this.lookupListener = new ContextListener();
        }
        return this.lookupListener;
    }

    private synchronized StateListener getStateListener() {
        if (this.stateListener == null) {
            this.stateListener = new StateListener();
        }
        return this.stateListener;
    }

    private AsmModelAccessor getAccessor(DataObject dob) {
        if (dob == null) {
            return null;
        }
        return AsmObjectUtilities.getAccessor(dob);
    }

    private void unsubscribe() {
        if (this.curDataObject != null) {
            JEditorPane pane;
            AsmModelAccessor acc = this.getAccessor((DataObject)this.curDataObject);
            if (acc != null) {
                acc.removeParseListener(this.getStateListener());
            }
            if ((pane = this.getJEditorPane((DataObject)this.curDataObject)) != null) {
                pane.removeCaretListener(this.getStateListener());
            }
            this.curDataObject = null;
        }
    }

    private void subscribe(AsmDataObject dob) {
        this.curDataObject = dob;
        if (this.curDataObject != null) {
            try {
                JEditorPane pane;
                EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
                if (ec == null) {
                    return;
                }
                ec.openDocument();
                AsmModelAccessor acc = this.getAccessor((DataObject)this.curDataObject);
                if (acc != null) {
                    acc.addParseListener(this.getStateListener());
                }
                if ((pane = this.getJEditorPane((DataObject)this.curDataObject)) != null) {
                    pane.addCaretListener(this.getStateListener());
                }
            }
            catch (IOException ex) {
                return;
            }
        }
    }

    private void setContent(Lookup.Result<AsmDataObject> result) {
        Runnable action;
        Collection dobs = result.allInstances();
        if (dobs.size() != 0) {
            final AsmDataObject dob = (AsmDataObject)((Object)dobs.iterator().next());
            if (this.curDataObject == dob) {
                return;
            }
            action = new Runnable(){

                @Override
                public void run() {
                    FunctionNavigator.this.unsubscribe();
                    FunctionNavigator.this.subscribe(dob);
                    FunctionNavigator.this.update();
                }
            };
        } else {
            action = new Runnable(){

                @Override
                public void run() {
                    FunctionNavigator.this.unsubscribe();
                    FunctionNavigator.this.update();
                }
            };
        }
        this.runInEDT(action);
    }

    private void update() {
        AsmModelAccessor acc = this.getAccessor((DataObject)this.curDataObject);
        if (acc == null) {
            return;
        }
        this.getComponent().update((DataObject)this.curDataObject, acc.getState());
    }

    private void updateCursor(int pos) {
        this.getComponent().updateCursor(pos);
    }

    private void runInEDT(Runnable run) {
        SwingUtilities.invokeLater(run);
    }

    private JEditorPane getJEditorPane(DataObject dob) {
        JEditorPane currentJEditorPane = null;
        if (dob == null) {
            return null;
        }
        CloneableEditorSupport support = (CloneableEditorSupport)dob.getLookup().lookup(CloneableEditorSupport.class);
        if (support != null) {
            JEditorPane[] jEditorPanes = support.getOpenedPanes();
            if (jEditorPanes == null) {
                return null;
            }
            if (jEditorPanes.length >= 1) {
                currentJEditorPane = jEditorPanes[0];
            }
        }
        return currentJEditorPane;
    }

    private class StateListener
    implements AsmModelAccessor.ParseListener,
    CaretListener {
        private StateListener() {
        }

        @Override
        public void caretUpdate(final CaretEvent e) {
            FunctionNavigator.this.runInEDT(new Runnable(){

                @Override
                public void run() {
                    FunctionNavigator.this.updateCursor(e.getDot());
                }
            });
        }

        @Override
        public void notifyParsed() {
            FunctionNavigator.this.runInEDT(new Runnable(){

                @Override
                public void run() {
                    FunctionNavigator.this.update();
                }
            });
        }
    }

    private class ContextListener
    implements LookupListener {
        private ContextListener() {
        }

        public void resultChanged(LookupEvent ev) {
            FunctionNavigator.this.setContent((Lookup.Result<AsmDataObject>)((Lookup.Result)ev.getSource()));
        }
    }
}

