/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.el.ChainAwareVariableResolver;
import com.sun.faces.el.DummyPropertyResolverImpl;
import com.sun.faces.el.FacesResourceBundleELResolver;
import com.sun.faces.el.ImplicitObjectELResolver;
import com.sun.faces.el.ImplicitObjectELResolverForJsp;
import com.sun.faces.el.ManagedBeanELResolver;
import com.sun.faces.el.PropertyResolverChainWrapper;
import com.sun.faces.el.ScopedAttributeELResolver;
import com.sun.faces.el.VariableResolverChainWrapper;
import com.sun.faces.spi.ManagedBeanFactory;
import com.sun.faces.util.MessageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.VariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELUtils {
    public static final ArrayELResolver ARRAY_RESOLVER = new ArrayELResolver();
    public static final BeanELResolver BEAN_RESOLVER = new BeanELResolver();
    public static final FacesResourceBundleELResolver FACES_BUNDLE_RESOLVER = new FacesResourceBundleELResolver();
    public static final ImplicitObjectELResolverForJsp IMPLICIT_JSP_RESOLVER = new ImplicitObjectELResolverForJsp();
    public static final ImplicitObjectELResolver IMPLICIT_RESOLVER = new ImplicitObjectELResolver();
    public static final ListELResolver LIST_RESOLVER = new ListELResolver();
    public static final ManagedBeanELResolver MANAGED_BEAN_RESOLVER = new ManagedBeanELResolver();
    public static final MapELResolver MAP_RESOLVER = new MapELResolver();
    public static final ResourceBundleELResolver BUNDLE_RESOLVER = new ResourceBundleELResolver();
    public static final ScopedAttributeELResolver SCOPED_RESOLVER = new ScopedAttributeELResolver();

    private ELUtils() {
        throw new IllegalStateException();
    }

    public static void buildFacesResolver(CompositeELResolver composite, ApplicationAssociate associate) {
        if (associate == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "associate");
            throw new NullPointerException(message);
        }
        if (composite == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "composite");
            throw new NullPointerException(message);
        }
        composite.add((ELResolver)IMPLICIT_RESOLVER);
        ELUtils.addELResolvers(composite, associate.getELResolversFromFacesConfig());
        ELUtils.addVariableResolvers(composite, associate);
        ELUtils.addPropertyResolvers(composite, associate);
        ELUtils.addELResolvers(composite, associate.getApplicationELResolvers());
        composite.add((ELResolver)MANAGED_BEAN_RESOLVER);
        composite.add((ELResolver)BUNDLE_RESOLVER);
        composite.add((ELResolver)FACES_BUNDLE_RESOLVER);
        composite.add((ELResolver)MAP_RESOLVER);
        composite.add((ELResolver)LIST_RESOLVER);
        composite.add((ELResolver)ARRAY_RESOLVER);
        composite.add((ELResolver)BEAN_RESOLVER);
        composite.add((ELResolver)SCOPED_RESOLVER);
    }

    public static void buildJSPResolver(CompositeELResolver composite, ApplicationAssociate associate) {
        if (associate == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "associate");
            throw new NullPointerException(message);
        }
        if (composite == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "composite");
            throw new NullPointerException(message);
        }
        composite.add((ELResolver)IMPLICIT_JSP_RESOLVER);
        composite.add((ELResolver)MANAGED_BEAN_RESOLVER);
        composite.add((ELResolver)FACES_BUNDLE_RESOLVER);
        ELUtils.addELResolvers(composite, associate.getELResolversFromFacesConfig());
        ELUtils.addVariableResolvers(composite, associate);
        ELUtils.addPropertyResolvers(composite, associate);
        ELUtils.addELResolvers(composite, associate.getApplicationELResolvers());
    }

    public static Object evaluateValueExpression(ValueExpression expression, ELContext elContext) {
        if (expression.isLiteralText()) {
            return expression.getExpressionString();
        }
        return expression.getValue(elContext);
    }

    public static PropertyResolver getDelegatePR(ApplicationAssociate associate, boolean provideDefault) {
        PropertyResolver pr = associate.getLegacyPropertyResolver();
        if (pr == null && (pr = associate.getLegacyPRChainHead()) == null && provideDefault) {
            pr = new DummyPropertyResolverImpl();
        }
        return pr;
    }

    public static VariableResolver getDelegateVR(ApplicationAssociate associate, boolean provideDefault) {
        VariableResolver vr = associate.getLegacyVariableResolver();
        if (vr == null && (vr = associate.getLegacyVRChainHead()) == null && provideDefault) {
            vr = new ChainAwareVariableResolver();
        }
        return vr;
    }

    public static List getExpressionsFromString(String expressionString) throws ReferenceSyntaxException {
        int i;
        if (null == expressionString) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        int len = expressionString.length();
        int cur = 0;
        while (cur < len && -1 != (i = expressionString.indexOf("#{", cur))) {
            int j = expressionString.indexOf(125, i + 2);
            if (-1 == j) {
                throw new ReferenceSyntaxException(MessageUtils.getExceptionMessageString("com.sun.faces.INVALID_EXPRESSION", expressionString));
            }
            cur = j + 1;
            result.add(expressionString.substring(i, cur));
        }
        return result;
    }

    public static ManagedBeanFactory.Scope getScope(String valueBinding, String[] outString) throws ReferenceSyntaxException {
        if (valueBinding == null || 0 == valueBinding.length()) {
            return null;
        }
        valueBinding = ELUtils.stripBracketsIfNecessary(valueBinding);
        int segmentIndex = ELUtils.getFirstSegmentIndex(valueBinding);
        String identifier = valueBinding;
        if (segmentIndex > 0) {
            identifier = valueBinding.substring(0, segmentIndex);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext ec = context.getExternalContext();
        if (null != outString) {
            outString[0] = identifier;
        }
        if ("requestScope".equalsIgnoreCase(identifier)) {
            return ManagedBeanFactory.Scope.REQUEST;
        }
        if ("sessionScope".equalsIgnoreCase(identifier)) {
            return ManagedBeanFactory.Scope.SESSION;
        }
        if ("applicationScope".equalsIgnoreCase(identifier)) {
            return ManagedBeanFactory.Scope.APPLICATION;
        }
        if ("initParam".equalsIgnoreCase(identifier)) {
            return ManagedBeanFactory.Scope.APPLICATION;
        }
        if ("cookie".equalsIgnoreCase(identifier)) {
            return ManagedBeanFactory.Scope.REQUEST;
        }
        if ("facesContext".equalsIgnoreCase(identifier)) {
            return ManagedBeanFactory.Scope.REQUEST;
        }
        if ("header".equalsIgnoreCase(identifier)) {
            return ManagedBeanFactory.Scope.REQUEST;
        }
        if ("headerValues".equalsIgnoreCase(identifier)) {
            return ManagedBeanFactory.Scope.REQUEST;
        }
        if ("param".equalsIgnoreCase(identifier)) {
            return ManagedBeanFactory.Scope.REQUEST;
        }
        if ("paramValues".equalsIgnoreCase(identifier)) {
            return ManagedBeanFactory.Scope.REQUEST;
        }
        if ("view".equalsIgnoreCase(identifier)) {
            return ManagedBeanFactory.Scope.REQUEST;
        }
        if (ec.getRequestMap().get(identifier) != null) {
            return ManagedBeanFactory.Scope.REQUEST;
        }
        if (ec.getSessionMap().get(identifier) != null) {
            return ManagedBeanFactory.Scope.SESSION;
        }
        if (ec.getApplicationMap().get(identifier) != null) {
            return ManagedBeanFactory.Scope.APPLICATION;
        }
        return null;
    }

    public static ValueExpression getValueExpression(String valueRef) {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), valueRef, Object.class);
    }

    private static void addELResolvers(CompositeELResolver target, List<ELResolver> resolvers) {
        if (resolvers != null && !resolvers.isEmpty()) {
            for (ELResolver resolver : resolvers) {
                target.add(resolver);
            }
        }
    }

    private static void addPropertyResolvers(CompositeELResolver target, ApplicationAssociate associate) {
        PropertyResolver pr = ELUtils.getDelegatePR(associate, false);
        if (pr != null) {
            target.add((ELResolver)new PropertyResolverChainWrapper(pr));
        }
    }

    private static void addVariableResolvers(CompositeELResolver target, ApplicationAssociate associate) {
        VariableResolver vr = ELUtils.getDelegateVR(associate, false);
        if (vr != null) {
            target.add((ELResolver)new VariableResolverChainWrapper(vr));
        }
    }

    private static int getFirstSegmentIndex(String valueBinding) {
        int segmentIndex = valueBinding.indexOf(46);
        int bracketIndex = valueBinding.indexOf(91);
        if (segmentIndex < 0) {
            segmentIndex = bracketIndex;
        } else if (bracketIndex > 0 && segmentIndex > bracketIndex) {
            segmentIndex = bracketIndex;
        }
        return segmentIndex;
    }

    private static String stripBracketsIfNecessary(String expression) throws ReferenceSyntaxException {
        assert (null != expression);
        if (expression.charAt(0) == '#') {
            if (expression.charAt(1) != '{') {
                throw new ReferenceSyntaxException(MessageUtils.getExceptionMessageString("com.sun.faces.INVALID_EXPRESSION", expression));
            }
            int len = expression.length();
            if (expression.charAt(len - 1) != '}') {
                throw new ReferenceSyntaxException(MessageUtils.getExceptionMessageString("com.sun.faces.INVALID_EXPRESSION", expression));
            }
            expression = expression.substring(2, len - 1);
        }
        return expression;
    }
}

