/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.resources.FontCD;
import org.netbeans.modules.vmd.midp.propertyeditors.MidpPropertyEditorSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorComboBox
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private final Map<String, PropertyValue> values;
    private String[] tags;
    private String valueLabel;
    private TypeID typeID;
    private TypeID enableTypeID;
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private static String[] USERCODE_TAGS = new String[]{PropertyEditorUserCode.USER_CODE_TEXT};

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        this.typeID = null;
        this.tags = null;
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.enableTypeID = null;
    }

    private PropertyEditorComboBox(Map<String, PropertyValue> values, TypeID typeID, TypeID enableTypeID, String valueLabel, String userCodeLabel) {
        super(userCodeLabel);
        this.values = values;
        this.typeID = typeID;
        this.enableTypeID = enableTypeID;
        this.valueLabel = valueLabel;
        this.createTags();
    }

    public static PropertyEditorComboBox createInstance(Map<String, PropertyValue> values, TypeID typeID, String valueLabel, String userCodeLabel) {
        return PropertyEditorComboBox.createInstance(values, typeID, null, valueLabel, userCodeLabel);
    }

    public static PropertyEditorComboBox createInstance(Map<String, PropertyValue> values, TypeID typeID, TypeID enableTypeID, String valueLabel, String userCodeLabel) {
        if (values == null) {
            throw new IllegalArgumentException("Argument values can't be null");
        }
        for (String key : values.keySet()) {
            PropertyValue value = values.get(key);
            if (value != null) continue;
            throw new IllegalArgumentException("PropertyValue for " + key + " key can't be null");
        }
        PropertyEditorComboBox instance = new PropertyEditorComboBox(values, typeID, enableTypeID, valueLabel, userCodeLabel);
        return instance;
    }

    @Override
    public void setAsText(String text) {
        if (this.canWrite()) {
            if (text.equals(NULL_TEXT)) {
                super.setValue((Object)NULL_VALUE);
            } else {
                this.saveValue(text);
            }
        }
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)this.valueLabel);
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.customEditor = new CustomEditor();
        this.customEditor.updateModel();
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return false;
    }

    @Override
    public String getAsText() {
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        PropertyValue value = (PropertyValue)super.getValue();
        for (String key : this.values.keySet()) {
            PropertyValue tmpValue = this.values.get(key);
            if (!value.getPrimitiveValue().equals(tmpValue.getPrimitiveValue())) continue;
            return key;
        }
        return NbBundle.getMessage(PropertyEditorComboBox.class, (String)"LBL_MULTIPLE");
    }

    @Override
    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void updateState(PropertyValue value) {
        if (!this.isCurrentValueANull() && value != null) {
            this.customEditor.setValue(value);
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String text) {
        PropertyValue value;
        if (text.length() > 0 && (value = this.values.get(text)) != null) {
            super.setValue((Object)value);
        }
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    public String[] getTags() {
        if (this.isCurrentValueAUserCodeType()) {
            return USERCODE_TAGS;
        }
        return this.tags;
    }

    private void createTags() {
        int i = 0;
        this.tags = new String[this.values.size()];
        for (String valueAsText : this.values.keySet()) {
            this.tags[i++] = valueAsText;
        }
    }

    @Override
    public Boolean canEditAsText() {
        return null;
    }

    @Override
    public boolean canWrite() {
        final boolean[] canWrite = new boolean[]{true};
        if (!MidpPropertyEditorSupport.singleSelectionEditAsTextOnly()) {
            canWrite[0] = false;
        } else if (this.enableTypeID != null && this.enableTypeID == FontCD.TYPEID && this.component != null && this.component.get() != null) {
            final DesignComponent _component = (DesignComponent)this.component.get();
            _component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    int kind = MidpTypes.getInteger(_component.readProperty("fontKind"));
                    canWrite[0] = kind == 1;
                }
            });
        }
        return canWrite[0];
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private JComboBox combobox;

        void cleanUp() {
            if (this.combobox != null) {
                this.combobox.removeActionListener(this);
                this.combobox = null;
            }
            this.removeAll();
        }

        public CustomEditor() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.combobox = new JComboBox();
            this.combobox.setModel(new DefaultComboBoxModel());
            this.combobox.addActionListener(this);
            this.combobox.getAccessibleContext().setAccessibleName(PropertyEditorComboBox.this.radioButton.getAccessibleContext().getAccessibleName());
            this.combobox.getAccessibleContext().setAccessibleDescription(PropertyEditorComboBox.this.radioButton.getAccessibleContext().getAccessibleDescription());
            this.add((Component)this.combobox, "Center");
        }

        public void setValue(PropertyValue value) {
            for (String key : PropertyEditorComboBox.this.values.keySet()) {
                if (!((PropertyValue)PropertyEditorComboBox.this.values.get(key)).getPrimitiveValue().equals(value.getPrimitiveValue())) continue;
                this.combobox.setSelectedItem(key);
                break;
            }
        }

        public String getText() {
            return (String)this.combobox.getSelectedItem();
        }

        public void updateModel() {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.combobox.getModel();
            model.removeAllElements();
            for (String tag : PropertyEditorComboBox.this.tags) {
                model.addElement(tag);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PropertyEditorComboBox.this.radioButton.setSelected(true);
        }
    }
}

