/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class MidpJavaSupport
implements Runnable,
PropertyChangeListener {
    private static HashMap<String, MidpJavaSupport> instanceMap;
    private static RequestProcessor validationRP;
    private final ConcurrentLinkedQueue<String> validationQueue;
    private final ConcurrentHashMap<String, Boolean> validationCache;
    private final AtomicBoolean isValidationRunning;
    private WeakReference<DesignDocument> document;

    private MidpJavaSupport(DesignDocument designDocument) {
        this.document = new WeakReference<DesignDocument>(designDocument);
        this.validationQueue = new ConcurrentLinkedQueue();
        this.validationCache = new ConcurrentHashMap();
        this.isValidationRunning = new AtomicBoolean();
        this.registerClassPathListener();
    }

    public Boolean checkValidityCached(TypeID typeID) {
        return this.checkValidityCached(MidpTypes.getFQNClassName(typeID));
    }

    public Boolean checkValidityCached(String string) {
        if (this.validationCache.containsKey(string)) {
            return this.validationCache.get(string);
        }
        this.scheduleValidation(string);
        return null;
    }

    private void scheduleValidation(String string) {
        this.validationQueue.add(string);
        if (!this.isValidationRunning.getAndSet(true)) {
            validationRP.post((Runnable)this);
        }
    }

    @Override
    public void run() {
        DesignDocument designDocument = (DesignDocument)this.document.get();
        if (designDocument == null) {
            return;
        }
        while (true) {
            if (this.validationQueue.isEmpty()) break;
            String string = (String)this.validationQueue.remove();
            boolean bl = MidpJavaSupport.checkValidity(designDocument, string);
            this.validationCache.put(string, bl);
        }
        this.isValidationRunning.set(false);
    }

    private void registerClassPathListener() {
        DesignDocument designDocument = (DesignDocument)this.document.get();
        if (designDocument == null) {
            return;
        }
        final ClasspathInfo classpathInfo = this.getClasspathInfo(org.netbeans.modules.vmd.api.io.ProjectUtils.getProject((DesignDocument)designDocument));
        if (classpathInfo == null) {
            Debug.warning((Object[])new Object[]{"Can't get ClasspathInfo for project"});
            return;
        }
        try {
            Task<CompilationController> task = new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    ClassPath classPath = classpathInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
                    PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)MidpJavaSupport.this, (Object)classPath);
                    classPath.addPropertyChangeListener(propertyChangeListener);
                }
            };
            JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]).runUserActionTask((Task)task, true);
        }
        catch (IOException iOException) {
            Debug.warning((Object[])new Object[]{iOException});
        }
    }

    private ClasspathInfo getClasspathInfo(Project project) {
        if (project == null) {
            return null;
        }
        SourceGroup sourceGroup = this.getSourceGroup(project);
        return sourceGroup != null ? ClasspathInfo.create((FileObject)sourceGroup.getRootFolder()) : null;
    }

    private SourceGroup getSourceGroup(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        return sourceGroupArray != null && sourceGroupArray.length > 0 ? sourceGroupArray[0] : null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateCacheInternally();
    }

    void updateCacheInternally() {
        final DesignDocument designDocument = (DesignDocument)this.document.get();
        if (designDocument == null) {
            return;
        }
        this.validationCache.clear();
        String string = designDocument.getDocumentInterface().getProjectID();
        String string2 = designDocument.getDocumentInterface().getProjectType();
        final ArrayList arrayList = new ArrayList();
        final DescriptorRegistry descriptorRegistry = DescriptorRegistry.getDescriptorRegistry((String)string2, (String)string);
        descriptorRegistry.readAccess(new Runnable(){

            @Override
            public void run() {
                arrayList.addAll(descriptorRegistry.getComponentProducers());
            }
        });
        ClasspathInfo classpathInfo = this.getClasspathInfo(org.netbeans.modules.vmd.api.io.ProjectUtils.getProject((DesignDocument)designDocument));
        if (classpathInfo != null) {
            try {
                JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]).runWhenScanFinished((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        for (ComponentProducer componentProducer : arrayList) {
                            componentProducer.checkValidity(designDocument, true);
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                Debug.warning((Object[])new Object[]{iOException});
            }
        }
    }

    public static boolean checkValidity(DesignDocument designDocument, TypeID typeID) {
        return MidpJavaSupport.checkValidity(designDocument, MidpTypes.getFQNClassName(typeID));
    }

    public static boolean checkValidity(DesignDocument designDocument, String string) {
        DataObjectContext dataObjectContext = org.netbeans.modules.vmd.api.io.ProjectUtils.getDataObjectContextForDocument((DesignDocument)designDocument);
        if (dataObjectContext == null) {
            return true;
        }
        List list = org.netbeans.modules.vmd.api.io.ProjectUtils.getSourceGroups((DataObjectContext)dataObjectContext);
        boolean bl = false;
        CheckingTask checkingTask = new CheckingTask();
        Set set = Collections.emptySet();
        for (SourceGroup sourceGroup : list) {
            checkingTask.setFQName(string);
            ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)sourceGroup.getRootFolder());
            try {
                JavaSource.create((ClasspathInfo)classpathInfo, set).runUserActionTask((Task)checkingTask, true);
            }
            catch (Exception exception) {
                Debug.warning((Object[])new Object[]{"Can't create javasource for", string});
            }
            if (bl = checkingTask.getResult()) continue;
            break;
        }
        return bl;
    }

    public static synchronized MidpJavaSupport getCache(DesignDocument designDocument) {
        String string;
        MidpJavaSupport midpJavaSupport;
        if (instanceMap == null) {
            instanceMap = new HashMap(1);
            validationRP = new RequestProcessor("VMD MIDP ClassPath validation");
        }
        if ((midpJavaSupport = instanceMap.get(string = designDocument.getDocumentInterface().getProjectID())) == null) {
            midpJavaSupport = new MidpJavaSupport(designDocument);
            instanceMap.put(string, midpJavaSupport);
        }
        return midpJavaSupport;
    }

    private static final class CheckingTask
    implements Task<CompilationController> {
        private boolean result;
        private String fqName;

        private CheckingTask() {
        }

        public void run(CompilationController compilationController) throws Exception {
            Elements elements = compilationController.getElements();
            TypeElement typeElement = elements.getTypeElement(this.fqName);
            this.result = typeElement != null;
        }

        public boolean getResult() {
            return this.result;
        }

        public void setFQName(String string) {
            this.fqName = string;
        }
    }
}

