/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.netbeans.modules.ant.freeform.FreeformProjectGenerator;
import org.netbeans.modules.ant.freeform.spi.TargetDescriptor;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TargetMappingPanel
extends JPanel
implements ActionListener,
HelpCtx.Provider {
    public static final String BUILD_ACTION = "build";
    public static final String CLEAN_ACTION = "clean";
    public static final String REBUILD_ACTION = "rebuild";
    public static final String JAVADOC_ACTION = "javadoc";
    public static final String RUN_ACTION = "run";
    public static final String TEST_ACTION = "test";
    private static final List<String> DEFAULT_BUILD_TARGETS = Arrays.asList("build", "compile", "jar", "dist", "all", ".*jar.*");
    private static final List<String> DEFAULT_CLEAN_TARGETS = Arrays.asList("clean", ".*clean.*");
    private static final List<String> DEFAULT_JAVADOC_TARGETS = Arrays.asList("javadoc", "javadocs", "docs", "doc", ".*javadoc.*", ".*doc.*");
    private static final List<String> DEFAULT_RUN_TARGETS = Arrays.asList("run", "start", ".*run.*", ".*start.*");
    private static final List<String> DEFAULT_TEST_TARGETS = Arrays.asList("test", ".*test.*");
    private List<String> targetNames;
    private List<FreeformProjectGenerator.TargetMapping> targetMappings;
    private List<FreeformProjectGenerator.CustomTarget> custTargets;
    private CustomTargetsModel customTargetsModel;
    private String antScript;
    private List<JComboBox> combos = new ArrayList<JComboBox>();
    private List<TargetDescriptor> targetDescs = new ArrayList<TargetDescriptor>();
    private boolean dirtyRegular;
    private boolean dirtyCustom;
    private AntProjectHelper helper;
    private JButton add;
    private JLabel additionalTargetsLabel;
    private JComboBox buildCombo;
    private JLabel buildLabel;
    private JComboBox cleanCombo;
    private JLabel cleanLabel;
    private JTable customTargets;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JComboBox javadocCombo;
    private JLabel javadocLabel;
    private JPanel remainder;
    private JButton remove;
    private JComboBox runCombo;
    private JLabel runLabel;
    private JPanel specialRemainder;
    private JPanel targetsPanel;
    private JComboBox testCombo;
    private JLabel testLabel;

    public TargetMappingPanel(boolean advancedPart) {
        this(new ArrayList<TargetDescriptor>(), advancedPart);
    }

    public TargetMappingPanel(List<TargetDescriptor> extraTargets, boolean advancedPart) {
        this.initComponents();
        this.targetMappings = new ArrayList<FreeformProjectGenerator.TargetMapping>();
        this.custTargets = new ArrayList<FreeformProjectGenerator.CustomTarget>();
        this.customTargetsModel = new CustomTargetsModel();
        this.customTargets.setModel(this.customTargetsModel);
        this.customTargets.getTableHeader().setReorderingAllowed(false);
        this.addTargets(extraTargets);
        this.showAdvancedPart(advancedPart);
    }

    public TargetMappingPanel(List<TargetDescriptor> extraTargets, PropertyEvaluator evaluator, AntProjectHelper helper) {
        this(extraTargets, true);
        this.helper = helper;
        FileObject as = FreeformProjectGenerator.getAntScript(helper, evaluator);
        List l = null;
        if (as != null) {
            try {
                l = AntScriptUtils.getCallableTargetNames((FileObject)as);
            }
            catch (IOException x) {
                Logger.getLogger(TargetMappingPanel.class.getName()).log(Level.INFO, "Cannot parse: " + as, x);
            }
        }
        if (l != null) {
            this.setTargetNames(l, false);
            this.initAntTargetEditor(l);
        }
        this.antScript = TargetMappingPanel.defaultAntScript(evaluator);
        this.initMappings(FreeformProjectGenerator.getTargetMappings(helper), this.antScript);
        this.custTargets = FreeformProjectGenerator.getCustomContextMenuActions(helper);
        this.customTargetsModel.fireTableDataChanged();
        this.updateButtons();
    }

    static String defaultAntScript(PropertyEvaluator evaluator) {
        String antScript = evaluator.getProperty("ant.script");
        if (antScript == null) {
            return null;
        }
        return "${ant.script}";
    }

    private void addTargets(List<TargetDescriptor> extraTargets) {
        this.combos.add(this.buildCombo);
        this.targetDescs.add(new TargetDescriptor(BUILD_ACTION, DEFAULT_BUILD_TARGETS, null, null));
        this.combos.add(this.cleanCombo);
        this.targetDescs.add(new TargetDescriptor(CLEAN_ACTION, DEFAULT_CLEAN_TARGETS, null, null));
        this.combos.add(this.javadocCombo);
        this.targetDescs.add(new TargetDescriptor(JAVADOC_ACTION, DEFAULT_JAVADOC_TARGETS, null, null));
        this.combos.add(this.runCombo);
        this.targetDescs.add(new TargetDescriptor(RUN_ACTION, DEFAULT_RUN_TARGETS, null, null));
        this.combos.add(this.testCombo);
        this.targetDescs.add(new TargetDescriptor(TEST_ACTION, DEFAULT_TEST_TARGETS, null, null));
        int y = 5;
        for (TargetDescriptor desc : extraTargets) {
            this.targetDescs.add(desc);
            JComboBox combo = new JComboBox();
            combo.setEditable(true);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = y;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            this.targetsPanel.add(combo, gridBagConstraints);
            JLabel label = new JLabel();
            label.setLabelFor(combo);
            Mnemonics.setLocalizedText((JLabel)label, (String)desc.getIDEActionLabel());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y++;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 6, 6);
            this.targetsPanel.add((Component)label, gridBagConstraints);
            label.getAccessibleContext().setAccessibleDescription(desc.getAccessibleLabel());
            this.combos.add(combo);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TargetMappingPanel.class);
    }

    private void showAdvancedPart(boolean show) {
        this.additionalTargetsLabel.setVisible(show);
        this.jScrollPane1.setVisible(show);
        this.customTargets.setVisible(show);
        this.add.setVisible(show);
        this.remove.setVisible(show);
        this.remainder.setVisible(show);
        this.specialRemainder.setVisible(!show);
    }

    private void initAntTargetEditor(List<String> targets) {
        JComboBox<String> combo = new JComboBox<String>();
        combo.setEditable(true);
        for (String target : targets) {
            combo.addItem(target);
        }
        this.customTargets.setDefaultEditor(JComboBox.class, new DefaultCellEditor(combo));
    }

    private FreeformProjectGenerator.CustomTarget getItem(int index) {
        return this.custTargets.get(index);
    }

    public void setTargetNames(List<String> list, boolean selectDefaults) {
        this.targetNames = list;
        this.targetNames.add(0, "");
        this.updateCombos(selectDefaults);
    }

    public void setScript(String script) {
        this.antScript = script;
        for (FreeformProjectGenerator.TargetMapping tm : this.targetMappings) {
            tm.script = script;
        }
    }

    private void updateCombos(boolean selectDefaults) {
        Iterator<TargetDescriptor> descriptors = this.targetDescs.iterator();
        for (JComboBox combo : this.combos) {
            TargetDescriptor desc = descriptors.next();
            combo.removeAllItems();
            for (String name : this.targetNames) {
                combo.addItem(name);
            }
            if (!selectDefaults) continue;
            this.selectItem(combo, desc.getDefaultTargets(), false);
        }
    }

    private void selectItem(JComboBox combo, List<String> items, boolean add) {
        ComboBoxModel model = combo.getModel();
        for (String item : items) {
            Pattern pattern = Pattern.compile(item);
            for (int i = 0; i < model.getSize(); ++i) {
                String target = (String)model.getElementAt(i);
                Matcher matcher = pattern.matcher(target);
                if (!matcher.matches()) continue;
                model.setSelectedItem(target);
                return;
            }
        }
        if (add) {
            assert (items.size() == 1) : "There should be only one item in this case";
            combo.addItem(items.get(0));
            model.setSelectedItem(items.get(0));
        } else {
            model.setSelectedItem("");
        }
    }

    private void initMappings(List<FreeformProjectGenerator.TargetMapping> list, String antScript) {
        for (FreeformProjectGenerator.TargetMapping tm : list) {
            Iterator<JComboBox> combosIt = this.combos.iterator();
            for (TargetDescriptor desc : this.targetDescs) {
                JComboBox combo = combosIt.next();
                if (!tm.name.equals(desc.getIDEActionName())) continue;
                this.selectItem(combo, Collections.singletonList(TargetMappingPanel.getListAsString(tm.targets)), true);
                this.checkAntScript(combo, antScript, tm.script);
            }
        }
        this.targetMappings = list;
    }

    private void checkAntScript(JComboBox combo, String antScript, String targetScript) {
        if (antScript == null && targetScript == null || antScript != null && antScript.equals(targetScript)) {
            combo.setEnabled(true);
        } else {
            combo.setEnabled(false);
        }
    }

    private static String getListAsString(List<String> list) {
        assert (list != null);
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    static List<String> getStringAsList(String str) {
        ArrayList<String> l = new ArrayList<String>(2);
        StringTokenizer tok = new StringTokenizer(str, " ");
        while (tok.hasMoreTokens()) {
            String target = tok.nextToken().trim();
            if (target.length() == 0) continue;
            l.add(target);
        }
        return l;
    }

    private void storeTarget(String key, JComboBox combo) {
        if (combo.getModel().getSelectedItem() == null || ((String)combo.getModel().getSelectedItem()).length() == 0) {
            this.removeTargetMapping(key);
            return;
        }
        FreeformProjectGenerator.TargetMapping tm = this.getTargetMapping(key);
        String value = (String)combo.getModel().getSelectedItem();
        List<String> l = TargetMappingPanel.getStringAsList(value);
        if (!((Object)l).equals(tm.targets)) {
            this.dirtyRegular = true;
        }
        tm.targets = l;
    }

    private FreeformProjectGenerator.TargetMapping getTargetMapping(String key) {
        for (FreeformProjectGenerator.TargetMapping tm : this.targetMappings) {
            if (!tm.name.equals(key)) continue;
            return tm;
        }
        FreeformProjectGenerator.TargetMapping tm = new FreeformProjectGenerator.TargetMapping();
        tm.name = key;
        tm.script = this.antScript;
        this.targetMappings.add(tm);
        this.dirtyRegular = true;
        return tm;
    }

    private void removeTargetMapping(String key) {
        Iterator<FreeformProjectGenerator.TargetMapping> it = this.targetMappings.iterator();
        while (it.hasNext()) {
            if (!it.next().name.equals(key)) continue;
            it.remove();
            this.dirtyRegular = true;
            return;
        }
    }

    public List<FreeformProjectGenerator.TargetMapping> getMapping() {
        Iterator<JComboBox> combosIt = this.combos.iterator();
        for (TargetDescriptor desc : this.targetDescs) {
            JComboBox combo = combosIt.next();
            this.storeTarget(desc.getIDEActionName(), combo);
        }
        if (this.cleanCombo.getModel().getSelectedItem() != null && ((String)this.cleanCombo.getModel().getSelectedItem()).length() > 0 && this.buildCombo.getModel().getSelectedItem() != null && ((String)this.buildCombo.getModel().getSelectedItem()).length() > 0) {
            FreeformProjectGenerator.TargetMapping tm = this.getTargetMapping(REBUILD_ACTION);
            String val = (String)this.cleanCombo.getModel().getSelectedItem() + " " + (String)this.buildCombo.getModel().getSelectedItem();
            tm.targets = TargetMappingPanel.getStringAsList(val);
        } else {
            this.removeTargetMapping(REBUILD_ACTION);
        }
        return this.targetMappings;
    }

    private void initComponents() {
        this.additionalTargetsLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.customTargets = new JTable();
        this.add = new JButton();
        this.remove = new JButton();
        this.jLabel1 = new JLabel();
        this.remainder = new JPanel();
        this.targetsPanel = new JPanel();
        this.buildLabel = new JLabel();
        this.cleanLabel = new JLabel();
        this.runLabel = new JLabel();
        this.javadocLabel = new JLabel();
        this.testLabel = new JLabel();
        this.buildCombo = new JComboBox();
        this.cleanCombo = new JComboBox();
        this.javadocCombo = new JComboBox();
        this.runCombo = new JComboBox();
        this.testCombo = new JComboBox();
        this.specialRemainder = new JPanel();
        this.setPreferredSize(new Dimension(300, 280));
        this.setLayout(new GridBagLayout());
        this.additionalTargetsLabel.setLabelFor(this.customTargets);
        Mnemonics.setLocalizedText((JLabel)this.additionalTargetsLabel, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel10"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.additionalTargetsLabel, gridBagConstraints);
        this.additionalTargetsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel10"));
        this.jScrollPane1.setViewportView(this.customTargets);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.add, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"BTN_TargetMappingPanel_add"));
        this.add.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.add, gridBagConstraints);
        this.add.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_add"));
        Mnemonics.setLocalizedText((AbstractButton)this.remove, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"BTN_TargetMappingPanel_remove"));
        this.remove.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.add((Component)this.remove, gridBagConstraints);
        this.remove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_remove"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_Mapping_Of_General_Actions"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.remainder, gridBagConstraints);
        this.targetsPanel.setLayout(new GridBagLayout());
        this.buildLabel.setLabelFor(this.buildCombo);
        Mnemonics.setLocalizedText((JLabel)this.buildLabel, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.buildLabel, gridBagConstraints);
        this.buildLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel2"));
        this.cleanLabel.setLabelFor(this.cleanCombo);
        Mnemonics.setLocalizedText((JLabel)this.cleanLabel, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel4"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.cleanLabel, gridBagConstraints);
        this.cleanLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel4"));
        this.runLabel.setLabelFor(this.runCombo);
        Mnemonics.setLocalizedText((JLabel)this.runLabel, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.runLabel, gridBagConstraints);
        this.runLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel5"));
        this.javadocLabel.setLabelFor(this.javadocCombo);
        Mnemonics.setLocalizedText((JLabel)this.javadocLabel, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel6"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.javadocLabel, gridBagConstraints);
        this.javadocLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel6"));
        this.testLabel.setLabelFor(this.testCombo);
        Mnemonics.setLocalizedText((JLabel)this.testLabel, (String)NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_jLabel7"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.targetsPanel.add((Component)this.testLabel, gridBagConstraints);
        this.testLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetMappingPanel.class, (String)"ACSD_TargetMappingPanel_jLabel7"));
        this.buildCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.buildCombo, gridBagConstraints);
        this.cleanCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.cleanCombo, gridBagConstraints);
        this.javadocCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.javadocCombo, gridBagConstraints);
        this.runCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.runCombo, gridBagConstraints);
        this.testCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.targetsPanel.add((Component)this.testCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.targetsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.specialRemainder, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.add) {
            this.addActionPerformed(evt);
        } else if (evt.getSource() == this.remove) {
            this.removeActionPerformed(evt);
        }
    }

    private void removeActionPerformed(ActionEvent evt) {
        int index = this.customTargets.getSelectedRow();
        if (index == -1) {
            return;
        }
        this.custTargets.remove(index);
        this.customTargetsModel.fireTableDataChanged();
        this.dirtyCustom = true;
        this.updateButtons();
    }

    private void addActionPerformed(ActionEvent evt) {
        FreeformProjectGenerator.CustomTarget ct = new FreeformProjectGenerator.CustomTarget();
        ct.targets = new ArrayList<String>();
        ct.script = this.antScript;
        this.custTargets.add(ct);
        this.customTargetsModel.fireTableDataChanged();
        this.dirtyCustom = true;
        this.updateButtons();
    }

    private void updateButtons() {
        this.remove.setEnabled(this.custTargets.size() > 0);
    }

    ActionListener getCustomizerOkListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                List<FreeformProjectGenerator.TargetMapping> mapping = TargetMappingPanel.this.getMapping();
                if (TargetMappingPanel.this.dirtyRegular) {
                    FreeformProjectGenerator.putTargetMappings(TargetMappingPanel.this.helper, mapping);
                    FreeformProjectGenerator.putContextMenuAction(TargetMappingPanel.this.helper, mapping);
                }
                if (TargetMappingPanel.this.dirtyCustom) {
                    ArrayList<FreeformProjectGenerator.CustomTarget> l = new ArrayList<FreeformProjectGenerator.CustomTarget>(TargetMappingPanel.this.custTargets);
                    Iterator it = l.iterator();
                    while (it.hasNext()) {
                        FreeformProjectGenerator.CustomTarget ct = (FreeformProjectGenerator.CustomTarget)it.next();
                        if (ct.targets == null || ct.targets.size() == 0) {
                            it.remove();
                            continue;
                        }
                        if (ct.label != null && ct.label.length() != 0) continue;
                        ct.label = ct.targets.get(0);
                    }
                    FreeformProjectGenerator.putCustomContextMenuActions(TargetMappingPanel.this.helper, l);
                }
            }
        };
    }

    public static void main(String[] ignore) {
        boolean[] adv = new boolean[]{false, true};
        for (int j = 0; j < adv.length; ++j) {
            JDialog dlg = new JDialog((Frame)null, "advancedMode=" + adv[j], false);
            dlg.setDefaultCloseOperation(2);
            TargetMappingPanel panel = new TargetMappingPanel(adv[j]);
            panel.setTargetNames(new ArrayList<String>(Arrays.asList(BUILD_ACTION, CLEAN_ACTION, TEST_ACTION)), true);
            dlg.getContentPane().add(panel);
            dlg.pack();
            dlg.setSize(700, 500);
            dlg.setVisible(true);
        }
    }

    private class CustomTargetsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_Label");
                }
            }
            return NbBundle.getMessage(TargetMappingPanel.class, (String)"LBL_TargetMappingPanel_Target");
        }

        @Override
        public int getRowCount() {
            return TargetMappingPanel.this.custTargets.size();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 1) {
                FreeformProjectGenerator.CustomTarget ct = TargetMappingPanel.this.getItem(row);
                if (ct.targets != null && ct.targets.size() > 1) {
                    return false;
                }
                return TargetMappingPanel.this.antScript == null && ct.script == null || TargetMappingPanel.this.antScript != null && TargetMappingPanel.this.antScript.equals(ct.script);
            }
            return true;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
            }
            return JComboBox.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                if (TargetMappingPanel.this.getItem(rowIndex) == null || ((TargetMappingPanel)TargetMappingPanel.this).getItem((int)rowIndex).targets == null) {
                    return "";
                }
                return TargetMappingPanel.getListAsString(((TargetMappingPanel)TargetMappingPanel.this).getItem((int)rowIndex).targets);
            }
            return ((TargetMappingPanel)TargetMappingPanel.this).getItem((int)rowIndex).label;
        }

        @Override
        public void setValueAt(Object val, int rowIndex, int columnIndex) {
            if (rowIndex >= TargetMappingPanel.this.custTargets.size()) {
                return;
            }
            FreeformProjectGenerator.CustomTarget ct = TargetMappingPanel.this.getItem(rowIndex);
            String v = (String)val;
            if (columnIndex == 1) {
                ct.targets = v.length() > 0 ? Collections.singletonList(v) : null;
            } else {
                ct.label = v;
            }
            TargetMappingPanel.this.dirtyCustom = true;
        }
    }
}

