/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class WSDesignViewNavigatorContent
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private ExplorerManager explorerManager;
    private TreeView treeView;

    public WSDesignViewNavigatorContent() {
        this.setLayout(new BorderLayout());
        this.explorerManager = new ExplorerManager();
        this.treeView = new BeanTreeView();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void navigate(DataObject dataObject) {
        this.add((Component)this.treeView, "Center");
        AbstractNode abstractNode = new AbstractNode((Children)new WSChildren(dataObject));
        abstractNode.setName(NbBundle.getMessage(WSDesignViewNavigatorContent.class, (String)"LBL_Operations"));
        this.getExplorerManager().setRootContext((Node)abstractNode);
        this.revalidate();
        this.repaint();
    }

    public class WSChildren
    extends Children.Keys<MethodModel> {
        DataObject implClass;

        public WSChildren(DataObject dataObject) {
            this.implClass = dataObject;
        }

        protected Node[] createNodes(MethodModel methodModel) {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setName(methodModel.getOperationName());
            return new Node[]{abstractNode};
        }

        protected void addNotify() {
            this.updateKeys();
        }

        private void updateKeys() {
            List<Object> list = new ArrayList();
            if (this.implClass != null) {
                ServiceModel serviceModel = ServiceModel.getServiceModel(this.implClass.getPrimaryFile());
                list = serviceModel.getOperations();
            }
            this.setKeys(list);
        }
    }
}

