/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.util.TreePath;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;

public class AutoImport
extends SimpleTypeVisitor6<Void, Void> {
    private static final String CAPTURED_WILDCARD = "<captured wildcard>";
    private CompilationInfo info;
    private StringBuilder builder;
    private TreePath path;

    private AutoImport(CompilationInfo compilationInfo) {
        this.info = compilationInfo;
    }

    public static AutoImport get(CompilationInfo compilationInfo) {
        return new AutoImport(compilationInfo);
    }

    public static CharSequence resolveImport(CompilationInfo compilationInfo, TreePath treePath, TypeMirror typeMirror) {
        AutoImport autoImport = new AutoImport(compilationInfo);
        return autoImport.resolveImport(treePath, typeMirror);
    }

    public CharSequence resolveImport(TreePath treePath, TypeMirror typeMirror) {
        this.builder = new StringBuilder();
        this.path = treePath;
        this.visit(typeMirror, null);
        return this.builder;
    }

    @Override
    public Void defaultAction(TypeMirror typeMirror, Void void_) {
        this.builder.append(typeMirror);
        return null;
    }

    @Override
    public Void visitArray(ArrayType arrayType, Void void_) {
        this.visit(arrayType.getComponentType());
        this.builder.append("[]");
        return null;
    }

    @Override
    public Void visitDeclared(DeclaredType declaredType, Void void_) {
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        String string = typeElement.getQualifiedName().toString();
        ElementKind elementKind = typeElement.getEnclosingElement().getKind();
        if (elementKind.isClass() || elementKind.isInterface() || elementKind == ElementKind.PACKAGE) {
            try {
                string = SourceUtils.resolveImport((CompilationInfo)this.info, (TreePath)this.path, (String)string);
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.INFO, null, exception);
            }
        }
        this.builder.append(string);
        Iterator<? extends TypeMirror> iterator = declaredType.getTypeArguments().iterator();
        if (iterator.hasNext()) {
            this.builder.append('<');
            while (iterator.hasNext()) {
                this.visit(iterator.next());
                if (!iterator.hasNext()) continue;
                this.builder.append(", ");
            }
            this.builder.append('>');
        }
        return null;
    }

    @Override
    public Void visitTypeVariable(TypeVariable typeVariable, Void void_) {
        Object object;
        Element element = typeVariable.asElement();
        if (element != null && !CAPTURED_WILDCARD.contentEquals((CharSequence)(object = element.getSimpleName()))) {
            this.builder.append((CharSequence)object);
            return null;
        }
        this.builder.append("?");
        object = typeVariable.getLowerBound();
        if (object != null && object.getKind() != TypeKind.NULL) {
            this.builder.append(" super ");
            this.visit((TypeMirror)object);
        } else {
            object = typeVariable.getUpperBound();
            if (object != null && object.getKind() != TypeKind.NULL) {
                this.builder.append(" extends ");
                if (object.getKind() == TypeKind.TYPEVAR) {
                    object = ((TypeVariable)object).getLowerBound();
                }
                this.visit((TypeMirror)object);
            }
        }
        return null;
    }

    @Override
    public Void visitWildcard(WildcardType wildcardType, Void void_) {
        this.builder.append("?");
        TypeMirror typeMirror = wildcardType.getSuperBound();
        if (typeMirror == null) {
            typeMirror = wildcardType.getExtendsBound();
            if (typeMirror != null) {
                this.builder.append(" extends ");
                if (typeMirror.getKind() == TypeKind.WILDCARD) {
                    typeMirror = ((WildcardType)typeMirror).getSuperBound();
                }
                this.visit(typeMirror);
            }
        } else {
            this.builder.append(" super ");
            this.visit(typeMirror);
        }
        return null;
    }

    @Override
    public Void visitError(ErrorType errorType, Void void_) {
        Element element = errorType.asElement();
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            this.builder.append(typeElement.getSimpleName());
        }
        return null;
    }
}

