/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.groovy.support.GroovyProjectExtender;
import org.netbeans.modules.groovy.support.api.GroovySources;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;

public class GroovyFileWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private transient GroovyProjectExtender extender;

    public static GroovyFileWizardIterator create() {
        return new GroovyFileWizardIterator();
    }

    private GroovyFileWizardIterator() {
    }

    private WizardDescriptor.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        Sources sources = ProjectUtils.getSources((Project)project);
        List<SourceGroup> groupList = GroovySources.getGroovySourceGroups(sources);
        SourceGroup[] groups = groupList.toArray(new SourceGroup[groupList.size()]);
        assert (groups != null) : "Cannot return null from Sources.getSourceGroups: " + sources;
        if (groups.length == 0) {
            groups = sources.getSourceGroups("generic");
            return new WizardDescriptor.Panel[]{Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])groups)};
        }
        return new WizardDescriptor.Panel[]{JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])groups)};
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        assert (panels != null);
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public Set<FileObject> instantiate() throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wiz);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        DataObject dTemplate = DataObject.find((FileObject)template);
        String pkgName = GroovyFileWizardIterator.getPackageName(dir);
        DataObject dobj = null;
        dobj = pkgName == null ? dTemplate.createFromTemplate(df, targetName) : dTemplate.createFromTemplate(df, targetName, Collections.singletonMap("package", pkgName));
        FileObject createdFile = dobj.getPrimaryFile();
        this.initExtender();
        if (this.extender != null && !this.extender.isGroovyEnabled()) {
            this.extender.enableGroovy();
        }
        return Collections.singleton(createdFile);
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels(wiz);
        String[] beforeSteps = null;
        Object prop = wiz.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    protected final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    private GroovyProjectExtender initExtender() {
        Project project;
        if (this.extender == null && this.wiz != null && (project = Templates.getProject((WizardDescriptor)this.wiz)) != null) {
            this.extender = (GroovyProjectExtender)project.getLookup().lookup(GroovyProjectExtender.class);
        }
        return this.extender;
    }

    private static String getPackageName(FileObject targetFolder) {
        Project project = FileOwnerQuery.getOwner((FileObject)targetFolder);
        Sources sources = ProjectUtils.getSources((Project)project);
        List<SourceGroup> groups = GroovySources.getGroovySourceGroups(sources);
        String packageName = null;
        for (int i = 0; i < groups.size() && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups.get(i).getRootFolder(), (FileObject)targetFolder);
        }
        if (packageName != null) {
            packageName = packageName.replaceAll("/", ".");
        }
        return packageName;
    }
}

