/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.spring.beans.utils.StringUtils;

public final class FieldNamesCalculator {
    private final String typeName;
    private final Set<String> forbidden;
    private static Pattern pattern = Pattern.compile("(\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\d|\\-)*)");

    public FieldNamesCalculator(String typeName, Set<String> forbidden) {
        this.typeName = typeName;
        this.forbidden = forbidden;
    }

    public List<String> calculate() {
        ArrayList<String> nameBlocks = new ArrayList<String>();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        Matcher matcher = pattern.matcher(this.typeName);
        if (matcher.find()) {
            int idx = matcher.start();
            if (idx > 0) {
                String prefix = this.typeName.substring(0, idx);
                nameBlocks.add(prefix);
            }
            String group = matcher.group();
            nameBlocks.add(group);
            while (matcher.find()) {
                group = matcher.group();
                nameBlocks.add(group);
            }
            String[] blocks = nameBlocks.toArray(new String[0]);
            for (int i = 0; i < blocks.length; ++i) {
                StringBuilder sb = new StringBuilder(StringUtils.toLowerCamelCase(blocks[i]));
                for (int j = i + 1; j < blocks.length; ++j) {
                    names.add(this.findFreeFieldName(sb.toString()));
                    sb.append(blocks[j]);
                }
                names.add(this.findFreeFieldName(sb.toString()));
            }
        } else {
            names.add(this.findFreeFieldName(this.typeName));
        }
        return Collections.unmodifiableList(new ArrayList(names));
    }

    private String findFreeFieldName(String origName) {
        if (!this.forbidden.contains(origName)) {
            return origName;
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String newName = origName + Integer.toString(i);
            if (this.forbidden.contains(newName)) continue;
            return newName;
        }
        return null;
    }
}

