/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionCursor;
import org.h2.index.TreeIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class MultiVersionIndex
implements Index {
    private final Index base;
    private final TreeIndex delta;
    private final TableData table;
    private final Object sync;
    private final Column firstColumn;

    public MultiVersionIndex(Index index, TableData tableData) {
        this.base = index;
        this.table = tableData;
        IndexType indexType = IndexType.createNonUnique(false);
        this.delta = new TreeIndex(tableData, -1, "DELTA", index.getIndexColumns(), indexType);
        this.delta.setMultiVersion(true);
        this.sync = index.getDatabase();
        this.firstColumn = index.getColumns()[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session, Row row) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.base.add(session, row);
            if (!this.removeIfExists(session, row) && row.getSessionId() != 0) {
                this.delta.add(session, row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Session session) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.base.close(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            Cursor cursor = this.base.find(session, searchRow, searchRow2);
            Cursor cursor2 = this.delta.find(session, searchRow, searchRow2);
            return new MultiVersionCursor(session, this, cursor, cursor2, this.sync);
        }
    }

    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        throw Message.getInternalError();
    }

    public boolean canFindNext() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return this.base.canGetFirstOrLast() && this.delta.canGetFirstOrLast();
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        SearchRow searchRow;
        if (bl) {
            Cursor cursor = this.find(session, null, null);
            while (cursor.next()) {
                SearchRow searchRow2 = cursor.getSearchRow();
                Value value = searchRow2.getValue(this.firstColumn.getColumnId());
                if (value == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        Cursor cursor = this.base.findFirstOrLast(session, false);
        Cursor cursor2 = this.delta.findFirstOrLast(session, false);
        MultiVersionCursor multiVersionCursor = new MultiVersionCursor(session, this, cursor, cursor2, this.sync);
        multiVersionCursor.loadCurrent();
        while (multiVersionCursor.previous() && (searchRow = multiVersionCursor.getSearchRow()) != null) {
            Value value = searchRow.getValue(this.firstColumn.getColumnId());
            if (value == ValueNull.INSTANCE) continue;
            return multiVersionCursor;
        }
        return multiVersionCursor;
    }

    public double getCost(Session session, int[] nArray) throws SQLException {
        return this.base.getCost(session, nArray);
    }

    public boolean needRebuild() {
        return this.base.needRebuild();
    }

    private boolean removeIfExists(Session session, Row row) throws SQLException {
        Cursor cursor = this.delta.find(session, row, row);
        while (cursor.next()) {
            Row row2 = cursor.get();
            if (row2.getPos() != row.getPos() || row2.getVersion() != row.getVersion()) continue;
            if (row2 != row && this.table.getScanIndex(session).compareRows(row2, row) != 0) {
                row.setVersion(row2.getVersion() + 1);
                continue;
            }
            this.delta.remove(session, row2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session, Row row) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.base.remove(session, row);
            if (!this.removeIfExists(session, row)) {
                this.delta.add(session, row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.base.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(Session session) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.delta.truncate(session);
            this.base.truncate(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(int n, Row row) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.removeIfExists(null, row);
        }
    }

    public int compareKeys(SearchRow searchRow, SearchRow searchRow2) {
        return this.base.compareKeys(searchRow, searchRow2);
    }

    public int compareRows(SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        return this.base.compareRows(searchRow, searchRow2);
    }

    public int getColumnIndex(Column column) {
        return this.base.getColumnIndex(column);
    }

    public String getColumnListSQL() {
        return this.base.getColumnListSQL();
    }

    public Column[] getColumns() {
        return this.base.getColumns();
    }

    public IndexColumn[] getIndexColumns() {
        return this.base.getIndexColumns();
    }

    public long getCostRangeIndex(int[] nArray, long l) throws SQLException {
        return this.base.getCostRangeIndex(nArray, l);
    }

    public String getCreateSQL() {
        return this.base.getCreateSQL();
    }

    public String getCreateSQLForCopy(Table table, String string) {
        return this.base.getCreateSQLForCopy(table, string);
    }

    public String getDropSQL() {
        return this.base.getDropSQL();
    }

    public SQLException getDuplicateKeyException() {
        return this.base.getDuplicateKeyException();
    }

    public IndexType getIndexType() {
        return this.base.getIndexType();
    }

    public int getLookupCost(long l) {
        return this.base.getLookupCost(l);
    }

    public String getPlanSQL() {
        return this.base.getPlanSQL();
    }

    public long getRowCount(Session session) {
        return this.base.getRowCount(session);
    }

    public Table getTable() {
        return this.base.getTable();
    }

    public int getType() {
        return this.base.getType();
    }

    public boolean containsNullAndAllowMultipleNull(Session session, Row row) {
        return this.base.containsNullAndAllowMultipleNull(session, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildrenAndResources(Session session) throws SQLException {
        Object object = this.sync;
        synchronized (object) {
            this.table.removeIndex(this);
            this.remove(session);
        }
    }

    public String getSQL() {
        return this.base.getSQL();
    }

    public Schema getSchema() {
        return this.base.getSchema();
    }

    public void checkRename() throws SQLException {
        this.base.checkRename();
    }

    public ObjectArray getChildren() {
        return this.base.getChildren();
    }

    public String getComment() {
        return this.base.getComment();
    }

    public Database getDatabase() {
        return this.base.getDatabase();
    }

    public int getHeadPos() {
        return this.base.getHeadPos();
    }

    public int getId() {
        return this.base.getId();
    }

    public long getModificationId() {
        return this.base.getModificationId();
    }

    public String getName() {
        return this.base.getName();
    }

    public boolean getTemporary() {
        return this.base.getTemporary();
    }

    public void rename(String string) throws SQLException {
        this.base.rename(string);
    }

    public void setComment(String string) {
        this.base.setComment(string);
    }

    public void setModified() {
        this.base.setModified();
    }

    public void setTemporary(boolean bl) {
        this.base.setTemporary(bl);
    }
}

