/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class RasterImage {
    Image image;
    int[] argb;

    public RasterImage(Image img) {
        if (img == null) {
            throw new NullPointerException();
        }
        this.image = img;
    }

    public int getWidth() {
        return this.image.getWidth(null);
    }

    public int getHeight() {
        return this.image.getHeight(null);
    }

    public int[] getRGB() {
        if (this.argb != null) {
            return this.argb;
        }
        BufferedImage bi = null;
        if (this.image instanceof BufferedImage) {
            bi = (BufferedImage)this.image;
            if (bi.getType() != 2) {
                bi = this.toBufferedImage(this.image);
            }
        } else {
            bi = this.toBufferedImage(this.image);
        }
        this.image = bi;
        this.argb = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
        int[] tmpargb = new int[this.argb.length];
        System.arraycopy(this.argb, 0, tmpargb, 0, this.argb.length);
        this.argb = tmpargb;
        return this.argb;
    }

    protected BufferedImage toBufferedImage(Image img) {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        return bi;
    }
}

