/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.welcome.content.ActionButton;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.ui.InstallConfig;
import org.netbeans.modules.welcome.ui.SampleProjectAction;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

class GetStarted
extends JPanel
implements Constants {
    private int row;
    private InstallConfig ic;

    public GetStarted() {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.ic = InstallConfig.getDefault();
        this.buildContent();
    }

    private void buildContent() {
        String rootName = "WelcomePage/GettingStartedLinks";
        FileObject root = FileUtil.getConfigFile((String)rootName);
        if (null == root) {
            Logger.getLogger(GetStarted.class.getName()).log(Level.INFO, "Start page content not found: FileObject: " + rootName);
            return;
        }
        DataFolder folder = DataFolder.findFolder((FileObject)root);
        if (null == folder) {
            Logger.getLogger(GetStarted.class.getName()).log(Level.INFO, "Start page content not found: DataFolder: " + rootName);
            return;
        }
        DataObject[] children = folder.getChildren();
        if (null == children) {
            Logger.getLogger(GetStarted.class.getName()).log(Level.INFO, "Start page content not found: DataObject: " + rootName);
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getPrimaryFile().isFolder()) {
                String headerText = children[i].getNodeDelegate().getDisplayName();
                JLabel lblTitle = new JLabel(headerText);
                lblTitle.setFont(BUTTON_FONT);
                lblTitle.setHorizontalAlignment(2);
                lblTitle.setOpaque(true);
                lblTitle.setBorder(HEADER_TEXT_BORDER);
                this.add((Component)lblTitle, new GridBagConstraints(0, this.row++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
                DataFolder subFolder = DataFolder.findFolder((FileObject)children[i].getPrimaryFile());
                DataObject[] subFolderChildren = subFolder.getChildren();
                for (int j = 0; j < subFolderChildren.length; ++j) {
                    this.row = this.addLink(this.row, subFolderChildren[j]);
                }
                continue;
            }
            this.row = this.addLink(this.row, children[i]);
        }
        this.add((Component)new JLabel(), new GridBagConstraints(0, this.row++, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private int addLink(int row, DataObject dob) {
        Action action = this.extractAction(dob);
        if (null != action) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setOpaque(false);
            ActionButton lb = new ActionButton(action, Utils.getUrlString(dob), Utils.getColor("HeaderForegroundColor"), true, dob.getPrimaryFile().getPath());
            panel.add((Component)lb, new GridBagConstraints(1, 0, 1, 3, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            lb.setFont(GET_STARTED_FONT);
            lb.getAccessibleContext().setAccessibleName(lb.getText());
            lb.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("GettingStarted", lb.getText()));
            this.add((Component)panel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 7, 0), 0, 0));
        }
        return row;
    }

    private Action extractAction(DataObject dob) {
        OpenCookie oc = (OpenCookie)dob.getCookie(OpenCookie.class);
        if (null != oc) {
            return new LinkAction(dob);
        }
        InstanceCookie.Of instCookie = (InstanceCookie.Of)dob.getCookie(InstanceCookie.Of.class);
        if (null != instCookie && instCookie.instanceOf(Action.class)) {
            try {
                Action res = (Action)instCookie.instanceCreate();
                if (null != res) {
                    res.putValue("Name", dob.getNodeDelegate().getDisplayName());
                }
                return res;
            }
            catch (Exception e) {
                Logger.getLogger(SampleProjectAction.class.getName()).log(Level.INFO, null, e);
            }
        }
        return null;
    }

    private static class LinkAction
    extends AbstractAction {
        private DataObject dob;

        public LinkAction(DataObject dob) {
            super(dob.getNodeDelegate().getDisplayName());
            this.dob = dob;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OpenCookie oc = (OpenCookie)this.dob.getCookie(OpenCookie.class);
            if (null != oc) {
                oc.open();
            }
        }
    }
}

