/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.ui.models.SessionsTableModelFilter;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class JPDASessionActionsProvider
implements NodeActionsProviderFilter {
    private HashSet listeners;

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        nodeActionsProvider.performDefaultAction(object);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        Action[] actionArray;
        if (!(object instanceof Session) || !SessionsTableModelFilter.isJPDASession((Session)object)) {
            return nodeActionsProvider.getActions(object);
        }
        Session session = (Session)object;
        try {
            actionArray = nodeActionsProvider.getActions(object);
        }
        catch (UnknownTypeException unknownTypeException) {
            actionArray = new Action[]{};
        }
        ArrayList<Action> arrayList = new ArrayList<Action>();
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine != null) {
            JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
            arrayList.add(new CustomizeSession(jPDADebugger));
        }
        arrayList.add(new LanguageSelection(session));
        arrayList.addAll(Arrays.asList(actionArray));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private String localize(String string) {
        return NbBundle.getBundle(JPDASessionActionsProvider.class).getString(string);
    }

    public void addModelListener(ModelListener modelListener) {
        HashSet hashSet = this.listeners == null ? new HashSet() : (HashSet)this.listeners.clone();
        hashSet.add(modelListener);
        this.listeners = hashSet;
    }

    public void removeModelListener(ModelListener modelListener) {
        if (this.listeners == null) {
            return;
        }
        HashSet hashSet = (HashSet)this.listeners.clone();
        hashSet.remove(modelListener);
        this.listeners = hashSet;
    }

    private class CustomizeSession
    extends AbstractAction
    implements Presenter.Popup {
        private JPDADebugger dbg;

        public CustomizeSession(JPDADebugger jPDADebugger) {
            this.dbg = jPDADebugger;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu jMenu = new JMenu(JPDASessionActionsProvider.this.localize("CTL_Session_Resume_Threads"));
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction(JPDASessionActionsProvider.this.localize("CTL_Session_Resume_All_Threads")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomizeSession.this.dbg.setSuspend(2);
                }
            });
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(new AbstractAction(JPDASessionActionsProvider.this.localize("CTL_Session_Resume_Current_Thread")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomizeSession.this.dbg.setSuspend(1);
                }
            });
            if (this.dbg.getSuspend() == 2) {
                jRadioButtonMenuItem.setSelected(true);
            } else {
                jRadioButtonMenuItem2.setSelected(true);
            }
            jMenu.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem2);
            return jMenu;
        }
    }

    private class LanguageSelection
    extends AbstractAction
    implements Presenter.Popup {
        private Session session;

        public LanguageSelection(Session session) {
            this.session = session;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu jMenu = new JMenu(JPDASessionActionsProvider.this.localize("CTL_Session_Popup_Language"));
            String[] stringArray = this.session.getSupportedLanguages();
            String string = this.session.getCurrentLanguage();
            for (int i = 0; i < stringArray.length; ++i) {
                final String string2 = stringArray[i];
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction(string2){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        LanguageSelection.this.session.setCurrentLanguage(string2);
                    }
                });
                if (string.equals(string2)) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                jMenu.add(jRadioButtonMenuItem);
            }
            return jMenu;
        }
    }
}

