/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.ToolTipManager;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.spi.tasklist.TaskScanningScope;

class ScopeButton
extends JToggleButton
implements PropertyChangeListener {
    private TaskManagerImpl tm;
    private TaskScanningScope scope;

    public ScopeButton(TaskManagerImpl tm, TaskScanningScope scope) {
        this.tm = tm;
        this.scope = scope;
        this.setText(null);
        this.setIcon(new ImageIcon(Accessor.getIcon(scope)));
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setSelected(scope.equals(tm.getScope()));
        this.setFocusable(false);
    }

    @Override
    public String getToolTipText() {
        return null == this.scope ? null : Accessor.getDescription(this.scope);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tm.addPropertyChangeListener("taskScanningScope", this);
        this.setSelected(this.scope.equals(this.tm.getScope()));
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.tm.removePropertyChangeListener("taskScanningScope", this);
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        super.fireActionPerformed(event);
        this.switchScope();
    }

    private void switchScope() {
        if (this.scope.equals(this.tm.getScope())) {
            this.setSelected(true);
            return;
        }
        this.tm.observe(this.scope, this.tm.getFilter());
        this.setSelected(true);
        Settings.getDefault().setActiveScanningScope(this.scope);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.setSelected(this.scope.equals(this.tm.getScope()));
    }
}

