/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.heapwalk.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.heapwalk.HeapImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.views.DebuggerHeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.ClassesController;
import org.netbeans.modules.profiler.heapwalk.ClassesListController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class ClassesCountsView
extends TopComponent
implements HelpCtx.Provider {
    private transient EngineListener listener;
    private transient JPanel content;
    private transient HeapFragmentWalker hfw;
    private transient ClassesListController clc;

    public ClassesCountsView() {
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/debugger/resources/classesView/Classes.png"));
        this.setLayout(new BorderLayout());
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
    }

    protected String preferredID() {
        return "org.netbeans.modules.debugger.jpda.ui.views.ClassesView";
    }

    private void setUp() {
        if (this.listener == null) {
            this.listener = new EngineListener();
            this.listener.start();
        }
        if (this.content == null) {
            this.setContent();
        }
    }

    private synchronized void tearDown() {
        if (this.content != null) {
            final JPanel jPanel = this.content;
            this.content = null;
            this.hfw = null;
            this.clc = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassesCountsView.this.remove(jPanel);
                }
            });
        }
    }

    private void setContent() {
        assert (SwingUtilities.isEventDispatchThread());
        JPDADebugger jPDADebugger = null;
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine != null) {
            jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        }
        if (this.content != null) {
            this.remove(this.content);
            this.content = null;
        }
        if (jPDADebugger != null && jPDADebugger.canGetInstanceInfo()) {
            final JPDADebugger jPDADebugger2 = jPDADebugger;
            RequestProcessor requestProcessor = (RequestProcessor)debuggerEngine.lookupFirst(null, RequestProcessor.class);
            if (requestProcessor == null) {
                requestProcessor = RequestProcessor.getDefault();
            }
            requestProcessor.post(new Runnable(){

                @Override
                public void run() {
                    HeapImpl heapImpl = new HeapImpl(jPDADebugger2);
                    final DebuggerHeapFragmentWalker debuggerHeapFragmentWalker = new DebuggerHeapFragmentWalker(heapImpl);
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ClassesCountsView classesCountsView = ClassesCountsView.this;
                            synchronized (classesCountsView) {
                                ClassesCountsView.this.hfw = debuggerHeapFragmentWalker;
                                ClassesController classesController = debuggerHeapFragmentWalker.getClassesController();
                                ClassesCountsView.this.content = classesController.getPanel();
                                ClassesCountsView.this.clc = classesController.getClassesListController();
                                Component component = classesController.getClassesListController().getPanel().getComponent(0);
                                component.setVisible(false);
                                classesController.getClassesListController().setColumnVisibility(3, false);
                                ClassesCountsView.this.add(ClassesCountsView.this.content, "Center");
                            }
                            ClassesCountsView.this.repaint();
                            ClassesCountsView.this.revalidate();
                        }
                    });
                }
            });
        }
    }

    private void refreshContent() {
        if (this.clc != null) {
            this.clc.updateData();
        } else {
            this.setContent();
        }
    }

    HeapFragmentWalker getCurrentFragmentWalker() {
        return this.hfw;
    }

    protected void componentShowing() {
        super.componentShowing();
        this.setUp();
    }

    protected void componentHidden() {
        super.componentHidden();
    }

    protected void componentClosed() {
        super.componentClosed();
        this.tearDown();
        if (this.listener != null) {
            this.listener.stop();
            this.listener = null;
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerInstancesNode");
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.content == null) {
            return false;
        }
        return this.content.requestFocusInWindow();
    }

    public String getName() {
        return NbBundle.getMessage(ClassesCountsView.class, (String)"CTL_Classes_view");
    }

    public String getToolTipText() {
        return NbBundle.getMessage(ClassesCountsView.class, (String)"CTL_Classes_tooltip");
    }

    private final class EngineListener
    extends DebuggerManagerAdapter {
        private WeakReference<JPDADebugger> lastDebugger = new WeakReference<Object>(null);
        private RequestProcessor.Task refreshTask;

        private EngineListener() {
        }

        void start() {
            DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
            this.attachToStateChange(debuggerEngine);
        }

        void stop() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            this.detachFromStateChange();
        }

        private synchronized void attachToStateChange(DebuggerEngine debuggerEngine) {
            this.detachFromStateChange();
            if (debuggerEngine == null) {
                return;
            }
            JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
            if (jPDADebugger == null) {
                return;
            }
            jPDADebugger.addPropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            this.lastDebugger = new WeakReference<JPDADebugger>(jPDADebugger);
        }

        private synchronized void detachFromStateChange() {
            JPDADebugger jPDADebugger = (JPDADebugger)this.lastDebugger.get();
            if (jPDADebugger != null) {
                jPDADebugger.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            }
            if (this.refreshTask != null) {
                this.refreshTask.cancel();
                this.refreshTask = null;
            }
            ClassesCountsView.this.tearDown();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof JPDADebugger) {
                int n = ((JPDADebugger)propertyChangeEvent.getSource()).getState();
                if (n == 4) {
                    this.detachFromStateChange();
                } else if (n != 1) {
                    this.getRefreshContentTask().schedule(10);
                }
                return;
            }
            DebuggerEngine debuggerEngine = (DebuggerEngine)propertyChangeEvent.getNewValue();
            this.attachToStateChange(debuggerEngine);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassesCountsView.this.setContent();
                }
            });
        }

        private synchronized RequestProcessor.Task getRefreshContentTask() {
            if (this.refreshTask == null) {
                this.refreshTask = RequestProcessor.getDefault().create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        JPDADebugger jPDADebugger;
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ClassesCountsView.this.refreshContent();
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                        }
                        Object object = EngineListener.this;
                        synchronized (object) {
                            jPDADebugger = (JPDADebugger)EngineListener.this.lastDebugger.get();
                        }
                        if (jPDADebugger != null && jPDADebugger.getState() == 2) {
                            object = ClassesCountsView.this;
                            synchronized (object) {
                                if (EngineListener.this.refreshTask != null) {
                                    EngineListener.this.refreshTask.schedule(500);
                                }
                            }
                        }
                    }
                });
            }
            return this.refreshTask;
        }
    }
}

