/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.flow;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.vmd.api.flow.visual.FlowDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowEdgeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowNodeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DataSerializer;
import org.netbeans.modules.vmd.api.io.ProjectTypeInfo;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.flow.FlowAccessController;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlowDataSerializer
implements DataSerializer {
    private static final String FLOW_DOCUMENT_NODE = "FlowScene";
    private static final String VERSION_ATTR = "version";
    private static final String NODE_NODE = "Node";
    private static final String EDGE_NODE = "Edge";
    private static final String COMPONENTID_ATTR = "componentID";
    private static final String DESCRIPTORID_ATTR = "descriptorID";
    private static final String X_NODE_ATTR = "x";
    private static final String Y_NODE_ATTR = "y";
    private static final String X_EDGE_ATTR = "x";
    private static final String Y_EDGE_ATTR = "y";
    private static final String VERSION_VALUE_1 = "1";

    public Node serializeData(DataObjectContext context, DesignDocument document, Document file) {
        ProjectTypeInfo info = ProjectTypeInfo.getProjectTypeInfoFor((String)context.getProjectType());
        if (!info.getTags().contains("flow")) {
            return null;
        }
        FlowAccessController accessController = (FlowAccessController)document.getListenerManager().getAccessController(FlowAccessController.class);
        FlowScene scene = accessController.getScene();
        Element node = file.createElement(FLOW_DOCUMENT_NODE);
        FlowDataSerializer.setAttribute(file, node, VERSION_ATTR, VERSION_VALUE_1);
        Set objects = scene.getObjects();
        for (Object o : objects) {
            Widget widget;
            FlowDescriptor descriptor;
            if (scene.isNode(o)) {
                Point location;
                descriptor = (FlowDescriptor)o;
                widget = scene.findWidget(descriptor);
                if (widget == null || (location = widget.getPreferredLocation()) == null) continue;
                Element data = file.createElement(NODE_NODE);
                FlowDataSerializer.setAttribute(file, data, COMPONENTID_ATTR, Long.toString(descriptor.getRepresentedComponent().getComponentID()));
                FlowDataSerializer.setAttribute(file, data, DESCRIPTORID_ATTR, descriptor.getDescriptorID());
                FlowDataSerializer.setAttribute(file, data, "x", Integer.toString(location.x));
                FlowDataSerializer.setAttribute(file, data, "y", Integer.toString(location.y));
                node.appendChild(data);
                continue;
            }
            if (!scene.isEdge(o) || !((widget = scene.findWidget(descriptor = (FlowDescriptor)o)) instanceof ConnectionWidget)) continue;
            ConnectionWidget conn = (ConnectionWidget)widget;
            List controlPoints = conn.getControlPoints();
            if (conn.getRoutingPolicy() != ConnectionWidget.RoutingPolicy.DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED || controlPoints.isEmpty()) continue;
            Element data = file.createElement(EDGE_NODE);
            FlowDataSerializer.setAttribute(file, data, COMPONENTID_ATTR, Long.toString(descriptor.getRepresentedComponent().getComponentID()));
            FlowDataSerializer.setAttribute(file, data, DESCRIPTORID_ATTR, descriptor.getDescriptorID());
            for (int i = 0; i < controlPoints.size(); ++i) {
                Point point = (Point)controlPoints.get(i);
                FlowDataSerializer.setAttribute(file, data, "x" + i, Integer.toString(point.x));
                FlowDataSerializer.setAttribute(file, data, "y" + i, Integer.toString(point.y));
            }
            node.appendChild(data);
        }
        return node;
    }

    public boolean deserializeData(DataObjectContext context, final DesignDocument document, final Node data) {
        ProjectTypeInfo info = ProjectTypeInfo.getProjectTypeInfoFor((String)context.getProjectType());
        if (!info.getTags().contains("flow")) {
            return false;
        }
        if (!FLOW_DOCUMENT_NODE.equals(data.getNodeName())) {
            return false;
        }
        if (!VERSION_VALUE_1.equals(FlowDataSerializer.getAttributeValue(data, VERSION_ATTR))) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final FlowScene scene = ((FlowAccessController)document.getListenerManager().getAccessController(FlowAccessController.class)).getScene();
                document.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        FlowDataSerializer.this.deserializeDataVersion1(document, data, scene);
                    }
                });
                scene.validate();
            }
        });
        return true;
    }

    private void deserializeDataVersion1(DesignDocument document, Node data, FlowScene scene) {
        boolean isAnythingLoaded = false;
        for (Node node : FlowDataSerializer.getChildNode(data)) {
            FlowEdgeDescriptor descriptor;
            Widget widget;
            String descriptorid;
            long componentID;
            if (NODE_NODE.equals(node.getNodeName())) {
                FlowNodeDescriptor descriptor2;
                Widget widget2;
                int y;
                int x;
                componentID = Long.parseLong(FlowDataSerializer.getAttributeValue(node, COMPONENTID_ATTR));
                descriptorid = FlowDataSerializer.getAttributeValue(node, DESCRIPTORID_ATTR);
                try {
                    x = Integer.parseInt(FlowDataSerializer.getAttributeValue(node, "x"));
                    y = Integer.parseInt(FlowDataSerializer.getAttributeValue(node, "y"));
                }
                catch (NumberFormatException e) {
                    continue;
                }
                DesignComponent representedComponent = document.getComponentByUID(componentID);
                if (representedComponent == null || descriptorid == null || (widget2 = scene.findWidget(descriptor2 = new FlowNodeDescriptor(representedComponent, descriptorid))) == null) continue;
                widget2.setPreferredLocation(new Point(x, y));
                isAnythingLoaded = true;
                continue;
            }
            if (!EDGE_NODE.equals(node.getNodeName())) continue;
            componentID = Long.parseLong(FlowDataSerializer.getAttributeValue(node, COMPONENTID_ATTR));
            descriptorid = FlowDataSerializer.getAttributeValue(node, DESCRIPTORID_ATTR);
            DesignComponent representedComponent = document.getComponentByUID(componentID);
            if (representedComponent == null || descriptorid == null || !((widget = scene.findWidget(descriptor = new FlowEdgeDescriptor(representedComponent, descriptorid, null, false, null, false))) instanceof ConnectionWidget)) continue;
            ConnectionWidget conn = (ConnectionWidget)widget;
            conn.setRoutingPolicy(ConnectionWidget.RoutingPolicy.DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED);
            ArrayList<Point> controlPoints = new ArrayList<Point>();
            int i = 0;
            while (true) {
                int y;
                int x;
                try {
                    x = Integer.parseInt(FlowDataSerializer.getAttributeValue(node, "x" + i));
                    y = Integer.parseInt(FlowDataSerializer.getAttributeValue(node, "x" + i));
                }
                catch (NumberFormatException e) {
                    break;
                }
                controlPoints.add(new Point(x, y));
                ++i;
            }
            if (controlPoints.isEmpty()) continue;
            conn.setRoutingPolicy(ConnectionWidget.RoutingPolicy.DISABLE_ROUTING_UNTIL_END_POINT_IS_MOVED);
            conn.setControlPoints(controlPoints, false);
        }
        if (!isAnythingLoaded) {
            scene.layoutScene();
        }
    }

    private static String getAttributeValue(Node node, String attr) {
        try {
            NamedNodeMap map;
            if (node != null && (map = node.getAttributes()) != null && (node = map.getNamedItem(attr)) != null) {
                return node.getNodeValue();
            }
        }
        catch (DOMException e) {
            Debug.warning((Object[])new Object[]{e});
        }
        return null;
    }

    private static void setAttribute(Document xml, Node node, String name, String value) {
        NamedNodeMap map = node.getAttributes();
        Attr attribute = xml.createAttribute(name);
        attribute.setValue(value);
        map.setNamedItem(attribute);
    }

    private static Node[] getChildNode(Node node) {
        NodeList childNodes = node.getChildNodes();
        Node[] nodes = new Node[childNodes != null ? childNodes.getLength() : 0];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = childNodes.item(i);
        }
        return nodes;
    }
}

