/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.maven.execute.cmd.Constructor;
import org.openide.util.Utilities;

public class ShellConstructor
implements Constructor {
    private final File mavenHome;

    public ShellConstructor(File mavenHome) {
        this.mavenHome = mavenHome;
    }

    @Override
    public List<String> construct() {
        String ex;
        String quote = "\"";
        String escaped = "\\" + quote;
        ArrayList<String> toRet = new ArrayList<String>();
        String string = ex = Utilities.isWindows() ? "mvn.bat" : "mvn";
        if (this.mavenHome != null) {
            File bin = new File(this.mavenHome, "bin" + File.separator + ex);
            if (bin.exists()) {
                toRet.add(ShellConstructor.quoteSpaces(bin.getAbsolutePath(), quote));
            } else {
                toRet.add(ex);
            }
        } else {
            toRet.add(ex);
        }
        if (Utilities.isWindows() && Boolean.getBoolean("maven.run.cmd")) {
            toRet.add(0, "/c");
            toRet.add(0, "cmd");
        }
        return toRet;
    }

    private static String quoteSpaces(String val, String quote) {
        if (val.indexOf(32) != -1 && Utilities.isWindows()) {
            return quote + val + quote;
        }
        return val;
    }
}

