/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.cos;

import hidden.org.codehaus.plexus.util.DirectoryScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.cos.CosChecker;
import org.netbeans.modules.maven.spi.cos.AdditionalDestination;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class CopyResourcesOnSave
extends FileChangeAdapter {
    private static CopyResourcesOnSave instance = new CopyResourcesOnSave();
    private static final RequestProcessor RP = new RequestProcessor("CopyResourcesOnSave");
    private boolean isAdded = false;

    private CopyResourcesOnSave() {
    }

    public static CopyResourcesOnSave getInstance() {
        return instance;
    }

    public void checkOpenProjects() {
        boolean hasAnyMavens = false;
        for (Project prj : OpenProjects.getDefault().getOpenProjects()) {
            if (prj.getLookup().lookup(NbMavenProject.class) == null) continue;
            hasAnyMavens = true;
            break;
        }
        if (hasAnyMavens) {
            if (!this.isAdded) {
                FileUtil.addFileChangeListener((FileChangeListener)this);
                this.isAdded = true;
            }
        } else if (this.isAdded) {
            FileUtil.removeFileChangeListener((FileChangeListener)this);
            this.isAdded = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySrcToDest(FileObject srcFile, FileObject destFile) throws IOException {
        if (destFile != null && !srcFile.isFolder()) {
            InputStream is = null;
            OutputStream os = null;
            FileLock fl = null;
            try {
                is = srcFile.getInputStream();
                fl = destFile.lock();
                os = destFile.getOutputStream(fl);
                FileUtil.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                if (fl != null) {
                    fl.releaseLock();
                }
            }
        }
    }

    private Project getOwningMavenProject(FileObject file) {
        Project prj = FileOwnerQuery.getOwner((FileObject)file);
        if (prj == null) {
            return null;
        }
        if (!prj.getProjectDirectory().isValid()) {
            return null;
        }
        NbMavenProject mvn = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        if (mvn == null) {
            return null;
        }
        if (RunUtils.hasTestCompileOnSaveEnabled(prj) || RunUtils.hasApplicationCompileOnSaveEnabled(prj)) {
            return prj;
        }
        return null;
    }

    public void fileChanged(final FileEvent fe) {
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    CopyResourcesOnSave.this.fileChanged(fe);
                }
            });
            return;
        }
        Project owning = this.getOwningMavenProject(fe.getFile());
        if (owning == null) {
            return;
        }
        try {
            this.handleCopyFileToDestDir(fe.getFile(), owning);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void fileDataCreated(final FileEvent fe) {
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    CopyResourcesOnSave.this.fileDataCreated(fe);
                }
            });
            return;
        }
        Project owning = this.getOwningMavenProject(fe.getFile());
        if (owning == null) {
            return;
        }
        try {
            this.handleCopyFileToDestDir(fe.getFile(), owning);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void fileRenamed(final FileRenameEvent fe) {
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    CopyResourcesOnSave.this.fileRenamed(fe);
                }
            });
            return;
        }
        try {
            FileObject fo = fe.getFile();
            Project owning = this.getOwningMavenProject(fo);
            if (owning == null) {
                return;
            }
            Tuple base = this.findAppropriateResourceRoots(fo, owning);
            if (base != null) {
                this.handleCopyFileToDestDir(base, fo, owning);
                FileObject parent = fo.getParent();
                String path = FileUtil.isParentOf((FileObject)base.root, (FileObject)parent) ? FileUtil.getRelativePath((FileObject)base.root, (FileObject)fo.getParent()) + "/" + fe.getName() + "." + fe.getExt() : fe.getName() + "." + fe.getExt();
                this.handleDeleteFileInDestDir(fo, path, base, owning);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    public void fileDeleted(final FileEvent fe) {
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    CopyResourcesOnSave.this.fileDeleted(fe);
                }
            });
            return;
        }
        Project owning = this.getOwningMavenProject(fe.getFile());
        if (owning == null) {
            return;
        }
        try {
            this.handleDeleteFileInDestDir(fe.getFile(), null, owning);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void handleDeleteFileInDestDir(FileObject fo, String path, Project project) throws IOException {
        Tuple tuple = this.findAppropriateResourceRoots(fo, project);
        this.handleDeleteFileInDestDir(fo, path, tuple, project);
    }

    private void handleDeleteFileInDestDir(FileObject fo, String path, Tuple tuple, Project project) throws IOException {
        if (tuple != null) {
            AdditionalDestination add;
            path = path != null ? path : FileUtil.getRelativePath((FileObject)tuple.root, (FileObject)fo);
            FileObject toDelete = tuple.destinationRoot.getFileObject(path = this.addTargetPath(path, tuple.resource));
            if (toDelete != null) {
                toDelete.delete();
            }
            if ((add = (AdditionalDestination)project.getLookup().lookup(AdditionalDestination.class)) != null) {
                add.delete(fo, path);
            }
        }
    }

    private void handleCopyFileToDestDir(FileObject fo, Project prj) throws IOException {
        Tuple tuple = this.findAppropriateResourceRoots(fo, prj);
        this.handleCopyFileToDestDir(tuple, fo, prj);
    }

    private void handleCopyFileToDestDir(Tuple tuple, FileObject fo, Project project) throws IOException {
        if (tuple != null && !tuple.resource.isFiltering()) {
            String path = FileUtil.getRelativePath((FileObject)tuple.root, (FileObject)fo);
            path = this.addTargetPath(path, tuple.resource);
            FileObject destFile = this.ensureDestinationFileExists(tuple.destinationRoot, path, fo.isFolder());
            this.copySrcToDest(fo, destFile);
            AdditionalDestination add = (AdditionalDestination)project.getLookup().lookup(AdditionalDestination.class);
            if (add != null) {
                add.copy(fo, path);
            }
        }
    }

    private String addTargetPath(String path, Resource resource) {
        String target = resource.getTargetPath();
        if (target != null) {
            target = (target = target.replace("\\", "/")).endsWith("/") ? target : target + "/";
            path = target + path;
        }
        return path;
    }

    private Tuple findAppropriateResourceRoots(FileObject child, Project prj) {
        Tuple tup;
        Tuple tup2;
        NbMavenProject nbproj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        assert (nbproj != null);
        boolean test = RunUtils.hasTestCompileOnSaveEnabled(prj);
        if (test && (tup2 = this.findResource(nbproj.getMavenProject().getTestResources(), prj, nbproj, child, true)) != null) {
            return tup2;
        }
        boolean main = RunUtils.hasApplicationCompileOnSaveEnabled(prj);
        if ((test || main) && (tup = this.findResource(nbproj.getMavenProject().getResources(), prj, nbproj, child, false)) != null) {
            return tup;
        }
        return null;
    }

    private Tuple findResource(List<Resource> resources, Project prj, NbMavenProject nbproj, FileObject child, boolean test) {
        File fil;
        if (resources == null) {
            return null;
        }
        MavenProject mav = nbproj.getMavenProject();
        FileObject target = null;
        if (mav.getBuild() != null) {
            fil = new File(test ? mav.getBuild().getTestOutputDirectory() : mav.getBuild().getOutputDirectory());
            File stamp = new File(fil = FileUtil.normalizeFile((File)fil), ".netbeans_automatic_build");
            if (!stamp.exists()) {
                return null;
            }
        } else {
            return null;
        }
        target = FileUtil.toFileObject((File)fil);
        block0: for (Resource res : resources) {
            URI uri = FileUtilities.getDirURI(prj.getProjectDirectory(), res.getDirectory());
            FileObject fo = FileUtil.toFileObject((File)new File(uri));
            if (fo == null || !FileUtil.isParentOf((FileObject)fo, (FileObject)child)) continue;
            String path = FileUtil.getRelativePath((FileObject)fo, (FileObject)child);
            List<String> incls = res.getIncludes();
            if (incls.size() == 0) {
                incls = Arrays.asList(CosChecker.DEFAULT_INCLUDES);
            }
            boolean included = false;
            for (String incl : incls) {
                if (!DirectoryScanner.match((String)incl, (String)path)) continue;
                included = true;
                break;
            }
            if (!included) break;
            ArrayList<String> excls = new ArrayList<String>(res.getExcludes());
            excls.addAll(Arrays.asList(DirectoryScanner.DEFAULTEXCLUDES));
            for (String excl : excls) {
                if (!DirectoryScanner.match((String)excl, (String)path)) continue;
                continue block0;
            }
            return new Tuple(res, fo, target);
        }
        return null;
    }

    private FileObject ensureDestinationFileExists(FileObject root, String path, boolean isFolder) throws IOException {
        if (isFolder) {
            return FileUtil.createFolder((FileObject)root, (String)path);
        }
        return FileUtil.createData((FileObject)root, (String)path);
    }

    private class Tuple {
        Resource resource;
        FileObject root;
        FileObject destinationRoot;

        private Tuple(Resource res, FileObject fo, FileObject destFolder) {
            this.resource = res;
            this.root = fo;
            this.destinationRoot = destFolder;
        }
    }
}

