/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Resource;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.support.PathResourceBase;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public class ExcludingResourceImpl
extends PathResourceBase
implements FilteringPathResourceImplementation,
PropertyChangeListener {
    private NbMavenProjectImpl project;
    private URL[] cachedRoots;
    private HashMap<URL, PathMatcher> matchers;
    private boolean test;

    protected ExcludingResourceImpl(boolean test) {
        this.test = test;
        this.matchers = new HashMap();
    }

    public ExcludingResourceImpl(NbMavenProjectImpl project, boolean test) {
        this(test);
        this.project = project;
        NbMavenProject watch = project.getProjectWatcher();
        watch.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)watch));
    }

    public synchronized URL[] getRoots() {
        if (this.cachedRoots != null) {
            return this.cachedRoots;
        }
        URL[] urls = this.calculateRoots();
        this.cachedRoots = urls;
        return urls;
    }

    public ClassPathImplementation getContent() {
        return null;
    }

    public synchronized boolean includes(URL root, String resource) {
        PathMatcher match = this.matchers.get(root);
        assert (match != null) : "No PathMatcher for " + root;
        return match.matches(resource, true);
    }

    protected List<Resource> getResources(boolean istest) {
        return istest ? this.project.getOriginalMavenProject().getTestResources() : this.project.getOriginalMavenProject().getResources();
    }

    protected File getBase() {
        return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
    }

    private URL[] calculateRoots() {
        assert (Thread.holdsLock(this));
        ArrayList<URL> newurls = new ArrayList<URL>();
        HashMap<URL, String> includes = new HashMap<URL, String>();
        HashMap<URL, String> excludes = new HashMap<URL, String>();
        List<Resource> lst = this.getResources(this.test);
        for (Resource res : lst) {
            URI uri = FileUtilities.getDirURI(this.getBase(), res.getDirectory());
            try {
                URL entry = uri.toURL();
                if (entry != null && !entry.toExternalForm().endsWith("/")) {
                    entry = new URL(entry.toExternalForm() + "/");
                }
                if (entry == null) continue;
                if (!newurls.contains(entry)) {
                    newurls.add(entry);
                }
                this.processInEx(includes, entry, res.getIncludes());
                this.processInEx(excludes, entry, res.getExcludes());
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
            }
        }
        this.matchers.clear();
        for (URL u : newurls) {
            String in = (String)includes.get(u);
            String ex = (String)excludes.get(u);
            this.matchers.put(u, new PathMatcher(in, ex, new File(u.toExternalForm())));
        }
        this.cachedRoots = newurls.toArray(new URL[0]);
        return this.cachedRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("MavenProject".equals(evt.getPropertyName())) {
            ExcludingResourceImpl excludingResourceImpl = this;
            synchronized (excludingResourceImpl) {
                this.cachedRoots = null;
            }
            this.firePropertyChange("roots", null, null);
        }
    }

    private void processInEx(Map<URL, String> cludes, URL entry, List res) {
        String clude = cludes.get(entry);
        clude = clude == null ? "" : clude + ",";
        if (res != null && res.size() > 0) {
            for (Object incl : res) {
                clude = clude + incl + ",";
            }
            if (clude.endsWith(",")) {
                clude.substring(0, clude.length() - 1);
            }
        }
        if (clude.length() == 0) {
            clude = null;
        }
        cludes.put(entry, clude);
    }
}

