/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.MavenProjectPropsImpl;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.model.pom.Activation;
import org.netbeans.modules.maven.model.pom.ActivationProperty;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.maven.model.profile.ProfilesModel;
import org.openide.util.NbBundle;

public final class ModelHandle {
    public static final String PANEL_RUN = "RUN";
    public static final String PANEL_BASIC = "BASIC";
    public static final String PANEL_CONFIGURATION = "CONFIGURATION";
    public static final String PANEL_MAPPING = "MAPPING";
    public static final String PANEL_LIBRARIES = "LIBRARIES";
    public static final String PANEL_SOURCES = "SOURCES";
    public static final String PANEL_COMPILE = "COMPILE";
    public static final String PROFILE_PUBLIC = "netbeans-public";
    public static final String PROFILE_PRIVATE = "netbeans-private";
    public static final String PROPERTY_PROFILE = "netbeans.execution";
    private final MavenProjectPropsImpl auxiliaryProps;
    private final POMModel model;
    private final MavenProject project;
    private final ProfilesModel profiles;
    private final Map<String, ActionToGoalMapping> mappings;
    private final Map<ActionToGoalMapping, Boolean> modMappings;
    private Profile publicProfile;
    private org.netbeans.modules.maven.model.profile.Profile privateProfile;
    private List<Configuration> configurations;
    private boolean modProfiles = false;
    private boolean modModel = false;
    private boolean modConfig = false;
    private Configuration active;

    private ModelHandle(POMModel mdl, ProfilesModel profile, MavenProject proj, Map<String, ActionToGoalMapping> mappings, List<Configuration> configs, Configuration active, MavenProjectPropsImpl auxProps) {
        this.model = mdl;
        this.project = proj;
        this.profiles = profile;
        this.mappings = mappings;
        this.modMappings = new HashMap<ActionToGoalMapping, Boolean>();
        for (ActionToGoalMapping map : mappings.values()) {
            this.modMappings.put(map, Boolean.FALSE);
        }
        this.configurations = configs;
        this.active = active;
        this.auxiliaryProps = auxProps;
    }

    public POMModel getPOMModel() {
        return this.model;
    }

    public ProfilesModel getProfileModel() {
        return this.profiles;
    }

    public Profile getNetbeansPublicProfile() {
        return this.getNetbeansPublicProfile(true);
    }

    public Profile getNetbeansPublicProfile(boolean addIfNotPresent) {
        if (this.publicProfile == null) {
            List lst = this.model.getProject().getProfiles();
            if (lst != null) {
                for (Profile profile : lst) {
                    if (!PROFILE_PUBLIC.equals(profile.getId())) continue;
                    this.publicProfile = profile;
                    break;
                }
            }
            if (this.publicProfile == null && addIfNotPresent) {
                this.publicProfile = this.model.getFactory().createProfile();
                this.publicProfile.setId(PROFILE_PUBLIC);
                Activation act = this.model.getFactory().createActivation();
                ActivationProperty prop = this.model.getFactory().createActivationProperty();
                prop.setName(PROPERTY_PROFILE);
                prop.setValue("true");
                act.setActivationProperty(prop);
                this.publicProfile.setActivation(act);
                this.publicProfile.setBuildBase(this.model.getFactory().createBuildBase());
                this.model.getProject().addProfile(this.publicProfile);
                this.markAsModified(this.model);
            }
        }
        if (this.publicProfile == null && !addIfNotPresent) {
            return this.model.getFactory().createProfile();
        }
        return this.publicProfile;
    }

    public org.netbeans.modules.maven.model.profile.Profile getNetbeansPrivateProfile() {
        return this.getNetbeansPrivateProfile(true);
    }

    public org.netbeans.modules.maven.model.profile.Profile getNetbeansPrivateProfile(boolean addIfNotPresent) {
        if (this.privateProfile == null) {
            List lst = this.profiles.getProfilesRoot().getProfiles();
            if (lst != null) {
                for (org.netbeans.modules.maven.model.profile.Profile profile : lst) {
                    if (!PROFILE_PRIVATE.equals(profile.getId())) continue;
                    this.privateProfile = profile;
                    break;
                }
            }
            if (this.privateProfile == null && addIfNotPresent) {
                this.privateProfile = this.profiles.getFactory().createProfile();
                this.privateProfile.setId(PROFILE_PRIVATE);
                org.netbeans.modules.maven.model.profile.Activation act = this.profiles.getFactory().createActivation();
                org.netbeans.modules.maven.model.profile.ActivationProperty prop = this.profiles.getFactory().createActivationProperty();
                prop.setName(PROPERTY_PROFILE);
                prop.setValue("true");
                act.setActivationProperty(prop);
                this.privateProfile.setActivation(act);
                this.profiles.getProfilesRoot().addProfile(this.privateProfile);
                this.markAsModified(this.profiles);
            }
        }
        if (this.privateProfile == null && !addIfNotPresent) {
            return this.profiles.getFactory().createProfile();
        }
        return this.privateProfile;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getRawAuxiliaryProperty(String propertyName, boolean shared) {
        return this.auxiliaryProps.get(propertyName, shared, false);
    }

    public void setRawAuxiliaryProperty(String propertyName, String value, boolean shared) {
        this.auxiliaryProps.put(propertyName, value, shared);
    }

    public ActionToGoalMapping getActionMappings() {
        return this.mappings.get(M2Configuration.DEFAULT);
    }

    public ActionToGoalMapping getActionMappings(Configuration config) {
        ActionToGoalMapping mapp = this.mappings.get(config.getId());
        if (mapp == null) {
            mapp = new ActionToGoalMapping();
            this.mappings.put(config.getId(), mapp);
            this.modMappings.put(mapp, Boolean.FALSE);
        }
        return mapp;
    }

    public static void setUserActionMapping(NetbeansActionMapping action, ActionToGoalMapping mapp) {
        action.setPackagings(null);
        ArrayList<NetbeansActionMapping> lst = mapp.getActions() != null ? mapp.getActions() : new ArrayList<NetbeansActionMapping>();
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            NetbeansActionMapping act = (NetbeansActionMapping)it.next();
            if (!act.getActionName().equals(action.getActionName())) continue;
            int index = lst.indexOf(act);
            it.remove();
            lst.add(index, action);
            return;
        }
        lst.add(action);
    }

    public static NetbeansActionMapping getActiveMapping(String action, Project project) {
        return ActionToGoalUtils.getActiveMapping(action, project, null);
    }

    public void setConfigurationsEnabled(boolean bool) {
    }

    public boolean isConfigurationsEnabled() {
        return true;
    }

    public List<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void addConfiguration(Configuration config) {
        assert (config != null);
        this.configurations.add(config);
        this.modConfig = true;
    }

    public void removeConfiguration(Configuration config) {
        assert (config != null);
        this.configurations.remove(config);
        if (this.active == config) {
            this.active = this.configurations.size() > 0 ? this.configurations.get(0) : null;
        }
        this.modConfig = true;
    }

    public Configuration getActiveConfiguration() {
        return this.active;
    }

    public void setActiveConfiguration(Configuration conf) {
        assert (conf != null);
        assert (this.configurations.contains(conf));
        this.active = conf;
    }

    public boolean isModified(Object obj) {
        if (this.modMappings.containsKey(obj)) {
            return this.modMappings.get(obj);
        }
        if (obj == this.profiles) {
            return this.modProfiles;
        }
        if (obj == this.model) {
            return this.modModel;
        }
        if (obj == this.configurations || this.configurations.contains(obj)) {
            return this.modConfig;
        }
        return true;
    }

    public void markAsModified(Object obj) {
        if (this.modMappings.containsKey(obj)) {
            this.modMappings.put((ActionToGoalMapping)obj, Boolean.TRUE);
        } else if (obj == this.profiles) {
            this.modProfiles = true;
        } else if (obj == this.model) {
            this.modModel = true;
        } else if (obj == this.configurations || this.configurations.contains(obj)) {
            this.modConfig = true;
        } else assert (false) : "Unexpected parameter type " + obj.getClass().getName();
    }

    public static Configuration createProfileConfiguration(String id) {
        Configuration conf = new Configuration();
        conf.setId(id);
        conf.setDisplayName(id);
        conf.setProfileBased(true);
        return conf;
    }

    public static Configuration createDefaultConfiguration() {
        Configuration conf = new Configuration();
        conf.setId(M2Configuration.DEFAULT);
        conf.setDisplayName(NbBundle.getMessage(ModelHandle.class, (String)"TXT_DefautlConfig"));
        conf.setDefault(true);
        return conf;
    }

    public static Configuration createCustomConfiguration(String id) {
        Configuration conf = new Configuration();
        conf.setId(id);
        conf.setDisplayName(id);
        return conf;
    }

    static {
        AccessorImpl impl = new AccessorImpl();
        impl.assign();
    }

    public static class Configuration {
        private String id;
        private boolean profileBased = false;
        private boolean defaul = false;
        private String displayName;
        private List<String> activatedProfiles;
        private boolean shared = false;

        Configuration() {
        }

        public String getFileNameExt() {
            return M2Configuration.getFileNameExt(this.id);
        }

        public boolean isDefault() {
            return this.defaul;
        }

        public void setDefault(boolean def) {
            this.defaul = def;
        }

        public List<String> getActivatedProfiles() {
            return this.activatedProfiles;
        }

        public void setActivatedProfiles(List<String> activatedProfiles) {
            this.activatedProfiles = activatedProfiles;
        }

        public String getDisplayName() {
            if (this.isDefault()) {
                return NbBundle.getMessage(ModelHandle.class, (String)"DefaultConfig");
            }
            if (this.isProfileBased()) {
                return NbBundle.getMessage(ModelHandle.class, (String)"ProfileConfig", (Object)this.id);
            }
            if (this.getActivatedProfiles() != null && this.getActivatedProfiles().size() > 0) {
                return NbBundle.getMessage(ModelHandle.class, (String)"CustomConfig1", (Object)this.id, (Object)Arrays.toString(this.getActivatedProfiles().toArray()));
            }
            return NbBundle.getMessage(ModelHandle.class, (String)"CustomConfig2", (Object)this.id);
        }

        public void setDisplayName(String displayName) {
            if (this.isProfileBased()) {
                return;
            }
            this.displayName = displayName;
        }

        public String getId() {
            return this.id;
        }

        public void setShared(boolean shared) {
            this.shared = shared;
        }

        public boolean isShared() {
            return this.shared;
        }

        void setId(String id) {
            this.id = id;
        }

        public boolean isProfileBased() {
            return this.profileBased;
        }

        void setProfileBased(boolean profileBased) {
            this.profileBased = profileBased;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    static class AccessorImpl
    extends CustomizerProviderImpl.ModelAccessor {
        AccessorImpl() {
        }

        @Override
        public ModelHandle createHandle(POMModel model, ProfilesModel prof, MavenProject proj, Map<String, ActionToGoalMapping> mapp, List<Configuration> configs, Configuration active, MavenProjectPropsImpl auxProps) {
            return new ModelHandle(model, prof, proj, mapp, configs, active, auxProps);
        }

        public void assign() {
            if (CustomizerProviderImpl.ACCESSOR == null) {
                CustomizerProviderImpl.ACCESSOR = this;
            }
        }
    }
}

