/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.LayerXmlHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaMELibsConfigurationHelper
extends BaseHelper {
    public static final String TEMPLATE_LIB_DESCR = "libdescriptemplate.xml";
    public static final String VOLUME_CLASS = "classpath";
    public static final String VOLUME_SRC = "src";
    public static final String VOLUME_JAVADOC = "javadoc";
    private static final String LIB_EXTRACT_RELEASE = "release/";
    public static final String LIB_EXTRACT_PATH_LIBS = "release/libs/";
    public static final String LIB_EXTRACT_SOURCES = "release/sources/";
    public static final String LIB_EXTRACT_DOCS = "release/docs/";
    public static final String FILE_PROTOCOL = "file";
    private static final String LAYER_RESOURCE = "resource";
    private static final String LAYER_TAG_LIBRARIES_ROOT = "org-netbeans-api-project-libraries";
    private static final String LAYER_TAG_LIBRARIES = "Libraries";
    private static final String LAYER_TAG_RESOURCE_OPEN = "<resource>";
    private static final String LAYER_TAG_RESOURCE_CLOSE = "</resource>";
    private static final String LAYER_XPATH_LIBRARIES_ROOT = "./folder[@name=\"org-netbeans-api-project-libraries\"]";
    private static final String LAYER_XPATH_LIBRARIES = "./folder[@name=\"Libraries\"]";
    private static final String TPL_TOKEN_NAME = "NAME";
    private static final String TPL_TOKEN_BUNDLE = "BUNDLE";
    private static final String TPL_TOKEN_CLASSPATH = "CLASSPATH";
    private static final String TPL_TOKEN_SRC = "SRC";
    private static final String TPL_TOKEN_JAVADOC = "JAVADOC";

    public static void configureJavaMELibs(Project project, WizardDescriptor wizardDescriptor) throws IOException {
        List list;
        List list2;
        List list3 = (List)wizardDescriptor.getProperty("libraries");
        if (!JavaMELibsConfigurationHelper.haveLibsToConfigure(list3, list2 = (List)wizardDescriptor.getProperty("libNames"), list = (List)wizardDescriptor.getProperty("libDisplayNames"))) {
            return;
        }
        assert (wizardDescriptor.getProperty("bundle") != null && wizardDescriptor.getProperty("layer") != null && wizardDescriptor.getProperty("codeBaseName") != null) : "Some properties necessary for lib configuration are absent";
        Iterator iterator = list3.iterator();
        Iterator iterator2 = list2.iterator();
        Iterator iterator3 = list.iterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            String string = (String)iterator2.next();
            String string2 = (String)iterator3.next();
            JavaMELibsConfigurationHelper.configureLibrary(library, string, string2, project, wizardDescriptor);
        }
    }

    private static void configureLibrary(Library library, String string, String string2, Project project, WizardDescriptor wizardDescriptor) throws IOException {
        FileObject fileObject = JavaMELibsConfigurationHelper.getTemplate(TEMPLATE_LIB_DESCR);
        Map<String, String> map = JavaMELibsConfigurationHelper.getTokens(library, string, project, wizardDescriptor);
        JavaMELibsConfigurationHelper.configureLibXml(fileObject, map, string, project, wizardDescriptor);
        JavaMELibsConfigurationHelper.configureLayerXml(string, project, wizardDescriptor);
        JavaMELibsConfigurationHelper.configureBundle(string, string2, project, wizardDescriptor);
    }

    private static void configureLibXml(FileObject fileObject, Map<String, String> map, String string, Project project, WizardDescriptor wizardDescriptor) throws IOException {
        String string2 = ((String)wizardDescriptor.getProperty("codeBaseName")).replace('.', '/');
        String string3 = "src/" + string2 + "/" + string + ".xml";
        JavaMELibsConfigurationHelper.doCopyFile(project.getProjectDirectory(), string3, fileObject, map);
    }

    private static void configureBundle(String string, String string2, Project project, WizardDescriptor wizardDescriptor) throws IOException {
        String string3 = "src/" + (String)wizardDescriptor.getProperty("bundle");
        FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string3);
        EditableProperties editableProperties = JavaMELibsConfigurationHelper.loadProperties(fileObject2);
        editableProperties.setProperty(string, string2);
        JavaMELibsConfigurationHelper.storeProperties(fileObject2, editableProperties);
    }

    private static void configureLayerXml(String string, Project project, WizardDescriptor wizardDescriptor) throws IOException {
        String string2 = ((String)wizardDescriptor.getProperty("codeBaseName")).replace('.', '/');
        String string3 = "src/" + string2 + "/" + "layer.xml";
        FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string3);
        try {
            Document document = LayerXmlHelper.parseXmlDocument(fileObject2);
            Element element = document.getDocumentElement();
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node node = LayerXmlHelper.goToFilesystemNode(document, xPath, element);
            Node node2 = JavaMELibsConfigurationHelper.goToLibsRootNode(document, xPath, node);
            Node node3 = JavaMELibsConfigurationHelper.goToLibsNode(document, xPath, node2);
            Element element2 = document.createElement("folder");
            element2.setAttribute("name", string + ".xml");
            element2.setAttribute("url", string + ".xml");
            node3.appendChild(element2);
            LayerXmlHelper.saveXmlDocument(document, fileObject2);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private static Node goToLibsRootNode(Document document, XPath xPath, Node node) throws XPathExpressionException {
        String string = LAYER_XPATH_LIBRARIES_ROOT;
        Node node2 = (Node)xPath.evaluate(string, node, XPathConstants.NODE);
        if (node2 == null) {
            Element element = document.createElement("folder");
            element.setAttribute("name", LAYER_TAG_LIBRARIES_ROOT);
            node.appendChild(element);
            node2 = element;
        }
        return node2;
    }

    private static Node goToLibsNode(Document document, XPath xPath, Node node) throws XPathExpressionException {
        String string = LAYER_XPATH_LIBRARIES;
        Node node2 = (Node)xPath.evaluate(string, node, XPathConstants.NODE);
        if (node2 == null) {
            Element element = document.createElement("folder");
            element.setAttribute("name", LAYER_TAG_LIBRARIES);
            node.appendChild(element);
            node2 = element;
        }
        return node2;
    }

    private static Map<String, String> getTokens(Library library, String string, Project project, WizardDescriptor wizardDescriptor) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(TPL_TOKEN_NAME, string);
        String string2 = ((String)wizardDescriptor.getProperty("bundle")).replace('/', '.');
        hashMap.put(TPL_TOKEN_BUNDLE, string2);
        Iterator<URL> iterator = library.getContent(VOLUME_CLASS).iterator();
        hashMap.put(TPL_TOKEN_CLASSPATH, JavaMELibsConfigurationHelper.getTokenSubstitution(iterator, LIB_EXTRACT_PATH_LIBS, string, project, wizardDescriptor));
        iterator = library.getContent(VOLUME_SRC).iterator();
        hashMap.put(TPL_TOKEN_SRC, JavaMELibsConfigurationHelper.getTokenSubstitution(iterator, LIB_EXTRACT_SOURCES, string, project, wizardDescriptor));
        iterator = library.getContent(VOLUME_JAVADOC).iterator();
        hashMap.put(TPL_TOKEN_JAVADOC, JavaMELibsConfigurationHelper.getTokenSubstitution(iterator, LIB_EXTRACT_DOCS, string, project, wizardDescriptor));
        return hashMap;
    }

    private static String getTokenSubstitution(Iterator<URL> iterator, String string, String string2, Project project, WizardDescriptor wizardDescriptor) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            URL uRL = iterator.next();
            String string3 = JavaMELibsConfigurationHelper.addArchiveToCopy(uRL, string, project, string2);
            if (string3 == null) continue;
            String string4 = (String)wizardDescriptor.getProperty("codeBaseName");
            String string5 = JavaMELibsConfigurationHelper.transformURL(string4, string, string3);
            stringBuffer.append(LAYER_TAG_RESOURCE_OPEN);
            stringBuffer.append(string5);
            stringBuffer.append(LAYER_TAG_RESOURCE_CLOSE);
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static String addArchiveToCopy(URL uRL, String string, Project project, String string2) throws IOException {
        FileObject fileObject;
        String string3 = null;
        URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
        if (uRL2 != null && FileUtil.isArchiveFile((URL)uRL2)) {
            FileObject fileObject2 = URLMapper.findFileObject((URL)uRL2);
            if (fileObject2 != null) {
                string3 = fileObject2.getNameExt();
                JavaMELibsConfigurationHelper.doCopyFile(project.getProjectDirectory(), string + string3, fileObject2, null);
            }
        } else if (FILE_PROTOCOL.equals(uRL.getProtocol()) && (fileObject = URLMapper.findFileObject((URL)uRL)) != null) {
            string3 = string2 + ".zip";
            string = string + string3;
            JavaMELibsConfigurationHelper.doZipAndCopyFolder(project, string + string3, fileObject);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doZipAndCopyFolder(Project project, String string, FileObject fileObject) throws IOException {
        ArrayList arrayList = Collections.list(fileObject.getChildren(true));
        if (arrayList.isEmpty()) {
            return;
        }
        FileObject fileObject2 = project.getProjectDirectory();
        assert (fileObject2 != null);
        FileObject fileObject3 = fileObject2.getFileObject(string);
        if (fileObject3 == null) {
            fileObject3 = FileUtil.createData((FileObject)fileObject2, (String)string);
        }
        assert (fileObject3 != null);
        FileLock fileLock = null;
        OutputStream outputStream = null;
        try {
            fileLock = fileObject3.lock();
            outputStream = fileObject3.getOutputStream(fileLock);
            JavaMELibsConfigurationHelper.createZipFile(outputStream, fileObject, arrayList);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createZipFile(OutputStream outputStream, FileObject fileObject, Collection<? extends FileObject> collection) throws IOException {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(outputStream);
            for (FileObject fileObject2 : collection) {
                String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
                if (fileObject2.isFolder()) {
                    if (fileObject2.getChildren().length > 0) continue;
                    if (!string.endsWith("/")) {
                        string = string + "/";
                    }
                }
                ZipEntry zipEntry = new ZipEntry(string);
                zipOutputStream.putNextEntry(zipEntry);
                if (fileObject2.isData()) {
                    InputStream inputStream = null;
                    try {
                        inputStream = fileObject2.getInputStream();
                        FileUtil.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                zipOutputStream.closeEntry();
            }
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }

    private static String transformURL(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jar:nbinst://").append(string).append("/");
        stringBuffer.append(string2).append(string3).append("!/");
        return stringBuffer.toString();
    }

    private static boolean haveLibsToConfigure(List<Library> list, List<String> list2, List<String> list3) {
        if (list == null || list2 == null || list3 == null) {
            return false;
        }
        assert (list.size() == list2.size() && list.size() == list3.size() && list3.size() == list2.size()) : "libraries data is not consistent";
        return list.size() != 0;
    }
}

