/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.helpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.LayerXmlHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.ProjectXmlHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.PaletteCategory;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.Version;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class CustomComponentHelper
extends BaseHelper {
    public static final String OPENIDE_MODULE = "OpenIDE-Module";
    public static final String OPENIDE_MODULE_LAYER = "OpenIDE-Module-Layer";
    public static final String OPENIDE_MODULE_LOCALIZING_BUNDLE = "OpenIDE-Module-Localizing-Bundle";
    public static final String TEMPLATE_COMP_DESCR = "CustomComponentCD.java";
    public static final String TEMPLATE_PRODUCER = "CustomComponentProducer.java";
    private static final String MANIFEST = "manifest.mf";

    public abstract Set<FileObject> instantiate() throws IOException;

    public abstract String getCodeNameBase();

    public abstract String getProjectName();

    public abstract String getCDPath();

    public abstract String getProducerPath();

    public abstract boolean isCDClassNameExist(String var1);

    public abstract boolean isProducerClassNameExist(String var1);

    protected String createCDPath(String string) {
        String string2 = this.getCodeNameBase().replace('.', '/');
        return "src/" + string2 + "/" + "descriptors" + "/" + string + ".java";
    }

    protected String createProducerPath(String string) {
        String string2 = this.getCodeNameBase().replace('.', '/');
        return "src/" + string2 + "/" + "producers" + "/" + string + ".java";
    }

    public static class RealInstantiationHelper
    extends CustomComponentHelper {
        private static final String INSTANCE_NAME_EXTENSION = ".instance";
        private static final String LAYER_TAG_VMD_MIDP = "vmd-midp";
        private static final String LAYER_TAG_COMPONENTS = "components";
        private static final String LAYER_TAG_PRODUCERS = "producers";
        private static final String LAYER_XPATH_VMD_MIDP = "./folder[@name=\"vmd-midp\"]";
        private static final String LAYER_XPATH_COMPONENTS = "./folder[@name=\"components\"]";
        private static final String LAYER_XPATH_PRODUCERS = "./folder[@name=\"producers\"]";
        private static final String VALIDITY_TOKEN_VALUE_ALWAYS = "always";
        private static final String VALIDITY_TOKEN_VALUE_PLATFORM = "platform";
        private static final String VALIDITY_TOKEN_VALUE_CUSTOM = "custom";
        private static final String VMD_MIDP_NAME = "org.netbeans.modules.vmd.midp";
        private static final String VMD_MIDP_VERSION = "1.1";
        private static final String VMD_MODEL_NAME = "org.netbeans.modules.vmd.model";
        private static final String VMD_MODEL_VERSION = "1.1";
        private static final String VMD_PROPERTIES_NAME = "org.netbeans.modules.vmd.properties";
        private static final String VMD_PROPERTIES_VERSION = "1.1";
        private static final String OPENIDE_UTIL_NAME = "org.openide.util";
        private static final String OPENIDE_UTIL_VERSION = "7.12";
        private Project myProject;
        private Map<String, Object> myComponent;
        private WizardDescriptor myComponentWizard;
        private String myBundlePath;
        private String myLayerPath;
        private String myCodeNameBase;
        private Manifest myManifest;

        public RealInstantiationHelper(Project project, Map<String, Object> map) {
            this.myProject = project;
            this.myComponent = map;
            this.myComponentWizard = null;
            assert (this.myComponent != null);
        }

        public RealInstantiationHelper(Project project, WizardDescriptor wizardDescriptor) {
            this.myProject = project;
            this.myComponent = null;
            this.myComponentWizard = wizardDescriptor;
            assert (this.myComponentWizard != null);
        }

        @Override
        public boolean isCDClassNameExist(String string) {
            FileObject fileObject = this.getProject().getProjectDirectory();
            String string2 = this.createCDPath(string);
            return this.isFileExist(fileObject, string2);
        }

        @Override
        public boolean isProducerClassNameExist(String string) {
            FileObject fileObject = this.getProject().getProjectDirectory();
            String string2 = this.createProducerPath(string);
            return this.isFileExist(fileObject, string2);
        }

        @Override
        public String getProjectName() {
            return ProjectUtils.getInformation((Project)this.myProject).getDisplayName();
        }

        @Override
        public Set<FileObject> instantiate() throws IOException {
            LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
            assert (this.myComponent != null || this.myComponentWizard != null);
            this.configureDependencies();
            FileObject fileObject = this.configureComponentDescriptor();
            linkedHashSet.add(fileObject);
            FileObject fileObject2 = this.configureProducer();
            linkedHashSet.add(fileObject2);
            linkedHashSet.addAll(this.configureLayerXml());
            linkedHashSet.addAll(this.configureProducerBundle());
            linkedHashSet.addAll(this.configureIcons());
            return linkedHashSet;
        }

        @Override
        public String getCDPath() {
            String string = this.getCDClassName();
            return this.createCDPath(string);
        }

        @Override
        public String getProducerPath() {
            String string = this.getProducerClassName();
            return this.createProducerPath(string);
        }

        @Override
        public String getCodeNameBase() {
            if (this.myCodeNameBase != null) {
                return this.myCodeNameBase;
            }
            Manifest manifest = this.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue(CustomComponentHelper.OPENIDE_MODULE);
            if (string != null) {
                int n = string.lastIndexOf(47);
                this.myCodeNameBase = n == -1 ? string : string.substring(0, n);
            }
            return this.myCodeNameBase;
        }

        public String getCDPkg() {
            return this.getCodeNameBase() + "." + "descriptors";
        }

        public String getProducerPkg() {
            return this.getCodeNameBase() + "." + LAYER_TAG_PRODUCERS;
        }

        public String getCDLayerInstanceName() {
            String string = this.getCodeNameBase();
            String string2 = this.getCDClassName();
            String string3 = string.replace('.', '-');
            return string3 + "-" + "descriptors" + "-" + string2 + INSTANCE_NAME_EXTENSION;
        }

        public String getProducerLayerInstanceName() {
            String string = this.getCodeNameBase();
            String string2 = this.getProducerClassName();
            String string3 = string.replace('.', '-');
            return string3 + "-" + LAYER_TAG_PRODUCERS + "-" + string2 + INSTANCE_NAME_EXTENSION;
        }

        protected String getLocalizingBundle() {
            if (this.myBundlePath == null) {
                Manifest manifest = this.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                this.myBundlePath = attributes.getValue(CustomComponentHelper.OPENIDE_MODULE_LOCALIZING_BUNDLE);
            }
            return this.myBundlePath;
        }

        protected String getLayer() {
            Manifest manifest;
            Attributes attributes;
            if (this.myLayerPath == null && (attributes = (manifest = this.getManifest()).getMainAttributes()).containsKey(CustomComponentHelper.OPENIDE_MODULE_LAYER)) {
                this.myLayerPath = "src/" + attributes.getValue(CustomComponentHelper.OPENIDE_MODULE_LAYER);
            }
            return this.myLayerPath;
        }

        protected Project getProject() {
            return this.myProject;
        }

        private FileObject configureComponentDescriptor() throws IOException {
            FileObject fileObject = RealInstantiationHelper.getTemplate(CustomComponentHelper.TEMPLATE_COMP_DESCR);
            Map<String, String> map = this.getCDTokens();
            return RealInstantiationHelper.doCopyFile(this.getProject().getProjectDirectory(), this.getCDPath(), fileObject, map);
        }

        private FileObject configureProducer() throws IOException {
            FileObject fileObject = RealInstantiationHelper.getTemplate(CustomComponentHelper.TEMPLATE_PRODUCER);
            Map<String, String> map = this.getProducerTokens();
            return RealInstantiationHelper.doCopyFile(this.getProject().getProjectDirectory(), this.getProducerPath(), fileObject, map);
        }

        private Map<String, String> getCDTokens() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("package", this.getCDPkg());
            hashMap.put("cdName", this.getCDClassName());
            hashMap.put("typeId", (String)this.getProperty("compDescrTypeId"));
            hashMap.put("superDescriptorClass", this.getSuperDescrClassNameToken());
            hashMap.put("superDescriptorClassFQN", this.getSuperDescrClassFQNToken());
            hashMap.put("prefix", (String)this.getProperty("prefix"));
            hashMap.put("canInstantiate", this.getProperty("compDescrCanInstantiate").toString());
            hashMap.put("canBeSuper", this.getProperty("compDescrCanBeSuper").toString());
            hashMap.put("midpVersion", this.getMidpVersionToken());
            return hashMap;
        }

        private String getMidpVersionToken() {
            Version version = (Version)((Object)this.getProperty("compDescrVersion"));
            assert (version != null);
            return version.javaCodeValue();
        }

        private String getSuperDescrClassFQNToken() {
            String string = (String)this.getProperty("compDescrSuperClass");
            assert (string != null);
            if (string.indexOf(".") == -1) {
                return "";
            }
            return string;
        }

        private String getSuperDescrClassNameToken() {
            String string = (String)this.getProperty("compDescrSuperClass");
            assert (string != null);
            if (string.indexOf(".") == -1) {
                return string;
            }
            return string.substring(string.lastIndexOf(".") + 1, string.length());
        }

        private Map<String, String> getProducerTokens() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("package", this.getProducerPkg());
            hashMap.put("producerName", this.getProducerClassName());
            hashMap.put("iconPathSmall", this.getSmallIconToken());
            hashMap.put("iconPathLarge", this.getLargeIconToken());
            hashMap.put("cdName", this.getCDClassName());
            hashMap.put("cdPackage", this.getCDPkg());
            hashMap.put("paletteCategory", this.getPaletteCategoryToken());
            hashMap.put("prefix", (String)this.getProperty("prefix"));
            if (((Boolean)this.getProperty("compProdAddLib")).booleanValue()) {
                hashMap.put("libraryName", (String)this.getProperty("compProdLibName"));
            }
            hashMap.put("validity", this.getProducerValidityToken());
            return hashMap;
        }

        private String getPaletteCategoryToken() {
            PaletteCategory paletteCategory = (PaletteCategory)((Object)this.getProperty("compProdPaletteCategory"));
            assert (paletteCategory != null);
            return paletteCategory.javaCodeValue();
        }

        private String getProducerValidityToken() {
            Boolean bl = (Boolean)this.getProperty("compProdValidAlways");
            Boolean bl2 = (Boolean)this.getProperty("compProdValidPlatform");
            Boolean bl3 = (Boolean)this.getProperty("compProdValidCustom");
            assert (bl != null || bl2 != null || bl3 != null);
            if (bl != null) {
                return VALIDITY_TOKEN_VALUE_ALWAYS;
            }
            if (bl2 != null) {
                return VALIDITY_TOKEN_VALUE_PLATFORM;
            }
            if (bl3 != null) {
                return VALIDITY_TOKEN_VALUE_CUSTOM;
            }
            return VALIDITY_TOKEN_VALUE_ALWAYS;
        }

        private String getSmallIconToken() {
            return this.getIconToken(this.getSmallIconPath());
        }

        private String getLargeIconToken() {
            return this.getIconToken(this.getLargeIconPath());
        }

        private String getIconToken(String string) {
            if (string == null) {
                return "null";
            }
            String string2 = this.getCodeNameBase().replace('.', '/');
            File file = new File(string);
            String string3 = file.getName();
            return string2 + "/" + "resources" + "/" + string3;
        }

        private Set<FileObject> configureProducerBundle() throws IOException {
            FileObject fileObject = this.getProject().getProjectDirectory();
            String string = this.getProducerPkg().replace('.', '/');
            String string2 = "src/" + string + "/" + "Bundle.properties";
            boolean bl = this.isFileExist(fileObject, string2);
            FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string2);
            this.doUpdateProducerBundle(fileObject2);
            if (bl) {
                return Collections.EMPTY_SET;
            }
            LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
            linkedHashSet.add(fileObject2);
            return linkedHashSet;
        }

        private void doUpdateProducerBundle(FileObject fileObject) throws IOException {
            String string = (String)this.getProperty("prefix") + "_";
            EditableProperties editableProperties = RealInstantiationHelper.loadProperties(fileObject);
            String string2 = string + "paletteName";
            String string3 = (String)this.getProperty("compProdPaletteDispName");
            String string4 = string + "paletteTooltip";
            String string5 = (String)this.getProperty("compProdPaletteTip");
            editableProperties.setProperty(string2, string3);
            editableProperties.setProperty(string4, string5);
            RealInstantiationHelper.storeProperties(fileObject, editableProperties);
        }

        private boolean isFileExist(FileObject fileObject, String string) {
            File file = new File(FileUtil.toFile((FileObject)fileObject), string);
            return file.exists();
        }

        private FileObject createAndRegisterLayerXml() throws IOException {
            FileObject fileObject = this.getProject().getProjectDirectory();
            String string = this.getCodeNameBase().replace(".", "/");
            String string2 = string + "/" + "layer.xml";
            FileObject fileObject2 = LayerXmlHelper.createLayerXml(fileObject, "src/" + string2);
            Manifest manifest = this.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.putValue(CustomComponentHelper.OPENIDE_MODULE_LAYER, string2);
            this.saveManifest(manifest);
            return fileObject2;
        }

        private Set<FileObject> configureLayerXml() throws IOException {
            String string = this.getLayer();
            FileObject fileObject = this.getProject().getProjectDirectory();
            FileObject fileObject2 = null;
            fileObject2 = string == null || !this.isFileExist(fileObject, string) ? this.createAndRegisterLayerXml() : FileUtil.createData((FileObject)fileObject, (String)string);
            try {
                Document document = LayerXmlHelper.parseXmlDocument(fileObject2);
                assert (document != null);
                Element element = document.getDocumentElement();
                XPath xPath = XPathFactory.newInstance().newXPath();
                Node node = LayerXmlHelper.goToFilesystemNode(document, xPath, element);
                Node node2 = RealInstantiationHelper.goToVmdMidpNode(document, xPath, node);
                Node node3 = RealInstantiationHelper.goToComponentsNode(document, xPath, node2);
                Element element2 = document.createElement("file");
                element2.setAttribute("name", this.getCDLayerInstanceName());
                node3.appendChild(element2);
                Node node4 = RealInstantiationHelper.goToProducersNode(document, xPath, node2);
                Element element3 = document.createElement("file");
                element3.setAttribute("name", this.getProducerLayerInstanceName());
                node4.appendChild(element3);
                LayerXmlHelper.saveXmlDocument(document, fileObject2);
            }
            catch (XPathExpressionException xPathExpressionException) {
                ErrorManager.getDefault().notify((Throwable)xPathExpressionException);
            }
            return Collections.EMPTY_SET;
        }

        private static Node goToProducersNode(Document document, XPath xPath, Node node) throws XPathExpressionException {
            String string = LAYER_XPATH_PRODUCERS;
            Node node2 = (Node)xPath.evaluate(string, node, XPathConstants.NODE);
            if (node2 == null) {
                Element element = document.createElement("folder");
                element.setAttribute("name", LAYER_TAG_PRODUCERS);
                node.appendChild(element);
                node2 = element;
            }
            return node2;
        }

        private static Node goToComponentsNode(Document document, XPath xPath, Node node) throws XPathExpressionException {
            String string = LAYER_XPATH_COMPONENTS;
            Node node2 = (Node)xPath.evaluate(string, node, XPathConstants.NODE);
            if (node2 == null) {
                Element element = document.createElement("folder");
                element.setAttribute("name", LAYER_TAG_COMPONENTS);
                node.appendChild(element);
                node2 = element;
            }
            return node2;
        }

        private static Node goToVmdMidpNode(Document document, XPath xPath, Node node) throws XPathExpressionException {
            String string = LAYER_XPATH_VMD_MIDP;
            Node node2 = (Node)xPath.evaluate(string, node, XPathConstants.NODE);
            if (node2 == null) {
                Element element = document.createElement("folder");
                element.setAttribute("name", LAYER_TAG_VMD_MIDP);
                node.appendChild(element);
                node2 = element;
            }
            return node2;
        }

        private Set<FileObject> configureIcons() throws IOException {
            String string;
            LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
            String string2 = this.getSmallIconPath();
            if (string2 != null) {
                linkedHashSet.add(this.copyIcon(string2));
            }
            if ((string = this.getLargeIconPath()) != null) {
                linkedHashSet.add(this.copyIcon(string));
            }
            return linkedHashSet;
        }

        private FileObject copyIcon(String string) throws IOException {
            String string2 = this.getCodeNameBase();
            String string3 = string2.replace('.', '/');
            File file = new File(string);
            String string4 = file.getName();
            String string5 = "src/" + string3 + "/" + "resources" + "/" + string4;
            FileObject fileObject = FileUtil.createData((FileObject)this.getProject().getProjectDirectory(), (String)string5);
            RealInstantiationHelper.copyByteAfterByte(file, fileObject);
            return fileObject;
        }

        private String getSmallIconPath() {
            String string = (String)this.getProperty("compProdSmallIcon");
            if (string == null || string.length() == 0) {
                return null;
            }
            return string;
        }

        private String getLargeIconPath() {
            String string = (String)this.getProperty("compProdLargeIcon");
            if (string == null || string.length() == 0) {
                return null;
            }
            return string;
        }

        private void configureDependencies() {
            try {
                FileObject fileObject = this.getProject().getProjectDirectory();
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)"nbproject/project.xml");
                Document document = LayerXmlHelper.parseXmlDocument(fileObject2);
                XPath xPath = XPathFactory.newInstance().newXPath();
                Node node = ProjectXmlHelper.getPrimaryConfigurationData(xPath, document.getDocumentElement());
                Node node2 = ProjectXmlHelper.goToModuleDependencies(document, xPath, node);
                ProjectXmlHelper.testAndAddDependency(document, xPath, node2, VMD_MIDP_NAME, "1.1");
                ProjectXmlHelper.testAndAddDependency(document, xPath, node2, VMD_MODEL_NAME, "1.1");
                ProjectXmlHelper.testAndAddDependency(document, xPath, node2, VMD_PROPERTIES_NAME, "1.1");
                ProjectXmlHelper.testAndAddDependency(document, xPath, node2, OPENIDE_UTIL_NAME, OPENIDE_UTIL_VERSION);
                ProjectXmlHelper.saveXmlDocument(document, fileObject2);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            catch (XPathExpressionException xPathExpressionException) {
                ErrorManager.getDefault().notify((Throwable)xPathExpressionException);
            }
        }

        private Object getProperty(String string) {
            if (this.myComponent == null) {
                return this.myComponentWizard.getProperty(string);
            }
            return this.myComponent.get(string);
        }

        private String getCDClassName() {
            return (String)this.getProperty("compDescrClassName");
        }

        private String getProducerClassName() {
            return (String)this.getProperty("compProdClassName");
        }

        private Manifest getManifest() {
            if (this.myManifest == null) {
                this.myManifest = this.readManifest();
            }
            return this.myManifest;
        }

        private Manifest readManifest() {
            return (Manifest)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Manifest>(){

                public Manifest run() {
                    try {
                        return RealInstantiationHelper.this.doReadManifest();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                        return null;
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Manifest doReadManifest() throws IOException {
            Manifest manifest = null;
            FileObject fileObject = this.getProject().getProjectDirectory().getFileObject(CustomComponentHelper.MANIFEST);
            if (fileObject != null) {
                InputStream inputStream = fileObject.getInputStream();
                try {
                    manifest = new Manifest(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            return manifest;
        }

        private void saveManifest(final Manifest manifest) {
            if (manifest == null) {
                return;
            }
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    try {
                        RealInstantiationHelper.this.doSaveManifest(manifest);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doSaveManifest(Manifest manifest) throws IOException {
            FileObject fileObject = this.getProject().getProjectDirectory().getFileObject(CustomComponentHelper.MANIFEST);
            if (fileObject != null) {
                FileLock fileLock = fileObject.lock();
                try {
                    OutputStream outputStream = fileObject.getOutputStream(fileLock);
                    try {
                        manifest.write(outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
    }

    public static class InstantiationToWizardHelper
    extends CustomComponentHelper {
        private WizardDescriptor myComponentWizard;
        private WizardDescriptor myMainWizard;

        public InstantiationToWizardHelper(WizardDescriptor wizardDescriptor, WizardDescriptor wizardDescriptor2) {
            this.myMainWizard = wizardDescriptor;
            this.myComponentWizard = wizardDescriptor2;
        }

        @Override
        public boolean isCDClassNameExist(String string) {
            return this.checkIfComponentValueExists("compDescrClassName", string);
        }

        @Override
        public boolean isProducerClassNameExist(String string) {
            return this.checkIfComponentValueExists("compProdClassName", string);
        }

        @Override
        public String getProjectName() {
            return (String)this.myMainWizard.getProperty("projName");
        }

        @Override
        public String getCDPath() {
            String string = this.getCDClassName();
            return this.createCDPath(string);
        }

        @Override
        public String getProducerPath() {
            String string = this.getProducerClassName();
            return this.createProducerPath(string);
        }

        @Override
        public Set<FileObject> instantiate() throws IOException {
            assert (this.myComponentWizard != null && this.myMainWizard != null);
            LinkedList<Map> linkedList = (LinkedList<Map>)this.myMainWizard.getProperty("customComponents");
            if (linkedList == null) {
                linkedList = new LinkedList<Map>();
                this.myMainWizard.putProperty("customComponents", linkedList);
            }
            linkedList.add(this.myComponentWizard.getProperties());
            return Collections.EMPTY_SET;
        }

        @Override
        public String getCodeNameBase() {
            String string = (String)this.myMainWizard.getProperty("codeBaseName");
            String string2 = (String)this.myMainWizard.getProperty("projName");
            if (string == null) {
                string = InstantiationToWizardHelper.getDefaultCodeNameBase(string2);
            }
            return string;
        }

        private boolean checkIfComponentValueExists(String string, Object object) {
            List<Map<String, Object>> list = this.getExistingComponents();
            if (list == null) {
                return false;
            }
            for (Map<String, Object> map : list) {
                Object object2 = map.get(string);
                if (!object2.equals(object)) continue;
                return true;
            }
            return false;
        }

        private List<Map<String, Object>> getExistingComponents() {
            Object object = this.myMainWizard.getProperty("customComponents");
            if (object == null || !(object instanceof List)) {
                return null;
            }
            return (List)object;
        }

        private String getCDClassName() {
            return (String)this.myComponentWizard.getProperty("compDescrClassName");
        }

        private String getProducerClassName() {
            return (String)this.myComponentWizard.getProperty("compProdClassName");
        }
    }
}

