/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.elements;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.RubyElement;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public abstract class IndexedElement
extends RubyElement {
    public static final int DOCUMENTED = 1;
    public static final int PROTECTED = 2;
    public static final int PRIVATE = 4;
    public static final int TOPLEVEL = 8;
    public static final int STATIC = 16;
    public static final int NODOC = 32;
    public static final int VIRTUAL = 512;
    protected final FileObject file;
    protected final String clz;
    protected final String fqn;
    protected final String require;
    protected final String attributes;
    protected final int flags;
    protected int docLength = -1;
    private Set<Modifier> modifiers;
    private final RubyIndex index;
    private Document document;
    private final FileObject context;
    protected RubyType type;

    protected IndexedElement(RubyIndex index, FileObject file, String fqn, String clz, String require, String attributes, int flags, FileObject context, RubyType type) {
        this.index = index;
        this.file = file;
        this.fqn = fqn;
        this.require = require;
        this.attributes = attributes;
        this.clz = clz;
        this.flags = flags;
        this.context = context;
        this.type = type;
    }

    protected IndexedElement(RubyIndex index, IndexResult result, String fqn, String clz, String require, String attributes, int flags, FileObject context, RubyType type) {
        this(index, result.getFile(), fqn, clz, require, attributes, flags, context, type);
    }

    protected IndexedElement(RubyIndex index, IndexResult result, String fqn, String clz, String require, String attributes, int flags, FileObject context) {
        this(index, result, fqn, clz, require, attributes, flags, context, null);
    }

    public abstract String getSignature();

    public final String getRequire() {
        return this.require;
    }

    public final String getFqn() {
        return this.fqn;
    }

    @Override
    public RubyType getType() {
        int lastSemiColon;
        if (this.type == null && this.attributes != null && (lastSemiColon = this.attributes.lastIndexOf(59)) != -1) {
            int last2SemiColon = this.attributes.lastIndexOf(59, lastSemiColon - 1);
            if (lastSemiColon != -1) {
                String typesS = this.attributes.substring(last2SemiColon + 1, lastSemiColon);
                this.type = this.parseTypes(typesS);
            }
        }
        if (this.type == null) {
            this.type = RubyType.unknown();
        }
        return this.type;
    }

    private RubyType parseTypes(String types) {
        if (types.length() == 0) {
            return RubyType.unknown();
        }
        if (!types.contains("|")) {
            return RubyType.create(types);
        }
        return new RubyType(types.split("\\|"));
    }

    public String toString() {
        return this.getSignature();
    }

    public final String getClz() {
        return this.clz;
    }

    public RubyIndex getIndex() {
        return this.index;
    }

    @Override
    public String getIn() {
        return this.getClz();
    }

    public Document getDocument() {
        if (this.document == null) {
            FileObject fo = this.getFileObject();
            if (fo == null) {
                return null;
            }
            this.document = GsfUtilities.getDocument((FileObject)fo, (boolean)true);
        }
        return this.document;
    }

    @Override
    public FileObject getFileObject() {
        return this.file;
    }

    public String getFileUrl() {
        if (this.file == null) {
            return null;
        }
        File f = FileUtil.toFile((FileObject)this.file);
        try {
            return f == null ? null : f.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    @Override
    public final Set<Modifier> getModifiers() {
        if (this.modifiers == null) {
            Modifier access = Modifier.PUBLIC;
            if (this.isPrivate()) {
                access = Modifier.PRIVATE;
            } else if (this.isProtected()) {
                access = Modifier.PROTECTED;
            }
            boolean isStatic = this.isStatic();
            this.modifiers = access != Modifier.PUBLIC ? (isStatic ? EnumSet.of(access, Modifier.STATIC) : EnumSet.of(access)) : (isStatic ? EnumSet.of(Modifier.STATIC) : Collections.emptySet());
        }
        return this.modifiers;
    }

    public int getDocumentationLength() {
        return this.isDocumented() ? 1 : 0;
    }

    public static char flagToFirstChar(int flags) {
        char first = (char)(flags >>= 4);
        if (first >= '\n') {
            return (char)(first - 10 + 97);
        }
        return (char)(first + 48);
    }

    public static char flagToSecondChar(int flags) {
        char second = (char)(flags & 0xF);
        if (second >= '\n') {
            return (char)(second - 10 + 97);
        }
        return (char)(second + 48);
    }

    public static String flagToString(int flags) {
        return "" + IndexedElement.flagToFirstChar(flags) + IndexedElement.flagToSecondChar(flags);
    }

    public static int stringToFlag(String s, int startIndex) {
        return IndexedElement.stringToFlag(s.charAt(startIndex), s.charAt(startIndex + 1));
    }

    public static int stringToFlag(char first, char second) {
        if (first == ';') {
            return 0;
        }
        int high = 0;
        int low = 0;
        high = first > '9' ? first - 97 + 10 : first - 48;
        low = second > '9' ? second - 97 + 10 : second - 48;
        return (high << 4) + low;
    }

    public boolean isDocumented() {
        return (this.flags & 1) != 0;
    }

    public boolean isPublic() {
        return (this.flags & 4 & 2) == 0;
    }

    public boolean isPrivate() {
        return (this.flags & 4) != 0 || (this.flags & 2) != 0;
    }

    public boolean isProtected() {
        return (this.flags & 2) != 0;
    }

    public boolean isTopLevel() {
        return (this.flags & 8) != 0;
    }

    public boolean isStatic() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isNoDoc() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isVirtual() {
        return (this.flags & 0x200) != 0;
    }

    public static String decodeFlags(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 1) != 0) {
            sb.append("|DOCUMENTED");
        }
        if ((flags & 4) != 0) {
            sb.append("|PRIVATE");
        }
        if ((flags & 2) != 0) {
            sb.append("|PROTECTED");
        }
        if ((flags & 8) != 0) {
            sb.append("|TOPLEVEL");
        }
        if ((flags & 0x10) != 0) {
            sb.append("|STATIC");
        }
        if ((flags & 0x20) != 0) {
            sb.append("|NODOC");
        }
        if ((flags & 0x200) != 0) {
            sb.append("|VIRTUAL");
        }
        return sb.toString();
    }

    public static int stringToFlags(String string) {
        int flags = 0;
        if (string.indexOf("|DOCUMENTED") != -1) {
            ++flags;
        }
        if (string.indexOf("|PRIVATE") != -1) {
            flags += 4;
        }
        if (string.indexOf("|PROTECTED") != -1) {
            flags += 2;
        }
        if (string.indexOf("|TOPLEVEL") != -1) {
            flags += 8;
        }
        if (string.indexOf("|STATIC") != -1) {
            flags += 16;
        }
        if (string.indexOf("|NODOC") != -1) {
            flags += 32;
        }
        if (string.indexOf("|VIRTUAL") != -1) {
            flags += 512;
        }
        return flags;
    }

    public boolean doesBelongToModule() {
        return "Module".equals(this.getFqn());
    }
}

