/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.ActiveRecordQueryIndexer;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.FindersHelper;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeInferencer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.options.TypeInferenceSettings;

final class RubyMethodTypeInferencer {
    private static final String[] COMPARISON_OPERATORS = new String[]{"==", "===", "!="};
    private static final String[] RECEIVER_METHODS = new String[]{"new", "clone", "dup", "freeze", "+", "-"};
    private static final Map<String, RubyType> METHOD_TYPES = new HashMap<String, RubyType>(16);
    private final Node callNodeToInfer;
    private final ContextKnowledge knowledge;
    private final boolean fast;

    private RubyMethodTypeInferencer(Node nodeToInfer, ContextKnowledge knowledge, boolean fast) {
        assert (AstUtilities.isCall(nodeToInfer)) : "Must be a call node";
        this.callNodeToInfer = nodeToInfer;
        this.knowledge = knowledge;
        this.fast = fast;
    }

    static RubyType inferTypeFor(Node nodeToInfer, ContextKnowledge knowledge, boolean fast) {
        return new RubyMethodTypeInferencer(nodeToInfer, knowledge, fast).inferType();
    }

    static RubyType fastCheckType(String methodName) {
        if (methodName.endsWith("?") || RubyMethodTypeInferencer.isTrueFalseCall(methodName)) {
            return RubyType.BOOLEAN;
        }
        return METHOD_TYPES.get(methodName);
    }

    private static boolean isTrueFalseCall(String methodName) {
        for (String each : COMPARISON_OPERATORS) {
            if (!each.equals(methodName)) continue;
            return true;
        }
        return false;
    }

    static boolean returnsReceiver(String methodName) {
        for (String each : RECEIVER_METHODS) {
            if (!each.equals(methodName)) continue;
            return true;
        }
        return false;
    }

    RubyIndex getIndex() {
        return this.knowledge == null ? null : this.knowledge.getIndex();
    }

    private RubyType inferType() {
        String name = AstUtilities.getName(this.callNodeToInfer);
        Node receiver = null;
        RubyType receiverType = null;
        switch (this.callNodeToInfer.getNodeType()) {
            case CALLNODE: {
                receiver = ((CallNode)this.callNodeToInfer).getReceiverNode();
                break;
            }
            case FCALLNODE: 
            case VCALLNODE: {
                Node root = this.knowledge.getRoot();
                AstPath path = new AstPath(root, this.callNodeToInfer);
                String className = AstUtilities.getFqnName(path);
                if (className.isEmpty()) break;
                RubyType methodInSameFile = this.knowledge.getTypeForMethod(className, name);
                if (methodInSameFile != null) {
                    return methodInSameFile;
                }
                receiverType = RubyType.create(className);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal node passed: " + this.callNodeToInfer);
            }
        }
        RubyType fastResult = RubyMethodTypeInferencer.fastCheckType(name);
        if (fastResult != null) {
            return fastResult;
        }
        if (receiverType == null && receiver != null) {
            receiverType = this.getReceiverType(receiver);
        }
        if (receiverType == null) {
            return RubyType.unknown();
        }
        if (RubyMethodTypeInferencer.returnsReceiver(name)) {
            return receiverType;
        }
        if ((FindersHelper.isFinderMethod(name) || ActiveRecordQueryIndexer.isQueryMethod(name)) && receiverType.isSingleton() && this.getIndex() != null) {
            IndexedClass superClass = this.getIndex().getSuperclass(receiverType.first());
            if (superClass != null && "ActiveRecord::Base".equals(superClass.getFqn())) {
                return FindersHelper.isFinderMethod(name) ? FindersHelper.pickFinderType(this.callNodeToInfer, name, receiverType) : ActiveRecordQueryIndexer.getReturnType(name);
            }
            if (ActiveRecordQueryIndexer.isQueryMethod(name) && "ActiveRecord::Relation".equals(receiverType.first())) {
                return ActiveRecordQueryIndexer.getReturnType(name);
            }
        }
        if (this.fast && !TypeInferenceSettings.getDefault().getMethodTypeInference()) {
            return RubyType.unknown();
        }
        RubyType resultType = new RubyType();
        RubyIndex index = this.getIndex();
        if (index == null) {
            return resultType;
        }
        HashSet<IndexedMethod> methods = new HashSet<IndexedMethod>();
        methods.addAll(index.getMethods(name, receiverType.getRealTypes(), QuerySupport.Kind.EXACT));
        if (methods.isEmpty()) {
            methods.addAll(index.getInheritedMethods(receiverType, name, QuerySupport.Kind.EXACT));
        }
        for (IndexedMethod indexedMethod : methods) {
            RubyType type = indexedMethod.getType();
            resultType.append(type);
        }
        return resultType;
    }

    private RubyType getReceiverType(Node receiver) {
        RubyType type = RubyTypeInferencer.create(this.knowledge, this.fast).inferType(receiver);
        if (!type.isKnown()) {
            String name = null;
            if (receiver instanceof Colon2Node) {
                name = AstUtilities.getFqn((Colon2Node)receiver);
            } else if (receiver instanceof INameNode) {
                name = AstUtilities.getName(receiver);
            }
            if (name != null && RubyUtils.isValidConstantFQN(name)) {
                type = RubyType.create(name);
            }
        }
        return type;
    }

    static {
        METHOD_TYPES.put("<=>", new RubyType(RubyType.FIXNUM, RubyType.NIL_CLASS));
        METHOD_TYPES.put("<", new RubyType(RubyType.BOOLEAN, RubyType.NIL_CLASS));
        METHOD_TYPES.put(">", new RubyType(RubyType.BOOLEAN, RubyType.NIL_CLASS));
        METHOD_TYPES.put("<=", new RubyType(RubyType.BOOLEAN, RubyType.NIL_CLASS));
        METHOD_TYPES.put("=>", new RubyType(RubyType.BOOLEAN, RubyType.NIL_CLASS));
        METHOD_TYPES.put("to_s", RubyType.STRING);
        METHOD_TYPES.put("to_str", RubyType.STRING);
        METHOD_TYPES.put("to_string", RubyType.STRING);
        METHOD_TYPES.put("to_sym", RubyType.SYMBOL);
        METHOD_TYPES.put("to_symbol", RubyType.SYMBOL);
        METHOD_TYPES.put("to_a", RubyType.ARRAY);
        METHOD_TYPES.put("to_ary", RubyType.ARRAY);
        METHOD_TYPES.put("to_array", RubyType.ARRAY);
        METHOD_TYPES.put("to_i", RubyType.INTEGER);
        METHOD_TYPES.put("to_int", RubyType.INTEGER);
        METHOD_TYPES.put("to_f", RubyType.FLOAT);
        METHOD_TYPES.put("to_float", RubyType.FLOAT);
    }
}

