/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.RubyBaseCompleter;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.lexer.Call;

final class RubyClassCompleter
extends RubyBaseCompleter {
    private final boolean showSymbols;
    private final Call call;

    static boolean complete(List<? super CompletionProposal> proposals, CompletionRequest request, int anchor, boolean caseSensitive, Call call, boolean showSymbols) {
        RubyClassCompleter rsc = new RubyClassCompleter(proposals, request, anchor, caseSensitive, call, showSymbols);
        return rsc.complete();
    }

    private RubyClassCompleter(List<? super CompletionProposal> proposals, CompletionRequest request, int anchor, boolean caseSensitive, Call call, boolean showSymbols) {
        super(proposals, request, anchor, caseSensitive);
        this.call = call;
        this.showSymbols = showSymbols;
    }

    private boolean complete() {
        String prefix = this.request.prefix;
        QuerySupport.Kind kind = this.request.kind;
        int classAnchor = this.anchor;
        int fqnIndex = prefix.lastIndexOf("::");
        if (fqnIndex != -1) {
            classAnchor += fqnIndex + 2;
        }
        String fullPrefix = prefix;
        if (this.call.isMethodExpected()) {
            return false;
        }
        RubyType type = this.call.getType();
        String lhs = this.call.getLhs();
        if (lhs != null && type.isSingleton() && lhs.equals(type.first())) {
            fullPrefix = type.first() + "::" + prefix;
        }
        AstPath path = this.request.path;
        String ctx = AstUtilities.getFqnName(path);
        HashSet<String> uniqueClasses = new HashSet<String>();
        Set<IndexedClass> classes = this.getIndex().getClasses(fullPrefix, kind, false, false, false, uniqueClasses);
        if (ctx != null && ctx.length() > 0) {
            Set<IndexedClass> extraClasses = this.getIndex().getClasses(ctx + "::" + fullPrefix, kind, false, false, false, uniqueClasses);
            classes.addAll(extraClasses);
        }
        for (IndexedClass cls : classes) {
            if (cls.isNoDoc()) continue;
            RubyCompletionItem.ClassItem item = new RubyCompletionItem.ClassItem(cls, classAnchor, this.request);
            item.setSmart(true);
            if (this.showSymbols) {
                item.setSymbol(true);
            }
            this.propose((CompletionProposal)item);
        }
        return false;
    }
}

