/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RubyIndexer;
import org.netbeans.modules.ruby.RubyUtils;

final class MigrationIndexer {
    private final ContextKnowledge knowledge;
    private final RubyIndexer.TreeAnalyzer analyzer;

    public MigrationIndexer(ContextKnowledge knowledge, RubyIndexer.TreeAnalyzer analyzer) {
        this.knowledge = knowledge;
        this.analyzer = analyzer;
    }

    void handleMigrations() {
        int flags = 0;
        this.analyzer.addClassIncludes("Migration", "ActiveRecord::Migration", "ActiveRecord", flags, "ActiveRecord::ConnectionAdapters::SchemaStatements");
    }

    void handleMigration() {
        String version;
        Node root = this.knowledge.getRoot();
        String fileName = this.analyzer.getFile().getName();
        Node top = null;
        if ("schema".equals(fileName)) {
            top = root;
            version = "schema";
        } else {
            String migrationClass;
            if (fileName.charAt(3) == '_') {
                version = fileName.substring(0, 3);
                migrationClass = RubyUtils.underlinedNameToCamel(fileName.substring(4));
            } else {
                version = fileName.substring(0, 14);
                migrationClass = RubyUtils.underlinedNameToCamel(fileName.substring(15));
            }
            String sig = migrationClass + "#up";
            Node def = AstUtilities.findBySignature(root, sig);
            if (def == null) {
                return;
            }
            top = def;
        }
        HashMap<String, List<String>> items = new HashMap<String, List<String>>();
        this.scanMigration(top, items, null);
        if (items.size() > 0) {
            for (Map.Entry entry : items.entrySet()) {
                IndexDocument document = this.analyzer.getSupport().createDocument(this.analyzer.getIndexable());
                this.analyzer.getDocuments().add(document);
                String tableName = (String)entry.getKey();
                document.addPair("dbtable", tableName, true, true);
                document.addPair("dbversion", version, false, true);
                List columns = (List)entry.getValue();
                for (String column : columns) {
                    document.addPair("dbcolumn", column, false, true);
                }
            }
        }
    }

    private void scanMigration(Node node, Map<String, List<String>> items, String currentTable) {
        Node child4;
        String name;
        if (node.getNodeType() == NodeType.FCALLNODE) {
            name = AstUtilities.getCallName(node);
            if ("create_table".equals(name)) {
                Node grandChild;
                List grandChildren;
                List childNodes = node.childNodes();
                if (childNodes.size() > 0 && (child4 = (Node)childNodes.get(0)).getNodeType() == NodeType.ARRAYNODE && (grandChildren = child4.childNodes()).size() > 0 && ((grandChild = (Node)grandChildren.get(0)).getNodeType() == NodeType.SYMBOLNODE || grandChild.getNodeType() == NodeType.STRNODE)) {
                    Node n;
                    String tableName = this.getString(grandChild);
                    items.put(tableName, new ArrayList());
                    if (childNodes.size() > 1 && (n = (Node)childNodes.get(1)).getNodeType() == NodeType.ITERNODE) {
                        this.scanMigration(n, items, tableName);
                    }
                    return;
                }
            } else {
                if ("add_column".equals(name) || "remove_column".equals(name)) {
                    ArrayList<Node> symbols = new ArrayList<Node>();
                    AstUtilities.addNodesByType(node, new NodeType[]{NodeType.SYMBOLNODE, NodeType.STRNODE}, symbols);
                    if (symbols.size() >= 2) {
                        List<String> list;
                        String tableName = this.getString((Node)symbols.get(0));
                        String columnName = this.getString((Node)symbols.get(1));
                        String columnType = null;
                        boolean isAdd = "add_column".equals(name);
                        if (isAdd && symbols.size() >= 3) {
                            columnType = this.getString((Node)symbols.get(2));
                        }
                        if ((list = items.get(tableName)) == null) {
                            list = new ArrayList<String>();
                            items.put(tableName, list);
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append(columnName);
                        sb.append(';');
                        if (isAdd) {
                            if (columnType != null) {
                                sb.append(columnType);
                            }
                        } else {
                            sb.append("-");
                        }
                        list.add(sb.toString());
                    }
                    return;
                }
                if ("rename_column".equals(name)) {
                    ArrayList<Node> symbols = new ArrayList<Node>();
                    AstUtilities.addNodesByType(node, new NodeType[]{NodeType.SYMBOLNODE, NodeType.STRNODE}, symbols);
                    if (symbols.size() >= 3) {
                        String tableName = this.getString((Node)symbols.get(0));
                        String oldCol = this.getString((Node)symbols.get(1));
                        String newCol = this.getString((Node)symbols.get(2));
                        List<String> list = items.get(tableName);
                        if (list == null) {
                            list = new ArrayList<String>();
                            items.put(tableName, list);
                        }
                        list.add(oldCol + ";-");
                        list.add(newCol);
                    }
                    return;
                }
            }
        } else if (node.getNodeType() == NodeType.CALLNODE && currentTable != null) {
            name = AstUtilities.getCallName(node);
            if ("column".equals(name)) {
                List childNodes = node.childNodes();
                if (childNodes.size() >= 2) {
                    Node child2 = (Node)childNodes.get(0);
                    if (child2.getNodeType() != NodeType.DVARNODE) {
                        return;
                    }
                    child2 = (Node)childNodes.get(1);
                    ArrayList<Node> symbols = new ArrayList<Node>();
                    AstUtilities.addNodesByType(child2, new NodeType[]{NodeType.SYMBOLNODE, NodeType.STRNODE}, symbols);
                    if (symbols.size() >= 2) {
                        String columnName = this.getString((Node)symbols.get(0));
                        String columnType = this.getString((Node)symbols.get(1));
                        List<String> list = items.get(currentTable);
                        if (list == null) {
                            list = new ArrayList<String>();
                            items.put(currentTable, list);
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append(columnName);
                        sb.append(';');
                        sb.append(columnType);
                        list.add(sb.toString());
                    }
                }
                return;
            }
            if ("timestamps".equals(name)) {
                List childNodes = node.childNodes();
                if (childNodes.size() >= 1) {
                    child4 = (Node)childNodes.get(0);
                    if (child4.getNodeType() != NodeType.DVARNODE) {
                        return;
                    }
                    List<String> list = items.get(currentTable);
                    if (list == null) {
                        list = new ArrayList<String>();
                        items.put(currentTable, list);
                    }
                    list.add("created_at;datetime");
                    list.add("updated_at;datetime");
                }
            } else {
                int columnTypeIndex = Arrays.binarySearch(RubyIndexer.FIXED_COLUMN_TYPES, name);
                if (columnTypeIndex >= 0 && columnTypeIndex < RubyIndexer.FIXED_COLUMN_TYPES.length) {
                    String columnType = RubyIndexer.FIXED_COLUMN_TYPES[columnTypeIndex];
                    List childNodes = node.childNodes();
                    if (childNodes.size() >= 2) {
                        Node child3 = (Node)childNodes.get(0);
                        if (child3.getNodeType() != NodeType.DVARNODE) {
                            return;
                        }
                        child3 = (Node)childNodes.get(1);
                        List args = child3.childNodes();
                        for (Node n : args) {
                            if (n.getNodeType() != NodeType.SYMBOLNODE && n.getNodeType() != NodeType.STRNODE) continue;
                            String columnName = this.getString(n);
                            List<String> list = items.get(currentTable);
                            if (list == null) {
                                list = new ArrayList<String>();
                                items.put(currentTable, list);
                            }
                            StringBuilder sb = new StringBuilder();
                            sb.append(columnName);
                            sb.append(';');
                            sb.append(columnType);
                            list.add(sb.toString());
                        }
                    }
                    return;
                }
            }
        }
        List list = node.childNodes();
        for (Node child4 : list) {
            if (child4.isInvisible()) continue;
            this.scanMigration(child4, items, currentTable);
        }
    }

    private String getString(Node node) {
        if (node.getNodeType() == NodeType.STRNODE) {
            return ((StrNode)node).getValue().toString();
        }
        return ((INameNode)node).getName();
    }
}

