/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.AndNode;
import org.jrubyparser.ast.ArgsCatNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.CaseNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DSymbolNode;
import org.jrubyparser.ast.DefinedNode;
import org.jrubyparser.ast.DotNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.ILiteralNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LiteralNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.MultipleAsgnNode;
import org.jrubyparser.ast.NewlineNode;
import org.jrubyparser.ast.NilNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.NotNode;
import org.jrubyparser.ast.OrNode;
import org.jrubyparser.ast.RescueNode;
import org.jrubyparser.ast.ReturnNode;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.UntilNode;
import org.jrubyparser.ast.VCallNode;
import org.jrubyparser.ast.WhenNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.ActiveRecordAssociationFinder;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyMethodCompleter;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyStructureAnalyzer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.TestNameResolver;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class AstUtilities {
    private static final Logger LOGGER = Logger.getLogger(AstUtilities.class.getName());
    private static final boolean INCLUDE_DEFS_PREFIX = false;
    private static final String[] ATTR_ACCESSORS = new String[]{"attr", "attr_reader", "attr_accessor", "attr_writer", "attr_internal", "attr_internal_accessor", "attr_internal_reader", "attr_internal_writer"};
    private static final String[] CATTR_ACCESSORS = new String[]{"cattr_reader", "cattr_accessor", "cattr_writer"};
    private static final String[] NAMED_SCOPE = new String[]{"named_scope", "scope"};

    public static RubyParseResult getParseResult(Parser.Result result) {
        if (!(result instanceof RubyParseResult)) {
            LOGGER.log(Level.WARNING, "Expected RubyParseResult, but have {0}", result);
            return null;
        }
        return (RubyParseResult)result;
    }

    public static int getAstOffset(Parser.Result info, int lexOffset) {
        RubyParseResult result = AstUtilities.getParseResult(info);
        if (result != null) {
            return result.getSnapshot().getEmbeddedOffset(lexOffset);
        }
        return lexOffset;
    }

    public static OffsetRange getAstOffsets(Parser.Result info, OffsetRange lexicalRange) {
        RubyParseResult result = AstUtilities.getParseResult(info);
        if (result != null) {
            int rangeStart = lexicalRange.getStart();
            int start = result.getSnapshot().getEmbeddedOffset(rangeStart);
            if (start == rangeStart) {
                return lexicalRange;
            }
            if (start == -1) {
                return OffsetRange.NONE;
            }
            return new OffsetRange(start, start + lexicalRange.getLength());
        }
        return lexicalRange;
    }

    private AstUtilities() {
    }

    public static List<String> gatherDocumentation(Snapshot baseDoc, Node node) {
        LinkedList<String> comments = new LinkedList<String>();
        int elementBegin = node.getPosition().getStartOffset();
        try {
            if (elementBegin < 0 || elementBegin >= baseDoc.getText().length()) {
                return null;
            }
            int offset = GsfUtilities.getRowStart((CharSequence)baseDoc.getText(), (int)elementBegin);
            --offset;
            while (offset >= 0) {
                offset = GsfUtilities.getRowStart((CharSequence)baseDoc.getText(), (int)offset);
                if (!GsfUtilities.isRowEmpty((CharSequence)baseDoc.getText(), (int)offset) && !GsfUtilities.isRowWhite((CharSequence)baseDoc.getText(), (int)offset)) break;
                --offset;
            }
            if (offset < 0) {
                return null;
            }
            block3: while (offset >= 0) {
                offset = GsfUtilities.getRowStart((CharSequence)baseDoc.getText(), (int)offset);
                if (GsfUtilities.isRowEmpty((CharSequence)baseDoc.getText(), (int)offset) || GsfUtilities.isRowWhite((CharSequence)baseDoc.getText(), (int)offset)) break;
                int lineBegin = GsfUtilities.getRowFirstNonWhite((CharSequence)baseDoc.getText(), (int)offset);
                int lineEnd = GsfUtilities.getRowLastNonWhite((CharSequence)baseDoc.getText(), (int)offset) + 1;
                String line = ((Object)baseDoc.getText().subSequence(lineBegin, lineEnd)).toString();
                if (line.startsWith("#")) {
                    comments.addFirst(line);
                } else {
                    if (comments.size() == 0 && line.startsWith("=end") && lineBegin == GsfUtilities.getRowStart((CharSequence)baseDoc.getText(), (int)offset)) {
                        AstUtilities.gatherInlineDocumentation(comments, baseDoc, offset);
                        return comments;
                    }
                    if (!line.equals("public") && !line.equals("private") && !line.equals("protected")) break;
                    --offset;
                    while (offset >= 0) {
                        offset = GsfUtilities.getRowStart((CharSequence)baseDoc.getText(), (int)offset);
                        if (!GsfUtilities.isRowEmpty((CharSequence)baseDoc.getText(), (int)offset) && !GsfUtilities.isRowWhite((CharSequence)baseDoc.getText(), (int)offset)) continue block3;
                        --offset;
                    }
                    continue;
                }
                --offset;
            }
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return comments;
    }

    private static void gatherInlineDocumentation(LinkedList<String> comments, Snapshot baseDoc, int offset) throws BadLocationException {
        offset = GsfUtilities.getRowStart((CharSequence)baseDoc.getText(), (int)offset);
        --offset;
        while (offset >= 0) {
            int lineBegin = offset = GsfUtilities.getRowStart((CharSequence)baseDoc.getText(), (int)offset);
            int lineEnd = GsfUtilities.getRowEnd((CharSequence)baseDoc.getText(), (int)offset);
            String line = ((Object)baseDoc.getText().subSequence(lineBegin, lineEnd)).toString();
            if (line.startsWith("=begin")) {
                return;
            }
            comments.addFirst(line);
            --offset;
        }
    }

    public static Node getForeignNode(IndexedElement elem) {
        return AstUtilities.getForeignNode(elem, null);
    }

    public static Node getForeignNode(final IndexedElement elem, final Parser.Result[] foreignInfoHolder) {
        FileObject fo = elem.getFileObject();
        if (fo == null) {
            return null;
        }
        Source source = Source.create((FileObject)fo);
        final Node[] nodeHolder = new Node[1];
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    String signature;
                    Node root;
                    Parser.Result result = resultIterator.getParserResult();
                    if (foreignInfoHolder != null) {
                        assert (foreignInfoHolder.length == 1);
                        foreignInfoHolder[0] = result;
                    }
                    if ((root = AstUtilities.getRoot(result)) != null && (signature = elem.getSignature()) != null) {
                        Node node = AstUtilities.findBySignature(root, signature);
                        if (node == null && "new".equals(elem.getName())) {
                            signature = signature.indexOf("#new") != -1 ? signature.replaceFirst("#new", "#initialize") : signature.replaceFirst("new", "initialize");
                            node = AstUtilities.findBySignature(root, signature);
                        }
                        nodeHolder[0] = node;
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        return nodeHolder[0];
    }

    public static int boundCaretOffset(ParserResult result, int caretOffset) {
        int length;
        BaseDocument doc = RubyUtils.getDocument((Parser.Result)result);
        if (doc != null && caretOffset > (length = doc.getLength())) {
            caretOffset = length;
        }
        return caretOffset;
    }

    public static Set<String> getRequires(Node root) {
        HashSet<String> requires = new HashSet<String>();
        AstUtilities.addRequires(root, requires);
        return requires;
    }

    private static void addRequires(Node node, Set<String> requires) {
        if (node.getNodeType() == NodeType.FCALLNODE) {
            String require;
            Node n;
            ListNode args;
            Node argsNode;
            String name = AstUtilities.getName(node);
            if (name.equals("require") && (argsNode = ((FCallNode)node).getArgsNode()) instanceof ListNode && (args = (ListNode)argsNode).size() > 0 && (n = args.get(0)) instanceof StrNode && (require = ((StrNode)n).getValue()) != null && require.length() > 0) {
                requires.add(require.toString());
            }
        } else if (node.getNodeType() == NodeType.MODULENODE || node.getNodeType() == NodeType.CLASSNODE || node.getNodeType() == NodeType.DEFNNODE || node.getNodeType() == NodeType.DEFSNODE) {
            return;
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            AstUtilities.addRequires(child, requires);
        }
    }

    public static MethodDefNode findMethod(Node node, String name, Arity arity) {
        Arity defArity;
        if ((node.getNodeType() == NodeType.DEFNNODE || node.getNodeType() == NodeType.DEFSNODE) && AstUtilities.getName(node).equals(name) && Arity.matches(arity, defArity = Arity.getDefArity(node))) {
            return (MethodDefNode)node;
        }
        List list = node.childNodes();
        for (Node child : list) {
            MethodDefNode match;
            if (child.isInvisible() || (match = AstUtilities.findMethod(child, name, arity)) == null) continue;
            return match;
        }
        return null;
    }

    public static Node findNodeAtOffset(Node root, int offset) {
        AstPath path = new AstPath(root, offset);
        ListIterator<Node> it = path.leafToRoot();
        return it.hasNext() ? (Node)it.next() : null;
    }

    public static MethodDefNode findMethodAtOffset(Node root, int offset) {
        AstPath path = new AstPath(root, offset);
        ListIterator<Node> it = path.leafToRoot();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node.getNodeType() != NodeType.DEFNNODE && node.getNodeType() != NodeType.DEFSNODE) continue;
            return (MethodDefNode)node;
        }
        return null;
    }

    public static ClassNode findClassAtOffset(Node root, int offset) {
        AstPath path = new AstPath(root, offset);
        ListIterator<Node> it = path.leafToRoot();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!(node instanceof ClassNode)) continue;
            return (ClassNode)node;
        }
        return null;
    }

    public static Node findLocalScope(Node node, AstPath path) {
        MethodDefNode method = AstUtilities.findMethod(path);
        if (method == null) {
            ListIterator<Node> it = path.leafToRoot();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                switch (n.getNodeType()) {
                    case DEFNNODE: 
                    case DEFSNODE: 
                    case CLASSNODE: 
                    case SCLASSNODE: 
                    case MODULENODE: {
                        return n;
                    }
                }
            }
            if (path.root() != null) {
                return path.root();
            }
            method = AstUtilities.findBlock(path);
        }
        if (method == null) {
            method = path.leafParent();
            if (method.getNodeType() == NodeType.NEWLINENODE) {
                method = path.leafGrandParent();
            }
            if (method == null) {
                method = node;
            }
        }
        return method;
    }

    public static Node findDynamicScope(Node node, AstPath path) {
        Node block = AstUtilities.findBlock(path);
        if (block == null && (block = path.leafParent()) == null) {
            block = node;
        }
        return block;
    }

    public static Node findBlock(AstPath path) {
        Node candidate = null;
        for (Node curr : path) {
            switch (curr.getNodeType()) {
                case ITERNODE: {
                    candidate = curr;
                    break;
                }
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    return candidate;
                }
            }
        }
        return candidate;
    }

    public static MethodDefNode findMethod(AstPath path) {
        for (Node curr : path) {
            if (curr.getNodeType() == NodeType.DEFNNODE || curr.getNodeType() == NodeType.DEFSNODE) {
                return (MethodDefNode)curr;
            }
            if (curr.getNodeType() != NodeType.CLASSNODE && curr.getNodeType() != NodeType.SCLASSNODE && curr.getNodeType() != NodeType.MODULENODE) continue;
            break;
        }
        return null;
    }

    public static ClassNode findClass(AstPath path) {
        for (Node curr : path) {
            if (!(curr instanceof ClassNode)) continue;
            return (ClassNode)curr;
        }
        return null;
    }

    public static IScopingNode findClassOrModule(AstPath path) {
        for (Node curr : path) {
            if (curr.getNodeType() != NodeType.CLASSNODE && curr.getNodeType() != NodeType.MODULENODE) continue;
            return (IScopingNode)curr;
        }
        return null;
    }

    public static boolean isCall(Node node) {
        return node.getNodeType() == NodeType.FCALLNODE || node.getNodeType() == NodeType.VCALLNODE || node.getNodeType() == NodeType.CALLNODE;
    }

    static boolean isRaiseCall(Node node) {
        if (AstUtilities.isCall(node)) {
            return "raise".equals(AstUtilities.getName(node));
        }
        return false;
    }

    static boolean isAssignmentNode(Node node) {
        return node.getNodeType() == NodeType.INSTASGNNODE || node.getNodeType() == NodeType.LOCALASGNNODE || node.getNodeType() == NodeType.CLASSVARASGNNODE || node.getNodeType() == NodeType.GLOBALASGNNODE || node.getNodeType() == NodeType.ATTRASSIGNNODE || node.getNodeType() == NodeType.MULTIPLEASGNNODE;
    }

    static Node findNextNonNewLineNode(Node target) {
        if (target.getNodeType() != NodeType.NEWLINENODE) {
            return target;
        }
        NewlineNode newlineNode = (NewlineNode)target;
        return AstUtilities.findNextNonNewLineNode(newlineNode.getNextNode());
    }

    public static String getCallName(Node node) {
        assert (AstUtilities.isCall(node));
        if (node instanceof INameNode) {
            return AstUtilities.getName(node);
        }
        assert (false) : node;
        return null;
    }

    public static String getDefName(Node node) {
        if (node instanceof MethodDefNode) {
            return AstUtilities.getName(node);
        }
        assert (false) : node;
        return null;
    }

    public static ArgumentNode getDefNameNode(MethodDefNode node) {
        return node.getNameNode();
    }

    public static boolean isConstructorMethod(MethodDefNode node) {
        String name = node.getName();
        return name.equals("new") || name.equals("initialize");
    }

    public static List<String> getDefArgs(MethodDefNode node, boolean namesOnly) {
        List nodes = node.childNodes();
        for (Node c : nodes) {
            String name;
            if (!(c instanceof ArgsNode)) continue;
            ArgsNode an = (ArgsNode)c;
            List args = an.childNodes();
            ArrayList<String> parameters = new ArrayList<String>();
            for (Node arg : args) {
                if (!(arg instanceof ListNode)) continue;
                List args2 = arg.childNodes();
                for (Node arg2 : args2) {
                    if (!(arg2 instanceof ArgumentNode) && !(arg2 instanceof LocalAsgnNode)) continue;
                    String name2 = AstUtilities.getName(arg2);
                    parameters.add(name2);
                }
            }
            if (an.getRest() != null) {
                name = an.getRest().getName();
                if (!namesOnly) {
                    name = "*" + name;
                }
                parameters.add(name);
            }
            if (an.getBlock() != null) {
                name = an.getBlock().getName();
                if (!namesOnly) {
                    name = "&" + name;
                }
                parameters.add(name);
            }
            return parameters;
        }
        return null;
    }

    public static String getDefSignature(MethodDefNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append(AstUtilities.getDefName((Node)node));
        List<String> args = AstUtilities.getDefArgs(node, false);
        if (args != null && args.size() > 0) {
            sb.append('(');
            Iterator<String> it = args.iterator();
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(',');
                sb.append(it.next());
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static int findArgumentIndex(Node node, int offset) {
        switch (node.getNodeType()) {
            case FCALLNODE: {
                Node argsNode = ((FCallNode)node).getArgsNode();
                if (argsNode == null) {
                    return -1;
                }
                return AstUtilities.findArgumentIndex(argsNode, offset);
            }
            case CALLNODE: {
                Node argsNode = ((CallNode)node).getArgsNode();
                if (argsNode == null) {
                    return -1;
                }
                return AstUtilities.findArgumentIndex(argsNode, offset);
            }
            case ARGSCATNODE: {
                ArgsCatNode acn = (ArgsCatNode)node;
                int index = AstUtilities.findArgumentIndex(acn.getFirstNode(), offset);
                if (index != -1) {
                    return index;
                }
                index = AstUtilities.findArgumentIndex(acn.getSecondNode(), offset);
                if (index != -1) {
                    return AstUtilities.getConstantArgs(acn) + index;
                }
                SourcePosition pos = node.getPosition();
                if (offset >= pos.getStartOffset() && offset <= pos.getEndOffset()) {
                    return AstUtilities.getConstantArgs(acn);
                }
                return -1;
            }
            case HASHNODE: {
                return offset;
            }
        }
        if (node instanceof ListNode) {
            List children = node.childNodes();
            int prevEnd = Integer.MAX_VALUE;
            for (int index = 0; index < children.size(); ++index) {
                Node child = (Node)children.get(index);
                if (child.isInvisible()) continue;
                if (child.getNodeType() == NodeType.HASHNODE) {
                    OffsetRange range = AstUtilities.getRange(child);
                    if (offset <= range.getEnd() && (offset >= prevEnd || offset >= range.getStart())) {
                        return index;
                    }
                    prevEnd = range.getEnd();
                    continue;
                }
                SourcePosition pos = child.getPosition();
                if (offset <= pos.getEndOffset() && (offset >= prevEnd || offset >= pos.getStartOffset())) {
                    return index;
                }
                prevEnd = pos.getEndOffset();
            }
            SourcePosition pos = node.getPosition();
            if (offset > pos.getStartOffset() && offset < pos.getEndOffset()) {
                return 0;
            }
        } else {
            SourcePosition pos = node.getPosition();
            if (offset >= pos.getStartOffset() && offset <= pos.getEndOffset()) {
                return 0;
            }
        }
        return -1;
    }

    private static int getConstantArgs(ArgsCatNode acn) {
        Node node = acn.getFirstNode();
        if (node instanceof ListNode) {
            List children = node.childNodes();
            return children.size();
        }
        return 1;
    }

    public static boolean isCallFor(Node call, Arity callArity, Node method) {
        assert (AstUtilities.isCall(call));
        assert (method instanceof MethodDefNode);
        return AstUtilities.getDefName(method).equals(AstUtilities.getCallName(call)) && Arity.matches(callArity, Arity.getDefArity(method));
    }

    public static Node findBySignature(Node root, String signature) {
        String originalSig = signature;
        boolean[] lookingForMethod = new boolean[1];
        String name = AstUtilities.getNextSigComponent(signature, lookingForMethod);
        Node node = AstUtilities.findBySignature(root, root, signature = signature.substring(name.length()), name, lookingForMethod);
        if (node == null && originalSig.startsWith("Object#")) {
            originalSig = originalSig.substring(originalSig.indexOf(35) + 1);
            name = AstUtilities.getNextSigComponent(signature, lookingForMethod);
            signature = originalSig.substring(name.length());
            lookingForMethod[0] = true;
            node = AstUtilities.findBySignature(root, root, signature, name, lookingForMethod);
        }
        return node;
    }

    private static String getNextSigComponent(String signature, boolean[] lookingForMethod) {
        char c;
        int i;
        StringBuilder sb = new StringBuilder();
        int n = signature.length();
        for (i = 0; i < n; ++i) {
            c = signature.charAt(i);
            if (c == '#') {
                lookingForMethod[0] = true;
                continue;
            }
            if (c != ':' && c != '(') break;
        }
        while (i < n && (c = signature.charAt(i)) != '#' && c != ':' && c != '(') {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private static Node findBySignature(Node root, Node node, String signature, String name, boolean[] lookingForMethod) {
        switch (node.getNodeType()) {
            case INSTASGNNODE: {
                String n;
                if (name.charAt(0) != '@' || !name.equals(n = AstUtilities.getName(node))) break;
                return node;
            }
            case CLASSVARDECLNODE: 
            case CLASSVARASGNNODE: {
                String n;
                if (!name.startsWith("@@") || !name.equals(n = AstUtilities.getName(node))) break;
                return node;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                SymbolNode[] symbols;
                if (lookingForMethod[0] && name.equals(AstUtilities.getDefName(node))) {
                    List<String> parameters = AstUtilities.getDefArgs((MethodDefNode)node, false);
                    if (signature.length() == 0 && (parameters == null || parameters.size() == 0)) {
                        return node;
                    }
                    if (signature.length() == 0) break;
                    assert (signature.charAt(0) == '(') : signature;
                    String argList = signature.substring(1, signature.length() - 1);
                    String[] args = argList.split(",");
                    if (args.length != parameters.size()) break;
                    boolean equal = true;
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i].equals(parameters.get(i))) continue;
                        equal = false;
                        break;
                    }
                    if (!equal) break;
                    return node;
                }
                if (!AstUtilities.isAttr(node)) break;
                for (SymbolNode sym : symbols = AstUtilities.getAttrSymbols(node)) {
                    if (!name.equals(sym.getName())) continue;
                    return node;
                }
                break;
            }
            case FCALLNODE: {
                String shoulda;
                if (AstUtilities.isAttr(node) || AstUtilities.isNamedScope(node) || AstUtilities.isActiveRecordAssociation(node) || AstUtilities.isNodeNameIn(node, RubyStructureAnalyzer.DYNAMIC_METHODS)) {
                    List<Node> values = AstUtilities.getChildValues(node);
                    for (Node each : values) {
                        if (!name.equals(AstUtilities.getNameOrValue(each))) continue;
                        return each;
                    }
                    break;
                }
                if (!TestNameResolver.isShouldaMethod(AstUtilities.getName(node)) || !name.equals(shoulda = TestNameResolver.getTestName(new AstPath(root, node)))) break;
                return node;
            }
            case ALIASNODE: {
                AliasNode aliasNode = (AliasNode)node;
                if (!name.equals(AstUtilities.getNameOrValue(aliasNode.getNewName())) && !name.equals(AstUtilities.getNameOrValue(aliasNode.getOldName()))) break;
                return aliasNode;
            }
            case CONSTDECLNODE: {
                if (!name.equals(AstUtilities.getName(node))) break;
                return node;
            }
            case CLASSNODE: 
            case MODULENODE: {
                int index;
                Colon3Node c3n = ((IScopingNode)node).getCPath();
                if (c3n instanceof Colon2Node) {
                    String fqn = AstUtilities.getFqn((Colon2Node)c3n);
                    if (!fqn.startsWith(name) || !signature.startsWith(fqn.substring(name.length()))) break;
                    if ((name = AstUtilities.getNextSigComponent(signature = signature.substring(fqn.substring(name.length()).length()), lookingForMethod)).length() == 0) {
                        return node;
                    }
                    index = signature.indexOf(name);
                    assert (index != -1);
                    signature = signature.substring(index + name.length());
                    break;
                }
                if (!name.equals(AstUtilities.getClassOrModuleName((IScopingNode)node))) break;
                name = AstUtilities.getNextSigComponent(signature, lookingForMethod);
                if (name.length() == 0) {
                    return node;
                }
                int index2 = signature.indexOf(name);
                assert (index2 != -1);
                signature = signature.substring(index2 + name.length());
                break;
            }
            case SCLASSNODE: {
                Node receiver = ((SClassNode)node).getReceiverNode();
                String rn = null;
                if (receiver instanceof Colon2Node) {
                    rn = AstUtilities.getName(receiver);
                } else if (receiver instanceof ConstNode) {
                    rn = AstUtilities.getName(receiver);
                }
                if (rn == null || !name.equals(rn)) break;
                name = AstUtilities.getNextSigComponent(signature, lookingForMethod);
                if (name.length() == 0) {
                    return node;
                }
                int index = signature.indexOf(name);
                assert (index != -1);
                signature = signature.substring(index + name.length());
            }
        }
        List list = node.childNodes();
        boolean old = lookingForMethod[0];
        for (Node child : list) {
            Node match;
            if (child.isInvisible() || (match = AstUtilities.findBySignature(root, child, signature, name, lookingForMethod)) == null) continue;
            return match;
        }
        lookingForMethod[0] = old;
        return null;
    }

    public static boolean containsOffset(Node node, int offset) {
        SourcePosition pos = node.getPosition();
        return offset >= pos.getStartOffset() && offset <= pos.getEndOffset();
    }

    static OffsetRange getRangeIncludeNil(Node node) {
        if (node != null && node.getClass().equals(NilNode.class)) {
            SourcePosition pos = node.getPosition();
            try {
                return new OffsetRange(pos.getStartOffset(), pos.getEndOffset());
            }
            catch (Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
                return OffsetRange.NONE;
            }
        }
        return AstUtilities.getRange(node);
    }

    public static OffsetRange getRange(Node node) {
        if (node.isInvisible()) {
            return OffsetRange.NONE;
        }
        if (node.getNodeType() == NodeType.NOTNODE) {
            Node first;
            SourcePosition pos = node.getPosition();
            List list = node.childNodes();
            if (list != null && list.size() > 0 && (first = (Node)list.get(0)).getNodeType() == NodeType.NEWLINENODE) {
                OffsetRange range = AstUtilities.getRange(first);
                return new OffsetRange(pos.getStartOffset(), range.getEnd());
            }
            return new OffsetRange(pos.getStartOffset(), pos.getEndOffset());
        }
        if (node.getNodeType() == NodeType.HASHNODE) {
            List list = node.childNodes();
            if (list != null && list.size() > 0) {
                int start = ((Node)list.get(0)).getPosition().getStartOffset();
                int end = ((Node)list.get(list.size() - 1)).getPosition().getEndOffset();
                return new OffsetRange(start, end);
            }
            SourcePosition pos = node.getPosition();
            return new OffsetRange(pos.getStartOffset(), pos.getEndOffset());
        }
        if (node.getNodeType() == NodeType.NILNODE) {
            return OffsetRange.NONE;
        }
        SourcePosition pos = node.getPosition();
        try {
            return new OffsetRange(pos.getStartOffset(), pos.getEndOffset());
        }
        catch (Throwable t) {
            Exceptions.printStackTrace((Throwable)t);
            return OffsetRange.NONE;
        }
    }

    public static OffsetRange getLValueRange(AssignableNode node) {
        if (node instanceof MultipleAsgnNode) {
            MultipleAsgnNode man = (MultipleAsgnNode)node;
            if (man.getHeadNode() != null) {
                return AstUtilities.getNameRange((Node)man.getHeadNode());
            }
            return AstUtilities.getRange((Node)node);
        }
        assert (node instanceof INameNode) : node;
        SourcePosition pos = node.getPosition();
        OffsetRange range = new OffsetRange(pos.getStartOffset(), pos.getStartOffset() + AstUtilities.getName((Node)node).length());
        return range;
    }

    public static OffsetRange getNameRange(Node node) {
        if (node instanceof AssignableNode) {
            return AstUtilities.getLValueRange((AssignableNode)node);
        }
        if (node instanceof MethodDefNode) {
            return AstUtilities.getFunctionNameRange(node);
        }
        if (AstUtilities.isCall(node)) {
            return AstUtilities.getCallRange(node);
        }
        if (node instanceof ClassNode) {
            Colon3Node c3n = ((ClassNode)node).getCPath();
            if (c3n != null) {
                return AstUtilities.getRange((Node)c3n);
            }
            return AstUtilities.getRange(node);
        }
        if (node instanceof ModuleNode) {
            Colon3Node c3n = ((ModuleNode)node).getCPath();
            if (c3n != null) {
                return AstUtilities.getRange((Node)c3n);
            }
            return AstUtilities.getRange(node);
        }
        return AstUtilities.getRange(node);
    }

    public static OffsetRange getCallRange(Node node) {
        Node receiver;
        SourcePosition pos = node.getPosition();
        int start = pos.getStartOffset();
        int end = pos.getEndOffset();
        assert (AstUtilities.isCall(node));
        assert (node instanceof INameNode);
        if (node instanceof CallNode && (receiver = ((CallNode)node).getReceiverNode()) != null && !receiver.isInvisible()) {
            start = receiver.getPosition().getEndOffset() + 1;
        }
        if (node instanceof INameNode) {
            end = start + AstUtilities.getName(node).length();
        }
        return new OffsetRange(start, end);
    }

    public static OffsetRange getFunctionNameRange(Node node) {
        for (Node child : node.childNodes()) {
            if (!(child instanceof ArgumentNode)) continue;
            OffsetRange range = AstUtilities.getRange(child);
            return range;
        }
        if (node instanceof MethodDefNode) {
            for (Node child : node.childNodes()) {
                if (!(child instanceof ConstNode)) continue;
                SourcePosition pos = child.getPosition();
                int end = pos.getEndOffset();
                int start = end + 1;
                end = end + 1 + AstUtilities.getDefName(node).length();
                OffsetRange range = new OffsetRange(start, end);
                return range;
            }
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange getAliasNewRange(AliasNode node) {
        SourcePosition pos = node.getPosition();
        int newStart = pos.getStartOffset() + 6;
        String name = AstUtilities.getNameOrValue(node.getNewName());
        int length = name != null ? name.length() : 0;
        return new OffsetRange(newStart, newStart + length);
    }

    public static OffsetRange getAliasOldRange(AliasNode node) {
        SourcePosition pos = node.getPosition();
        String newName = AstUtilities.getNameOrValue(node.getNewName());
        int newLength = newName != null ? newName.length() : 0;
        String oldName = AstUtilities.getNameOrValue(node.getOldName());
        int oldLength = oldName != null ? oldName.length() : 0;
        int oldStart = pos.getStartOffset() + 6 + newLength + 1;
        return new OffsetRange(oldStart, oldStart + oldLength);
    }

    public static String getClassOrModuleName(IScopingNode node) {
        return AstUtilities.getName((Node)node.getCPath());
    }

    public static List<ClassNode> getClasses(Node root) {
        ArrayList<ClassNode> classes = new ArrayList<ClassNode>();
        AstUtilities.addClasses(root, classes);
        return classes;
    }

    private static void addClasses(Node node, List<ClassNode> classes) {
        if (node instanceof ClassNode) {
            classes.add((ClassNode)node);
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            AstUtilities.addClasses(child, classes);
        }
    }

    private static void addAncestorParents(Node node, StringBuilder sb) {
        if (node instanceof Colon2Node) {
            Colon2Node c2n = (Colon2Node)node;
            AstUtilities.addAncestorParents(c2n.getLeftNode(), sb);
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ':') {
                sb.append("::");
            }
            sb.append(c2n.getName());
        } else if (node instanceof INameNode) {
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ':') {
                sb.append("::");
            }
            sb.append(AstUtilities.getName(node));
        }
    }

    public static String getFqn(Colon2Node c2n) {
        StringBuilder sb = new StringBuilder();
        AstUtilities.addAncestorParents((Node)c2n, sb);
        return sb.toString();
    }

    public static String getSuperclass(ClassNode clz) {
        StringBuilder sb = new StringBuilder();
        if (clz.getSuperNode() != null) {
            AstUtilities.addAncestorParents(clz.getSuperNode(), sb);
            return sb.toString();
        }
        return null;
    }

    static String getFqnName(Node root, Node target) {
        String fqn = AstUtilities.getFqnName(new AstPath(root, target));
        if (fqn.length() > 0) {
            return fqn + "::" + AstUtilities.getName(target);
        }
        return AstUtilities.getName(target);
    }

    static String getFqnName(AstPath path, String simpleName) {
        String fqn = AstUtilities.getFqnName(path);
        if (fqn.length() > 0) {
            return fqn + "::" + simpleName;
        }
        return simpleName;
    }

    public static String getFqnName(AstPath path) {
        StringBuilder sb = new StringBuilder();
        ListIterator<Node> it = path.rootToLeaf();
        while (it.hasNext()) {
            Colon3Node cpath;
            Node node = (Node)it.next();
            if (!(node instanceof ModuleNode) && !(node instanceof ClassNode) || (cpath = ((IScopingNode)node).getCPath()) == null) continue;
            if (sb.length() > 0) {
                sb.append("::");
            }
            if (cpath instanceof Colon2Node) {
                sb.append(AstUtilities.getFqn((Colon2Node)cpath));
                continue;
            }
            sb.append(cpath.getName());
        }
        return sb.toString();
    }

    public static boolean isAttr(Node node) {
        if (!AstUtilities.isCallNode(node)) {
            return false;
        }
        return AstUtilities.isNodeNameIn(node, ATTR_ACCESSORS) || AstUtilities.isNodeNameIn(node, CATTR_ACCESSORS);
    }

    public static boolean isCAttr(Node node) {
        if (!AstUtilities.isCallNode(node)) {
            return false;
        }
        return AstUtilities.isNodeNameIn(node, CATTR_ACCESSORS);
    }

    static boolean isNamedScope(Node node) {
        if (!AstUtilities.isCallNode(node)) {
            return false;
        }
        return AstUtilities.isNodeNameIn(node, NAMED_SCOPE);
    }

    public static boolean isActiveRecordAssociation(Node node) {
        if (!AstUtilities.isCallNode(node)) {
            return false;
        }
        return AstUtilities.isNodeNameIn(node, ActiveRecordAssociationFinder.AR_ASSOCIATIONS);
    }

    static boolean isNodeNameIn(Node node, String ... names) {
        String name = AstUtilities.getName(node);
        for (String each : names) {
            if (!each.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCallNode(Node node) {
        return node instanceof FCallNode || node instanceof VCallNode;
    }

    static List<String> getNamesOrValues(ListNode listNode) {
        ArrayList<String> result = new ArrayList<String>(listNode.size());
        int max = listNode.size();
        for (int i = 0; i < max; ++i) {
            String name;
            Node n = listNode.get(i);
            if (!(n instanceof StrNode) && !(n instanceof SymbolNode) && !(n instanceof ConstNode) || (name = AstUtilities.getNameOrValue(n)) == null || name.isEmpty()) continue;
            result.add(name);
        }
        return result;
    }

    public static String getNameOrValue(Node node) {
        if (node instanceof SymbolNode) {
            return ((SymbolNode)node).getName();
        }
        if (node instanceof StrNode) {
            return ((StrNode)node).getValue();
        }
        if (node instanceof INameNode) {
            return AstUtilities.getName(node);
        }
        if (node instanceof DSymbolNode && !node.childNodes().isEmpty()) {
            Node child = (Node)node.childNodes().get(0);
            return AstUtilities.getNameOrValue(child);
        }
        if (node instanceof LiteralNode) {
            return ((LiteralNode)node).getName();
        }
        return null;
    }

    static SymbolNode[] getSymbols(Node node) {
        ArrayList<SymbolNode> symbolList = new ArrayList<SymbolNode>();
        for (Node child : AstUtilities.getChildValues(node)) {
            if (!(child instanceof SymbolNode)) continue;
            symbolList.add((SymbolNode)child);
        }
        return symbolList.toArray(new SymbolNode[symbolList.size()]);
    }

    static List<Node> getChildValues(Node node) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node child : node.childNodes()) {
            if (!(child instanceof ListNode)) continue;
            List values = child.childNodes();
            result.addAll(values);
        }
        return result;
    }

    public static SymbolNode[] getAttrSymbols(Node node) {
        assert (AstUtilities.isAttr(node));
        return AstUtilities.getSymbols(node);
    }

    public static Node getRoot(FileObject sourceFO) {
        Source source = Source.create((FileObject)sourceFO);
        if (source == null) {
            return null;
        }
        final Node[] rootHolder = new Node[1];
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator ri) throws Exception {
                    Parser.Result result = ri.getParserResult();
                    rootHolder[0] = AstUtilities.getRoot(result);
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return rootHolder[0];
    }

    public static Node getRoot(Parser.Result parserResult) {
        if (!(parserResult instanceof RubyParseResult)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                String msg = "Expected RubyParseResult, but got " + parserResult;
                LOGGER.log(Level.FINE, msg, new Exception(msg));
            }
            return null;
        }
        RubyParseResult result = (RubyParseResult)parserResult;
        return result.getRootNode();
    }

    public static void findPrivateMethods(Node clz, Set<Node> protectedMethods, Set<Node> privateMethods) {
        HashSet<String> publicMethodSymbols = new HashSet<String>();
        HashSet<String> protectedMethodSymbols = new HashSet<String>();
        HashSet<String> privateMethodSymbols = new HashSet<String>();
        HashSet<Node> publicMethods = new HashSet<Node>();
        List list = clz.childNodes();
        Modifier access = Modifier.PUBLIC;
        for (Node child : list) {
            if (child.isInvisible()) continue;
            access = AstUtilities.getMethodAccess(child, access, publicMethodSymbols, protectedMethodSymbols, privateMethodSymbols, publicMethods, protectedMethods, privateMethods);
        }
        privateMethodSymbols.removeAll(publicMethodSymbols);
        protectedMethodSymbols.removeAll(publicMethodSymbols);
        for (String name : privateMethodSymbols) {
            for (Node n : publicMethods) {
                if (!name.equals(AstUtilities.getDefName(n))) continue;
                privateMethods.add(n);
            }
        }
        for (String name : protectedMethodSymbols) {
            for (Node n : publicMethods) {
                if (!name.equals(AstUtilities.getDefName(n))) continue;
                protectedMethods.add(n);
            }
        }
    }

    private static Modifier getMethodAccess(Node node, Modifier access, Set<String> publicMethodSymbols, Set<String> protectedMethodSymbols, Set<String> privateMethodSymbols, Set<Node> publicMethods, Set<Node> protectedMethods, Set<Node> privateMethods) {
        if (node instanceof MethodDefNode) {
            if (access == Modifier.PRIVATE) {
                privateMethods.add(node);
            } else if (access == Modifier.PUBLIC) {
                publicMethods.add(node);
            } else if (access == Modifier.PROTECTED) {
                protectedMethods.add(node);
            }
            return access;
        }
        if (node instanceof VCallNode || node instanceof FCallNode) {
            String name = AstUtilities.getName(node);
            if ("private".equals(name)) {
                if (Arity.callHasArguments(node)) {
                    List params = node.childNodes();
                    for (Node param : params) {
                        if (!(param instanceof ListNode)) continue;
                        List params2 = param.childNodes();
                        for (Node param2 : params2) {
                            if (!(param2 instanceof SymbolNode)) continue;
                            String symbol = AstUtilities.getName(param2);
                            privateMethodSymbols.add(symbol);
                        }
                    }
                } else {
                    access = Modifier.PRIVATE;
                }
                return access;
            }
            if ("protected".equals(name)) {
                if (Arity.callHasArguments(node)) {
                    List params = node.childNodes();
                    for (Node param : params) {
                        if (!(param instanceof ListNode)) continue;
                        List params2 = param.childNodes();
                        for (Node param2 : params2) {
                            if (!(param2 instanceof SymbolNode)) continue;
                            String symbol = AstUtilities.getName(param2);
                            protectedMethodSymbols.add(symbol);
                        }
                    }
                } else {
                    access = Modifier.PROTECTED;
                }
                return access;
            }
            if ("public".equals(name)) {
                if (!Arity.callHasArguments(node)) {
                    access = Modifier.PUBLIC;
                    return access;
                }
                List params = node.childNodes();
                for (Node param : params) {
                    if (!(param instanceof ListNode)) continue;
                    List params2 = param.childNodes();
                    for (Node param2 : params2) {
                        if (!(param2 instanceof SymbolNode)) continue;
                        String symbol = AstUtilities.getName(param2);
                        publicMethodSymbols.add(symbol);
                    }
                }
            }
            return access;
        }
        if (node instanceof ClassNode || node instanceof ModuleNode) {
            return access;
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            access = AstUtilities.getMethodAccess(child, access, publicMethodSymbols, protectedMethodSymbols, privateMethodSymbols, publicMethods, protectedMethods, privateMethods);
        }
        return access;
    }

    public static String getMethodName(FileObject fo, final int lexOffset) {
        Source source = Source.create((FileObject)fo);
        if (source == null) {
            return null;
        }
        final String[] methodName = new String[1];
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    BaseDocument doc;
                    Parser.Result result = resultIterator.getParserResult();
                    Node root = AstUtilities.getRoot(result);
                    if (root == null) {
                        return;
                    }
                    int astOffset = AstUtilities.getAstOffset(result, lexOffset);
                    if (astOffset == -1) {
                        return;
                    }
                    MethodDefNode method = AstUtilities.findMethodAtOffset(root, astOffset);
                    if (method == null && (doc = RubyUtils.getDocument(result)) != null) {
                        try {
                            int endOffset = Utilities.getRowEnd((BaseDocument)doc, (int)lexOffset);
                            if (endOffset != lexOffset) {
                                astOffset = AstUtilities.getAstOffset(result, endOffset);
                                if (astOffset == -1) {
                                    return;
                                }
                                method = AstUtilities.findMethodAtOffset(root, astOffset);
                            }
                        }
                        catch (BadLocationException ble) {
                            // empty catch block
                        }
                    }
                    if (method != null) {
                        methodName[0] = method.getName();
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return methodName[0];
    }

    public static String getTestName(FileObject fo, final int caretOffset) {
        Source source = Source.create((FileObject)fo);
        if (source == null) {
            return null;
        }
        final String[] testName = new String[1];
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    try {
                        int astOffset;
                        Parser.Result result = resultIterator.getParserResult();
                        Node root = AstUtilities.getRoot(result);
                        if (root == null) {
                            return;
                        }
                        BaseDocument doc = RubyUtils.getDocument(result, true);
                        if (doc == null) {
                            return;
                        }
                        int lexOffset = caretOffset;
                        int rowStart = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)lexOffset);
                        if (rowStart != -1 && lexOffset <= rowStart) {
                            lexOffset = rowStart + 1;
                        }
                        if ((astOffset = AstUtilities.getAstOffset(result, lexOffset)) == -1) {
                            return;
                        }
                        AstPath path = new AstPath(root, astOffset);
                        testName[0] = TestNameResolver.getTestName(path);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return testName[0];
    }

    public static int findOffset(FileObject fo, final String methodName) {
        Source source = Source.create((FileObject)fo);
        if (source == null) {
            return -1;
        }
        final int[] offset = new int[]{-1};
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = resultIterator.getParserResult();
                    Node root = AstUtilities.getRoot(result);
                    if (root == null) {
                        return;
                    }
                    MethodDefNode method = AstUtilities.findMethod(root, methodName, Arity.UNKNOWN);
                    if (method != null) {
                        int startOffset;
                        offset[0] = startOffset = method.getPosition().getStartOffset();
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return offset[0];
    }

    public static void addNodesByType(Node root, NodeType[] nodeIds, List<Node> result) {
        for (int i = 0; i < nodeIds.length; ++i) {
            if (root.getNodeType() != nodeIds[i]) continue;
            result.add(root);
            break;
        }
        List list = root.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            AstUtilities.addNodesByType(child, nodeIds, result);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<Node> getApplicableBlocks(AstPath path, boolean includeNested) {
        Node block = AstUtilities.findBlock(path);
        if (block == null && (block = path.leafParent()) == null) {
            return Collections.emptyList();
        }
        ArrayList<Node> result = new ArrayList<Node>();
        ListIterator<Node> it = path.leafToRoot();
        if (includeNested && it.hasNext()) {
            it.next();
        }
        Node leaf = path.root();
        block4: while (it.hasNext()) {
            Node n = (Node)it.next();
            switch (n.getNodeType()) {
                case ITERNODE: {
                    leaf = n;
                    result.add(n);
                    break;
                }
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    leaf = n;
                    break block4;
                }
            }
        }
        if (includeNested) {
            AstUtilities.addNodesByType(leaf, new NodeType[]{NodeType.ITERNODE}, result);
        }
        return result;
    }

    public static String guessName(Parser.Result result, OffsetRange lexRange, OffsetRange astRange) {
        String guessedName = "";
        IndexedMethod[] methodHolder = new IndexedMethod[1];
        Set[] alternatesHolder = new Set[1];
        int[] paramIndexHolder = new int[1];
        int[] anchorOffsetHolder = new int[1];
        if (!RubyMethodCompleter.computeMethodCall(result, lexRange.getStart(), astRange.getStart(), methodHolder, paramIndexHolder, anchorOffsetHolder, alternatesHolder, QuerySupport.Kind.PREFIX)) {
            return guessedName;
        }
        IndexedMethod targetMethod = methodHolder[0];
        int index = paramIndexHolder[0];
        List<String> params = targetMethod.getParameters();
        if (params == null || params.size() <= index) {
            return guessedName;
        }
        String s = params.get(index);
        if (s.startsWith("*") || s.startsWith("&")) {
            s = s.substring(1);
        }
        return s;
    }

    public static Set<String> getUsedFields(RubyIndex index, AstPath path) {
        String fqn = AstUtilities.getFqnName(path);
        if (fqn == null || fqn.length() == 0) {
            return Collections.emptySet();
        }
        Set<IndexedField> fields = index.getInheritedFields(fqn, "", QuerySupport.Kind.PREFIX, false);
        HashSet<String> fieldNames = new HashSet<String>();
        for (IndexedField f : fields) {
            fieldNames.add(f.getName());
        }
        return fieldNames;
    }

    public static Set<String> getUsedMethods(RubyIndex index, AstPath path) {
        String fqn = AstUtilities.getFqnName(path);
        if (fqn == null || fqn.length() == 0) {
            return Collections.emptySet();
        }
        Set<IndexedMethod> methods = index.getInheritedMethods(fqn, "", QuerySupport.Kind.PREFIX);
        HashSet<String> methodNames = new HashSet<String>();
        for (IndexedMethod m : methods) {
            methodNames.add(m.getName());
        }
        return methodNames;
    }

    public static Set<String> getUsedConstants(RubyIndex index, AstPath path) {
        return Collections.emptySet();
    }

    public static Set<String> getUsedLocalNames(AstPath path, Node closest) {
        Node method = AstUtilities.findLocalScope(closest, path);
        HashMap<String, Node> variables = new HashMap<String, Node>();
        RubyCodeCompleter.addLocals(method, variables);
        List<Node> applicableBlocks = AstUtilities.getApplicableBlocks(path, false);
        for (Node block : applicableBlocks) {
            RubyCodeCompleter.addDynamic(block, variables);
        }
        return variables.keySet();
    }

    public static String getName(Node node) {
        if (node instanceof LiteralNode) {
            return ((LiteralNode)node).getName();
        }
        return ((INameNode)node).getName();
    }

    static String safeGetName(Node node) {
        if (node instanceof INameNode || node instanceof LiteralNode) {
            return AstUtilities.getName(node);
        }
        return null;
    }

    public static void findExitPoints(MethodDefNode defNode, Collection<? super Node> exits) {
        Node body = defNode.getBodyNode();
        if (body != null) {
            AstUtilities.findExitPoints(body, exits);
        }
    }

    static void findExitPoints(Node body, Collection<? super Node> exits) {
        AstUtilities.findNonLastExitPoints(body, exits);
        AstUtilities.findLastNodes(body, exits);
    }

    static List<String> getValuesAsFqn(ListNode args) {
        if (args.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(args.size());
        for (Node n : args.childNodes()) {
            if (n instanceof Colon2Node) {
                result.add(AstUtilities.getFqn((Colon2Node)n));
                continue;
            }
            if (!(n instanceof INameNode)) continue;
            result.add(AstUtilities.getName(n));
        }
        return result;
    }

    private static void findLastNodes(Node node, Collection<? super Node> result) {
        if (node == null) {
            return;
        }
        List<Node> children = AstUtilities.findExitChidren(node);
        if (children.isEmpty()) {
            result.add((Node)node);
            return;
        }
        for (Node child : children) {
            if (child instanceof ArgsNode || child instanceof ArgumentNode) {
                result.add((Node)node);
                return;
            }
            AstUtilities.findLastNodes(child, result);
        }
    }

    private static List<Node> findExitChidren(Node node) {
        if (node instanceof IfNode) {
            IfNode ifNode = (IfNode)node;
            return Arrays.asList(ifNode.getThenBody(), ifNode.getElseBody());
        }
        if (node instanceof CaseNode) {
            CaseNode caseNode = (CaseNode)node;
            ListNode cases = caseNode.getCases();
            ArrayList<Node> result = new ArrayList<Node>(cases.childNodes());
            result.add(caseNode.getElseNode());
            return result;
        }
        if (node instanceof WhenNode) {
            WhenNode whenNode = (WhenNode)node;
            return Collections.singletonList(whenNode.getBodyNode());
        }
        if (node instanceof OrNode) {
            return node.childNodes();
        }
        if (node instanceof AndNode) {
            return Collections.singletonList(((AndNode)node).getSecondNode());
        }
        if (node instanceof ReturnNode || AstUtilities.isCall(node) || node instanceof ILiteralNode || node instanceof HashNode || node instanceof DotNode || node instanceof NotNode || node instanceof UntilNode || node instanceof DefinedNode) {
            return Collections.emptyList();
        }
        if (node instanceof RescueNode) {
            return node.childNodes();
        }
        List children = node.childNodes();
        if (!children.isEmpty()) {
            Node lastChild = (Node)children.get(children.size() - 1);
            return Collections.singletonList(lastChild);
        }
        return children;
    }

    private static void findNonLastExitPoints(Node node, Collection<? super Node> exits) {
        switch (node.getNodeType()) {
            case RETURNNODE: 
            case YIELDNODE: {
                exits.add((Node)node);
                break;
            }
            case CLASSNODE: 
            case SCLASSNODE: 
            case MODULENODE: {
                return;
            }
            case FCALLNODE: {
                FCallNode fc = (FCallNode)node;
                if (!"fail".equals(fc.getName()) && !"raise".equals(fc.getName())) break;
                exits.add((Node)node);
            }
        }
        if (node instanceof MethodDefNode) {
            return;
        }
        List children = node.childNodes();
        for (Node child : children) {
            if (child.isInvisible()) continue;
            AstUtilities.findNonLastExitPoints(child, exits);
        }
    }
}

