/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.catalog.impl;

import org.netbeans.modules.websvc.jaxws.catalog.Catalog;
import org.netbeans.modules.websvc.jaxws.catalog.CatalogComponent;
import org.netbeans.modules.websvc.jaxws.catalog.CatalogComponentFactory;
import org.netbeans.modules.websvc.jaxws.catalog.CatalogQNames;
import org.netbeans.modules.websvc.jaxws.catalog.CatalogVisitor;
import org.netbeans.modules.websvc.jaxws.catalog.NextCatalog;
import org.netbeans.modules.websvc.jaxws.catalog.System;
import org.netbeans.modules.websvc.jaxws.catalog.impl.CatalogImpl;
import org.netbeans.modules.websvc.jaxws.catalog.impl.CatalogModelImpl;
import org.netbeans.modules.websvc.jaxws.catalog.impl.NextCatalogImpl;
import org.netbeans.modules.websvc.jaxws.catalog.impl.SystemImpl;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CatalogComponentFactoryImpl
implements CatalogComponentFactory {
    private CatalogModelImpl model;

    public CatalogComponentFactoryImpl(CatalogModelImpl catalogModelImpl) {
        this.model = catalogModelImpl;
    }

    @Override
    public CatalogComponent create(Element element, CatalogComponent catalogComponent) {
        if (catalogComponent == null) {
            if (CatalogComponentFactoryImpl.areSameQName(CatalogQNames.CATALOG, element)) {
                return new CatalogImpl(this.model, element);
            }
            return null;
        }
        return new CreateVisitor().create(element, catalogComponent);
    }

    @Override
    public NextCatalog createNextCatalog() {
        return new NextCatalogImpl(this.model);
    }

    @Override
    public System createSystem() {
        return new SystemImpl(this.model);
    }

    @Override
    public Catalog createCatalog() {
        return new CatalogImpl(this.model);
    }

    public static boolean areSameQName(CatalogQNames catalogQNames, Element element) {
        return catalogQNames.getQName().equals(AbstractDocumentComponent.getQName((Node)element));
    }

    public static class CreateVisitor
    extends CatalogVisitor.Default {
        Element element;
        CatalogComponent created;

        CatalogComponent create(Element element, CatalogComponent catalogComponent) {
            this.element = element;
            catalogComponent.accept(this);
            return this.created;
        }

        private boolean isElementQName(CatalogQNames catalogQNames) {
            return CatalogComponentFactoryImpl.areSameQName(catalogQNames, this.element);
        }

        @Override
        public void visit(Catalog catalog) {
            if (this.isElementQName(CatalogQNames.SYSTEM)) {
                this.created = new SystemImpl((CatalogModelImpl)catalog.getModel(), this.element);
            }
            if (this.isElementQName(CatalogQNames.NEXTCATALOG)) {
                this.created = new NextCatalogImpl((CatalogModelImpl)catalog.getModel(), this.element);
            }
        }

        @Override
        public void visit(System system) {
        }

        @Override
        public void visit(NextCatalog nextCatalog) {
        }
    }
}

