/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;

public class ReverseRangeIterator
implements SequenceIterator,
ReversibleIterator,
LastPositionFinder,
LookaheadIterator {
    long start;
    long currentValue;
    long limit;

    public ReverseRangeIterator(long start, long end) {
        this.start = start;
        this.currentValue = start + 1L;
        this.limit = end;
    }

    public boolean hasNext() {
        return this.currentValue > this.limit;
    }

    public Item next() {
        if (--this.currentValue < this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    public Item current() {
        if (this.currentValue < this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    public int position() {
        if (this.currentValue < this.limit) {
            return -1;
        }
        return (int)(this.start - this.currentValue + 1L);
    }

    public int getLastPosition() {
        return (int)(this.start - this.limit + 1L);
    }

    public SequenceIterator getAnother() throws XPathException {
        return new ReverseRangeIterator(this.start, this.limit);
    }

    public int getProperties() {
        return 6;
    }

    public SequenceIterator getReverseIterator() {
        return new RangeIterator(this.limit, this.start);
    }
}

