/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.h2.api.DatabaseEventListener;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.DatabaseCloser;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Engine;
import org.h2.engine.FunctionAlias;
import org.h2.engine.MetaRecord;
import org.h2.engine.Mode;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.jdbc.JdbcSQLException;
import org.h2.log.LogSystem;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.DiskFile;
import org.h2.store.FileLock;
import org.h2.store.FileStore;
import org.h2.store.PageStore;
import org.h2.store.RecordReader;
import org.h2.store.Storage;
import org.h2.store.WriterThread;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.table.TableLinkConnection;
import org.h2.table.TableView;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.h2.util.BitField;
import org.h2.util.ByteUtils;
import org.h2.util.ClassUtils;
import org.h2.util.FileUtils;
import org.h2.util.IntHashMap;
import org.h2.util.MemoryUtils;
import org.h2.util.NetUtils;
import org.h2.util.ObjectArray;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueLob;

public class Database
implements DataHandler {
    private static int initialPowerOffCount;
    private final boolean persistent;
    private final String databaseName;
    private final String databaseShortName;
    private final String databaseURL;
    private final String cipher;
    private final byte[] filePasswordHash;
    private final HashMap roles = new HashMap();
    private final HashMap users = new HashMap();
    private final HashMap settings = new HashMap();
    private final HashMap schemas = new HashMap();
    private final HashMap rights = new HashMap();
    private final HashMap functionAliases = new HashMap();
    private final HashMap userDataTypes = new HashMap();
    private final HashMap aggregates = new HashMap();
    private final HashMap comments = new HashMap();
    private IntHashMap tableMap = new IntHashMap();
    private final Set userSessions = Collections.synchronizedSet(new HashSet());
    private Session exclusiveSession;
    private final BitField objectIds = new BitField();
    private final Object lobSyncObject = new Object();
    private Schema mainSchema;
    private Schema infoSchema;
    private int nextSessionId;
    private User systemUser;
    private Session systemSession;
    private TableData meta;
    private Index metaIdIndex;
    private FileLock lock;
    private LogSystem log;
    private WriterThread writer;
    private IntHashMap storageMap = new IntHashMap();
    private boolean starting;
    private DiskFile fileData;
    private DiskFile fileIndex;
    private TraceSystem traceSystem;
    private DataPage dummy;
    private int fileLockMethod;
    private Role publicRole;
    private long modificationDataId;
    private long modificationMetaId;
    private CompareMode compareMode;
    private String cluster = "''";
    private boolean readOnly;
    private boolean noDiskSpace;
    private int writeDelay = 500;
    private DatabaseEventListener eventListener;
    private int maxMemoryRows = 10000;
    private int maxMemoryUndo = SysProperties.DEFAULT_MAX_MEMORY_UNDO;
    private int lockMode = SysProperties.DEFAULT_LOCK_MODE;
    private boolean logIndexChanges;
    private int logLevel = 1;
    private int maxLengthInplaceLob = 1024;
    private int allowLiterals = 2;
    private int powerOffCount = initialPowerOffCount;
    private int closeDelay;
    private DatabaseCloser delayedCloser;
    private boolean recovery;
    private volatile boolean closing;
    private boolean ignoreCase;
    private boolean deleteFilesOnDisconnect;
    private String lobCompressionAlgorithm;
    private boolean optimizeReuseResults = true;
    private String cacheType;
    private boolean indexSummaryValid = true;
    private String accessModeLog;
    private String accessModeData;
    private boolean referentialIntegrity = true;
    private boolean multiVersion;
    private DatabaseCloser closeOnExit;
    private Mode mode = Mode.getInstance("REGULAR");
    private boolean multiThreaded;
    private int maxOperationMemory = SysProperties.DEFAULT_MAX_OPERATION_MEMORY;
    private boolean lobFilesInDirectories = SysProperties.LOB_FILES_IN_DIRECTORIES;
    private SmallLRUCache lobFileListCache = new SmallLRUCache(128);
    private boolean autoServerMode;
    private Server server;
    private HashMap linkConnections;
    private TempFileDeleter tempFileDeleter = TempFileDeleter.getInstance();
    private PageStore pageStore;

    public Database(String string, ConnectionInfo connectionInfo, String string2) throws SQLException {
        String string3;
        String string4;
        this.compareMode = new CompareMode(null, null, 0);
        this.persistent = connectionInfo.isPersistent();
        this.filePasswordHash = connectionInfo.getFilePasswordHash();
        this.databaseName = string;
        this.databaseShortName = this.parseDatabaseShortName();
        this.cipher = string2;
        String string5 = connectionInfo.removeProperty("FILE_LOCK", null);
        this.accessModeLog = connectionInfo.removeProperty("ACCESS_MODE_LOG", "rw").toLowerCase();
        this.accessModeData = connectionInfo.removeProperty("ACCESS_MODE_DATA", "rw").toLowerCase();
        this.autoServerMode = connectionInfo.removeProperty("AUTO_SERVER", false);
        if ("r".equals(this.accessModeData)) {
            this.readOnly = true;
            this.accessModeLog = "r";
        }
        this.fileLockMethod = FileLock.getFileLockMethod(string5);
        this.databaseURL = connectionInfo.getURL();
        this.eventListener = connectionInfo.getDatabaseEventListenerObject();
        connectionInfo.removeDatabaseEventListenerObject();
        if (this.eventListener == null && (string4 = connectionInfo.removeProperty("DATABASE_EVENT_LISTENER", null)) != null) {
            string4 = StringUtils.trim(string4, true, true, "'");
            this.setEventListenerClass(string4);
        }
        if ((string4 = connectionInfo.getProperty(19, null)) != null) {
            this.logIndexChanges = "2".equals(string4);
        }
        if ((string3 = connectionInfo.getProperty("RECOVER", null)) != null) {
            this.recovery = true;
        }
        this.multiVersion = connectionInfo.removeProperty("MVCC", false);
        boolean bl = connectionInfo.removeProperty("DB_CLOSE_ON_EXIT", true);
        int n = connectionInfo.getIntProperty(10, 1);
        int n2 = connectionInfo.getIntProperty(9, 0);
        this.cacheType = StringUtils.toUpperEnglish(connectionInfo.removeProperty("CACHE_TYPE", "LRU"));
        try {
            this.open(n, n2);
            if (bl) {
                this.closeOnExit = new DatabaseCloser(this, 0, true);
                try {
                    Runtime.getRuntime().addShutdownHook(this.closeOnExit);
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (SecurityException securityException) {}
            }
        }
        catch (Exception exception) {
            if (this.traceSystem != null) {
                SQLException sQLException;
                if (exception instanceof SQLException && (sQLException = (SQLException)exception).getErrorCode() != 90020) {
                    this.traceSystem.getTrace("database").error("opening " + this.databaseName, exception);
                }
                this.traceSystem.close();
            }
            this.closeOpenFilesAndUnlock();
            throw Message.convert(exception);
        }
    }

    public static void setInitialPowerOffCount(int n) {
        initialPowerOffCount = n;
    }

    public void setPowerOffCount(int n) {
        if (this.powerOffCount == -1) {
            return;
        }
        this.powerOffCount = n;
    }

    public boolean areEqual(Value value, Value value2) throws SQLException {
        return value.compareTo(value2, this.compareMode) == 0;
    }

    public int compare(Value value, Value value2) throws SQLException {
        return value.compareTo(value2, this.compareMode);
    }

    public int compareTypeSave(Value value, Value value2) throws SQLException {
        return value.compareTypeSave(value2, this.compareMode);
    }

    public long getModificationDataId() {
        return this.modificationDataId;
    }

    public long getNextModificationDataId() {
        return ++this.modificationDataId;
    }

    public long getModificationMetaId() {
        return this.modificationMetaId;
    }

    public long getNextModificationMetaId() {
        ++this.modificationDataId;
        return this.modificationMetaId++;
    }

    public int getPowerOffCount() {
        return this.powerOffCount;
    }

    public void checkPowerOff() throws SQLException {
        if (this.powerOffCount == 0) {
            return;
        }
        if (this.powerOffCount > 1) {
            --this.powerOffCount;
            return;
        }
        if (this.powerOffCount != -1) {
            try {
                this.powerOffCount = -1;
                if (this.log != null) {
                    try {
                        this.stopWriter();
                        this.log.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.log = null;
                }
                if (this.fileData != null) {
                    try {
                        this.fileData.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.fileData = null;
                }
                if (this.fileIndex != null) {
                    try {
                        this.fileIndex.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.fileIndex = null;
                }
                if (this.pageStore != null) {
                    try {
                        this.pageStore.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.pageStore = null;
                }
                if (this.lock != null) {
                    this.stopServer();
                    this.lock.unlock();
                    this.lock = null;
                }
            }
            catch (Exception exception) {
                TraceSystem.traceThrowable(exception);
            }
        }
        Engine.getInstance().close(this.databaseName);
        throw Message.getSQLException(90098);
    }

    public static boolean exists(String string) {
        return FileUtils.exists(string + ".data.db");
    }

    public Trace getTrace(String string) {
        return this.traceSystem.getTrace(string);
    }

    public FileStore openFile(String string, String string2, boolean bl) throws SQLException {
        if (bl && !FileUtils.exists(string)) {
            throw Message.getSQLException(90124, string);
        }
        FileStore fileStore = FileStore.open(this, string, string2, this.cipher, this.filePasswordHash);
        try {
            fileStore.init();
        }
        catch (SQLException sQLException) {
            fileStore.closeSilently();
            throw sQLException;
        }
        return fileStore;
    }

    public boolean validateFilePasswordHash(String string, byte[] byArray) throws SQLException {
        if (!StringUtils.equals(string, this.cipher)) {
            return false;
        }
        return ByteUtils.compareSecure(byArray, this.filePasswordHash);
    }

    private void openFileData() throws SQLException {
        this.fileData = new DiskFile(this, this.databaseName + ".data.db", this.accessModeData, true, true, SysProperties.CACHE_SIZE_DEFAULT);
    }

    private void openFileIndex() throws SQLException {
        this.fileIndex = new DiskFile(this, this.databaseName + ".index.db", this.accessModeData, false, this.logIndexChanges, SysProperties.CACHE_SIZE_INDEX_DEFAULT);
    }

    public DataPage getDataPage() {
        return this.dummy;
    }

    private String parseDatabaseShortName() {
        String string = this.databaseName;
        if (string.endsWith(":")) {
            string = null;
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/\\:,;");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        if (string == null || string.length() == 0) {
            string = "UNNAMED";
        }
        return StringUtils.toUpperEnglish(string);
    }

    private synchronized void open(int n, int n2) throws SQLException {
        PageStore pageStore;
        Object object;
        Object object2;
        if (this.persistent) {
            if (SysProperties.PAGE_STORE && FileUtils.exists((String)(object2 = this.databaseName + ".h2.db")) && FileUtils.isReadOnly((String)object2)) {
                this.readOnly = true;
            }
            if (FileUtils.exists((String)(object2 = this.databaseName + ".data.db"))) {
                this.readOnly |= FileUtils.isReadOnly((String)object2);
            }
            this.traceSystem = this.readOnly ? new TraceSystem(null, false) : new TraceSystem(this.databaseName + ".trace.db", true);
            this.traceSystem.setLevelFile(n);
            this.traceSystem.setLevelSystemOut(n2);
            this.traceSystem.getTrace("database").info("opening " + this.databaseName + " (build " + 107 + ")");
            if (this.autoServerMode && (this.readOnly || this.fileLockMethod == 0)) {
                throw Message.getSQLException(50100);
            }
            if (!this.readOnly && this.fileLockMethod != 0) {
                this.lock = new FileLock(this.traceSystem, 1000);
                this.lock.lock(this.databaseName + ".lock.db", this.fileLockMethod == 2);
                if (this.autoServerMode) {
                    this.startServer(this.lock.getUniqueId());
                }
            }
            if (SysProperties.PAGE_STORE && !((PageStore)(object = this.getPageStore())).isNew()) {
                ((PageStore)object).getLog().recover(true);
            }
            if (FileUtils.exists((String)object2)) {
                this.lobFilesInDirectories &= !ValueLob.existsLobFile(this.getDatabasePath());
                this.lobFilesInDirectories |= FileUtils.exists(this.databaseName + ".lobs.db");
            }
            this.dummy = DataPage.create((DataHandler)this, 0);
            this.deleteOldTempFiles();
            this.log = new LogSystem(this, this.databaseName, this.readOnly, this.accessModeLog, this.pageStore);
            this.openFileData();
            this.log.open();
            this.openFileIndex();
            this.log.recover();
            this.fileData.init();
            try {
                this.fileIndex.init();
            }
            catch (Exception exception) {
                if (this.recovery) {
                    this.traceSystem.getTrace("database").error("opening index", exception);
                    ArrayList arrayList = new ArrayList(this.storageMap.values());
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Storage storage = (Storage)arrayList.get(i);
                        if (storage.getDiskFile() != this.fileIndex) continue;
                        this.removeStorage(storage.getId(), this.fileIndex);
                    }
                    this.fileIndex.delete();
                    this.openFileIndex();
                }
                throw Message.convert(exception);
            }
            this.reserveLobFileObjectIds();
            this.writer = WriterThread.create(this, this.writeDelay);
        } else {
            this.traceSystem = new TraceSystem(null, false);
            this.log = new LogSystem(null, null, false, null, null);
        }
        this.systemUser = new User(this, 0, "DBA", true);
        this.mainSchema = new Schema(this, 0, "PUBLIC", this.systemUser, true);
        this.infoSchema = new Schema(this, -1, "INFORMATION_SCHEMA", this.systemUser, true);
        this.schemas.put(this.mainSchema.getName(), this.mainSchema);
        this.schemas.put(this.infoSchema.getName(), this.infoSchema);
        this.publicRole = new Role(this, 0, "PUBLIC", true);
        this.roles.put("PUBLIC", this.publicRole);
        this.systemUser.setAdmin(true);
        this.systemSession = new Session(this, this.systemUser, ++this.nextSessionId);
        object2 = new ObjectArray();
        object = new Column("ID", 4);
        ((Column)object).setNullable(false);
        ((ObjectArray)object2).add(object);
        ((ObjectArray)object2).add(new Column("HEAD", 4));
        ((ObjectArray)object2).add(new Column("TYPE", 4));
        ((ObjectArray)object2).add(new Column("SQL", 13));
        int n3 = 0;
        if (this.pageStore != null) {
            n3 = this.pageStore.getSystemRootPageId();
        }
        this.meta = this.mainSchema.createTable("SYS", 0, (ObjectArray)object2, this.persistent, false, n3);
        this.tableMap.put(0, this.meta);
        IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{object});
        this.metaIdIndex = this.meta.addIndex(this.systemSession, "SYS_ID", 0, indexColumnArray, IndexType.createPrimaryKey(false, false), -1, null);
        this.objectIds.set(0);
        for (int i = 0; i < MetaTable.getMetaTableTypeCount(); ++i) {
            this.addMetaData(i);
        }
        this.starting = true;
        Cursor cursor = this.metaIdIndex.find(this.systemSession, null, null);
        ObjectArray objectArray = new ObjectArray();
        while (cursor.next()) {
            MetaRecord metaRecord = new MetaRecord(cursor.get());
            this.objectIds.set(metaRecord.getId());
            objectArray.add(metaRecord);
        }
        MetaRecord.sort(objectArray);
        for (int i = 0; i < objectArray.size(); ++i) {
            MetaRecord metaRecord = (MetaRecord)objectArray.get(i);
            metaRecord.execute(this, this.systemSession, this.eventListener);
        }
        if (SysProperties.PAGE_STORE && !(pageStore = this.getPageStore()).isNew()) {
            this.getPageStore().getLog().recover(false);
            pageStore.checkpoint();
        }
        this.recompileInvalidViews(this.systemSession);
        this.starting = false;
        this.addDefaultSetting(this.systemSession, 6, null, 2000);
        this.addDefaultSetting(this.systemSession, 7, null, 0);
        this.addDefaultSetting(this.systemSession, 8, null, SysProperties.CACHE_SIZE_DEFAULT);
        this.addDefaultSetting(this.systemSession, 13, "''", 0);
        this.addDefaultSetting(this.systemSession, 14, null, 500);
        this.addDefaultSetting(this.systemSession, 34, null, 107);
        if (!this.readOnly) {
            this.removeUnusedStorages(this.systemSession);
        }
        this.systemSession.commit(true);
        this.traceSystem.getTrace("database").info("opened " + this.databaseName);
    }

    private void startServer(String string) throws SQLException {
        this.server = Server.createTcpServer(new String[]{"-tcpPort", "0", "-tcpAllowOthers", "true", "-key", string, this.databaseName});
        this.server.start();
        String string2 = NetUtils.getLocalAddress() + ":" + this.server.getPort();
        this.lock.addProperty("server", string2);
    }

    private void stopServer() {
        if (this.server != null) {
            Server server = this.server;
            this.server = null;
            server.stop();
        }
    }

    private void recompileInvalidViews(Session session) {
        TableView tableView;
        DbObject dbObject;
        int n;
        ObjectArray objectArray;
        boolean bl;
        do {
            bl = false;
            objectArray = this.getAllSchemaObjects(0);
            for (n = 0; n < objectArray.size(); ++n) {
                dbObject = (DbObject)objectArray.get(n);
                if (!(dbObject instanceof TableView) || !(tableView = (TableView)dbObject).getInvalid()) continue;
                try {
                    tableView.recompile(session);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (tableView.getInvalid()) continue;
                bl = true;
            }
        } while (bl);
        objectArray = this.getAllSchemaObjects(0);
        for (n = 0; n < objectArray.size(); ++n) {
            dbObject = (DbObject)objectArray.get(n);
            if (!(dbObject instanceof TableView) || (tableView = (TableView)dbObject).getInvalid()) continue;
            try {
                tableView.recompile(this.systemSession);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void removeUnusedStorages(Session session) throws SQLException {
        if (this.persistent) {
            ObjectArray objectArray = this.getAllStorages();
            for (int i = 0; i < objectArray.size(); ++i) {
                Storage storage = (Storage)objectArray.get(i);
                if (storage == null || storage.getRecordReader() != null) continue;
                storage.truncate(session);
            }
        }
    }

    private void addDefaultSetting(Session session, int n, String string, int n2) throws SQLException {
        if (this.readOnly) {
            return;
        }
        String string2 = SetTypes.getTypeName(n);
        if (this.settings.get(string2) == null) {
            Setting setting = new Setting(this, this.allocateObjectId(false, true), string2);
            if (string == null) {
                setting.setIntValue(n2);
            } else {
                setting.setStringValue(string);
            }
            this.addDatabaseObject(session, setting);
        }
    }

    public void removeStorage(int n, DiskFile diskFile) {
        Storage storage;
        if (SysProperties.CHECK && ((storage = (Storage)this.storageMap.get(n)) == null || storage.getDiskFile() != diskFile)) {
            Message.throwInternalError();
        }
        this.storageMap.remove(n);
    }

    public Storage getStorage(int n, DiskFile diskFile) {
        Storage storage = (Storage)this.storageMap.get(n);
        if (storage != null) {
            if (SysProperties.CHECK && storage.getDiskFile() != diskFile) {
                Message.throwInternalError();
            }
        } else {
            storage = new Storage(this, diskFile, null, n);
            this.storageMap.put(n, storage);
        }
        return storage;
    }

    private void addMetaData(int n) throws SQLException {
        MetaTable metaTable = new MetaTable(this.infoSchema, -1 - n, n);
        this.infoSchema.add(metaTable);
    }

    private synchronized void addMeta(Session session, DbObject dbObject) throws SQLException {
        if (dbObject.getTemporary()) {
            return;
        }
        Row row = this.meta.getTemplateRow();
        MetaRecord metaRecord = new MetaRecord(dbObject);
        metaRecord.setRecord(row);
        this.objectIds.set(dbObject.getId());
        this.meta.lock(session, true, true);
        this.meta.addRow(session, row);
        if (this.isMultiVersion()) {
            session.log(this.meta, (short)0, row);
        }
    }

    public synchronized void removeMeta(Session session, int n) throws SQLException {
        SearchRow searchRow = this.meta.getTemplateSimpleRow(false);
        searchRow.setValue(0, ValueInt.get(n));
        Cursor cursor = this.metaIdIndex.find(session, searchRow, searchRow);
        if (cursor.next()) {
            Row row = cursor.get();
            this.meta.lock(session, true, true);
            this.meta.removeRow(session, row);
            if (this.isMultiVersion()) {
                session.log(this.meta, (short)1, row);
            }
            this.objectIds.clear(n);
            if (SysProperties.CHECK) {
                this.checkMetaFree(session, n);
            }
        }
    }

    private HashMap getMap(int n) {
        switch (n) {
            case 2: {
                return this.users;
            }
            case 6: {
                return this.settings;
            }
            case 7: {
                return this.roles;
            }
            case 8: {
                return this.rights;
            }
            case 9: {
                return this.functionAliases;
            }
            case 10: {
                return this.schemas;
            }
            case 12: {
                return this.userDataTypes;
            }
            case 13: {
                return this.comments;
            }
            case 14: {
                return this.aggregates;
            }
        }
        throw Message.throwInternalError("type=" + n);
    }

    public synchronized void addSchemaObject(Session session, SchemaObject schemaObject) throws SQLException {
        int n = schemaObject.getId();
        if (n > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        schemaObject.getSchema().add(schemaObject);
        if (n > 0 && !this.starting) {
            this.addMeta(session, schemaObject);
        }
        if (schemaObject instanceof TableData) {
            this.tableMap.put(n, schemaObject);
        }
    }

    public synchronized void addDatabaseObject(Session session, DbObject dbObject) throws SQLException {
        Object object;
        int n = dbObject.getId();
        if (n > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        HashMap hashMap = this.getMap(dbObject.getType());
        if (dbObject.getType() == 2 && ((User)(object = (User)dbObject)).getAdmin() && this.systemUser.getName().equals("DBA")) {
            this.systemUser.rename(((DbObjectBase)object).getName());
        }
        object = dbObject.getName();
        if (SysProperties.CHECK && hashMap.get(object) != null) {
            Message.throwInternalError("object already exists");
        }
        if (n > 0 && !this.starting) {
            this.addMeta(session, dbObject);
        }
        hashMap.put(object, dbObject);
    }

    public UserAggregate findAggregate(String string) {
        return (UserAggregate)this.aggregates.get(string);
    }

    public Comment findComment(DbObject dbObject) {
        if (dbObject.getType() == 13) {
            return null;
        }
        String string = Comment.getKey(dbObject);
        return (Comment)this.comments.get(string);
    }

    public FunctionAlias findFunctionAlias(String string) {
        return (FunctionAlias)this.functionAliases.get(string);
    }

    public Role findRole(String string) {
        return (Role)this.roles.get(string);
    }

    public Schema findSchema(String string) {
        return (Schema)this.schemas.get(string);
    }

    public Setting findSetting(String string) {
        return (Setting)this.settings.get(string);
    }

    public User findUser(String string) {
        return (User)this.users.get(string);
    }

    public UserDataType findUserDataType(String string) {
        return (UserDataType)this.userDataTypes.get(string);
    }

    public User getUser(String string) throws SQLException {
        User user = this.findUser(string);
        if (user == null) {
            throw Message.getSQLException(90032, string);
        }
        return user;
    }

    public synchronized Session createSession(User user) throws SQLException {
        if (this.exclusiveSession != null) {
            throw Message.getSQLException(90135);
        }
        Session session = new Session(this, user, ++this.nextSessionId);
        this.userSessions.add(session);
        this.traceSystem.getTrace("session").info("connecting #" + session.getId() + " to " + this.databaseName);
        if (this.delayedCloser != null) {
            this.delayedCloser.reset();
            this.delayedCloser = null;
        }
        return session;
    }

    public synchronized void removeSession(Session session) {
        if (session != null) {
            if (this.exclusiveSession == session) {
                this.exclusiveSession = null;
            }
            this.userSessions.remove(session);
            if (session != this.systemSession) {
                this.traceSystem.getTrace("session").info("disconnecting #" + session.getId());
            }
        }
        if (this.userSessions.size() == 0 && session != this.systemSession) {
            if (this.closeDelay == 0) {
                this.close(false);
            } else {
                if (this.closeDelay < 0) {
                    return;
                }
                this.delayedCloser = new DatabaseCloser(this, this.closeDelay * 1000, false);
                this.delayedCloser.setName("H2 Close Delay " + this.getShortName());
                this.delayedCloser.setDaemon(true);
                this.delayedCloser.start();
            }
        }
        if (session != this.systemSession && session != null) {
            this.traceSystem.getTrace("session").info("disconnected #" + session.getId());
        }
    }

    synchronized void close(boolean bl) {
        Object object;
        int n;
        Object object2;
        if (this.closing) {
            return;
        }
        if (MemoryUtils.isShutdown()) {
            try {
                this.traceSystem.getTrace("database").error("already shut down");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.closing = true;
        this.stopServer();
        if (this.userSessions.size() > 0) {
            if (!bl) {
                return;
            }
            this.traceSystem.getTrace("database").info("closing " + this.databaseName + " from shutdown hook");
            object2 = new Session[this.userSessions.size()];
            this.userSessions.toArray((T[])object2);
            for (n = 0; n < ((Object)object2).length; ++n) {
                object = object2[n];
                try {
                    ((Session)object).close();
                    continue;
                }
                catch (SQLException sQLException) {
                    this.traceSystem.getTrace("session").error("disconnecting #" + ((Session)object).getId(), sQLException);
                }
            }
        }
        if (this.log != null) {
            this.log.setDisabled(false);
        }
        this.traceSystem.getTrace("database").info("closing " + this.databaseName);
        if (this.eventListener != null) {
            this.closing = false;
            object2 = this.eventListener;
            this.eventListener = null;
            object2.closingDatabase();
            if (this.userSessions.size() > 0) {
                return;
            }
            this.closing = true;
        }
        try {
            if (this.systemSession != null) {
                object2 = this.getAllSchemaObjects(0);
                for (n = 0; n < ((ObjectArray)object2).size(); ++n) {
                    object = (Table)((ObjectArray)object2).get(n);
                    ((Table)object).close(this.systemSession);
                }
                ObjectArray objectArray = this.getAllSchemaObjects(3);
                for (int i = 0; i < objectArray.size(); ++i) {
                    Sequence sequence = (Sequence)objectArray.get(i);
                    sequence.close();
                }
                ObjectArray objectArray2 = this.getAllSchemaObjects(4);
                for (int i = 0; i < objectArray2.size(); ++i) {
                    TriggerObject triggerObject = (TriggerObject)objectArray2.get(i);
                    triggerObject.close();
                }
                this.meta.close(this.systemSession);
                this.systemSession.commit(true);
                this.indexSummaryValid = true;
            }
        }
        catch (SQLException sQLException) {
            this.traceSystem.getTrace("database").error("close", sQLException);
        }
        if (this.persistent) {
            try {
                ValueLob.removeAllForTable(this, -1);
            }
            catch (SQLException sQLException) {
                this.traceSystem.getTrace("database").error("close", sQLException);
            }
        }
        this.tempFileDeleter.deleteAll();
        try {
            this.closeOpenFilesAndUnlock();
        }
        catch (SQLException sQLException) {
            this.traceSystem.getTrace("database").error("close", sQLException);
        }
        this.traceSystem.getTrace("database").info("closed");
        this.traceSystem.close();
        if (this.closeOnExit != null) {
            this.closeOnExit.reset();
            try {
                Runtime.getRuntime().removeShutdownHook(this.closeOnExit);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.closeOnExit = null;
        }
        Engine.getInstance().close(this.databaseName);
        if (this.deleteFilesOnDisconnect && this.persistent) {
            this.deleteFilesOnDisconnect = false;
            try {
                object2 = FileUtils.getParent(this.databaseName);
                String string = FileUtils.getFileName(this.databaseName);
                DeleteDbFiles.execute((String)object2, string, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopWriter() {
        if (this.writer != null) {
            try {
                this.writer.stopThread();
            }
            catch (SQLException sQLException) {
                this.traceSystem.getTrace("database").error("close", sQLException);
            }
            this.writer = null;
        }
    }

    private synchronized void closeOpenFilesAndUnlock() throws SQLException {
        if (this.log != null) {
            this.stopWriter();
            try {
                this.log.close();
            }
            catch (Throwable throwable) {
                this.traceSystem.getTrace("database").error("close", throwable);
            }
            this.log = null;
        }
        if (this.pageStore != null) {
            this.pageStore.checkpoint();
        }
        this.closeFiles();
        if (this.persistent && this.lock == null && this.fileLockMethod != 0) {
            return;
        }
        if (this.persistent) {
            this.deleteOldTempFiles();
        }
        if (this.systemSession != null) {
            this.systemSession.close();
            this.systemSession = null;
        }
        if (this.lock != null) {
            this.lock.unlock();
            this.lock = null;
        }
    }

    private void closeFiles() {
        try {
            if (this.fileData != null) {
                this.fileData.close();
                this.fileData = null;
            }
            if (this.fileIndex != null) {
                this.fileIndex.close();
                this.fileIndex = null;
            }
            if (this.pageStore != null) {
                this.pageStore.close();
                this.pageStore = null;
            }
        }
        catch (SQLException sQLException) {
            this.traceSystem.getTrace("database").error("close", sQLException);
        }
        this.storageMap.clear();
    }

    private void checkMetaFree(Session session, int n) throws SQLException {
        SearchRow searchRow = this.meta.getTemplateSimpleRow(false);
        searchRow.setValue(0, ValueInt.get(n));
        Cursor cursor = this.metaIdIndex.find(session, searchRow, searchRow);
        if (cursor.next()) {
            Message.throwInternalError();
        }
    }

    public synchronized int allocateObjectId(boolean bl, boolean bl2) {
        int n;
        bl = true;
        if (bl) {
            n = this.objectIds.getLastSetBit() + 1;
            if ((n & 1) != (bl2 ? 1 : 0)) {
                ++n;
            }
            while (this.storageMap.get(n) != null || this.objectIds.get(n)) {
                if ((++n & 1) == (bl2 ? 1 : 0)) continue;
                ++n;
            }
        } else {
            n = this.objectIds.nextClearBit(0);
        }
        if (SysProperties.CHECK && this.objectIds.get(n)) {
            Message.throwInternalError();
        }
        this.objectIds.set(n);
        return n;
    }

    public ObjectArray getAllAggregates() {
        return new ObjectArray(this.aggregates.values());
    }

    public ObjectArray getAllComments() {
        return new ObjectArray(this.comments.values());
    }

    public ObjectArray getAllFunctionAliases() {
        return new ObjectArray(this.functionAliases.values());
    }

    public int getAllowLiterals() {
        if (this.starting) {
            return 2;
        }
        return this.allowLiterals;
    }

    public ObjectArray getAllRights() {
        return new ObjectArray(this.rights.values());
    }

    public ObjectArray getAllRoles() {
        return new ObjectArray(this.roles.values());
    }

    public ObjectArray getAllSchemaObjects(int n) {
        ObjectArray objectArray = new ObjectArray();
        Iterator iterator = this.schemas.values().iterator();
        while (iterator.hasNext()) {
            Schema schema = (Schema)iterator.next();
            objectArray.addAll(schema.getAll(n));
        }
        return objectArray;
    }

    public ObjectArray getAllSchemas() {
        return new ObjectArray(this.schemas.values());
    }

    public ObjectArray getAllSettings() {
        return new ObjectArray(this.settings.values());
    }

    public ObjectArray getAllStorages() {
        return new ObjectArray(this.storageMap.values());
    }

    public ObjectArray getAllUserDataTypes() {
        return new ObjectArray(this.userDataTypes.values());
    }

    public ObjectArray getAllUsers() {
        return new ObjectArray(this.users.values());
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public int getChecksum(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            n3 += byArray[n++];
        }
        return n3;
    }

    public String getCluster() {
        return this.cluster;
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    public String getDatabasePath() {
        if (this.persistent) {
            return FileUtils.getAbsolutePath(this.databaseName);
        }
        return null;
    }

    public String getShortName() {
        return this.databaseShortName;
    }

    public String getName() {
        return this.databaseName;
    }

    public LogSystem getLog() {
        return this.log;
    }

    public Session[] getSessions(boolean bl) {
        ArrayList<Session> arrayList = new ArrayList<Session>(this.userSessions);
        if (bl && this.systemSession != null) {
            arrayList.add(this.systemSession);
        }
        Session[] sessionArray = new Session[arrayList.size()];
        arrayList.toArray(sessionArray);
        return sessionArray;
    }

    public synchronized void update(Session session, DbObject dbObject) throws SQLException {
        int n = dbObject.getId();
        this.removeMeta(session, n);
        this.addMeta(session, dbObject);
    }

    public synchronized void renameSchemaObject(Session session, SchemaObject schemaObject, String string) throws SQLException {
        this.checkWritingAllowed();
        schemaObject.getSchema().rename(schemaObject, string);
        this.updateWithChildren(session, schemaObject);
    }

    private synchronized void updateWithChildren(Session session, DbObject dbObject) throws SQLException {
        ObjectArray objectArray = dbObject.getChildren();
        Comment comment = this.findComment(dbObject);
        if (comment != null) {
            Message.throwInternalError();
        }
        this.update(session, dbObject);
        for (int i = 0; objectArray != null && i < objectArray.size(); ++i) {
            DbObject dbObject2 = (DbObject)objectArray.get(i);
            if (dbObject2.getCreateSQL() == null) continue;
            this.update(session, dbObject2);
        }
    }

    public synchronized void renameDatabaseObject(Session session, DbObject dbObject, String string) throws SQLException {
        this.checkWritingAllowed();
        int n = dbObject.getType();
        HashMap hashMap = this.getMap(n);
        if (SysProperties.CHECK) {
            if (!hashMap.containsKey(dbObject.getName())) {
                Message.throwInternalError("not found: " + dbObject.getName());
            }
            if (dbObject.getName().equals(string) || hashMap.containsKey(string)) {
                Message.throwInternalError("object already exists: " + string);
            }
        }
        dbObject.checkRename();
        int n2 = dbObject.getId();
        this.removeMeta(session, n2);
        hashMap.remove(dbObject.getName());
        dbObject.rename(string);
        hashMap.put(string, dbObject);
        this.updateWithChildren(session, dbObject);
    }

    public String createTempFile() throws SQLException {
        try {
            boolean bl = this.readOnly;
            String string = this.databaseName;
            if (!this.persistent) {
                string = "memFS:" + string;
            }
            return FileUtils.createTempFile(string, ".temp.db", true, bl);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, this.databaseName);
        }
    }

    private void reserveLobFileObjectIds() throws SQLException {
        String string = FileUtils.normalize(this.databaseName) + ".";
        String string2 = FileUtils.getParent(this.databaseName);
        String[] stringArray = FileUtils.listFiles(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (!string3.endsWith(".lob.db") || !FileUtils.fileStartsWith(string3, string)) continue;
            string3 = string3.substring(string.length());
            int n = (string3 = string3.substring(0, string3.length() - ".lob.db".length())).indexOf(46);
            if (n < 0) continue;
            String string4 = string3.substring(n + 1);
            int n2 = Integer.parseInt(string4);
            this.objectIds.set(n2);
        }
    }

    private void deleteOldTempFiles() throws SQLException {
        String string = FileUtils.getParent(this.databaseName);
        String string2 = FileUtils.normalize(this.databaseName);
        String[] stringArray = FileUtils.listFiles(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (!string3.endsWith(".temp.db") || !FileUtils.fileStartsWith(string3, string2)) continue;
            FileUtils.tryDelete(string3);
        }
    }

    public Storage getStorage(RecordReader recordReader, int n, boolean bl) {
        DiskFile diskFile = bl ? this.fileData : this.fileIndex;
        Storage storage = this.getStorage(n, diskFile);
        storage.setReader(recordReader);
        return storage;
    }

    public Schema getSchema(String string) throws SQLException {
        Schema schema = this.findSchema(string);
        if (schema == null) {
            throw Message.getSQLException(90079, string);
        }
        return schema;
    }

    public synchronized void removeDatabaseObject(Session session, DbObject dbObject) throws SQLException {
        Comment comment;
        this.checkWritingAllowed();
        String string = dbObject.getName();
        int n = dbObject.getType();
        HashMap hashMap = this.getMap(n);
        if (SysProperties.CHECK && !hashMap.containsKey(string)) {
            Message.throwInternalError("not found: " + string);
        }
        if ((comment = this.findComment(dbObject)) != null) {
            this.removeDatabaseObject(session, comment);
        }
        int n2 = dbObject.getId();
        dbObject.removeChildrenAndResources(session);
        hashMap.remove(string);
        this.removeMeta(session, n2);
    }

    public Table getDependentTable(SchemaObject schemaObject, Table table) {
        switch (schemaObject.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 13: {
                return null;
            }
        }
        ObjectArray objectArray = this.getAllSchemaObjects(0);
        HashSet hashSet = new HashSet();
        for (int i = 0; i < objectArray.size(); ++i) {
            Table table2 = (Table)objectArray.get(i);
            if (table == table2) continue;
            hashSet.clear();
            table2.addDependencies(hashSet);
            if (!hashSet.contains(schemaObject)) continue;
            return table2;
        }
        return null;
    }

    private String getFirstInvalidTable(Session session) {
        String string = null;
        try {
            ObjectArray objectArray = this.getAllSchemaObjects(0);
            for (int i = 0; i < objectArray.size(); ++i) {
                Table table = (Table)objectArray.get(i);
                string = table.getSQL();
                session.prepare(table.getCreateSQL());
            }
        }
        catch (SQLException sQLException) {
            return string;
        }
        return null;
    }

    public synchronized void removeSchemaObject(Session session, SchemaObject schemaObject) throws SQLException {
        Table table;
        Object object;
        DbObject dbObject;
        int n = schemaObject.getType();
        if (n == 0) {
            dbObject = (Table)schemaObject;
            if (dbObject.getTemporary() && !dbObject.getGlobalTemporary()) {
                session.removeLocalTempTable((Table)dbObject);
                return;
            }
        } else if (n == 1) {
            dbObject = (Index)schemaObject;
            object = dbObject.getTable();
            if (((DbObjectBase)object).getTemporary() && !((Table)object).getGlobalTemporary()) {
                session.removeLocalTempTableIndex((Index)dbObject);
                return;
            }
        } else if (n == 5 && ((DbObjectBase)(object = ((Constraint)(dbObject = (Constraint)schemaObject)).getTable())).getTemporary() && !((Table)object).getGlobalTemporary()) {
            session.removeLocalTempTableConstraint((Constraint)dbObject);
            return;
        }
        this.checkWritingAllowed();
        dbObject = this.findComment(schemaObject);
        if (dbObject != null) {
            this.removeDatabaseObject(session, dbObject);
        }
        schemaObject.getSchema().remove(schemaObject);
        object = SysProperties.OPTIMIZE_DROP_DEPENDENCIES ? ((table = this.getDependentTable(schemaObject, null)) == null ? null : table.getSQL()) : this.getFirstInvalidTable(session);
        if (object != null) {
            schemaObject.getSchema().add(schemaObject);
            throw Message.getSQLException(90107, new String[]{schemaObject.getSQL(), object});
        }
        int n2 = schemaObject.getId();
        schemaObject.removeChildrenAndResources(session);
        this.removeMeta(session, n2);
        if (schemaObject instanceof TableData) {
            this.tableMap.remove(n2);
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public TraceSystem getTraceSystem() {
        return this.traceSystem;
    }

    public DiskFile getDataFile() {
        return this.fileData;
    }

    public DiskFile getIndexFile() {
        return this.fileIndex;
    }

    public synchronized void setCacheSize(int n) throws SQLException {
        if (this.fileData != null) {
            this.fileData.getCache().setMaxSize(n);
            int n2 = n <= 32 ? n : n >>> SysProperties.CACHE_SIZE_INDEX_SHIFT;
            this.fileIndex.getCache().setMaxSize(n2);
        }
    }

    public synchronized void setMasterUser(User user) throws SQLException {
        this.addDatabaseObject(this.systemSession, user);
        this.systemSession.commit(true);
    }

    public Role getPublicRole() {
        return this.publicRole;
    }

    public String getTempTableName(int n) {
        String string;
        int n2 = 0;
        while (this.mainSchema.findTableOrView(null, string = "TEMP_TABLE_" + n + "_" + n2) != null) {
            ++n2;
        }
        return string;
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    public void setCluster(String string) {
        this.cluster = string;
    }

    public void checkWritingAllowed() throws SQLException {
        if (this.readOnly) {
            throw Message.getSQLException(90097);
        }
        if (this.noDiskSpace) {
            throw Message.getSQLException(90100);
        }
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
        if (this.writer != null) {
            this.writer.setWriteDelay(n);
        }
    }

    public void deleteLogFileLater(String string) throws SQLException {
        if (this.writer != null) {
            this.writer.deleteLogFileLater(string);
        } else {
            FileUtils.delete(string);
        }
    }

    public void setEventListener(DatabaseEventListener databaseEventListener) {
        this.eventListener = databaseEventListener;
    }

    public void setEventListenerClass(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            this.eventListener = null;
        } else {
            try {
                this.eventListener = (DatabaseEventListener)ClassUtils.loadUserClass(string).newInstance();
                String string2 = this.databaseURL;
                if (this.cipher != null) {
                    string2 = string2 + ";CIPHER=" + this.cipher;
                }
                this.eventListener.init(string2);
            }
            catch (Throwable throwable) {
                throw Message.getSQLException(90099, new String[]{string, throwable.toString()}, throwable);
            }
        }
    }

    public synchronized void freeUpDiskSpace() throws SQLException {
        if (this.eventListener != null) {
            this.eventListener.diskSpaceIsLow(0L);
        }
    }

    public void setProgress(int n, String string, int n2, int n3) {
        if (this.eventListener != null) {
            try {
                this.eventListener.setProgress(n, string, n2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void exceptionThrown(SQLException sQLException, String string) {
        if (this.eventListener != null) {
            try {
                this.eventListener.exceptionThrown(sQLException, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sync() throws SQLException {
        if (this.log != null) {
            this.log.sync();
        }
        if (this.fileData != null) {
            this.fileData.sync();
        }
        if (this.fileIndex != null) {
            this.fileIndex.sync();
        }
    }

    public int getMaxMemoryRows() {
        return this.maxMemoryRows;
    }

    public void setMaxMemoryRows(int n) {
        this.maxMemoryRows = n;
    }

    public void setMaxMemoryUndo(int n) {
        this.maxMemoryUndo = n;
    }

    public int getMaxMemoryUndo() {
        return this.maxMemoryUndo;
    }

    public void setLockMode(int n) throws SQLException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw Message.getInvalidValueException("lock mode", "" + n);
            }
        }
        this.lockMode = n;
    }

    public int getLockMode() {
        return this.lockMode;
    }

    public synchronized void setCloseDelay(int n) {
        this.closeDelay = n;
    }

    public boolean getLogIndexChanges() {
        return this.logIndexChanges;
    }

    public synchronized void setLog(int n) throws SQLException {
        boolean bl;
        boolean bl2;
        if (this.logLevel == n) {
            return;
        }
        switch (n) {
            case 0: {
                bl2 = false;
                bl = false;
                break;
            }
            case 1: {
                bl2 = true;
                bl = false;
                break;
            }
            case 2: {
                bl2 = true;
                bl = true;
                break;
            }
            default: {
                throw Message.throwInternalError("level=" + n);
            }
        }
        if (this.fileIndex != null) {
            this.fileIndex.setLogChanges(bl);
        }
        this.logIndexChanges = bl;
        if (this.log != null) {
            this.log.setDisabled(!bl2);
            this.log.checkpoint();
        }
        this.traceSystem.getTrace("database").error("SET LOG " + n, null);
        this.logLevel = n;
    }

    public boolean getRecovery() {
        return this.recovery;
    }

    public Session getSystemSession() {
        return this.systemSession;
    }

    public void handleInvalidChecksum() throws SQLException {
        JdbcSQLException jdbcSQLException = Message.getSQLException(90030, "wrong checksum");
        if (!this.recovery) {
            throw jdbcSQLException;
        }
        this.traceSystem.getTrace("database").error("recover", jdbcSQLException);
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setMaxLengthInplaceLob(int n) {
        this.maxLengthInplaceLob = n;
    }

    public int getMaxLengthInplaceLob() {
        return this.persistent ? this.maxLengthInplaceLob : Integer.MAX_VALUE;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean getIgnoreCase() {
        if (this.starting) {
            return false;
        }
        return this.ignoreCase;
    }

    public synchronized void setDeleteFilesOnDisconnect(boolean bl) {
        this.deleteFilesOnDisconnect = bl;
    }

    public String getLobCompressionAlgorithm(int n) {
        return this.lobCompressionAlgorithm;
    }

    public void setLobCompressionAlgorithm(String string) {
        this.lobCompressionAlgorithm = string;
    }

    public void notifyFileSize(long l) {
    }

    public synchronized void setMaxLogSize(long l) {
        this.getLog().setMaxLogSize(l);
    }

    public void setAllowLiterals(int n) {
        this.allowLiterals = n;
    }

    public boolean getOptimizeReuseResults() {
        return this.optimizeReuseResults;
    }

    public void setOptimizeReuseResults(boolean bl) {
        this.optimizeReuseResults = bl;
    }

    public void invalidateIndexSummary() throws SQLException {
        if (this.indexSummaryValid) {
            this.indexSummaryValid = false;
            this.log.invalidateIndexSummary();
        }
    }

    public boolean getIndexSummaryValid() {
        return this.indexSummaryValid;
    }

    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }

    public int getSessionCount() {
        return this.userSessions.size();
    }

    public void setReferentialIntegrity(boolean bl) {
        this.referentialIntegrity = bl;
    }

    public boolean getReferentialIntegrity() {
        return this.referentialIntegrity;
    }

    public boolean isStarting() {
        return this.starting;
    }

    public boolean isMultiVersion() {
        return this.multiVersion;
    }

    public void opened() {
        if (this.eventListener != null) {
            this.eventListener.opened();
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    public void setMultiThreaded(boolean bl) throws SQLException {
        if (bl && this.multiVersion && this.multiThreaded != bl) {
            throw Message.getSQLException(90133, "MVCC & MULTI_THREADED");
        }
        this.multiThreaded = bl;
    }

    public void setMaxOperationMemory(int n) {
        this.maxOperationMemory = n;
    }

    public int getMaxOperationMemory() {
        return this.maxOperationMemory;
    }

    public Session getExclusiveSession() {
        return this.exclusiveSession;
    }

    public void setExclusiveSession(Session session) {
        this.exclusiveSession = session;
    }

    public boolean getLobFilesInDirectories() {
        return this.lobFilesInDirectories;
    }

    public SmallLRUCache getLobFileListCache() {
        return this.lobFileListCache;
    }

    public boolean isSysTableLocked() {
        return this.meta.isLockedExclusively();
    }

    public TableLinkConnection getLinkConnection(String string, String string2, String string3, String string4) throws SQLException {
        if (this.linkConnections == null) {
            this.linkConnections = new HashMap();
        }
        return TableLinkConnection.open(this.linkConnections, string, string2, string3, string4);
    }

    public String toString() {
        return this.databaseShortName + ":" + super.toString();
    }

    public void shutdownImmediately() {
        this.setPowerOffCount(1);
        try {
            this.checkPowerOff();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public TempFileDeleter getTempFileDeleter() {
        return this.tempFileDeleter;
    }

    public Trace getTrace() {
        return this.getTrace("database");
    }

    public PageStore getPageStore() throws SQLException {
        if (this.pageStore == null) {
            this.pageStore = new PageStore(this, this.databaseName + ".h2.db", this.accessModeData, SysProperties.CACHE_SIZE_DEFAULT);
            this.pageStore.open();
        }
        return this.pageStore;
    }

    public void redo(int n, Row row, boolean bl) throws SQLException {
        TableData tableData = (TableData)this.tableMap.get(n);
        if (bl) {
            tableData.addRow(this.systemSession, row);
        } else {
            tableData.removeRow(this.systemSession, row);
        }
        if (n == 0) {
            MetaRecord metaRecord = new MetaRecord(row);
            if (bl) {
                this.objectIds.set(metaRecord.getId());
                metaRecord.execute(this, this.systemSession, this.eventListener);
            }
        }
    }

    public Table getFirstUserTable() {
        ObjectArray objectArray = this.getAllSchemaObjects(0);
        for (int i = 0; i < objectArray.size(); ++i) {
            Table table = (Table)objectArray.get(i);
            if (table.getCreateSQL() == null) continue;
            return table;
        }
        return null;
    }
}

