/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.kenai.constantine.platform.Errno;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.JavaFileStat;
import org.jruby.ext.posix.JavaLibCHelper;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;
import org.jruby.ext.posix.util.Platform;

final class JavaPOSIX
implements POSIX {
    private final POSIXHandler handler;
    private final JavaLibCHelper helper;

    JavaPOSIX(POSIXHandler handler) {
        this.handler = handler;
        this.helper = new JavaLibCHelper(handler);
    }

    public FileStat allocateStat() {
        return new JavaFileStat(this, this.handler);
    }

    public int chmod(String filename2, int mode2) {
        return this.helper.chmod(filename2, mode2);
    }

    public int chown(String filename2, int user, int group2) {
        return this.helper.chown(filename2, user, group2);
    }

    public int exec(String path2, String ... argv) {
        this.handler.unimplementedError("No exec in Java (yet)");
        return -1;
    }

    public int exec(String path2, String[] argv, String[] envp) {
        this.handler.unimplementedError("No exec in Java (yet)");
        return -1;
    }

    public int execv(String path2, String[] argv) {
        this.handler.unimplementedError("No execv in Java (yet)");
        return -1;
    }

    public int execve(String path2, String[] argv, String[] envp) {
        this.handler.unimplementedError("No execve in Java (yet)");
        return -1;
    }

    public FileStat fstat(FileDescriptor descriptor) {
        this.handler.unimplementedError("fstat unimplemented");
        return null;
    }

    public int getegid() {
        return LoginInfo.GID;
    }

    public int geteuid() {
        return LoginInfo.UID;
    }

    public int getgid() {
        return LoginInfo.GID;
    }

    public String getlogin() {
        return this.helper.getlogin();
    }

    public int getpgid() {
        return this.unimplementedInt("getpgid");
    }

    public int getpgrp() {
        return this.unimplementedInt("getpgrp");
    }

    public int getpid() {
        return this.helper.getpid();
    }

    public int getppid() {
        return this.unimplementedInt("getppid");
    }

    public Passwd getpwent() {
        return this.helper.getpwent();
    }

    public Passwd getpwuid(int which) {
        return this.helper.getpwuid(which);
    }

    public Group getgrgid(int which) {
        this.handler.unimplementedError("getgrgid unimplemented");
        return null;
    }

    public Passwd getpwnam(String which) {
        this.handler.unimplementedError("getpwnam unimplemented");
        return null;
    }

    public Group getgrnam(String which) {
        this.handler.unimplementedError("getgrnam unimplemented");
        return null;
    }

    public Group getgrent() {
        this.handler.unimplementedError("getgrent unimplemented");
        return null;
    }

    public int setpwent() {
        return this.helper.setpwent();
    }

    public int endpwent() {
        return this.helper.endpwent();
    }

    public int setgrent() {
        return this.unimplementedInt("setgrent");
    }

    public int endgrent() {
        return this.unimplementedInt("endgrent");
    }

    public String getenv(String envName) {
        return this.helper.getEnv().get(envName);
    }

    public int getuid() {
        return LoginInfo.UID;
    }

    public int fork() {
        return -1;
    }

    public boolean isatty(FileDescriptor fd) {
        return fd == FileDescriptor.in || fd == FileDescriptor.out || fd == FileDescriptor.err;
    }

    public int kill(int pid2, int signal2) {
        return this.unimplementedInt("kill");
    }

    public int lchmod(String filename2, int mode2) {
        return this.unimplementedInt("lchmod");
    }

    public int lchown(String filename2, int user, int group2) {
        return this.unimplementedInt("lchown");
    }

    public int link(String oldpath, String newpath) {
        return this.helper.link(oldpath, newpath);
    }

    public FileStat lstat(String path2) {
        FileStat stat2 = this.allocateStat();
        if (this.helper.lstat(path2, stat2) < 0) {
            this.handler.error(Errno.ENOENT, path2);
        }
        return stat2;
    }

    public int mkdir(String path2, int mode2) {
        return this.helper.mkdir(path2, mode2);
    }

    public String readlink(String path2) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(256);
        int result = this.helper.readlink(path2, buffer, buffer.capacity());
        if (result == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    public int setenv(String envName, String envValue, int overwrite) {
        Map<String, String> env = this.helper.getEnv();
        if (envName.contains("=")) {
            this.handler.error(Errno.EINVAL, envName);
            return -1;
        }
        if (overwrite == 0 && env.containsKey(envName)) {
            return 0;
        }
        env.put(envName, envValue);
        return 0;
    }

    public FileStat stat(String path2) {
        FileStat stat2 = this.allocateStat();
        if (this.helper.stat(path2, stat2) < 0) {
            this.handler.error(Errno.ENOENT, path2);
        }
        return stat2;
    }

    public int symlink(String oldpath, String newpath) {
        return this.helper.symlink(oldpath, newpath);
    }

    public int setegid(int egid2) {
        return this.unimplementedInt("setegid");
    }

    public int seteuid(int euid2) {
        return this.unimplementedInt("seteuid");
    }

    public int setgid(int gid2) {
        return this.unimplementedInt("setgid");
    }

    public int getpgid(int pid2) {
        return this.unimplementedInt("getpgid");
    }

    public int setpgid(int pid2, int pgid) {
        return this.unimplementedInt("setpgid");
    }

    public int setpgrp(int pid2, int pgrp) {
        return this.unimplementedInt("setpgrp");
    }

    public int setsid() {
        return this.unimplementedInt("setsid");
    }

    public int setuid(int uid2) {
        return this.unimplementedInt("setuid");
    }

    public int umask(int mask) {
        return 0;
    }

    public int unsetenv(String envName) {
        if (this.helper.getEnv().remove(envName) == null) {
            this.handler.error(Errno.EINVAL, envName);
            return -1;
        }
        return 0;
    }

    public int utimes(String path2, long[] atimeval, long[] mtimeval) {
        long mtimeMillis;
        if (mtimeval != null) {
            assert (mtimeval.length == 2);
            mtimeMillis = mtimeval[0] * 1000L + mtimeval[1] / 1000L;
        } else {
            mtimeMillis = System.currentTimeMillis();
        }
        new File(path2).setLastModified(mtimeMillis);
        return 0;
    }

    public int wait(int[] status2) {
        return this.unimplementedInt("wait");
    }

    public int waitpid(int pid2, int[] status2, int flags) {
        return this.unimplementedInt("waitpid");
    }

    public int getpriority(int which, int who) {
        return this.unimplementedInt("getpriority");
    }

    public int setpriority(int which, int who, int prio) {
        return this.unimplementedInt("setpriority");
    }

    public int errno() {
        return 0;
    }

    public void errno(int value2) {
    }

    public boolean isNative() {
        return false;
    }

    public LibC libc() {
        return null;
    }

    private int unimplementedInt(String message2) {
        this.handler.unimplementedError(message2);
        return -1;
    }

    private static final class FakePasswd
    implements Passwd {
        private FakePasswd() {
        }

        public String getLoginName() {
            return LoginInfo.USERNAME;
        }

        public String getPassword() {
            return "";
        }

        public long getUID() {
            return LoginInfo.UID;
        }

        public long getGID() {
            return LoginInfo.GID;
        }

        public int getPasswdChangeTime() {
            return 0;
        }

        public String getAccessClass() {
            return "";
        }

        public String getGECOS() {
            return this.getLoginName();
        }

        public String getHome() {
            return "/";
        }

        public String getShell() {
            return "/bin/sh";
        }

        public int getExpire() {
            return -1;
        }
    }

    private static final class IDHelper {
        private static final String ID_CMD = Platform.IS_SOLARIS ? "/usr/xpg4/bin/id" : "/usr/bin/id";
        private static final int NOBODY = Platform.IS_WINDOWS ? 0 : Short.MAX_VALUE;

        private IDHelper() {
        }

        public static int getInt(String option) {
            try {
                Process p2 = Runtime.getRuntime().exec(new String[]{ID_CMD, option});
                BufferedReader r = new BufferedReader(new InputStreamReader(p2.getInputStream()));
                return Integer.parseInt(r.readLine());
            }
            catch (IOException ex) {
                return NOBODY;
            }
            catch (NumberFormatException ex) {
                return NOBODY;
            }
            catch (SecurityException ex) {
                return NOBODY;
            }
        }

        public static String getString(String option) {
            try {
                Process p2 = Runtime.getRuntime().exec(new String[]{ID_CMD, option});
                BufferedReader r = new BufferedReader(new InputStreamReader(p2.getInputStream()));
                return r.readLine();
            }
            catch (IOException ex) {
                return null;
            }
        }
    }

    static final class LoginInfo {
        public static final int UID = IDHelper.getInt("-u");
        public static final int GID = IDHelper.getInt("-g");
        public static final String USERNAME = IDHelper.getString("-un");

        LoginInfo() {
        }
    }
}

