/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.math.BigInteger;
import org.jruby.compiler.ir.IRClass;
import org.jruby.compiler.ir.operands.Constant;
import org.jruby.compiler.ir.operands.Float;
import org.jruby.compiler.ir.operands.Nil;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.interpreter.InterpreterContext;

public class Fixnum
extends Constant {
    public final Long value;

    public Fixnum(Long val) {
        this.value = val;
    }

    public Fixnum(BigInteger val) {
        this.value = val.longValue();
    }

    public String toString() {
        return this.value + ":fixnum";
    }

    public Operand fetchCompileTimeArrayElement(int argIndex, boolean getSubArray) {
        return argIndex == 0 ? this : Nil.NIL;
    }

    public IRClass getTargetClass() {
        return IRClass.getCoreClass("Fixnum");
    }

    public Constant computeValue(String methodName, Constant arg2) {
        if (arg2 instanceof Fixnum) {
            if (methodName.equals("+")) {
                return new Fixnum(this.value + ((Fixnum)arg2).value);
            }
            if (methodName.equals("-")) {
                return new Fixnum(this.value - ((Fixnum)arg2).value);
            }
            if (methodName.equals("*")) {
                return new Fixnum(this.value * ((Fixnum)arg2).value);
            }
            if (methodName.equals("/")) {
                Long divisor = ((Fixnum)arg2).value;
                return divisor == 0L ? null : new Fixnum(this.value / divisor);
            }
        } else if (arg2 instanceof Float) {
            if (methodName.equals("+")) {
                return new Float((double)this.value.longValue() + ((Float)arg2).value);
            }
            if (methodName.equals("-")) {
                return new Float((double)this.value.longValue() - ((Float)arg2).value);
            }
            if (methodName.equals("*")) {
                return new Float((double)this.value.longValue() * ((Float)arg2).value);
            }
            if (methodName.equals("/")) {
                Double divisor = ((Float)arg2).value;
                return divisor == 0.0 ? null : new Float((double)this.value.longValue() / divisor);
            }
        }
        return null;
    }

    public Object retrieve(InterpreterContext interp) {
        if (this.cachedValue == null) {
            this.cachedValue = interp.getRuntime().newFixnum(this.value);
        }
        return this.cachedValue;
    }
}

