/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.MethAddr;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyImplCallInstr
extends CallInstr {
    public JRubyImplCallInstr(Variable result, MethAddr methAddr, Operand receiver2, Operand[] args2) {
        super(Operation.JRUBY_IMPL, result, methAddr, receiver2, args2, null);
    }

    public JRubyImplCallInstr(Variable result, MethAddr methAddr, Operand receiver2, Operand[] args2, Operand closure) {
        super(result, methAddr, receiver2, args2, closure);
    }

    public boolean isStaticCallTarget() {
        return true;
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        return new JRubyImplCallInstr(ii.getRenamedVariable(this.result), (MethAddr)this.methAddr.cloneForInlining(ii), this.getReceiver().cloneForInlining(ii), this.cloneCallArgs(ii), this.closure == null ? null : this.closure.cloneForInlining(ii));
    }

    public Label interpret(InterpreterContext interp, IRubyObject self) {
        Ruby rt = interp.getRuntime();
        if (this.getMethodAddr() == MethAddr.MATCH2) {
            Object receiver2 = this.getReceiver().retrieve(interp);
            this.getResult().store(interp, ((RubyRegexp)receiver2).op_match(interp.getContext(), (IRubyObject)this.getCallArgs()[0].retrieve(interp)));
        } else if (this.getMethodAddr() == MethAddr.MATCH3) {
            Object receiver3 = this.getReceiver().retrieve(interp);
            this.getResult().store(interp, ((RubyRegexp)receiver3).op_match(interp.getContext(), (IRubyObject)this.getCallArgs()[0].retrieve(interp)));
        } else if (this.getMethodAddr() == MethAddr.TO_ARY) {
            Object receiver4 = this.getReceiver().retrieve(interp);
            this.getResult().store(interp, RuntimeHelpers.aryToAry((IRubyObject)receiver4));
        } else if (this.getMethodAddr().getName().equals("threadContext_saveErrInfo")) {
            this.getResult().store(interp, interp.getContext().getErrorInfo());
        } else if (this.getMethodAddr().getName().equals("threadContext_restoreErrInfo")) {
            interp.getContext().setErrorInfo((IRubyObject)this.getCallArgs()[0].retrieve(interp));
        } else if (this.getMethodAddr().getName().equals("threadContext_getConstantDefined")) {
            String name2 = this.getCallArgs()[0].retrieve(interp).toString();
            this.getResult().store(interp, rt.newBoolean(interp.getContext().getConstantDefined(name2)));
        } else if (this.getMethodAddr().getName().equals("self_hasInstanceVariable")) {
            Object receiver5 = this.getReceiver().retrieve(interp);
            String name3 = this.getCallArgs()[0].retrieve(interp).toString();
            this.getResult().store(interp, rt.newBoolean(((IRubyObject)receiver5).getInstanceVariables().fastHasInstanceVariable(name3)));
        } else if (this.getMethodAddr().getName().equals("runtime_isGlobalDefined")) {
            String name4 = this.getCallArgs()[0].retrieve(interp).toString();
            this.getResult().store(interp, rt.newBoolean(rt.getGlobalVariables().isDefined(name4)));
        } else if (this.getMethodAddr().getName().equals("runtime_getObject")) {
            this.getResult().store(interp, rt.getObject());
        } else if (this.getMethodAddr().getName().equals("block_isGiven")) {
            this.getResult().store(interp, rt.newBoolean(interp.getBlock().isGiven()));
        } else {
            super.interpret(interp, self);
        }
        return null;
    }
}

