/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Map;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.OneOperandInstr;
import org.jruby.compiler.ir.operands.BooleanLiteral;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Nil;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsTrueInstr
extends OneOperandInstr {
    public IsTrueInstr(Variable result, Operand arg2) {
        super(Operation.IS_TRUE, result, arg2);
    }

    @Override
    public Operand simplifyAndGetResult(Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap);
        if (this.argument.isConstant()) {
            return this.argument == Nil.NIL || this.argument == BooleanLiteral.FALSE ? BooleanLiteral.FALSE : BooleanLiteral.TRUE;
        }
        return null;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new IsTrueInstr(ii.getRenamedVariable(this.result), this.argument.cloneForInlining(ii));
    }

    @Override
    public boolean canRaiseException() {
        return false;
    }

    @Override
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        this.getResult().store(interp, ((IRubyObject)this.getArg().retrieve(interp)).isTrue());
        return null;
    }
}

