/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.cext;

import java.lang.ref.Reference;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.jruby.cext.GIL;
import org.jruby.cext.Handle;
import org.jruby.cext.Native;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.SoftReferenceReaper;

public class GC {
    private static final Map<Object, Handle> nativeHandles = new IdentityHashMap<Object, Handle>();
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory());
    private static volatile Reference<Object> reaper = null;
    private static Runnable gcTask;
    private static volatile Future<?> gcFuture;

    public static final void mark(IRubyObject obj) {
    }

    public static final void trigger() {
        if (gcFuture == null || gcFuture.isDone()) {
            gcFuture = executor.submit(gcTask);
        }
    }

    static void init(final Native n) {
        gcTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GIL.acquire();
                try {
                    Object obj;
                    n.gc();
                    while ((obj = n.pollGC()) != null) {
                        nativeHandles.remove(obj);
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    GIL.releaseNoCleanup();
                    throw throwable;
                }
                GIL.releaseNoCleanup();
            }
        };
    }

    static final Handle lookup(IRubyObject obj) {
        return nativeHandles.get(obj);
    }

    static final void register(IRubyObject obj, Handle h) {
        nativeHandles.put(obj, h);
    }

    static final void cleanup() {
        if (reaper == null) {
            reaper = new SoftReferenceReaper<Object>(new Object()){

                @Override
                public void run() {
                    reaper = null;
                    GC.trigger();
                }
            };
        }
    }
}

