/*
 * Decompiled with CFR 0.152.
 */
package sun.util.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.util.logging.LoggingSupport;

public class PlatformLogger {
    public static final int OFF = Integer.MAX_VALUE;
    public static final int SEVERE = 1000;
    public static final int WARNING = 900;
    public static final int INFO = 800;
    public static final int CONFIG = 700;
    public static final int FINE = 500;
    public static final int FINER = 400;
    public static final int FINEST = 300;
    public static final int ALL = Integer.MIN_VALUE;
    private static final int defaultLevel = 800;
    private static boolean loggingEnabled = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            String string = System.getProperty("java.util.logging.config.class");
            String string2 = System.getProperty("java.util.logging.config.file");
            return string != null || string2 != null;
        }
    });
    private static Map<String, WeakReference<PlatformLogger>> loggers = new HashMap<String, WeakReference<PlatformLogger>>();
    private volatile LoggerProxy logger;

    public static synchronized PlatformLogger getLogger(String string) {
        PlatformLogger platformLogger = null;
        WeakReference<PlatformLogger> weakReference = loggers.get(string);
        if (weakReference != null) {
            platformLogger = (PlatformLogger)weakReference.get();
        }
        if (platformLogger == null) {
            platformLogger = new PlatformLogger(string);
            loggers.put(string, new WeakReference<PlatformLogger>(platformLogger));
        }
        return platformLogger;
    }

    public static synchronized void redirectPlatformLoggers() {
        if (loggingEnabled || !LoggingSupport.isAvailable()) {
            return;
        }
        loggingEnabled = true;
        for (Map.Entry<String, WeakReference<PlatformLogger>> entry : loggers.entrySet()) {
            WeakReference<PlatformLogger> weakReference = entry.getValue();
            PlatformLogger platformLogger = (PlatformLogger)weakReference.get();
            if (platformLogger == null) continue;
            platformLogger.newJavaLogger();
        }
    }

    private void newJavaLogger() {
        this.logger = new JavaLogger(this.logger.name, this.logger.effectiveLevel);
    }

    private PlatformLogger(String string) {
        this.logger = loggingEnabled ? new JavaLogger(string) : new LoggerProxy(string);
    }

    public boolean isEnabled() {
        return this.logger.isEnabled();
    }

    public String getName() {
        return this.logger.name;
    }

    public boolean isLoggable(int n) {
        return this.logger.isLoggable(n);
    }

    public int getLevel() {
        return this.logger.getLevel();
    }

    public void setLevel(int n) {
        this.logger.setLevel(n);
    }

    public void severe(String string) {
        this.logger.doLog(1000, string);
    }

    public void severe(String string, Throwable throwable) {
        this.logger.doLog(1000, string, throwable);
    }

    public void severe(String string, Object ... objectArray) {
        this.logger.doLog(1000, string, objectArray);
    }

    public void warning(String string) {
        this.logger.doLog(900, string);
    }

    public void warning(String string, Throwable throwable) {
        this.logger.doLog(900, string, throwable);
    }

    public void warning(String string, Object ... objectArray) {
        this.logger.doLog(900, string, objectArray);
    }

    public void info(String string) {
        this.logger.doLog(800, string);
    }

    public void info(String string, Throwable throwable) {
        this.logger.doLog(800, string, throwable);
    }

    public void info(String string, Object ... objectArray) {
        this.logger.doLog(800, string, objectArray);
    }

    public void config(String string) {
        this.logger.doLog(700, string);
    }

    public void config(String string, Throwable throwable) {
        this.logger.doLog(700, string, throwable);
    }

    public void config(String string, Object ... objectArray) {
        this.logger.doLog(700, string, objectArray);
    }

    public void fine(String string) {
        this.logger.doLog(500, string);
    }

    public void fine(String string, Throwable throwable) {
        this.logger.doLog(500, string, throwable);
    }

    public void fine(String string, Object ... objectArray) {
        this.logger.doLog(500, string, objectArray);
    }

    public void finer(String string) {
        this.logger.doLog(400, string);
    }

    public void finer(String string, Throwable throwable) {
        this.logger.doLog(400, string, throwable);
    }

    public void finer(String string, Object ... objectArray) {
        this.logger.doLog(400, string, objectArray);
    }

    public void finest(String string) {
        this.logger.doLog(300, string);
    }

    public void finest(String string, Throwable throwable) {
        this.logger.doLog(300, string, throwable);
    }

    public void finest(String string, Object ... objectArray) {
        this.logger.doLog(300, string, objectArray);
    }

    private static String getLevelName(int n) {
        switch (n) {
            case 0x7FFFFFFF: {
                return "OFF";
            }
            case 1000: {
                return "SEVERE";
            }
            case 900: {
                return "WARNING";
            }
            case 800: {
                return "INFO";
            }
            case 700: {
                return "CONFIG";
            }
            case 500: {
                return "FINE";
            }
            case 400: {
                return "FINER";
            }
            case 300: {
                return "FINEST";
            }
            case -2147483648: {
                return "ALL";
            }
        }
        return "UNKNOWN";
    }

    static class JavaLogger
    extends LoggerProxy {
        private static final Map<Integer, Object> levelObjects = new HashMap<Integer, Object>();
        private final Object javaLogger;

        private static void getLevelObjects() {
            int[] nArray;
            for (int n : nArray = new int[]{Integer.MAX_VALUE, 1000, 900, 800, 700, 500, 400, 300, Integer.MIN_VALUE}) {
                Object object = LoggingSupport.parseLevel(PlatformLogger.getLevelName(n));
                levelObjects.put(n, object);
            }
        }

        JavaLogger(String string) {
            this(string, 0);
        }

        JavaLogger(String string, int n) {
            super(string, n);
            this.javaLogger = LoggingSupport.getLogger(string);
            if (n != 0) {
                LoggingSupport.setLevel(this.javaLogger, levelObjects.get(n));
            }
        }

        @Override
        void doLog(int n, String string) {
            LoggingSupport.log(this.javaLogger, levelObjects.get(n), string);
        }

        @Override
        void doLog(int n, String string, Throwable throwable) {
            LoggingSupport.log(this.javaLogger, levelObjects.get(n), string, throwable);
        }

        @Override
        void doLog(int n, String string, Object ... objectArray) {
            LoggingSupport.log(this.javaLogger, levelObjects.get(n), string, objectArray);
        }

        @Override
        boolean isEnabled() {
            Object object = LoggingSupport.getLevel(this.javaLogger);
            return object == null || !object.equals(levelObjects.get(Integer.MAX_VALUE));
        }

        @Override
        int getLevel() {
            Object object = LoggingSupport.getLevel(this.javaLogger);
            if (object != null) {
                for (Map.Entry<Integer, Object> entry : levelObjects.entrySet()) {
                    if (object != entry.getValue()) continue;
                    return entry.getKey();
                }
            }
            return 0;
        }

        @Override
        void setLevel(int n) {
            this.levelValue = n;
            LoggingSupport.setLevel(this.javaLogger, levelObjects.get(n));
        }

        @Override
        public boolean isLoggable(int n) {
            return LoggingSupport.isLoggable(this.javaLogger, levelObjects.get(n));
        }

        static {
            if (LoggingSupport.isAvailable()) {
                JavaLogger.getLevelObjects();
            }
        }
    }

    static class LoggerProxy {
        private static final PrintStream defaultStream = System.err;
        private static final String lineSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("line.separator");
            }
        });
        final String name;
        volatile int levelValue;
        volatile int effectiveLevel = 0;
        private static final String format = "{0,date} {0,time}";
        private Object[] args = new Object[1];
        private MessageFormat formatter;
        private Date dat;

        LoggerProxy(String string) {
            this(string, 800);
        }

        LoggerProxy(String string, int n) {
            this.name = string;
            this.levelValue = n == 0 ? 800 : n;
        }

        boolean isEnabled() {
            return this.levelValue != Integer.MAX_VALUE;
        }

        int getLevel() {
            return this.effectiveLevel;
        }

        void setLevel(int n) {
            this.levelValue = n;
            this.effectiveLevel = n;
        }

        void doLog(int n, String string) {
            if (n < this.levelValue || this.levelValue == Integer.MAX_VALUE) {
                return;
            }
            defaultStream.println(this.format(n, string, null));
        }

        void doLog(int n, String string, Throwable throwable) {
            if (n < this.levelValue || this.levelValue == Integer.MAX_VALUE) {
                return;
            }
            defaultStream.println(this.format(n, string, throwable));
        }

        void doLog(int n, String string, Object ... objectArray) {
            if (n < this.levelValue || this.levelValue == Integer.MAX_VALUE) {
                return;
            }
            String string2 = this.formatMessage(string, objectArray);
            defaultStream.println(this.format(n, string2, null));
        }

        public boolean isLoggable(int n) {
            return n >= this.levelValue && this.levelValue != Integer.MAX_VALUE;
        }

        private String formatMessage(String string, Object ... objectArray) {
            try {
                if (objectArray == null || objectArray.length == 0) {
                    return string;
                }
                if (string.indexOf("{0") >= 0 || string.indexOf("{1") >= 0 || string.indexOf("{2") >= 0 || string.indexOf("{3") >= 0) {
                    return MessageFormat.format(string, objectArray);
                }
                return string;
            }
            catch (Exception exception) {
                return string;
            }
        }

        private synchronized String format(int n, String string, Throwable throwable) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.dat == null) {
                this.dat = new Date();
                this.formatter = new MessageFormat(format);
            }
            this.dat.setTime(System.currentTimeMillis());
            this.args[0] = this.dat;
            StringBuffer stringBuffer2 = new StringBuffer();
            this.formatter.format(this.args, stringBuffer2, (FieldPosition)null);
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(" ");
            stringBuffer.append(this.getCallerInfo());
            stringBuffer.append(lineSeparator);
            stringBuffer.append(PlatformLogger.getLevelName(n));
            stringBuffer.append(": ");
            stringBuffer.append(string);
            if (throwable != null) {
                try {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    throwable.printStackTrace(printWriter);
                    printWriter.close();
                    stringBuffer.append(stringWriter.toString());
                }
                catch (Exception exception) {
                    throw new AssertionError((Object)exception);
                }
            }
            return stringBuffer.toString();
        }

        private String getCallerInfo() {
            String string = null;
            String string2 = null;
            JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
            Throwable throwable = new Throwable();
            int n = javaLangAccess.getStackTraceDepth(throwable);
            String string3 = "sun.util.logging.PlatformLogger";
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = javaLangAccess.getStackTraceElement(throwable, i);
                String string4 = stackTraceElement.getClassName();
                if (bl) {
                    if (!string4.equals(string3)) continue;
                    bl = false;
                    continue;
                }
                if (string4.equals(string3)) continue;
                string = string4;
                string2 = stackTraceElement.getMethodName();
                break;
            }
            if (string != null) {
                return string + " " + string2;
            }
            return this.name;
        }
    }
}

