/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;

public class DisabledAlgorithmConstraints
implements AlgorithmConstraints {
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    private static Map<String, String[]> disabledAlgorithmsMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, KeySizeConstraints> keySizeConstraintsMap = Collections.synchronizedMap(new HashMap());
    private String[] disabledAlgorithms;
    private KeySizeConstraints keySizeConstraints;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisabledAlgorithmConstraints(String string) {
        Map<String, String[]> map = disabledAlgorithmsMap;
        synchronized (map) {
            if (!disabledAlgorithmsMap.containsKey(string)) {
                DisabledAlgorithmConstraints.loadDisabledAlgorithmsMap(string);
            }
            this.disabledAlgorithms = disabledAlgorithmsMap.get(string);
            this.keySizeConstraints = keySizeConstraintsMap.get(string);
        }
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        if (set == null || set.isEmpty()) {
            throw new IllegalArgumentException("No cryptographic primitive specified");
        }
        Set<String> set2 = null;
        for (String string2 : this.disabledAlgorithms) {
            if (string2 == null || string2.isEmpty()) continue;
            if (string2.equalsIgnoreCase(string)) {
                return false;
            }
            if (set2 == null) {
                set2 = this.decomposes(string);
            }
            for (String string3 : set2) {
                if (!string2.equalsIgnoreCase(string3)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, Key key) {
        return this.checkConstraints(set, "", key, null);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        return this.checkConstraints(set, string, key, algorithmParameters);
    }

    protected Set<String> decomposes(String string) {
        if (string == null || string.length() == 0) {
            return new HashSet<String>();
        }
        Pattern pattern = Pattern.compile("/");
        String[] stringArray = pattern.split(string);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : stringArray) {
            String[] stringArray2;
            if (string2 == null || string2.length() == 0) continue;
            Pattern pattern2 = Pattern.compile("with|and", 2);
            for (String string3 : stringArray2 = pattern2.split(string2)) {
                if (string3 == null || string3.length() == 0) continue;
                hashSet.add(string3);
            }
        }
        if (hashSet.contains("SHA1") && !hashSet.contains("SHA-1")) {
            hashSet.add("SHA-1");
        }
        if (hashSet.contains("SHA-1") && !hashSet.contains("SHA1")) {
            hashSet.add("SHA1");
        }
        if (hashSet.contains("SHA224") && !hashSet.contains("SHA-224")) {
            hashSet.add("SHA-224");
        }
        if (hashSet.contains("SHA-224") && !hashSet.contains("SHA224")) {
            hashSet.add("SHA224");
        }
        if (hashSet.contains("SHA256") && !hashSet.contains("SHA-256")) {
            hashSet.add("SHA-256");
        }
        if (hashSet.contains("SHA-256") && !hashSet.contains("SHA256")) {
            hashSet.add("SHA256");
        }
        if (hashSet.contains("SHA384") && !hashSet.contains("SHA-384")) {
            hashSet.add("SHA-384");
        }
        if (hashSet.contains("SHA-384") && !hashSet.contains("SHA384")) {
            hashSet.add("SHA384");
        }
        if (hashSet.contains("SHA512") && !hashSet.contains("SHA-512")) {
            hashSet.add("SHA-512");
        }
        if (hashSet.contains("SHA-512") && !hashSet.contains("SHA512")) {
            hashSet.add("SHA512");
        }
        return hashSet;
    }

    private boolean checkConstraints(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (string != null && string.length() != 0 && !this.permits(set, string, algorithmParameters)) {
            return false;
        }
        if (!this.permits(set, key.getAlgorithm(), null)) {
            return false;
        }
        return !this.keySizeConstraints.disables(key);
    }

    private static void loadDisabledAlgorithmsMap(final String string) {
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(string);
            }
        });
        String[] stringArray = null;
        if (string2 != null && !string2.isEmpty()) {
            if (string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        disabledAlgorithmsMap.put(string, stringArray);
        KeySizeConstraints keySizeConstraints = new KeySizeConstraints(stringArray);
        keySizeConstraintsMap.put(string, keySizeConstraints);
    }

    private static class KeySizeConstraint {
        private int minSize;
        private int maxSize;
        private int prohibitedSize = -1;

        public KeySizeConstraint(Operator operator, int n) {
            switch (operator) {
                case EQ: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = n;
                    break;
                }
                case NE: {
                    this.minSize = n;
                    this.maxSize = n;
                    break;
                }
                case LT: {
                    this.minSize = n;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case LE: {
                    this.minSize = n + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case GT: {
                    this.minSize = 0;
                    this.maxSize = n;
                    break;
                }
                case GE: {
                    this.minSize = 0;
                    this.maxSize = n > 1 ? n - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        public boolean disables(Key key) {
            Object object;
            int n = -1;
            if (key instanceof SecretKey && (object = (SecretKey)key).getFormat().equals("RAW") && object.getEncoded() != null) {
                n = object.getEncoded().length * 8;
            }
            if (key instanceof RSAKey) {
                object = (RSAKey)((Object)key);
                n = object.getModulus().bitLength();
            } else if (key instanceof ECKey) {
                object = (ECKey)((Object)key);
                n = object.getParams().getOrder().bitLength();
            } else if (key instanceof DSAKey) {
                object = (DSAKey)((Object)key);
                n = object.getParams().getP().bitLength();
            } else if (key instanceof DHKey) {
                object = (DHKey)((Object)key);
                n = object.getParams().getP().bitLength();
            }
            if (n == 0) {
                return true;
            }
            if (n >= 0) {
                return n < this.minSize || n > this.maxSize || this.prohibitedSize == n;
            }
            return false;
        }

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String string) {
                switch (string) {
                    case "==": {
                        return EQ;
                    }
                    case "!=": {
                        return NE;
                    }
                    case "<": {
                        return LT;
                    }
                    case "<=": {
                        return LE;
                    }
                    case ">": {
                        return GT;
                    }
                    case ">=": {
                        return GE;
                    }
                }
                throw new IllegalArgumentException(string + " is not a legal Operator");
            }
        }
    }

    private static class KeySizeConstraints {
        private static final Pattern pattern = Pattern.compile("(\\S+)\\s+keySize\\s*(<=|<|==|!=|>|>=)\\s*(\\d+)");
        private Map<String, Set<KeySizeConstraint>> constraintsMap = Collections.synchronizedMap(new HashMap());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeySizeConstraints(String[] stringArray) {
            for (String string : stringArray) {
                Matcher matcher;
                if (string == null || string.isEmpty() || !(matcher = pattern.matcher(string)).matches()) continue;
                String string2 = matcher.group(1);
                KeySizeConstraint.Operator operator = KeySizeConstraint.Operator.of(matcher.group(2));
                int n = Integer.parseInt(matcher.group(3));
                string2 = string2.toLowerCase(Locale.ENGLISH);
                Map<String, Set<KeySizeConstraint>> map = this.constraintsMap;
                synchronized (map) {
                    if (!this.constraintsMap.containsKey(string2)) {
                        this.constraintsMap.put(string2, new HashSet());
                    }
                    Set<KeySizeConstraint> set = this.constraintsMap.get(string2);
                    KeySizeConstraint keySizeConstraint = new KeySizeConstraint(operator, n);
                    set.add(keySizeConstraint);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean disables(Key key) {
            String string = key.getAlgorithm().toLowerCase(Locale.ENGLISH);
            Map<String, Set<KeySizeConstraint>> map = this.constraintsMap;
            synchronized (map) {
                if (this.constraintsMap.containsKey(string)) {
                    Set<KeySizeConstraint> set = this.constraintsMap.get(string);
                    for (KeySizeConstraint keySizeConstraint : set) {
                        if (!keySizeConstraint.disables(key)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

