/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn.anon;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import sun.dyn.anon.ConstantPoolParser;
import sun.dyn.anon.ConstantPoolPatch;
import sun.dyn.anon.InvalidConstantPoolFormatException;
import sun.misc.IOUtils;
import sun.misc.Unsafe;
import sun.reflect.Reflection;

public class AnonymousClassLoader {
    final Class<?> hostClass;
    private static int CHC_CALLERS = 3;
    private static int fakeNameCounter = 99999;
    static Unsafe unsafe = Unsafe.getUnsafe();
    private static final Method defineAnonymousClass;

    public AnonymousClassLoader() {
        this.hostClass = AnonymousClassLoader.checkHostClass(null);
    }

    public AnonymousClassLoader(Class<?> clazz) {
        this.hostClass = AnonymousClassLoader.checkHostClass(clazz);
    }

    private static Class<?> getTopLevelClass(Class<?> clazz) {
        for (Class<?> clazz2 = clazz.getDeclaringClass(); clazz2 != null; clazz2 = clazz2.getDeclaringClass()) {
            clazz = clazz2;
        }
        return clazz;
    }

    private static Class<?> checkHostClass(Class<?> clazz) {
        Class<?> clazz2;
        Class<?> clazz3 = Reflection.getCallerClass(CHC_CALLERS);
        if (clazz3 == null) {
            if (clazz == null) {
                return AnonymousClassLoader.class;
            }
            return clazz;
        }
        if (clazz == null) {
            clazz = clazz3;
        }
        if (clazz3 == (clazz2 = clazz)) {
            return clazz;
        }
        if ((clazz3 = AnonymousClassLoader.getTopLevelClass(clazz3)) == (clazz2 = AnonymousClassLoader.getTopLevelClass(clazz2))) {
            return clazz3;
        }
        ClassLoader classLoader = clazz3.getClassLoader();
        if (classLoader == null) {
            return clazz;
        }
        try {
            Reflection.ensureMemberAccess(clazz3, clazz2, null, 2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
        return clazz;
    }

    public Class<?> loadClass(byte[] byArray) {
        if (defineAnonymousClass == null) {
            try {
                return this.fakeLoadClass(new ConstantPoolParser(byArray).createPatch());
            }
            catch (InvalidConstantPoolFormatException invalidConstantPoolFormatException) {
                throw new IllegalArgumentException(invalidConstantPoolFormatException);
            }
        }
        return this.loadClass(byArray, null);
    }

    public Class<?> loadClass(ConstantPoolPatch constantPoolPatch) {
        if (defineAnonymousClass == null) {
            return this.fakeLoadClass(constantPoolPatch);
        }
        Object[] objectArray = constantPoolPatch.patchArray;
        block3: for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            byte by = constantPoolPatch.getTag(i);
            switch (by) {
                case 7: {
                    if (!(object instanceof String)) continue block3;
                    if (objectArray == constantPoolPatch.patchArray) {
                        objectArray = (Object[])objectArray.clone();
                    }
                    objectArray[i] = ((String)object).replace('.', '/');
                    continue block3;
                }
            }
        }
        return this.loadClass(constantPoolPatch.outer.classFile, constantPoolPatch.patchArray);
    }

    private Class<?> loadClass(byte[] byArray, Object[] objectArray) {
        try {
            return (Class)defineAnonymousClass.invoke(unsafe, this.hostClass, byArray, objectArray);
        }
        catch (Exception exception) {
            AnonymousClassLoader.throwReflectedException(exception);
            throw new RuntimeException("error loading into " + this.hostClass, exception);
        }
    }

    private static void throwReflectedException(Exception exception) {
        if (exception instanceof InvocationTargetException) {
            Throwable throwable = ((InvocationTargetException)exception).getTargetException();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            exception = (Exception)throwable;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
    }

    private Class<?> fakeLoadClass(ConstantPoolPatch constantPoolPatch) {
        throw new UnsupportedOperationException("NYI");
    }

    private static void noJVMSupport() {
        throw new UnsupportedOperationException("no JVM support for anonymous classes");
    }

    private static native Class<?> loadClassInternal(Class<?> var0, byte[] var1, Object[] var2);

    public static byte[] readClassFile(Class<?> clazz) throws IOException {
        int n;
        String string = clazz.getName();
        URL uRL = clazz.getResource(string.substring((n = string.lastIndexOf(46)) + 1) + ".class");
        URLConnection uRLConnection = uRL.openConnection();
        int n2 = uRLConnection.getContentLength();
        if (n2 < 0) {
            throw new IOException("invalid content length " + n2);
        }
        return IOUtils.readFully(uRLConnection.getInputStream(), n2, true);
    }

    static {
        Method method = null;
        Class<?> clazz = unsafe.getClass();
        try {
            method = clazz.getMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
        }
        catch (Exception exception) {
            method = null;
        }
        defineAnonymousClass = method;
    }
}

