/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.MethodTypeForm;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sun.dyn.Access;
import sun.dyn.Invokers;
import sun.dyn.MemberName;
import sun.dyn.MethodTypeImpl;
import sun.dyn.util.BytecodeDescriptor;

public final class MethodType
implements Type {
    private final Class<?> rtype;
    private final Class<?>[] ptypes;
    private MethodTypeForm form;
    private MethodType wrapAlt;
    private Invokers invokers;
    private static final Access IMPL_TOKEN = Access.getToken();
    static final HashMap<MethodType, MethodType> internTable;
    static final Class<?>[] NO_PTYPES;
    private static final MethodType[] objectOnlyTypes;

    Invokers getInvokers() {
        return this.invokers;
    }

    void setInvokers(Invokers invokers) {
        this.invokers = invokers;
    }

    private MethodType(Class<?> clazz, Class<?>[] classArray) {
        this.checkRtype(clazz);
        this.checkPtypes(classArray);
        this.rtype = clazz;
        this.ptypes = classArray;
    }

    private void checkRtype(Class<?> clazz) {
        clazz.equals(clazz);
    }

    private void checkPtypes(Class<?>[] classArray) {
        for (Class<?> clazz : classArray) {
            clazz.equals(clazz);
            if (clazz != Void.TYPE) continue;
            throw MemberName.newIllegalArgumentException("void parameter: " + this);
        }
    }

    public static MethodType methodType(Class<?> clazz, Class<?>[] classArray) {
        return MethodType.makeImpl(clazz, classArray, false);
    }

    @Deprecated
    public static MethodType make(Class<?> clazz, Class<?>[] classArray) {
        return MethodType.methodType(clazz, classArray);
    }

    public static MethodType methodType(Class<?> clazz, List<? extends Class<?>> list) {
        boolean bl = false;
        return MethodType.makeImpl(clazz, list.toArray(NO_PTYPES), bl);
    }

    @Deprecated
    public static MethodType make(Class<?> clazz, List<? extends Class<?>> list) {
        return MethodType.methodType(clazz, list);
    }

    public static MethodType methodType(Class<?> clazz, Class<?> clazz2, Class<?> ... classArray) {
        Class[] classArray2 = new Class[1 + classArray.length];
        classArray2[0] = clazz2;
        System.arraycopy(classArray, 0, classArray2, 1, classArray.length);
        return MethodType.makeImpl(clazz, classArray2, true);
    }

    @Deprecated
    public static MethodType make(Class<?> clazz, Class<?> clazz2, Class<?> ... classArray) {
        return MethodType.methodType(clazz, clazz2, classArray);
    }

    public static MethodType methodType(Class<?> clazz) {
        return MethodType.makeImpl(clazz, NO_PTYPES, true);
    }

    @Deprecated
    public static MethodType make(Class<?> clazz) {
        return MethodType.methodType(clazz);
    }

    public static MethodType methodType(Class<?> clazz, Class<?> clazz2) {
        return MethodType.makeImpl(clazz, new Class[]{clazz2}, true);
    }

    @Deprecated
    public static MethodType make(Class<?> clazz, Class<?> clazz2) {
        return MethodType.methodType(clazz, clazz2);
    }

    public static MethodType methodType(Class<?> clazz, MethodType methodType) {
        return MethodType.makeImpl(clazz, methodType.ptypes, true);
    }

    @Deprecated
    public static MethodType make(Class<?> clazz, MethodType methodType) {
        return MethodType.methodType(clazz, methodType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MethodType makeImpl(Class<?> clazz, Class<?>[] classArray, boolean bl) {
        MethodType methodType;
        if (classArray == null || classArray.length == 0) {
            classArray = NO_PTYPES;
            bl = true;
        }
        MethodType methodType2 = new MethodType(clazz, classArray);
        HashMap<MethodType, MethodType> hashMap = internTable;
        synchronized (hashMap) {
            methodType = internTable.get(methodType2);
            if (methodType != null) {
                return methodType;
            }
        }
        if (!bl) {
            methodType2 = new MethodType(clazz, (Class[])classArray.clone());
        }
        MethodTypeImpl.initForm(IMPL_TOKEN, methodType2);
        hashMap = internTable;
        synchronized (hashMap) {
            methodType = internTable.get(methodType2);
            if (methodType != null) {
                return methodType;
            }
            internTable.put(methodType2, methodType2);
        }
        return methodType2;
    }

    private static MethodType makeImpl(Class<?> clazz, Class<?>[] classArray, boolean bl, boolean bl2) {
        return MethodType.makeImpl(clazz, classArray, true);
    }

    public static MethodType genericMethodType(int n, boolean bl) {
        MethodType methodType;
        int n2 = !bl ? 0 : 1;
        int n3 = n * 2 + n2;
        if (n3 < objectOnlyTypes.length && (methodType = objectOnlyTypes[n3]) != null) {
            return methodType;
        }
        Object[] objectArray = new Class[n + n2];
        Arrays.fill(objectArray, Object.class);
        if (n2 != 0) {
            objectArray[n] = Object[].class;
        }
        methodType = MethodType.makeImpl(Object.class, objectArray, true);
        if (n3 < objectOnlyTypes.length) {
            MethodType.objectOnlyTypes[n3] = methodType;
        }
        return methodType;
    }

    @Deprecated
    public static MethodType makeGeneric(int n, boolean bl) {
        return MethodType.genericMethodType(n, bl);
    }

    public static MethodType genericMethodType(int n) {
        return MethodType.genericMethodType(n, false);
    }

    @Deprecated
    public static MethodType makeGeneric(int n) {
        return MethodType.genericMethodType(n);
    }

    public MethodType changeParameterType(int n, Class<?> clazz) {
        if (this.parameterType(n) == clazz) {
            return this;
        }
        Class[] classArray = (Class[])this.ptypes.clone();
        classArray[n] = clazz;
        return MethodType.makeImpl(this.rtype, classArray, true);
    }

    @Deprecated
    public MethodType insertParameterType(int n, Class<?> clazz) {
        int n2 = this.ptypes.length;
        Class<?>[] classArray = Arrays.copyOfRange(this.ptypes, 0, n2 + 1);
        System.arraycopy(classArray, n, classArray, n + 1, n2 - n);
        classArray[n] = clazz;
        return MethodType.makeImpl(this.rtype, classArray, true);
    }

    public MethodType insertParameterTypes(int n, Class<?> ... classArray) {
        int n2 = this.ptypes.length;
        if (n < 0 || n > n2) {
            throw MemberName.newIllegalArgumentException("num=" + n);
        }
        int n3 = classArray.length;
        if (n3 == 0) {
            return this;
        }
        Class<?>[] classArray2 = Arrays.copyOfRange(this.ptypes, 0, n2 + n3);
        System.arraycopy(classArray2, n, classArray2, n + n3, n2 - n);
        System.arraycopy(classArray, 0, classArray2, n, n3);
        return MethodType.makeImpl(this.rtype, classArray2, true);
    }

    public MethodType insertParameterTypes(int n, List<Class<?>> list) {
        return this.insertParameterTypes(n, list.toArray(NO_PTYPES));
    }

    public MethodType dropParameterTypes(int n, int n2) {
        Class<?>[] classArray;
        int n3 = this.ptypes.length;
        if (0 > n || n > n2 || n2 > n3) {
            throw MemberName.newIllegalArgumentException("start=" + n + " end=" + n2);
        }
        if (n == n2) {
            return this;
        }
        if (n == 0) {
            classArray = n2 == n3 ? NO_PTYPES : Arrays.copyOfRange(this.ptypes, n2, n3);
        } else if (n2 == n3) {
            classArray = Arrays.copyOfRange(this.ptypes, 0, n);
        } else {
            int n4 = n3 - n2;
            classArray = Arrays.copyOfRange(this.ptypes, 0, n + n4);
            System.arraycopy(this.ptypes, n2, classArray, n, n4);
        }
        return MethodType.makeImpl(this.rtype, classArray, true);
    }

    @Deprecated
    public MethodType dropParameterType(int n) {
        return this.dropParameterTypes(n, n + 1);
    }

    public MethodType changeReturnType(Class<?> clazz) {
        if (this.returnType() == clazz) {
            return this;
        }
        return MethodType.makeImpl(clazz, this.ptypes, true);
    }

    public boolean hasPrimitives() {
        return this.form.hasPrimitives();
    }

    public boolean hasWrappers() {
        return this.unwrap() != this;
    }

    public MethodType erase() {
        return this.form.erasedType();
    }

    public MethodType generic() {
        return MethodType.genericMethodType(this.parameterCount());
    }

    public MethodType wrap() {
        return this.hasPrimitives() ? MethodType.wrapWithPrims(this) : this;
    }

    public MethodType unwrap() {
        MethodType methodType = !this.hasPrimitives() ? this : MethodType.wrapWithPrims(this);
        return MethodType.unwrapWithNoPrims(methodType);
    }

    private static MethodType wrapWithPrims(MethodType methodType) {
        assert (methodType.hasPrimitives());
        MethodType methodType2 = methodType.wrapAlt;
        if (methodType2 == null) {
            methodType2 = MethodTypeImpl.canonicalize(methodType, 2, 2);
            assert (methodType2 != null);
            methodType.wrapAlt = methodType2;
        }
        return methodType2;
    }

    private static MethodType unwrapWithNoPrims(MethodType methodType) {
        assert (!methodType.hasPrimitives());
        MethodType methodType2 = methodType.wrapAlt;
        if (methodType2 == null) {
            methodType2 = MethodTypeImpl.canonicalize(methodType, 3, 3);
            if (methodType2 == null) {
                methodType2 = methodType;
            }
            methodType.wrapAlt = methodType2;
        }
        return methodType2;
    }

    public Class<?> parameterType(int n) {
        return this.ptypes[n];
    }

    public int parameterCount() {
        return this.ptypes.length;
    }

    public Class<?> returnType() {
        return this.rtype;
    }

    public List<Class<?>> parameterList() {
        return Collections.unmodifiableList(Arrays.asList(this.ptypes));
    }

    public Class<?>[] parameterArray() {
        return (Class[])this.ptypes.clone();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof MethodType && this.equals((MethodType)object);
    }

    private boolean equals(MethodType methodType) {
        return this.rtype == methodType.rtype && Arrays.equals(this.ptypes, methodType.ptypes);
    }

    public int hashCode() {
        int n = 31 + this.rtype.hashCode();
        for (Class<?> clazz : this.ptypes) {
            n = 31 * n + clazz.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < this.ptypes.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            MethodType.putName(stringBuilder, this.ptypes[i]);
        }
        stringBuilder.append(")");
        MethodType.putName(stringBuilder, this.rtype);
        return stringBuilder.toString();
    }

    static void putName(StringBuilder stringBuilder, Class<?> clazz) {
        int n = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n;
        }
        String string = clazz.getName();
        stringBuilder.append(string);
        while (n > 0) {
            stringBuilder.append("[]");
            --n;
        }
    }

    public int parameterSlotCount() {
        return this.form.parameterSlotCount();
    }

    public int parameterSlotDepth(int n) {
        if (n < 0 || n > this.ptypes.length) {
            this.parameterType(n);
        }
        return this.form.parameterToArgSlot(n - 1);
    }

    public int returnSlotCount() {
        return this.form.returnSlotCount();
    }

    public static MethodType fromMethodDescriptorString(String string, ClassLoader classLoader) throws IllegalArgumentException, TypeNotPresentException {
        List<Class<?>> list = BytecodeDescriptor.parseMethod(string, classLoader);
        Class<?> clazz = list.remove(list.size() - 1);
        Class<?>[] classArray = list.toArray(NO_PTYPES);
        return MethodType.makeImpl(clazz, classArray, true);
    }

    public String toMethodDescriptorString() {
        return BytecodeDescriptor.unparse(this);
    }

    public String toBytecodeString() {
        return this.toMethodDescriptorString();
    }

    public static MethodType fromBytecodeString(String string, ClassLoader classLoader) throws IllegalArgumentException, TypeNotPresentException {
        return MethodType.fromMethodDescriptorString(string, classLoader);
    }

    static {
        MethodTypeImpl.setMethodTypeFriend(IMPL_TOKEN, new MethodTypeImpl.MethodTypeFriend(){

            @Override
            public Class<?>[] ptypes(MethodType methodType) {
                return methodType.ptypes;
            }

            @Override
            public MethodTypeImpl form(MethodType methodType) {
                return methodType.form;
            }

            @Override
            public void setForm(MethodType methodType, MethodTypeImpl methodTypeImpl) {
                assert (methodType.form == null);
                methodType.form = (MethodTypeForm)methodTypeImpl;
            }

            @Override
            public MethodType makeImpl(Class<?> clazz, Class<?>[] classArray, boolean bl) {
                return MethodType.makeImpl(clazz, classArray, bl);
            }

            @Override
            public MethodTypeImpl newMethodTypeForm(MethodType methodType) {
                return new MethodTypeForm(methodType);
            }

            @Override
            public Invokers getInvokers(MethodType methodType) {
                return methodType.invokers;
            }

            @Override
            public void setInvokers(MethodType methodType, Invokers invokers) {
                methodType.invokers = invokers;
            }
        });
        internTable = new HashMap();
        NO_PTYPES = new Class[0];
        objectOnlyTypes = new MethodType[20];
    }
}

