/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.RetrievalMethod;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(RetrievalMethodResolver.class.getName());

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        if (!XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod")) {
            return null;
        }
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
            String string2 = retrievalMethod.getType();
            XMLSignatureInput xMLSignatureInput = RetrievalMethodResolver.resolveInput(retrievalMethod, string);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(string2)) {
                X509Certificate x509Certificate = RetrievalMethodResolver.getRawCertificate(xMLSignatureInput);
                if (x509Certificate != null) {
                    return x509Certificate.getPublicKey();
                }
                return null;
            }
            Element element2 = RetrievalMethodResolver.obtainRefrenceElement(xMLSignatureInput);
            return RetrievalMethodResolver.resolveKey(element2, string, storageResolver);
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            log.log(Level.FINE, "CertificateException", certificateException);
        }
        catch (IOException iOException) {
            log.log(Level.FINE, "IOException", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.log(Level.FINE, "ParserConfigurationException", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            log.log(Level.FINE, "SAXException", sAXException);
        }
        return null;
    }

    private static Element obtainRefrenceElement(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException, KeyResolverException {
        Element element;
        if (xMLSignatureInput.isElement()) {
            element = (Element)xMLSignatureInput.getSubNode();
        } else if (xMLSignatureInput.isNodeSet()) {
            element = RetrievalMethodResolver.getDocumentElement(xMLSignatureInput.getNodeSet());
        } else {
            byte[] byArray = xMLSignatureInput.getBytes();
            element = RetrievalMethodResolver.getDocFromBytes(byArray);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "we have to parse " + byArray.length + " bytes");
            }
        }
        return element;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        if (!XMLUtils.elementIsInSignatureSpace(element, "RetrievalMethod")) {
            return null;
        }
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
            String string2 = retrievalMethod.getType();
            XMLSignatureInput xMLSignatureInput = RetrievalMethodResolver.resolveInput(retrievalMethod, string);
            if ("http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(string2)) {
                X509Certificate x509Certificate = RetrievalMethodResolver.getRawCertificate(xMLSignatureInput);
                return x509Certificate;
            }
            Element element2 = RetrievalMethodResolver.obtainRefrenceElement(xMLSignatureInput);
            return RetrievalMethodResolver.resolveCertificate(element2, string, storageResolver);
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            log.log(Level.FINE, "CertificateException", certificateException);
        }
        catch (IOException iOException) {
            log.log(Level.FINE, "IOException", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.log(Level.FINE, "ParserConfigurationException", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            log.log(Level.FINE, "SAXException", sAXException);
        }
        return null;
    }

    private static X509Certificate resolveCertificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Now we have a {" + element.getNamespaceURI() + "}" + element.getLocalName() + " Element");
        }
        if (element != null) {
            return KeyResolver.getX509Certificate(element, string, storageResolver);
        }
        return null;
    }

    private static PublicKey resolveKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Now we have a {" + element.getNamespaceURI() + "}" + element.getLocalName() + " Element");
        }
        if (element != null) {
            return KeyResolver.getPublicKey(element, string, storageResolver);
        }
        return null;
    }

    private static X509Certificate getRawCertificate(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, IOException, CertificateException {
        byte[] byArray = xMLSignatureInput.getBytes();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        return x509Certificate;
    }

    private static XMLSignatureInput resolveInput(RetrievalMethod retrievalMethod, String string) throws XMLSecurityException {
        Attr attr = retrievalMethod.getURIAttr();
        Transforms transforms = retrievalMethod.getTransforms();
        ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string);
        if (resourceResolver != null) {
            XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string);
            if (transforms != null) {
                log.log(Level.FINE, "We have Transforms");
                xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
            }
            return xMLSignatureInput;
        }
        return null;
    }

    static Element getDocFromBytes(byte[] byArray) throws KeyResolverException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            return document.getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new KeyResolverException("empty", sAXException);
        }
        catch (IOException iOException) {
            throw new KeyResolverException("empty", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new KeyResolverException("empty", parserConfigurationException);
        }
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    static Element getDocumentElement(Set set) {
        Object object;
        Object object2;
        Iterator iterator = set.iterator();
        Element element = null;
        while (iterator.hasNext()) {
            object2 = (Node)iterator.next();
            if (!(object2 instanceof Element)) continue;
            element = (Element)object2;
            break;
        }
        object2 = new ArrayList(10);
        do {
            object2.add(element);
        } while ((object = element.getParentNode()) instanceof Element && (element = (Element)object) != null);
        object = object2.listIterator(object2.size() - 1);
        Element element2 = null;
        while (object.hasPrevious()) {
            element2 = (Element)object.previous();
            if (!set.contains(element2)) continue;
            return element2;
        }
        return null;
    }
}

